<?php

namespace Drupal\support\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Hello' Block.
 *
 * @Block(
 *   id = "talk_contact_block",
 *   admin_label = @Translation("Talk Contact block"),
 *   category = @Translation("Main"),
 * )
 */
class TalkContactBlock extends BlockBase {

    public function build() {

        $string = '<h3 class="mb-2">Fale connosco</h3>';
        $string .= '<a href="https://goo.gl/maps/g2ZUuNJRLsaDz4Li9" target="_blank" class="info"><i class="fa fa-map-marker" aria-hidden="true"></i><div><strong>Morada</strong>Rua Castelo 15, 1º 4700-311 BRAGA</div></a>';
        $string .= '<a href="tel:939665031" class="info"><i class="fas fa-phone"></i><div><strong>Telemóvel</strong>939 665 031</div></a>';
        $string .= '<a href="tel:253279145" class="info"><i class="fas fa-mobile-alt"></i><div><strong>Telefone</strong>253 279 145</div></a>';
        $string .= '<a href="mailto:clidentcastelo@gmail.com" class="info"><i class="fa fa-envelope" aria-hidden="true"></i><div><strong>Email</strong>clidentcastelo@gmail.com</div></a>';
        $string .= '<div class="info schedule"><i class="far fa-clock "></i><div><strong>Horário</strong>
        <div><span class="days">Seg. a Sex.</span><span class="time">9h às 13h</span><span class="sep"> - </span><span class="time">14h às 19h</span></div>
        <div class="sab"><span class="days last">Sáb.</span><span class="time"> 9h às 13h</span></div></div>
   
  </div>';
        return array(
            '#attributes' => ['class' => ['col-md-6','mb-2']],
            '#markup' => $string,
        );
    }

}