<?php

namespace Drupal\support\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Hello' Block.
 *
 * @Block(
 *   id = "talk_block",
 *   admin_label = @Translation("Talk to us block"),
 *   category = @Translation("Footer"),
 * )
 */
class TalkBlock extends BlockBase {

    public function build() {

        $string = '<h4 class="footer_title">Fale connosco</h4>';
        $string .= '<div class="desc">Temos uma equipa de profissionais que o vão ajudar no que precisar.</div>';
        $string .= '<a href="https://goo.gl/maps/g2ZUuNJRLsaDz4Li9" target="_blank" class="info"><i class="fa fa-map-marker" aria-hidden="true"></i>Rua Castelo 15, 1º 4700-311 BRAGA</a>';
        $string .= '<a href="tel:939665031" class="info"><i class="fas fa-phone"></i>939 665 031</a>';
        $string .= '<a href="tel:253279145" class="info"><i class="fas fa-mobile-alt"></i>253 279 145</a>';
        $string .= '<a href="mailto:clidentcastelo@gmail.com" class="info"><i class="fa fa-envelope" aria-hidden="true"></i>clidentcastelo@gmail.com</a>';
        $string .= '<div class="info schedule">

    <i class="far fa-clock "></i>

        <div><span class="days">Seg. a Sex.</span><span class="time">9h às 13h</span><span class="sep"> - </span><span class="time">14h às 19h</span></div>
        <div class="sab"><span class="days last">Sáb.</span><span class="time"> 9h às 13h</span></div>
   
  </div>';
        return array(
            '#attributes' => ['class' => ['col-md-5']],
            '#markup' => $string,
        );
    }

}