<?php

namespace Drupal\support\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Hello' Block.
 *
 * @Block(
 *   id = "services_block",
 *   admin_label = @Translation("Services block"),
 *   category = @Translation("Footer"),
 * )
 */
class ServicesBlock extends BlockBase {

    public function build() {

        $string = '<h4 class="footer_title">Os nossos serviços</h4>';
        $string .= \Drupal::service('renderer')->render(views_embed_view('servicos', 'block_1'));
        return array(
            '#attributes' => ['class' => ['col-md-3']],
            '#markup' => $string,
        );
    }

}