<?php

namespace Drupal\support\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Hello' Block.
 *
 * @Block(
 *   id = "scheduletop_block",
 *   admin_label = @Translation("Schedule Top block"),
 *   category = @Translation("Header"),
 * )
 */
class ScheduleTopBlock extends BlockBase {
    public function build() {

        $string = '<i class="far fa-clock"></i>
<span class="days">Seg. a Sex.</span><span class="time"> 9h às 13h</span><span class="sep"> - </span><span class="time">14h às 19h</span>
<span class="days last">Sáb.</span><span class="time"> 9h às 13h</span>';
        return array(
            '#markup' => $string,
        );
    }

}