<?php

namespace Drupal\support\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Hello' Block.
 *
 * @Block(
 *   id = "news_block",
 *   admin_label = @Translation("News block"),
 *   category = @Translation("Footer"),
 * )
 */
class NewsBlock extends BlockBase {

    public function build() {

        $string = '<h4 class="footer_title">Últimas notícias</h4>';
        $string .= \Drupal::service('renderer')->render(views_embed_view('news', 'block_1'));
        return array(
            '#attributes' => ['class' => ['col-md-4']],
            '#markup' => $string,
        );
    }

}