<?php

namespace Drupal\support\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'Hello' Block.
 *
 * @Block(
 *   id = "map_contact_block",
 *   admin_label = @Translation("Map block"),
 *   category = @Translation("Main"),
 * )
 */
class MapContactBlock extends BlockBase {

    public function build() {
        $string = '<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d1492.908061176581!2d-8.4279804!3d41.5515784!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xd24fec203fcd747%3A0x8192dd30b01f73fd!2sR.+do+Castelo+15%2C+4700-314+Braga!5e0!3m2!1spt-PT!2spt!4v1558612337707!5m2!1spt-PT!2spt" width="100%" height="420px" style="width: 100%;height: 420px;" frameborder="0" style="border:0" allowfullscreen></iframe>';

        $iframe = array(
            '#attributes' => ['class' => ['col-md-6']],
            '#type' => 'inline_template',
            '#template' => $string,
        );

        return $iframe;
    }

}