-- MySQL dump 10.13  Distrib 5.7.24, for Linux (x86_64)
--
-- Host: localhost    Database: clidentcastelo
-- ------------------------------------------------------
-- Server version	5.7.24-0ubuntu0.18.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `batch`
--

DROP TABLE IF EXISTS `batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) CHARACTER SET ascii NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Stores details about batches (processes that run in…';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batch`
--

LOCK TABLES `batch` WRITE;
/*!40000 ALTER TABLE `batch` DISABLE KEYS */;
/*!40000 ALTER TABLE `batch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_content`
--

DROP TABLE IF EXISTS `block_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `block_content_field__uuid__value` (`uuid`),
  UNIQUE KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content`
--

LOCK TABLES `block_content` WRITE;
/*!40000 ALTER TABLE `block_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_content__body`
--

DROP TABLE IF EXISTS `block_content__body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_content__body` (
  `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for block_content field body.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content__body`
--

LOCK TABLES `block_content__body` WRITE;
/*!40000 ALTER TABLE `block_content__body` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_content__body` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_content_field_data`
--

DROP TABLE IF EXISTS `block_content_field_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_content_field_data` (
  `id` int(10) unsigned NOT NULL,
  `revision_id` int(10) unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `status` tinyint(4) NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int(11) DEFAULT NULL,
  `reusable` tinyint(4) DEFAULT NULL,
  `default_langcode` tinyint(4) NOT NULL,
  `revision_translation_affected` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`),
  KEY `block_content__status_type` (`status`,`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_field_data`
--

LOCK TABLES `block_content_field_data` WRITE;
/*!40000 ALTER TABLE `block_content_field_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_content_field_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_content_field_revision`
--

DROP TABLE IF EXISTS `block_content_field_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_content_field_revision` (
  `id` int(10) unsigned NOT NULL,
  `revision_id` int(10) unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `status` tinyint(4) NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int(11) DEFAULT NULL,
  `default_langcode` tinyint(4) NOT NULL,
  `revision_translation_affected` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_field_revision`
--

LOCK TABLES `block_content_field_revision` WRITE;
/*!40000 ALTER TABLE `block_content_field_revision` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_content_field_revision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_content_revision`
--

DROP TABLE IF EXISTS `block_content_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_content_revision` (
  `id` int(10) unsigned NOT NULL,
  `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii NOT NULL,
  `revision_user` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_created` int(11) DEFAULT NULL,
  `revision_log` longtext,
  `revision_default` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `block_content__id` (`id`),
  KEY `block_content_field__revision_user__target_id` (`revision_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision`
--

LOCK TABLES `block_content_revision` WRITE;
/*!40000 ALTER TABLE `block_content_revision` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_content_revision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_content_revision__body`
--

DROP TABLE IF EXISTS `block_content_revision__body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_content_revision__body` (
  `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for block_content field body.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision__body`
--

LOCK TABLES `block_content_revision__body` WRITE;
/*!40000 ALTER TABLE `block_content_revision__body` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_content_revision__body` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_bootstrap`
--

DROP TABLE IF EXISTS `cache_bootstrap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_bootstrap` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_bootstrap`
--

LOCK TABLES `cache_bootstrap` WRITE;
/*!40000 ALTER TABLE `cache_bootstrap` DISABLE KEYS */;
INSERT INTO `cache_bootstrap` VALUES ('hook_info',_binary 'a:42:{s:10:\"token_info\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:16:\"token_info_alter\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:6:\"tokens\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:12:\"tokens_alter\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:22:\"pathauto_pattern_alter\";a:1:{s:5:\"group\";s:8:\"pathauto\";}s:20:\"pathauto_alias_alter\";a:1:{s:5:\"group\";s:8:\"pathauto\";}s:26:\"pathauto_is_alias_reserved\";a:1:{s:5:\"group\";s:8:\"pathauto\";}s:10:\"views_data\";a:1:{s:5:\"group\";s:5:\"views\";}s:16:\"views_data_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:13:\"views_analyze\";a:1:{s:5:\"group\";s:5:\"views\";}s:22:\"views_invalidate_cache\";a:1:{s:5:\"group\";s:5:\"views\";}s:26:\"views_plugins_access_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:24:\"views_plugins_area_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:28:\"views_plugins_argument_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:36:\"views_plugins_argument_default_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:38:\"views_plugins_argument_validator_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_cache_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:36:\"views_plugins_display_extender_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:27:\"views_plugins_display_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:32:\"views_plugins_exposed_form_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_field_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:26:\"views_plugins_filter_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:24:\"views_plugins_join_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_pager_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_query_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:32:\"views_plugins_relationship_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:23:\"views_plugins_row_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:24:\"views_plugins_sort_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_style_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:26:\"views_plugins_wizard_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_query_substitutions\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:24:\"views_form_substitutions\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:14:\"views_pre_view\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:15:\"views_pre_build\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:16:\"views_post_build\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:17:\"views_pre_execute\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:18:\"views_post_execute\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:16:\"views_pre_render\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:17:\"views_post_render\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:17:\"views_query_alter\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:16:\"field_views_data\";a:1:{s:5:\"group\";s:5:\"views\";}s:22:\"field_views_data_alter\";a:1:{s:5:\"group\";s:5:\"views\";}}',-1,1578481106.543,1,'','0'),('module_implements',_binary 'a:447:{s:23:\"module_implements_alter\";a:2:{s:7:\"metatag\";b:0;s:5:\"token\";b:0;}s:7:\"rebuild\";a:1:{s:5:\"block\";b:0;}s:17:\"system_info_alter\";a:1:{s:6:\"system\";b:0;}s:11:\"entity_load\";a:0:{}s:10:\"block_load\";a:0:{}s:17:\"entity_type_build\";a:4:{s:8:\"field_ui\";b:0;s:7:\"menu_ui\";b:0;s:6:\"system\";b:0;s:8:\"views_ui\";b:0;}s:17:\"entity_type_alter\";a:6:{s:13:\"block_content\";b:0;s:7:\"contact\";b:0;s:5:\"devel\";b:0;s:8:\"taxonomy\";b:0;s:5:\"token\";b:0;s:17:\"menu_link_content\";b:0;}s:16:\"search_page_load\";a:0:{}s:27:\"views_plugins_display_alter\";a:1:{s:8:\"views_ui\";b:0;}s:9:\"view_load\";a:0:{}s:25:\"views_plugins_style_alter\";a:0:{}s:10:\"views_data\";a:3:{s:5:\"dblog\";s:5:\"views\";s:7:\"history\";s:5:\"views\";s:5:\"views\";s:5:\"views\";}s:11:\"action_load\";a:0:{}s:16:\"field_info_alter\";a:3:{s:8:\"language\";b:0;s:5:\"token\";b:0;s:8:\"pathauto\";b:0;}s:14:\"entity_preload\";a:0:{}s:11:\"query_alter\";a:0:{}s:30:\"query_user_load_multiple_alter\";a:0:{}s:18:\"entity_bundle_info\";a:0:{}s:23:\"block_content_type_load\";a:0:{}s:17:\"comment_type_load\";a:0:{}s:17:\"contact_form_load\";a:0:{}s:14:\"crop_type_load\";a:0:{}s:14:\"node_type_load\";a:0:{}s:17:\"shortcut_set_load\";a:0:{}s:24:\"taxonomy_vocabulary_load\";a:0:{}s:24:\"entity_bundle_info_alter\";a:0:{}s:20:\"data_type_info_alter\";a:0:{}s:22:\"entity_base_field_info\";a:4:{s:7:\"metatag\";b:0;s:4:\"path\";b:0;s:5:\"token\";b:0;s:8:\"pathauto\";b:0;}s:28:\"entity_base_field_info_alter\";a:1:{s:8:\"language\";b:0;}s:24:\"entity_bundle_field_info\";a:1:{s:5:\"field\";b:0;}s:17:\"field_config_load\";a:0:{}s:30:\"entity_bundle_field_info_alter\";a:0:{}s:25:\"entity_field_storage_info\";a:1:{s:5:\"field\";b:0;}s:25:\"field_storage_config_load\";a:0:{}s:31:\"entity_field_storage_info_alter\";a:0:{}s:19:\"entity_storage_load\";a:1:{s:7:\"comment\";b:0;}s:17:\"user_storage_load\";a:0:{}s:9:\"user_load\";a:0:{}s:19:\"search_plugin_alter\";a:0:{}s:22:\"field_views_data_alter\";a:1:{s:8:\"taxonomy\";s:5:\"views\";}s:24:\"base_field_override_load\";a:0:{}s:16:\"views_data_alter\";a:6:{s:7:\"comment\";s:5:\"views\";s:7:\"contact\";s:5:\"views\";s:10:\"contextual\";s:5:\"views\";s:14:\"draggableviews\";b:0;s:8:\"taxonomy\";s:5:\"views\";s:5:\"views\";s:5:\"views\";}s:23:\"views_plugins_row_alter\";a:0:{}s:26:\"views_plugins_access_alter\";a:0:{}s:36:\"query_menu_link_content_access_alter\";a:0:{}s:24:\"query_entity_query_alter\";a:0:{}s:42:\"query_entity_query_menu_link_content_alter\";a:0:{}s:43:\"query_menu_link_content_load_multiple_alter\";a:0:{}s:30:\"menu_link_content_storage_load\";a:0:{}s:22:\"menu_link_content_load\";a:0:{}s:19:\"language_types_info\";a:0:{}s:25:\"language_types_info_alter\";a:1:{s:8:\"language\";b:0;}s:30:\"query_node_load_multiple_alter\";a:0:{}s:17:\"node_storage_load\";a:0:{}s:9:\"node_load\";a:0:{}s:27:\"menu_links_discovered_alter\";a:4:{s:19:\"admin_toolbar_tools\";b:0;s:5:\"dblog\";b:0;s:5:\"devel\";b:0;s:6:\"editor\";b:0;}s:14:\"user_role_load\";a:0:{}s:9:\"menu_load\";a:0:{}s:13:\"entity_access\";a:0:{}s:11:\"user_access\";a:0:{}s:22:\"entity_view_mode_alter\";a:0:{}s:14:\"file_url_alter\";a:1:{s:4:\"crop\";b:0;}s:5:\"theme\";a:25:{s:5:\"block\";b:0;s:13:\"block_content\";b:0;s:8:\"ckeditor\";b:0;s:5:\"color\";b:0;s:7:\"comment\";b:0;s:4:\"crop\";b:0;s:6:\"ctools\";b:0;s:8:\"field_ui\";b:0;s:4:\"file\";b:0;s:6:\"filter\";b:0;s:5:\"image\";b:0;s:8:\"language\";b:0;s:4:\"link\";b:0;s:6:\"locale\";b:0;s:4:\"node\";b:0;s:3:\"rdf\";b:0;s:6:\"search\";b:0;s:6:\"system\";b:0;s:8:\"taxonomy\";b:0;s:5:\"token\";b:0;s:7:\"toolbar\";b:0;s:4:\"user\";b:0;s:8:\"views_ui\";b:0;s:5:\"views\";b:0;s:20:\"eu_cookie_compliance\";b:0;}s:25:\"views_plugins_pager_alter\";a:0:{}s:32:\"views_plugins_exposed_form_alter\";a:0:{}s:20:\"theme_registry_alter\";a:0:{}s:21:\"entity_view_mode_load\";a:0:{}s:27:\"entity_view_mode_info_alter\";a:0:{}s:25:\"user_build_defaults_alter\";a:0:{}s:27:\"entity_build_defaults_alter\";a:0:{}s:23:\"entity_extra_field_info\";a:5:{s:7:\"comment\";b:0;s:7:\"contact\";b:0;s:17:\"image_widget_crop\";b:0;s:4:\"node\";b:0;s:4:\"user\";b:0;}s:29:\"entity_extra_field_info_alter\";a:0:{}s:24:\"entity_view_display_load\";a:0:{}s:25:\"entity_view_display_alter\";a:1:{s:4:\"node\";b:0;}s:19:\"entity_prepare_view\";a:1:{s:3:\"rdf\";b:0;}s:16:\"rdf_mapping_load\";a:0:{}s:26:\"field_formatter_info_alter\";a:2:{s:6:\"editor\";b:0;s:9:\"quickedit\";b:0;}s:19:\"entity_field_access\";a:1:{s:8:\"language\";b:0;}s:25:\"entity_field_access_alter\";a:0:{}s:26:\"entity_display_build_alter\";a:0:{}s:9:\"user_view\";a:1:{s:4:\"user\";b:0;}s:11:\"entity_view\";a:1:{s:7:\"comment\";b:0;}s:15:\"user_view_alter\";a:1:{s:4:\"user\";b:0;}s:17:\"entity_view_alter\";a:2:{s:7:\"metatag\";b:0;s:9:\"quickedit\";b:0;}s:22:\"theme_suggestions_user\";a:0:{}s:23:\"theme_suggestions_alter\";a:0:{}s:28:\"theme_suggestions_user_alter\";a:0:{}s:43:\"template_preprocess_default_variables_alter\";a:1:{s:4:\"user\";b:0;}s:22:\"user_format_name_alter\";a:0:{}s:16:\"date_format_load\";a:0:{}s:18:\"element_info_alter\";a:5:{s:6:\"editor\";b:0;s:16:\"form_placeholder\";b:0;s:8:\"language\";b:0;s:6:\"system\";b:0;s:4:\"user\";b:0;}s:30:\"theme_suggestions_form_element\";a:0:{}s:36:\"theme_suggestions_form_element_alter\";a:0:{}s:28:\"display_variant_plugin_alter\";a:0:{}s:12:\"block_access\";a:0:{}s:38:\"query_entity_query_block_content_alter\";a:0:{}s:28:\"views_plugins_argument_alter\";a:0:{}s:38:\"views_plugins_argument_validator_alter\";a:2:{s:8:\"taxonomy\";s:5:\"views\";s:4:\"user\";s:5:\"views\";}s:11:\"block_alter\";a:0:{}s:20:\"condition_info_alter\";a:1:{s:6:\"ctools\";b:0;}s:17:\"block_build_alter\";a:0:{}s:32:\"block_build_phonetop_block_alter\";a:0:{}s:35:\"block_build_scheduletop_block_alter\";a:0:{}s:35:\"block_build_system_menu_block_alter\";a:0:{}s:34:\"block_build_page_title_block_alter\";a:0:{}s:16:\"block_view_alter\";a:1:{s:5:\"token\";b:0;}s:33:\"block_view_page_title_block_alter\";a:0:{}s:39:\"block_build_system_messages_block_alter\";a:0:{}s:35:\"block_build_local_tasks_block_alter\";a:0:{}s:37:\"block_build_local_actions_block_alter\";a:0:{}s:35:\"block_build_system_main_block_alter\";a:0:{}s:34:\"block_view_system_main_block_alter\";a:1:{s:6:\"system\";b:0;}s:28:\"block_build_talk_block_alter\";a:0:{}s:32:\"block_build_services_block_alter\";a:0:{}s:28:\"block_build_news_block_alter\";a:0:{}s:16:\"page_attachments\";a:6:{s:8:\"big_pipe\";b:0;s:10:\"contextual\";b:0;s:7:\"metatag\";b:0;s:9:\"quickedit\";b:0;s:6:\"system\";b:0;s:20:\"eu_cookie_compliance\";b:0;}s:21:\"metatag_defaults_load\";a:0:{}s:14:\"metatags_alter\";a:0:{}s:18:\"metatag_tags_alter\";a:0:{}s:6:\"tokens\";a:11:{s:5:\"token\";s:6:\"tokens\";s:7:\"comment\";s:6:\"tokens\";s:5:\"field\";b:1;s:4:\"file\";b:0;s:7:\"menu_ui\";b:1;s:4:\"node\";s:6:\"tokens\";s:6:\"system\";s:6:\"tokens\";s:8:\"taxonomy\";s:6:\"tokens\";s:4:\"user\";s:6:\"tokens\";s:8:\"pathauto\";s:6:\"tokens\";s:5:\"views\";s:6:\"tokens\";}s:26:\"token_entity_mapping_alter\";a:0:{}s:12:\"tokens_alter\";a:0:{}s:10:\"token_info\";a:10:{s:5:\"token\";s:6:\"tokens\";s:7:\"comment\";s:6:\"tokens\";s:4:\"file\";b:0;s:7:\"menu_ui\";b:1;s:4:\"node\";s:6:\"tokens\";s:6:\"system\";s:6:\"tokens\";s:8:\"taxonomy\";s:6:\"tokens\";s:4:\"user\";s:6:\"tokens\";s:8:\"pathauto\";s:6:\"tokens\";s:5:\"views\";s:6:\"tokens\";}s:16:\"token_info_alter\";a:2:{s:5:\"token\";s:6:\"tokens\";s:5:\"field\";b:1;}s:16:\"image_style_load\";a:0:{}s:26:\"metatags_attachments_alter\";a:0:{}s:37:\"eu_cookie_compliance_path_match_alter\";a:0:{}s:38:\"eu_cookie_compliance_geoip_match_alter\";a:0:{}s:37:\"eu_cookie_compliance_show_popup_alter\";a:0:{}s:18:\"filter_format_load\";a:0:{}s:17:\"filter_info_alter\";a:0:{}s:49:\"theme_suggestions_eu_cookie_compliance_popup_info\";a:0:{}s:55:\"theme_suggestions_eu_cookie_compliance_popup_info_alter\";a:0:{}s:51:\"theme_suggestions_eu_cookie_compliance_popup_agreed\";a:0:{}s:57:\"theme_suggestions_eu_cookie_compliance_popup_agreed_alter\";a:0:{}s:47:\"theme_suggestions_eu_cookie_compliance_withdraw\";a:0:{}s:53:\"theme_suggestions_eu_cookie_compliance_withdraw_alter\";a:0:{}s:22:\"page_attachments_alter\";a:3:{s:5:\"devel\";b:0;s:8:\"taxonomy\";b:0;s:7:\"metatag\";b:0;}s:8:\"page_top\";a:3:{s:5:\"block\";b:0;s:4:\"node\";b:0;s:7:\"toolbar\";b:0;}s:11:\"page_bottom\";a:1:{s:4:\"tour\";b:0;}s:22:\"theme_suggestions_html\";a:1:{s:6:\"system\";b:0;}s:28:\"theme_suggestions_html_alter\";a:0:{}s:14:\"rdf_namespaces\";a:1:{s:3:\"rdf\";b:0;}s:17:\"breakpoints_alter\";a:0:{}s:7:\"toolbar\";a:7:{s:19:\"admin_toolbar_tools\";b:0;s:10:\"contextual\";b:0;s:5:\"devel\";b:0;s:8:\"shortcut\";b:0;s:7:\"toolbar\";b:0;s:4:\"tour\";b:0;s:4:\"user\";b:0;}s:20:\"shortcut_default_set\";a:0:{}s:33:\"query_entity_query_shortcut_alter\";a:0:{}s:34:\"query_shortcut_load_multiple_alter\";a:0:{}s:21:\"shortcut_storage_load\";a:0:{}s:13:\"shortcut_load\";a:0:{}s:22:\"theme_suggestions_menu\";a:0:{}s:28:\"theme_suggestions_menu_alter\";a:0:{}s:10:\"link_alter\";a:0:{}s:13:\"toolbar_alter\";a:1:{s:13:\"admin_toolbar\";b:0;}s:25:\"theme_suggestions_toolbar\";a:0:{}s:31:\"theme_suggestions_toolbar_alter\";a:0:{}s:27:\"theme_suggestions_container\";a:0:{}s:33:\"theme_suggestions_container_alter\";a:1:{s:5:\"views\";b:0;}s:23:\"theme_suggestions_links\";a:0:{}s:29:\"theme_suggestions_links_alter\";a:0:{}s:22:\"theme_suggestions_page\";a:1:{s:6:\"system\";b:0;}s:28:\"theme_suggestions_page_alter\";a:0:{}s:31:\"block_view_phonetop_block_alter\";a:0:{}s:23:\"theme_suggestions_block\";a:1:{s:5:\"block\";b:0;}s:29:\"theme_suggestions_block_alter\";a:0:{}s:34:\"block_view_scheduletop_block_alter\";a:0:{}s:24:\"theme_suggestions_region\";a:1:{s:6:\"system\";b:0;}s:30:\"theme_suggestions_region_alter\";a:0:{}s:34:\"block_view_system_menu_block_alter\";a:1:{s:7:\"menu_ui\";b:0;}s:28:\"theme_suggestions_page_title\";a:0:{}s:34:\"theme_suggestions_page_title_alter\";a:0:{}s:38:\"block_view_system_messages_block_alter\";a:0:{}s:34:\"block_view_local_tasks_block_alter\";a:0:{}s:21:\"entity_form_mode_load\";a:0:{}s:27:\"entity_form_mode_info_alter\";a:0:{}s:17:\"local_tasks_alter\";a:3:{s:5:\"devel\";b:0;s:8:\"field_ui\";b:0;s:5:\"views\";b:0;}s:22:\"menu_local_tasks_alter\";a:1:{s:7:\"contact\";b:0;}s:34:\"theme_suggestions_menu_local_tasks\";a:0:{}s:40:\"theme_suggestions_menu_local_tasks_alter\";a:0:{}s:33:\"theme_suggestions_menu_local_task\";a:0:{}s:39:\"theme_suggestions_menu_local_task_alter\";a:0:{}s:36:\"block_view_local_actions_block_alter\";a:0:{}s:24:\"menu_local_actions_alter\";a:0:{}s:27:\"block_view_talk_block_alter\";a:0:{}s:31:\"block_view_services_block_alter\";a:0:{}s:14:\"views_pre_view\";a:0:{}s:25:\"views_plugins_field_alter\";a:0:{}s:24:\"views_plugins_sort_alter\";a:0:{}s:26:\"views_plugins_filter_alter\";a:0:{}s:15:\"views_pre_build\";a:0:{}s:25:\"views_plugins_query_alter\";a:0:{}s:17:\"views_query_alter\";a:0:{}s:25:\"views_query_substitutions\";a:3:{s:4:\"node\";s:15:\"views_execution\";s:4:\"user\";s:15:\"views_execution\";s:5:\"views\";s:15:\"views_execution\";}s:16:\"views_post_build\";a:0:{}s:17:\"views_pre_execute\";a:0:{}s:25:\"views_plugins_cache_alter\";a:0:{}s:17:\"query_views_alter\";a:1:{s:5:\"views\";b:0;}s:26:\"query_views_servicos_alter\";a:0:{}s:32:\"query_taxonomy_term_access_alter\";a:0:{}s:23:\"query_term_access_alter\";a:0:{}s:39:\"query_taxonomy_term_load_multiple_alter\";a:0:{}s:26:\"taxonomy_term_storage_load\";a:0:{}s:18:\"taxonomy_term_load\";a:0:{}s:18:\"views_post_execute\";a:0:{}s:16:\"views_pre_render\";a:2:{s:5:\"dblog\";b:0;s:5:\"views\";s:15:\"views_execution\";}s:34:\"theme_suggestions_views_view_field\";a:0:{}s:40:\"theme_suggestions_views_view_field_alter\";a:0:{}s:26:\"entity_view_display_create\";a:0:{}s:13:\"entity_create\";a:0:{}s:21:\"field_info_max_weight\";a:0:{}s:17:\"views_post_render\";a:0:{}s:28:\"theme_suggestions_views_view\";a:0:{}s:34:\"theme_suggestions_views_view_alter\";a:0:{}s:40:\"theme_suggestions_views_view_unformatted\";a:0:{}s:46:\"theme_suggestions_views_view_unformatted_alter\";a:0:{}s:35:\"theme_suggestions_views_view_fields\";a:0:{}s:41:\"theme_suggestions_views_view_fields_alter\";a:0:{}s:27:\"block_view_news_block_alter\";a:0:{}s:22:\"query_views_news_alter\";a:0:{}s:11:\"node_grants\";a:0:{}s:23:\"query_node_access_alter\";a:1:{s:4:\"node\";b:0;}s:41:\"theme_suggestions_off_canvas_page_wrapper\";a:0:{}s:47:\"theme_suggestions_off_canvas_page_wrapper_alter\";a:0:{}s:18:\"library_info_alter\";a:5:{s:8:\"ckeditor\";b:0;s:5:\"color\";b:0;s:17:\"image_widget_crop\";b:0;s:6:\"locale\";b:0;s:9:\"quickedit\";b:0;}s:9:\"css_alter\";a:0:{}s:8:\"js_alter\";a:2:{s:6:\"locale\";b:0;s:20:\"eu_cookie_compliance\";b:0;}s:17:\"js_settings_build\";a:1:{s:6:\"system\";b:0;}s:17:\"js_settings_alter\";a:3:{s:6:\"locale\";b:0;s:6:\"system\";b:0;s:4:\"user\";b:0;}s:17:\"ajax_render_alter\";a:0:{}s:33:\"theme_suggestions_status_messages\";a:0:{}s:39:\"theme_suggestions_status_messages_alter\";a:0:{}s:11:\"node_access\";a:1:{s:4:\"node\";b:0;}s:25:\"node_build_defaults_alter\";a:0:{}s:29:\"block_build_views_block_alter\";a:0:{}s:9:\"file_load\";a:0:{}s:28:\"block_view_views_block_alter\";a:0:{}s:31:\"query_views_node_auxiliar_alter\";a:0:{}s:9:\"node_view\";a:0:{}s:15:\"node_view_alter\";a:2:{s:7:\"comment\";b:0;s:7:\"history\";b:0;}s:29:\"query_entity_query_node_alter\";a:0:{}s:23:\"theme_suggestions_field\";a:1:{s:6:\"system\";b:0;}s:29:\"theme_suggestions_field_alter\";a:0:{}s:22:\"theme_suggestions_node\";a:1:{s:4:\"node\";b:0;}s:28:\"theme_suggestions_node_alter\";a:1:{s:5:\"views\";b:0;}s:26:\"theme_suggestions_username\";a:0:{}s:32:\"theme_suggestions_username_alter\";a:0:{}s:33:\"theme_suggestions_image_formatter\";a:0:{}s:39:\"theme_suggestions_image_formatter_alter\";a:0:{}s:23:\"theme_suggestions_image\";a:0:{}s:29:\"theme_suggestions_image_alter\";a:0:{}s:27:\"query_views_slideshow_alter\";a:0:{}s:18:\"rdf_mapping_create\";a:0:{}s:29:\"theme_suggestions_image_style\";a:0:{}s:35:\"theme_suggestions_image_style_alter\";a:0:{}s:9:\"crop_load\";a:0:{}s:16:\"node_links_alter\";a:1:{s:7:\"comment\";b:0;}s:34:\"taxonomy_term_build_defaults_alter\";a:0:{}s:18:\"taxonomy_term_view\";a:0:{}s:24:\"taxonomy_term_view_alter\";a:0:{}s:38:\"query_entity_query_taxonomy_term_alter\";a:0:{}s:31:\"theme_suggestions_taxonomy_term\";a:1:{s:8:\"taxonomy\";b:0;}s:37:\"theme_suggestions_taxonomy_term_alter\";a:0:{}s:30:\"contextual_links_plugins_alter\";a:0:{}s:22:\"contextual_links_alter\";a:0:{}s:27:\"contextual_links_view_alter\";a:2:{s:10:\"contextual\";b:0;s:8:\"views_ui\";b:0;}s:11:\"view_access\";a:0:{}s:29:\"query_entity_query_file_alter\";a:0:{}s:30:\"query_file_load_multiple_alter\";a:0:{}s:17:\"file_storage_load\";a:0:{}s:30:\"theme_suggestions_rdf_metadata\";a:0:{}s:36:\"theme_suggestions_rdf_metadata_alter\";a:0:{}s:35:\"block_build_map_contact_block_alter\";a:0:{}s:36:\"block_build_talk_contact_block_alter\";a:0:{}s:34:\"block_view_map_contact_block_alter\";a:0:{}s:35:\"block_view_talk_contact_block_alter\";a:0:{}s:22:\"quickedit_editor_alter\";a:0:{}s:17:\"editor_info_alter\";a:0:{}s:11:\"editor_load\";a:0:{}s:20:\"filter_format_access\";a:0:{}s:26:\"ckeditor_plugin_info_alter\";a:0:{}s:18:\"ckeditor_css_alter\";a:1:{s:8:\"ckeditor\";b:0;}s:24:\"editor_js_settings_alter\";a:0:{}s:30:\"query_crop_load_multiple_alter\";a:0:{}s:17:\"crop_storage_load\";a:0:{}s:24:\"views_plugins_area_alter\";a:0:{}s:22:\"query_views_team_alter\";a:0:{}s:34:\"theme_suggestions_views_mini_pager\";a:0:{}s:40:\"theme_suggestions_views_mini_pager_alter\";a:0:{}s:26:\"query_views_noticias_alter\";a:0:{}s:23:\"theme_suggestions_pager\";a:0:{}s:29:\"theme_suggestions_pager_alter\";a:0:{}s:27:\"query_views_parcerias_alter\";a:0:{}s:20:\"metatag_route_entity\";a:0:{}s:20:\"taxonomy_term_access\";a:0:{}s:31:\"query_views_taxonomy_term_alter\";a:0:{}s:10:\"form_alter\";a:4:{s:14:\"draggableviews\";b:0;s:8:\"honeypot\";b:0;s:8:\"language\";b:0;s:6:\"system\";b:0;}s:26:\"form_user_login_form_alter\";a:1:{s:6:\"seckit\";b:0;}s:23:\"theme_suggestions_input\";a:0:{}s:29:\"theme_suggestions_input_alter\";a:0:{}s:36:\"theme_suggestions_form_element_label\";a:0:{}s:42:\"theme_suggestions_form_element_label_alter\";a:0:{}s:22:\"theme_suggestions_form\";a:0:{}s:28:\"theme_suggestions_form_alter\";a:0:{}s:23:\"query_user_access_alter\";a:0:{}s:29:\"query_entity_query_user_alter\";a:0:{}s:10:\"user_login\";a:2:{s:6:\"system\";b:0;s:4:\"user\";b:0;}s:24:\"entity_form_display_load\";a:0:{}s:25:\"entity_form_display_alter\";a:0:{}s:19:\"entity_prepare_form\";a:0:{}s:17:\"user_prepare_form\";a:0:{}s:20:\"form_user_form_alter\";a:2:{s:7:\"contact\";b:0;s:6:\"system\";b:0;}s:31:\"honeypot_form_protections_alter\";a:0:{}s:26:\"taxonomy_vocabulary_access\";a:0:{}s:23:\"field_widget_info_alter\";a:2:{s:4:\"file\";b:0;s:8:\"pathauto\";b:0;}s:17:\"node_prepare_form\";a:0:{}s:23:\"field_widget_form_alter\";a:0:{}s:50:\"field_widget_text_textarea_with_summary_form_alter\";a:0:{}s:34:\"field_widget_multivalue_form_alter\";a:0:{}s:61:\"field_widget_multivalue_text_textarea_with_summary_form_alter\";a:0:{}s:41:\"field_widget_image_widget_crop_form_alter\";a:0:{}s:34:\"theme_suggestions_file_upload_help\";a:0:{}s:40:\"theme_suggestions_file_upload_help_alter\";a:0:{}s:52:\"field_widget_multivalue_image_widget_crop_form_alter\";a:0:{}s:26:\"pathauto_alias_types_alter\";a:0:{}s:21:\"pathauto_pattern_load\";a:0:{}s:28:\"field_widget_path_form_alter\";a:0:{}s:39:\"field_widget_multivalue_path_form_alter\";a:0:{}s:40:\"field_widget_boolean_checkbox_form_alter\";a:0:{}s:51:\"field_widget_multivalue_boolean_checkbox_form_alter\";a:0:{}s:40:\"field_widget_string_textfield_form_alter\";a:0:{}s:51:\"field_widget_multivalue_string_textfield_form_alter\";a:0:{}s:39:\"field_widget_string_textarea_form_alter\";a:0:{}s:50:\"field_widget_multivalue_string_textarea_form_alter\";a:0:{}s:20:\"form_node_form_alter\";a:2:{s:7:\"menu_ui\";b:0;s:5:\"token\";b:0;}s:30:\"form_node_page_edit_form_alter\";a:0:{}s:43:\"theme_suggestions_field_multiple_value_form\";a:0:{}s:49:\"theme_suggestions_field_multiple_value_form_alter\";a:0:{}s:23:\"editor_xss_filter_alter\";a:0:{}s:26:\"theme_suggestions_textarea\";a:0:{}s:32:\"theme_suggestions_textarea_alter\";a:0:{}s:24:\"theme_suggestions_select\";a:0:{}s:30:\"theme_suggestions_select_alter\";a:0:{}s:37:\"theme_suggestions_text_format_wrapper\";a:0:{}s:43:\"theme_suggestions_text_format_wrapper_alter\";a:0:{}s:38:\"theme_suggestions_file_widget_multiple\";a:0:{}s:44:\"theme_suggestions_file_widget_multiple_alter\";a:0:{}s:30:\"theme_suggestions_image_widget\";a:0:{}s:36:\"theme_suggestions_image_widget_alter\";a:0:{}s:27:\"theme_suggestions_file_link\";a:0:{}s:33:\"theme_suggestions_file_link_alter\";a:0:{}s:25:\"theme_suggestions_details\";a:0:{}s:31:\"theme_suggestions_details_alter\";a:0:{}s:31:\"theme_suggestions_vertical_tabs\";a:0:{}s:37:\"theme_suggestions_vertical_tabs_alter\";a:0:{}s:23:\"theme_suggestions_table\";a:0:{}s:29:\"theme_suggestions_table_alter\";a:0:{}s:47:\"form_views_form_slideshow_type__slideshow_alter\";a:0:{}s:24:\"views_form_substitutions\";a:1:{s:5:\"views\";s:15:\"views_execution\";}s:34:\"theme_suggestions_views_view_table\";a:0:{}s:40:\"theme_suggestions_views_view_table_alter\";a:0:{}s:29:\"theme_suggestions_indentation\";a:0:{}s:35:\"theme_suggestions_indentation_alter\";a:0:{}s:20:\"entity_create_access\";a:0:{}s:18:\"node_create_access\";a:0:{}s:30:\"language_content_settings_load\";a:0:{}s:22:\"node_field_values_init\";a:0:{}s:24:\"entity_field_values_init\";a:0:{}s:11:\"node_create\";a:0:{}s:36:\"field_widget_link_default_form_alter\";a:0:{}s:47:\"field_widget_multivalue_link_default_form_alter\";a:0:{}s:37:\"field_widget_text_textarea_form_alter\";a:0:{}s:48:\"field_widget_multivalue_text_textarea_form_alter\";a:0:{}s:30:\"form_node_slideshow_form_alter\";a:0:{}s:26:\"theme_suggestions_fieldset\";a:0:{}s:32:\"theme_suggestions_fieldset_alter\";a:0:{}s:27:\"file_mimetype_mapping_alter\";a:0:{}s:32:\"language_content_settings_create\";a:0:{}s:22:\"file_field_values_init\";a:0:{}s:11:\"file_create\";a:0:{}s:13:\"file_validate\";a:0:{}s:12:\"file_presave\";a:0:{}s:14:\"entity_presave\";a:1:{s:5:\"image\";b:0;}s:11:\"file_insert\";a:0:{}s:13:\"entity_insert\";a:4:{s:7:\"comment\";b:0;s:6:\"editor\";b:0;s:17:\"image_widget_crop\";b:0;s:8:\"pathauto\";b:0;}s:27:\"validation_constraint_alter\";a:0:{}s:32:\"entity_reference_selection_alter\";a:0:{}s:28:\"query_entity_reference_alter\";a:2:{s:13:\"block_content\";b:0;s:6:\"system\";b:0;}s:23:\"query_file_access_alter\";a:0:{}s:11:\"file_access\";a:0:{}s:29:\"image_toolkit_operation_alter\";a:0:{}s:12:\"node_presave\";a:0:{}s:19:\"node_access_records\";a:0:{}s:25:\"node_access_records_alter\";a:0:{}s:11:\"file_update\";a:0:{}s:13:\"entity_update\";a:3:{s:6:\"editor\";b:0;s:17:\"image_widget_crop\";b:0;s:8:\"pathauto\";b:0;}s:11:\"node_insert\";a:2:{s:8:\"taxonomy\";b:0;s:5:\"token\";b:0;}s:22:\"crop_field_values_init\";a:0:{}s:11:\"crop_create\";a:0:{}s:12:\"crop_presave\";a:0:{}s:11:\"crop_insert\";a:0:{}s:35:\"form_node_slideshow_edit_form_alter\";a:0:{}s:11:\"node_update\";a:1:{s:8:\"taxonomy\";b:0;}s:26:\"taxonomy_term_prepare_form\";a:0:{}s:35:\"field_widget_image_image_form_alter\";a:0:{}s:46:\"field_widget_multivalue_image_image_form_alter\";a:0:{}s:29:\"form_taxonomy_term_form_alter\";a:0:{}s:38:\"form_taxonomy_term_servicos_form_alter\";a:0:{}s:27:\"taxonomy_term_create_access\";a:0:{}s:16:\"entity_operation\";a:2:{s:5:\"devel\";b:0;s:8:\"field_ui\";b:0;}s:22:\"entity_operation_alter\";a:0:{}s:34:\"form_taxonomy_overview_terms_alter\";a:0:{}s:36:\"theme_suggestions_dropbutton_wrapper\";a:0:{}s:42:\"theme_suggestions_dropbutton_wrapper_alter\";a:0:{}s:35:\"theme_suggestions_menu_local_action\";a:0:{}s:41:\"theme_suggestions_menu_local_action_alter\";a:0:{}s:31:\"taxonomy_term_field_values_init\";a:0:{}s:20:\"taxonomy_term_create\";a:0:{}s:21:\"taxonomy_term_presave\";a:0:{}s:20:\"taxonomy_term_update\";a:0:{}s:22:\"pathauto_pattern_alter\";a:0:{}s:32:\"pathauto_punctuation_chars_alter\";a:0:{}s:31:\"transliteration_overrides_alter\";a:0:{}s:20:\"pathauto_alias_alter\";a:0:{}s:26:\"pathauto_is_alias_reserved\";a:0:{}s:11:\"path_update\";a:2:{s:6:\"system\";b:0;s:17:\"menu_link_content\";b:0;}s:20:\"taxonomy_term_insert\";a:0:{}s:11:\"path_insert\";a:2:{s:6:\"system\";b:0;s:17:\"menu_link_content\";b:0;}s:32:\"views_plugins_relationship_alter\";a:0:{}s:29:\"form_views_exposed_form_alter\";a:1:{s:5:\"views\";b:0;}s:25:\"query_views_content_alter\";a:0:{}s:16:\"node_type_access\";a:0:{}s:36:\"form_views_form_content_page_1_alter\";a:0:{}s:36:\"theme_suggestions_views_exposed_form\";a:0:{}s:42:\"theme_suggestions_views_exposed_form_alter\";a:0:{}s:37:\"theme_suggestions_tablesort_indicator\";a:0:{}s:43:\"theme_suggestions_tablesort_indicator_alter\";a:0:{}s:41:\"block_build_system_breadcrumb_block_alter\";a:0:{}s:40:\"block_view_system_breadcrumb_block_alter\";a:0:{}s:23:\"system_breadcrumb_alter\";a:1:{s:7:\"menu_ui\";b:0;}s:28:\"theme_suggestions_breadcrumb\";a:0:{}s:34:\"theme_suggestions_breadcrumb_alter\";a:0:{}s:41:\"form_taxonomy_overview_vocabularies_alter\";a:0:{}s:33:\"taxonomy_vocabulary_create_access\";a:0:{}s:35:\"theme_suggestions_filter_guidelines\";a:0:{}s:41:\"theme_suggestions_filter_guidelines_alter\";a:0:{}s:29:\"theme_suggestions_filter_tips\";a:0:{}s:35:\"theme_suggestions_filter_tips_alter\";a:0:{}}',-1,1579254252.395,1,'','0'),('path_alias_whitelist',_binary 'a:36:{s:5:\"admin\";b:0;s:8:\"run-cron\";b:0;s:8:\"big_pipe\";b:0;s:14:\"block-category\";N;s:5:\"block\";b:0;s:7:\"comment\";N;s:8:\"comments\";N;s:7:\"contact\";N;s:4:\"user\";b:0;s:10:\"contextual\";b:0;s:5:\"devel\";b:0;s:6:\"editor\";N;s:4:\"file\";N;s:6:\"filter\";b:0;s:7:\"history\";N;s:5:\"sites\";b:0;s:6:\"system\";N;s:9:\"quickedit\";N;s:4:\"node\";b:1;s:6:\"search\";N;s:20:\"report-csp-violation\";N;s:6:\"mypage\";N;s:4:\"cron\";N;s:12:\"machine_name\";N;s:0:\"\";N;s:9:\"<current>\";N;s:5:\"batch\";N;s:10:\"update.php\";N;s:29:\"entity_reference_autocomplete\";b:0;s:7:\"session\";N;s:8:\"taxonomy\";b:1;s:5:\"token\";N;s:7:\"toolbar\";N;s:7:\"rss.xml\";N;s:5:\"views\";N;s:20:\"eu-cookie-compliance\";N;}',-1,1578641944.588,1,'','0'),('routing.non_admin_routes',_binary 'a:190:{i:0;s:22:\"admin_toolbar.run.cron\";i:1;s:13:\"big_pipe.nojs\";i:2;s:27:\"block.category_autocomplete\";i:3;s:22:\"block_content.add_page\";i:4;s:22:\"block_content.add_form\";i:5;s:30:\"entity.block_content.canonical\";i:6;s:30:\"entity.block_content.edit_form\";i:7;s:32:\"entity.block_content.delete_form\";i:8;s:24:\"entity.comment.edit_form\";i:9;s:15:\"comment.approve\";i:10;s:24:\"entity.comment.canonical\";i:11;s:26:\"entity.comment.delete_form\";i:12;s:13:\"comment.reply\";i:13;s:31:\"comment.new_comments_node_links\";i:14;s:21:\"comment.node_redirect\";i:15;s:17:\"contact.site_page\";i:16;s:29:\"entity.contact_form.canonical\";i:17;s:24:\"entity.user.contact_form\";i:18;s:17:\"contextual.render\";i:19;s:15:\"devel.reinstall\";i:20;s:18:\"devel.menu_rebuild\";i:21;s:18:\"devel.configs_list\";i:22;s:17:\"devel.config_edit\";i:23;s:23:\"devel.state_system_page\";i:24;s:23:\"devel.system_state_edit\";i:25;s:20:\"devel.theme_registry\";i:26;s:21:\"devel.field_info_page\";i:27;s:13:\"devel.session\";i:28;s:12:\"devel.switch\";i:29;s:17:\"devel.cache_clear\";i:30;s:14:\"devel.run_cron\";i:31;s:28:\"devel.container_info.service\";i:32;s:35:\"devel.container_info.service.detail\";i:33;s:30:\"devel.container_info.parameter\";i:34;s:37:\"devel.container_info.parameter.detail\";i:35;s:16:\"devel.route_info\";i:36;s:21:\"devel.route_info.item\";i:37;s:16:\"devel.event_info\";i:38;s:19:\"devel.elements_page\";i:39;s:26:\"devel.elements_page.detail\";i:40;s:22:\"devel.entity_info_page\";i:41;s:29:\"devel.entity_info_page.detail\";i:42;s:17:\"editor.filter_xss\";i:43;s:31:\"editor.field_untransformed_text\";i:44;s:19:\"editor.image_dialog\";i:45;s:18:\"editor.link_dialog\";i:46;s:18:\"file.ajax_progress\";i:47;s:15:\"filter.tips_all\";i:48;s:11:\"filter.tips\";i:49;s:26:\"history.get_last_node_view\";i:50;s:17:\"history.read_node\";i:51;s:18:\"image.style_public\";i:52;s:19:\"image.style_private\";i:53;s:12:\"image.upload\";i:54;s:10:\"image.info\";i:55;s:13:\"node.add_page\";i:56;s:8:\"node.add\";i:57;s:19:\"entity.node.preview\";i:58;s:27:\"entity.node.version_history\";i:59;s:20:\"entity.node.revision\";i:60;s:28:\"node.revision_revert_confirm\";i:61;s:40:\"node.revision_revert_translation_confirm\";i:62;s:28:\"node.revision_delete_confirm\";i:63;s:18:\"quickedit.metadata\";i:64;s:21:\"quickedit.attachments\";i:65;s:20:\"quickedit.field_form\";i:66;s:21:\"quickedit.entity_save\";i:67;s:11:\"search.view\";i:68;s:23:\"search.view_node_search\";i:69;s:23:\"search.help_node_search\";i:70;s:23:\"search.view_user_search\";i:71;s:23:\"search.help_user_search\";i:72;s:13:\"seckit.report\";i:73;s:19:\"shortcut.set_switch\";i:74;s:15:\"example.my_page\";i:75;s:10:\"system.401\";i:76;s:10:\"system.403\";i:77;s:10:\"system.404\";i:78;s:10:\"system.4xx\";i:79;s:11:\"system.cron\";i:80;s:33:\"system.machine_name_transliterate\";i:81;s:12:\"system.files\";i:82;s:28:\"system.private_file_download\";i:83;s:16:\"system.temporary\";i:84;s:7:\"<front>\";i:85;s:6:\"<none>\";i:86;s:8:\"<nolink>\";i:87;s:9:\"<current>\";i:88;s:15:\"system.timezone\";i:89;s:22:\"system.batch_page.html\";i:90;s:22:\"system.batch_page.json\";i:91;s:16:\"system.db_update\";i:92;s:26:\"system.entity_autocomplete\";i:93;s:16:\"system.csrftoken\";i:94;s:30:\"entity.taxonomy_term.edit_form\";i:95;s:32:\"entity.taxonomy_term.delete_form\";i:96;s:10:\"token.tree\";i:97;s:18:\"token.autocomplete\";i:98;s:16:\"toolbar.subtrees\";i:99;s:13:\"user.register\";i:100;s:11:\"user.logout\";i:101;s:9:\"user.pass\";i:102;s:14:\"user.pass.http\";i:103;s:9:\"user.page\";i:104;s:10:\"user.login\";i:105;s:15:\"user.login.http\";i:106;s:22:\"user.login_status.http\";i:107;s:16:\"user.logout.http\";i:108;s:19:\"user.cancel_confirm\";i:109;s:16:\"user.reset.login\";i:110;s:10:\"user.reset\";i:111;s:15:\"user.reset.form\";i:112;s:21:\"view.frontpage.feed_1\";i:113;s:21:\"view.frontpage.page_1\";i:114;s:25:\"view.taxonomy_term.page_1\";i:115;s:10:\"views.ajax\";i:116;s:34:\"eu_cookie_compliance.store_consent\";i:117;s:21:\"entity.node.canonical\";i:118;s:23:\"entity.node.delete_form\";i:119;s:21:\"entity.node.edit_form\";i:120;s:21:\"entity.user.canonical\";i:121;s:21:\"entity.user.edit_form\";i:122;s:23:\"entity.user.cancel_form\";i:123;s:23:\"entity.block.devel_load\";i:124;s:29:\"entity.block.devel_definition\";i:125;s:31:\"entity.block_content.devel_load\";i:126;s:33:\"entity.block_content.devel_render\";i:127;s:37:\"entity.block_content.devel_definition\";i:128;s:36:\"entity.block_content_type.devel_load\";i:129;s:42:\"entity.block_content_type.devel_definition\";i:130;s:30:\"entity.comment_type.devel_load\";i:131;s:36:\"entity.comment_type.devel_definition\";i:132;s:25:\"entity.comment.devel_load\";i:133;s:27:\"entity.comment.devel_render\";i:134;s:31:\"entity.comment.devel_definition\";i:135;s:30:\"entity.contact_form.devel_load\";i:136;s:36:\"entity.contact_form.devel_definition\";i:137;s:27:\"entity.crop_type.devel_load\";i:138;s:33:\"entity.crop_type.devel_definition\";i:139;s:31:\"entity.filter_format.devel_load\";i:140;s:37:\"entity.filter_format.devel_definition\";i:141;s:29:\"entity.image_style.devel_load\";i:142;s:35:\"entity.image_style.devel_definition\";i:143;s:39:\"entity.configurable_language.devel_load\";i:144;s:45:\"entity.configurable_language.devel_definition\";i:145;s:34:\"entity.metatag_defaults.devel_load\";i:146;s:40:\"entity.metatag_defaults.devel_definition\";i:147;s:22:\"entity.node.devel_load\";i:148;s:24:\"entity.node.devel_render\";i:149;s:28:\"entity.node.devel_definition\";i:150;s:27:\"entity.node_type.devel_load\";i:151;s:33:\"entity.node_type.devel_definition\";i:152;s:29:\"entity.search_page.devel_load\";i:153;s:35:\"entity.search_page.devel_definition\";i:154;s:30:\"entity.shortcut_set.devel_load\";i:155;s:36:\"entity.shortcut_set.devel_definition\";i:156;s:26:\"entity.shortcut.devel_load\";i:157;s:28:\"entity.shortcut.devel_render\";i:158;s:32:\"entity.shortcut.devel_definition\";i:159;s:22:\"entity.menu.devel_load\";i:160;s:28:\"entity.menu.devel_definition\";i:161;s:37:\"entity.taxonomy_vocabulary.devel_load\";i:162;s:43:\"entity.taxonomy_vocabulary.devel_definition\";i:163;s:31:\"entity.taxonomy_term.devel_load\";i:164;s:33:\"entity.taxonomy_term.devel_render\";i:165;s:37:\"entity.taxonomy_term.devel_definition\";i:166;s:27:\"entity.user_role.devel_load\";i:167;s:33:\"entity.user_role.devel_definition\";i:168;s:22:\"entity.user.devel_load\";i:169;s:24:\"entity.user.devel_render\";i:170;s:28:\"entity.user.devel_definition\";i:171;s:35:\"entity.menu_link_content.devel_load\";i:172;s:37:\"entity.menu_link_content.devel_render\";i:173;s:41:\"entity.menu_link_content.devel_definition\";i:174;s:34:\"entity.pathauto_pattern.devel_load\";i:175;s:40:\"entity.pathauto_pattern.devel_definition\";i:176;s:22:\"entity.view.devel_load\";i:177;s:28:\"entity.view.devel_definition\";i:178;s:29:\"entity.date_format.devel_load\";i:179;s:35:\"entity.date_format.devel_definition\";i:180;s:34:\"entity.entity_view_mode.devel_load\";i:181;s:40:\"entity.entity_view_mode.devel_definition\";i:182;s:34:\"entity.entity_form_mode.devel_load\";i:183;s:40:\"entity.entity_form_mode.devel_definition\";i:184;s:32:\"entity.block_content.token_devel\";i:185;s:26:\"entity.comment.token_devel\";i:186;s:23:\"entity.node.token_devel\";i:187;s:32:\"entity.taxonomy_term.token_devel\";i:188;s:23:\"entity.user.token_devel\";i:189;s:30:\"entity.taxonomy_term.canonical\";}',-1,1578481108.924,1,'routes','560'),('theme.active_theme.clidentcastelo',_binary 'O:29:\"Drupal\\Core\\Theme\\ActiveTheme\":13:{s:7:\"\0*\0name\";s:14:\"clidentcastelo\";s:7:\"\0*\0logo\";s:30:\"themes/clidentcastelo/logo.svg\";s:7:\"\0*\0path\";s:21:\"themes/clidentcastelo\";s:9:\"\0*\0engine\";s:4:\"twig\";s:8:\"\0*\0owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:13:\"\0*\0baseThemes\";N;s:22:\"\0*\0baseThemeExtensions\";a:1:{s:9:\"bootstrap\";O:31:\"Drupal\\Core\\Extension\\Extension\":15:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:35:\"themes/bootstrap/bootstrap.info.yml\";s:11:\"\0*\0filename\";s:15:\"bootstrap.theme\";s:7:\"subpath\";s:16:\"themes/bootstrap\";s:6:\"origin\";s:0:\"\";s:4:\"info\";a:20:{s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:9:\"Bootstrap\";s:11:\"description\";s:115:\"Built to use Bootstrap, a sleek, intuitive, and powerful front-end framework for faster and easier web development.\";s:7:\"package\";s:9:\"Bootstrap\";s:7:\"regions\";a:11:{s:10:\"navigation\";s:10:\"Navigation\";s:22:\"navigation_collapsible\";s:24:\"Navigation (Collapsible)\";s:6:\"header\";s:7:\"Top Bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:7:\"Primary\";s:14:\"sidebar_second\";s:9:\"Secondary\";s:6:\"footer\";s:6:\"Footer\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:9:\"libraries\";a:1:{i:0;s:15:\"bootstrap/theme\";}s:16:\"libraries-extend\";a:11:{s:16:\"core/drupal.ajax\";a:1:{i:0;s:21:\"bootstrap/drupal.ajax\";}s:24:\"core/drupal.autocomplete\";a:1:{i:0;s:29:\"bootstrap/drupal.autocomplete\";}s:23:\"core/drupal.dialog.ajax\";a:1:{i:0;s:28:\"bootstrap/drupal.dialog.ajax\";}s:16:\"core/drupal.form\";a:1:{i:0;s:21:\"bootstrap/drupal.form\";}s:19:\"core/drupal.message\";a:1:{i:0;s:24:\"bootstrap/drupal.message\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:25:\"bootstrap/drupal.progress\";}s:18:\"core/drupal.states\";a:1:{i:0;s:23:\"bootstrap/drupal.states\";}s:21:\"core/drupal.tabledrag\";a:1:{i:0;s:26:\"bootstrap/drupal.tabledrag\";}s:23:\"core/drupal.tableheader\";a:1:{i:0;s:28:\"bootstrap/drupal.tableheader\";}s:37:\"image_widget_crop/cropper.integration\";a:1:{i:0;s:27:\"bootstrap/image_widget_crop\";}s:16:\"views/views.ajax\";a:1:{i:0;s:20:\"bootstrap/views.ajax\";}}s:18:\"libraries-override\";a:10:{s:17:\"core/drupal.batch\";s:22:\"bootstrap/drupal.batch\";s:22:\"core/drupal.dropbutton\";s:18:\"bootstrap/dropdown\";s:25:\"core/drupal.vertical-tabs\";s:30:\"bootstrap/drupal.vertical-tabs\";s:20:\"filter/drupal.filter\";s:23:\"bootstrap/drupal.filter\";s:12:\"system/admin\";b:0;s:16:\"text/drupal.text\";s:21:\"bootstrap/drupal.text\";s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:3:{s:39:\"css/components/ajax-progress.module.css\";b:0;s:46:\"css/components/autocomplete-loading.module.css\";b:0;s:35:\"css/components/tabledrag.module.css\";b:0;}}}s:16:\"file/drupal.file\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/file.admin.css\";b:0;}}}s:26:\"filter/drupal.filter.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";b:0;}}}s:24:\"node/drupal.node.preview\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/node.preview.css\";b:0;}}}}s:7:\"version\";s:8:\"8.x-3.19\";s:4:\"core\";s:3:\"8.x\";s:7:\"project\";s:9:\"bootstrap\";s:9:\"datestamp\";i:1557526090;s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:31:\"themes/bootstrap/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:1:{s:14:\"clidentcastelo\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:9:\"bootstrap\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}}s:8:\"requires\";a:0:{}s:4:\"sort\";i:0;s:10:\"sub_themes\";a:1:{s:14:\"clidentcastelo\";s:7:\"Clinica\";}s:9:\"libraries\";a:1:{i:0;s:15:\"bootstrap/theme\";}s:6:\"engine\";s:4:\"twig\";}}s:12:\"\0*\0extension\";O:31:\"Drupal\\Core\\Extension\\Extension\":15:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:45:\"themes/clidentcastelo/clidentcastelo.info.yml\";s:11:\"\0*\0filename\";s:20:\"clidentcastelo.theme\";s:7:\"subpath\";s:21:\"themes/clidentcastelo\";s:6:\"origin\";s:0:\"\";s:4:\"info\";a:18:{s:4:\"core\";s:3:\"8.x\";s:4:\"type\";s:5:\"theme\";s:10:\"base theme\";s:9:\"bootstrap\";s:4:\"name\";s:7:\"Clinica\";s:11:\"description\";s:37:\"A Drupal Bootstrap 3 based sub-theme.\";s:7:\"package\";s:9:\"Bootstrap\";s:7:\"regions\";a:14:{s:14:\"navigation_top\";s:14:\"Navigation Top\";s:10:\"navigation\";s:10:\"Navigation\";s:22:\"navigation_collapsible\";s:24:\"Navigation (Collapsible)\";s:6:\"header\";s:7:\"Top Bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:14:\"content_bottom\";s:19:\"Content Bottom WIDE\";s:11:\"content_top\";s:16:\"Content Top WIDE\";s:13:\"sidebar_first\";s:7:\"Primary\";s:14:\"sidebar_second\";s:9:\"Secondary\";s:6:\"footer\";s:6:\"Footer\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:16:\"libraries-extend\";a:1:{s:19:\"bootstrap/framework\";a:1:{i:0;s:24:\"clidentcastelo/framework\";}}s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:36:\"themes/clidentcastelo/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:9:\"libraries\";a:0:{}s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:9:\"bootstrap\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:0:{}s:8:\"requires\";a:1:{s:9:\"bootstrap\";r:105;}s:4:\"sort\";i:-1;s:11:\"base_themes\";a:1:{s:9:\"bootstrap\";s:9:\"Bootstrap\";}s:6:\"engine\";s:4:\"twig\";s:10:\"base_theme\";s:9:\"bootstrap\";}s:20:\"\0*\0styleSheetsRemove\";a:0:{}s:12:\"\0*\0libraries\";a:1:{i:0;s:15:\"bootstrap/theme\";}s:10:\"\0*\0regions\";a:14:{s:14:\"navigation_top\";s:14:\"Navigation Top\";s:10:\"navigation\";s:10:\"Navigation\";s:22:\"navigation_collapsible\";s:24:\"Navigation (Collapsible)\";s:6:\"header\";s:7:\"Top Bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:14:\"content_bottom\";s:19:\"Content Bottom WIDE\";s:11:\"content_top\";s:16:\"Content Top WIDE\";s:13:\"sidebar_first\";s:7:\"Primary\";s:14:\"sidebar_second\";s:9:\"Secondary\";s:6:\"footer\";s:6:\"Footer\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:20:\"\0*\0librariesOverride\";a:1:{s:16:\"themes/bootstrap\";a:10:{s:17:\"core/drupal.batch\";s:22:\"bootstrap/drupal.batch\";s:22:\"core/drupal.dropbutton\";s:18:\"bootstrap/dropdown\";s:25:\"core/drupal.vertical-tabs\";s:30:\"bootstrap/drupal.vertical-tabs\";s:20:\"filter/drupal.filter\";s:23:\"bootstrap/drupal.filter\";s:12:\"system/admin\";b:0;s:16:\"text/drupal.text\";s:21:\"bootstrap/drupal.text\";s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:3:{s:39:\"css/components/ajax-progress.module.css\";b:0;s:46:\"css/components/autocomplete-loading.module.css\";b:0;s:35:\"css/components/tabledrag.module.css\";b:0;}}}s:16:\"file/drupal.file\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/file.admin.css\";b:0;}}}s:26:\"filter/drupal.filter.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";b:0;}}}s:24:\"node/drupal.node.preview\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/node.preview.css\";b:0;}}}}}s:18:\"\0*\0librariesExtend\";a:12:{s:16:\"core/drupal.ajax\";a:1:{i:0;s:21:\"bootstrap/drupal.ajax\";}s:24:\"core/drupal.autocomplete\";a:1:{i:0;s:29:\"bootstrap/drupal.autocomplete\";}s:23:\"core/drupal.dialog.ajax\";a:1:{i:0;s:28:\"bootstrap/drupal.dialog.ajax\";}s:16:\"core/drupal.form\";a:1:{i:0;s:21:\"bootstrap/drupal.form\";}s:19:\"core/drupal.message\";a:1:{i:0;s:24:\"bootstrap/drupal.message\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:25:\"bootstrap/drupal.progress\";}s:18:\"core/drupal.states\";a:1:{i:0;s:23:\"bootstrap/drupal.states\";}s:21:\"core/drupal.tabledrag\";a:1:{i:0;s:26:\"bootstrap/drupal.tabledrag\";}s:23:\"core/drupal.tableheader\";a:1:{i:0;s:28:\"bootstrap/drupal.tableheader\";}s:37:\"image_widget_crop/cropper.integration\";a:1:{i:0;s:27:\"bootstrap/image_widget_crop\";}s:16:\"views/views.ajax\";a:1:{i:0;s:20:\"bootstrap/views.ajax\";}s:19:\"bootstrap/framework\";a:1:{i:0;s:24:\"clidentcastelo/framework\";}}}',-1,1578481108.988,1,'','0'),('theme.active_theme.seven',_binary 'O:29:\"Drupal\\Core\\Theme\\ActiveTheme\":13:{s:7:\"\0*\0name\";s:5:\"seven\";s:7:\"\0*\0logo\";s:26:\"core/themes/seven/logo.svg\";s:7:\"\0*\0path\";s:17:\"core/themes/seven\";s:9:\"\0*\0engine\";s:4:\"twig\";s:8:\"\0*\0owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:13:\"\0*\0baseThemes\";N;s:22:\"\0*\0baseThemeExtensions\";a:2:{s:6:\"classy\";O:31:\"Drupal\\Core\\Extension\\Extension\":17:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:34:\"core/themes/classy/classy.info.yml\";s:11:\"\0*\0filename\";N;s:7:\"subpath\";s:13:\"themes/classy\";s:6:\"origin\";s:4:\"core\";s:4:\"info\";a:20:{s:4:\"name\";s:6:\"Classy\";s:4:\"type\";s:5:\"theme\";s:11:\"description\";s:176:\"A base theme with sensible default CSS classes added. Learn how to use Classy as a base theme in the <a href=\"https://www.drupal.org/docs/8/theming\">Drupal 8 Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:5:\"8.7.0\";s:4:\"core\";s:3:\"8.x\";s:6:\"hidden\";b:1;s:9:\"libraries\";a:3:{i:0;s:11:\"classy/base\";i:1;s:15:\"classy/messages\";i:2;s:14:\"core/normalize\";}s:16:\"libraries-extend\";a:5:{s:16:\"user/drupal.user\";a:1:{i:0;s:11:\"classy/user\";}s:22:\"core/drupal.dropbutton\";a:1:{i:0;s:17:\"classy/dropbutton\";}s:18:\"core/drupal.dialog\";a:1:{i:0;s:13:\"classy/dialog\";}s:16:\"file/drupal.file\";a:1:{i:0;s:11:\"classy/file\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:15:\"classy/progress\";}}s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:10:\"base theme\";s:6:\"stable\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:12:\"primary_menu\";s:12:\"Primary menu\";s:14:\"secondary_menu\";s:14:\"Secondary menu\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";}s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:33:\"core/themes/classy/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:6:\"stable\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:3:{s:6:\"bartik\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"classy\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}s:5:\"seven\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"classy\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}s:9:\"yorkshire\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"classy\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}}s:8:\"requires\";a:1:{s:6:\"stable\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"stable\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}}s:4:\"sort\";i:-1;s:10:\"sub_themes\";a:3:{s:6:\"bartik\";s:6:\"Bartik\";s:5:\"seven\";s:5:\"Seven\";s:9:\"yorkshire\";s:11:\"DruAdminLTE\";}s:11:\"base_themes\";a:1:{s:6:\"stable\";s:6:\"Stable\";}s:9:\"libraries\";a:3:{i:0;s:11:\"classy/base\";i:1;s:15:\"classy/messages\";i:2;s:14:\"core/normalize\";}s:6:\"engine\";s:4:\"twig\";s:10:\"base_theme\";s:6:\"stable\";}s:6:\"stable\";O:31:\"Drupal\\Core\\Extension\\Extension\":14:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:34:\"core/themes/stable/stable.info.yml\";s:11:\"\0*\0filename\";s:12:\"stable.theme\";s:7:\"subpath\";s:13:\"themes/stable\";s:6:\"origin\";s:4:\"core\";s:4:\"info\";a:18:{s:4:\"name\";s:6:\"Stable\";s:4:\"type\";s:5:\"theme\";s:11:\"description\";s:62:\"A default base theme using Drupal 8.0.0\'s core markup and CSS.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:5:\"8.7.0\";s:4:\"core\";s:3:\"8.x\";s:6:\"hidden\";b:1;s:18:\"libraries-override\";a:51:{s:24:\"block/drupal.block.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/block.admin.css\";s:25:\"css/block/block.admin.css\";}}}s:24:\"ckeditor/drupal.ckeditor\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:16:\"css/ckeditor.css\";s:25:\"css/ckeditor/ckeditor.css\";}}}s:51:\"ckeditor/drupal.ckeditor.plugins.drupalimagecaption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:62:\"css/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";s:71:\"css/ckeditor/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";}}}s:41:\"ckeditor/drupal.ckeditor.plugins.language\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:42:\"css/plugins/language/ckeditor.language.css\";s:51:\"css/ckeditor/plugins/language/ckeditor.language.css\";}}}s:30:\"ckeditor/drupal.ckeditor.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/ckeditor.admin.css\";s:31:\"css/ckeditor/ckeditor.admin.css\";}}}s:11:\"color/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/color.admin.css\";s:25:\"css/color/color.admin.css\";}}}s:50:\"config_translation/drupal.config_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:32:\"css/config_translation.admin.css\";s:51:\"css/config_translation/config_translation.admin.css\";}}}s:52:\"content_translation/drupal.content_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:33:\"css/content_translation.admin.css\";s:53:\"css/content_translation/content_translation.admin.css\";}}}s:37:\"content_moderation/content_moderation\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:33:\"css/content_moderation.module.css\";s:52:\"css/content_moderation/content_moderation.module.css\";}s:5:\"theme\";a:1:{s:32:\"css/content_moderation.theme.css\";s:51:\"css/content_moderation/content_moderation.theme.css\";}}}s:34:\"contextual/drupal.contextual-links\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:25:\"css/contextual.module.css\";s:36:\"css/contextual/contextual.module.css\";}s:5:\"theme\";a:2:{s:24:\"css/contextual.theme.css\";s:35:\"css/contextual/contextual.theme.css\";s:30:\"css/contextual.icons.theme.css\";s:41:\"css/contextual/contextual.icons.theme.css\";}}}s:36:\"contextual/drupal.contextual-toolbar\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:26:\"css/contextual.toolbar.css\";s:37:\"css/contextual/contextual.toolbar.css\";}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:2:{s:4:\"base\";a:4:{s:32:\"misc/dialog/off-canvas.reset.css\";s:36:\"css/core/dialog/off-canvas.reset.css\";s:31:\"misc/dialog/off-canvas.base.css\";s:35:\"css/core/dialog/off-canvas.base.css\";s:26:\"misc/dialog/off-canvas.css\";s:30:\"css/core/dialog/off-canvas.css\";s:32:\"misc/dialog/off-canvas.theme.css\";s:36:\"css/core/dialog/off-canvas.theme.css\";}s:9:\"component\";a:8:{s:33:\"misc/dialog/off-canvas.motion.css\";s:37:\"css/core/dialog/off-canvas.motion.css\";s:33:\"misc/dialog/off-canvas.button.css\";s:37:\"css/core/dialog/off-canvas.button.css\";s:31:\"misc/dialog/off-canvas.form.css\";s:35:\"css/core/dialog/off-canvas.form.css\";s:32:\"misc/dialog/off-canvas.table.css\";s:36:\"css/core/dialog/off-canvas.table.css\";s:34:\"misc/dialog/off-canvas.details.css\";s:38:\"css/core/dialog/off-canvas.details.css\";s:36:\"misc/dialog/off-canvas.tabledrag.css\";s:40:\"css/core/dialog/off-canvas.tabledrag.css\";s:37:\"misc/dialog/off-canvas.dropbutton.css\";s:41:\"css/core/dialog/off-canvas.dropbutton.css\";s:33:\"misc/dialog/off-canvas.layout.css\";s:37:\"css/core/dialog/off-canvas.layout.css\";}}}s:22:\"core/drupal.dropbutton\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:30:\"misc/dropbutton/dropbutton.css\";s:34:\"css/core/dropbutton/dropbutton.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";s:26:\"css/core/vertical-tabs.css\";}}}s:18:\"dblog/drupal.dblog\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/dblog.module.css\";s:26:\"css/dblog/dblog.module.css\";}}}s:24:\"field_ui/drupal.field_ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/field_ui.admin.css\";s:31:\"css/field_ui/field_ui.admin.css\";}}}s:16:\"file/drupal.file\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/file.admin.css\";s:23:\"css/file/file.admin.css\";}}}s:26:\"filter/drupal.filter.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:20:\"filter/drupal.filter\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:14:\"filter/caption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/filter.caption.css\";s:29:\"css/filter/filter.caption.css\";}}}s:11:\"image/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/image.admin.css\";s:25:\"css/image/image.admin.css\";}}}s:35:\"image/quickedit.inPlaceEditor.image\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:21:\"css/editors/image.css\";s:27:\"css/image/editors/image.css\";}s:5:\"theme\";a:1:{s:27:\"css/editors/image.theme.css\";s:33:\"css/image/editors/image.theme.css\";}}}s:30:\"language/drupal.language.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/language.admin.css\";s:31:\"css/language/language.admin.css\";}}}s:36:\"layout_builder/drupal.layout_builder\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/layout-builder.css\";s:37:\"css/layout_builder/layout-builder.css\";}}}s:26:\"locale/drupal.locale.admin\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/locale.admin.css\";s:27:\"css/locale/locale.admin.css\";}}}s:22:\"media/oembed.formatter\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:24:\"css/oembed.formatter.css\";s:30:\"css/media/oembed.formatter.css\";}}}s:18:\"media/oembed.frame\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/oembed.frame.css\";s:26:\"css/media/oembed.frame.css\";}}}s:33:\"menu_ui/drupal.menu_ui.adminforms\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:21:\"css/menu_ui.admin.css\";s:29:\"css/menu_ui/menu_ui.admin.css\";}}}s:22:\"migrate_drupal_ui/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:49:\"css/components/upgrade-analysis-report-tables.css\";s:67:\"css/migrate_drupal_ui/components/upgrade-analysis-report-tables.css\";}}}s:16:\"node/drupal.node\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:24:\"node/drupal.node.preview\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/node.preview.css\";s:25:\"css/node/node.preview.css\";}}}s:9:\"node/form\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:22:\"node/drupal.node.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/node.admin.css\";s:23:\"css/node/node.admin.css\";}}}s:19:\"quickedit/quickedit\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:24:\"css/quickedit.module.css\";s:34:\"css/quickedit/quickedit.module.css\";}s:5:\"theme\";a:2:{s:23:\"css/quickedit.theme.css\";s:33:\"css/quickedit/quickedit.theme.css\";s:29:\"css/quickedit.icons.theme.css\";s:39:\"css/quickedit/quickedit.icons.theme.css\";}}}s:34:\"settings_tray/drupal.settings_tray\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:3:{s:28:\"css/settings_tray.module.css\";s:42:\"css/settings_tray/settings_tray.module.css\";s:28:\"css/settings_tray.motion.css\";s:42:\"css/settings_tray/settings_tray.motion.css\";s:29:\"css/settings_tray.toolbar.css\";s:43:\"css/settings_tray/settings_tray.toolbar.css\";}s:5:\"theme\";a:1:{s:27:\"css/settings_tray.theme.css\";s:41:\"css/settings_tray/settings_tray.theme.css\";}}}s:24:\"shortcut/drupal.shortcut\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:2:{s:22:\"css/shortcut.theme.css\";s:31:\"css/shortcut/shortcut.theme.css\";s:28:\"css/shortcut.icons.theme.css\";s:37:\"css/shortcut/shortcut.icons.theme.css\";}}}s:28:\"simpletest/drupal.simpletest\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:25:\"css/simpletest.module.css\";s:36:\"css/simpletest/simpletest.module.css\";}}}s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:22:{s:39:\"css/components/ajax-progress.module.css\";s:46:\"css/system/components/ajax-progress.module.css\";s:31:\"css/components/align.module.css\";s:38:\"css/system/components/align.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:53:\"css/system/components/autocomplete-loading.module.css\";s:36:\"css/components/fieldgroup.module.css\";s:43:\"css/system/components/fieldgroup.module.css\";s:42:\"css/components/container-inline.module.css\";s:49:\"css/system/components/container-inline.module.css\";s:34:\"css/components/clearfix.module.css\";s:41:\"css/system/components/clearfix.module.css\";s:33:\"css/components/details.module.css\";s:40:\"css/system/components/details.module.css\";s:32:\"css/components/hidden.module.css\";s:39:\"css/system/components/hidden.module.css\";s:35:\"css/components/item-list.module.css\";s:42:\"css/system/components/item-list.module.css\";s:28:\"css/components/js.module.css\";s:35:\"css/system/components/js.module.css\";s:32:\"css/components/nowrap.module.css\";s:39:\"css/system/components/nowrap.module.css\";s:44:\"css/components/position-container.module.css\";s:51:\"css/system/components/position-container.module.css\";s:34:\"css/components/progress.module.css\";s:41:\"css/system/components/progress.module.css\";s:42:\"css/components/reset-appearance.module.css\";s:49:\"css/system/components/reset-appearance.module.css\";s:32:\"css/components/resize.module.css\";s:39:\"css/system/components/resize.module.css\";s:39:\"css/components/sticky-header.module.css\";s:46:\"css/system/components/sticky-header.module.css\";s:40:\"css/components/system-status-counter.css\";s:47:\"css/system/components/system-status-counter.css\";s:48:\"css/components/system-status-report-counters.css\";s:55:\"css/system/components/system-status-report-counters.css\";s:52:\"css/components/system-status-report-general-info.css\";s:59:\"css/system/components/system-status-report-general-info.css\";s:35:\"css/components/tabledrag.module.css\";s:42:\"css/system/components/tabledrag.module.css\";s:35:\"css/components/tablesort.module.css\";s:42:\"css/system/components/tablesort.module.css\";s:36:\"css/components/tree-child.module.css\";s:43:\"css/system/components/tree-child.module.css\";}}}s:12:\"system/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/system.admin.css\";s:27:\"css/system/system.admin.css\";}}}s:18:\"system/maintenance\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/system.maintenance.css\";s:33:\"css/system/system.maintenance.css\";}}}s:11:\"system/diff\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/system.diff.css\";s:26:\"css/system/system.diff.css\";}}}s:24:\"taxonomy/drupal.taxonomy\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/taxonomy.theme.css\";s:31:\"css/taxonomy/taxonomy.theme.css\";}}}s:15:\"toolbar/toolbar\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/toolbar.module.css\";s:30:\"css/toolbar/toolbar.module.css\";}s:5:\"theme\";a:2:{s:21:\"css/toolbar.theme.css\";s:29:\"css/toolbar/toolbar.theme.css\";s:27:\"css/toolbar.icons.theme.css\";s:35:\"css/toolbar/toolbar.icons.theme.css\";}}}s:20:\"toolbar/toolbar.menu\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:20:\"css/toolbar.menu.css\";s:28:\"css/toolbar/toolbar.menu.css\";}}}s:17:\"tour/tour-styling\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/tour.module.css\";s:24:\"css/tour/tour.module.css\";}}}s:26:\"update/drupal.update.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/update.admin.theme.css\";s:33:\"css/update/update.admin.theme.css\";}}}s:16:\"user/drupal.user\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/user.module.css\";s:24:\"css/user/user.module.css\";}}}s:22:\"user/drupal.user.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/user.admin.css\";s:23:\"css/user/user.admin.css\";}}}s:22:\"user/drupal.user.icons\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:24:\"css/user.icons.admin.css\";s:29:\"css/user/user.icons.admin.css\";}}}s:18:\"views/views.module\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/views.module.css\";s:26:\"css/views/views.module.css\";}}}s:22:\"views_ui/admin.styling\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/views_ui.admin.css\";s:31:\"css/views_ui/views_ui.admin.css\";}s:5:\"theme\";a:2:{s:28:\"css/views_ui.admin.theme.css\";s:37:\"css/views_ui/views_ui.admin.theme.css\";s:27:\"css/views_ui.contextual.css\";s:36:\"css/views_ui/views_ui.contextual.css\";}}}}s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:12:\"primary_menu\";s:12:\"Primary menu\";s:14:\"secondary_menu\";s:14:\"Secondary menu\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";}s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:33:\"core/themes/stable/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:9:\"libraries\";a:0:{}s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:4:{s:6:\"classy\";r:86;s:6:\"bartik\";r:86;s:5:\"seven\";r:86;s:9:\"yorkshire\";r:86;}s:8:\"requires\";a:0:{}s:4:\"sort\";i:0;s:10:\"sub_themes\";a:4:{s:6:\"bartik\";s:6:\"Bartik\";s:6:\"classy\";s:6:\"Classy\";s:5:\"seven\";s:5:\"Seven\";s:9:\"yorkshire\";s:11:\"DruAdminLTE\";}s:6:\"engine\";s:4:\"twig\";}}s:12:\"\0*\0extension\";O:31:\"Drupal\\Core\\Extension\\Extension\":16:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:32:\"core/themes/seven/seven.info.yml\";s:11:\"\0*\0filename\";s:11:\"seven.theme\";s:7:\"subpath\";s:12:\"themes/seven\";s:6:\"origin\";s:4:\"core\";s:4:\"info\";a:22:{s:4:\"name\";s:5:\"Seven\";s:4:\"type\";s:5:\"theme\";s:10:\"base theme\";s:6:\"classy\";s:11:\"description\";s:153:\"The default administration theme for Drupal 8 was designed with clean lines, simple blocks, and sans-serif font to emphasize the tools and tasks at hand.\";s:8:\"alt text\";s:77:\"Default administration theme for Drupal 8 with simple blocks and clean lines.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:5:\"8.7.0\";s:4:\"core\";s:3:\"8.x\";s:9:\"libraries\";a:1:{i:0;s:20:\"seven/global-styling\";}s:18:\"libraries-override\";a:6:{s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:3:{s:67:\"/core/themes/stable/css/system/components/system-status-counter.css\";s:40:\"css/components/system-status-counter.css\";s:75:\"/core/themes/stable/css/system/components/system-status-report-counters.css\";s:48:\"css/components/system-status-report-counters.css\";s:79:\"/core/themes/stable/css/system/components/system-status-report-general-info.css\";s:52:\"css/components/system-status-report-general-info.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";b:0;}}}s:14:\"core/jquery.ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:21:\"core/jquery.ui.dialog\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:46:\"assets/vendor/jquery.ui/themes/base/dialog.css\";b:0;}}}s:13:\"classy/dialog\";s:25:\"seven/seven.drupal.dialog\";s:11:\"classy/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:26:\"css/components/details.css\";b:0;}}}}s:16:\"libraries-extend\";a:4:{s:13:\"core/ckeditor\";a:1:{i:0;s:21:\"seven/ckeditor-dialog\";}s:25:\"core/drupal.vertical-tabs\";a:1:{i:0;s:19:\"seven/vertical-tabs\";}s:14:\"core/jquery.ui\";a:1:{i:0;s:21:\"seven/seven.jquery.ui\";}s:17:\"tour/tour-styling\";a:1:{i:0;s:18:\"seven/tour-styling\";}}s:21:\"quickedit_stylesheets\";a:1:{i:0;s:28:\"css/components/quickedit.css\";}s:7:\"regions\";a:9:{s:6:\"header\";s:6:\"Header\";s:11:\"pre_content\";s:11:\"Pre-content\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:32:\"core/themes/seven/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:6:\"classy\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:0:{}s:8:\"requires\";a:2:{s:6:\"classy\";r:77;s:6:\"stable\";r:86;}s:4:\"sort\";i:-3;s:11:\"base_themes\";a:2:{s:6:\"stable\";s:6:\"Stable\";s:6:\"classy\";s:6:\"Classy\";}s:9:\"libraries\";a:1:{i:0;s:20:\"seven/global-styling\";}s:6:\"engine\";s:4:\"twig\";s:10:\"base_theme\";s:6:\"classy\";}s:20:\"\0*\0styleSheetsRemove\";a:0:{}s:12:\"\0*\0libraries\";a:4:{i:0;s:11:\"classy/base\";i:1;s:15:\"classy/messages\";i:2;s:14:\"core/normalize\";i:3;s:20:\"seven/global-styling\";}s:10:\"\0*\0regions\";a:9:{s:6:\"header\";s:6:\"Header\";s:11:\"pre_content\";s:11:\"Pre-content\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";}s:20:\"\0*\0librariesOverride\";a:2:{s:18:\"core/themes/stable\";a:51:{s:24:\"block/drupal.block.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/block.admin.css\";s:25:\"css/block/block.admin.css\";}}}s:24:\"ckeditor/drupal.ckeditor\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:16:\"css/ckeditor.css\";s:25:\"css/ckeditor/ckeditor.css\";}}}s:51:\"ckeditor/drupal.ckeditor.plugins.drupalimagecaption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:62:\"css/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";s:71:\"css/ckeditor/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";}}}s:41:\"ckeditor/drupal.ckeditor.plugins.language\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:42:\"css/plugins/language/ckeditor.language.css\";s:51:\"css/ckeditor/plugins/language/ckeditor.language.css\";}}}s:30:\"ckeditor/drupal.ckeditor.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/ckeditor.admin.css\";s:31:\"css/ckeditor/ckeditor.admin.css\";}}}s:11:\"color/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/color.admin.css\";s:25:\"css/color/color.admin.css\";}}}s:50:\"config_translation/drupal.config_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:32:\"css/config_translation.admin.css\";s:51:\"css/config_translation/config_translation.admin.css\";}}}s:52:\"content_translation/drupal.content_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:33:\"css/content_translation.admin.css\";s:53:\"css/content_translation/content_translation.admin.css\";}}}s:37:\"content_moderation/content_moderation\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:33:\"css/content_moderation.module.css\";s:52:\"css/content_moderation/content_moderation.module.css\";}s:5:\"theme\";a:1:{s:32:\"css/content_moderation.theme.css\";s:51:\"css/content_moderation/content_moderation.theme.css\";}}}s:34:\"contextual/drupal.contextual-links\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:25:\"css/contextual.module.css\";s:36:\"css/contextual/contextual.module.css\";}s:5:\"theme\";a:2:{s:24:\"css/contextual.theme.css\";s:35:\"css/contextual/contextual.theme.css\";s:30:\"css/contextual.icons.theme.css\";s:41:\"css/contextual/contextual.icons.theme.css\";}}}s:36:\"contextual/drupal.contextual-toolbar\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:26:\"css/contextual.toolbar.css\";s:37:\"css/contextual/contextual.toolbar.css\";}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:2:{s:4:\"base\";a:4:{s:32:\"misc/dialog/off-canvas.reset.css\";s:36:\"css/core/dialog/off-canvas.reset.css\";s:31:\"misc/dialog/off-canvas.base.css\";s:35:\"css/core/dialog/off-canvas.base.css\";s:26:\"misc/dialog/off-canvas.css\";s:30:\"css/core/dialog/off-canvas.css\";s:32:\"misc/dialog/off-canvas.theme.css\";s:36:\"css/core/dialog/off-canvas.theme.css\";}s:9:\"component\";a:8:{s:33:\"misc/dialog/off-canvas.motion.css\";s:37:\"css/core/dialog/off-canvas.motion.css\";s:33:\"misc/dialog/off-canvas.button.css\";s:37:\"css/core/dialog/off-canvas.button.css\";s:31:\"misc/dialog/off-canvas.form.css\";s:35:\"css/core/dialog/off-canvas.form.css\";s:32:\"misc/dialog/off-canvas.table.css\";s:36:\"css/core/dialog/off-canvas.table.css\";s:34:\"misc/dialog/off-canvas.details.css\";s:38:\"css/core/dialog/off-canvas.details.css\";s:36:\"misc/dialog/off-canvas.tabledrag.css\";s:40:\"css/core/dialog/off-canvas.tabledrag.css\";s:37:\"misc/dialog/off-canvas.dropbutton.css\";s:41:\"css/core/dialog/off-canvas.dropbutton.css\";s:33:\"misc/dialog/off-canvas.layout.css\";s:37:\"css/core/dialog/off-canvas.layout.css\";}}}s:22:\"core/drupal.dropbutton\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:30:\"misc/dropbutton/dropbutton.css\";s:34:\"css/core/dropbutton/dropbutton.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";s:26:\"css/core/vertical-tabs.css\";}}}s:18:\"dblog/drupal.dblog\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/dblog.module.css\";s:26:\"css/dblog/dblog.module.css\";}}}s:24:\"field_ui/drupal.field_ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/field_ui.admin.css\";s:31:\"css/field_ui/field_ui.admin.css\";}}}s:16:\"file/drupal.file\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/file.admin.css\";s:23:\"css/file/file.admin.css\";}}}s:26:\"filter/drupal.filter.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:20:\"filter/drupal.filter\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:14:\"filter/caption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/filter.caption.css\";s:29:\"css/filter/filter.caption.css\";}}}s:11:\"image/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/image.admin.css\";s:25:\"css/image/image.admin.css\";}}}s:35:\"image/quickedit.inPlaceEditor.image\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:21:\"css/editors/image.css\";s:27:\"css/image/editors/image.css\";}s:5:\"theme\";a:1:{s:27:\"css/editors/image.theme.css\";s:33:\"css/image/editors/image.theme.css\";}}}s:30:\"language/drupal.language.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/language.admin.css\";s:31:\"css/language/language.admin.css\";}}}s:36:\"layout_builder/drupal.layout_builder\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/layout-builder.css\";s:37:\"css/layout_builder/layout-builder.css\";}}}s:26:\"locale/drupal.locale.admin\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/locale.admin.css\";s:27:\"css/locale/locale.admin.css\";}}}s:22:\"media/oembed.formatter\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:24:\"css/oembed.formatter.css\";s:30:\"css/media/oembed.formatter.css\";}}}s:18:\"media/oembed.frame\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/oembed.frame.css\";s:26:\"css/media/oembed.frame.css\";}}}s:33:\"menu_ui/drupal.menu_ui.adminforms\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:21:\"css/menu_ui.admin.css\";s:29:\"css/menu_ui/menu_ui.admin.css\";}}}s:22:\"migrate_drupal_ui/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:49:\"css/components/upgrade-analysis-report-tables.css\";s:67:\"css/migrate_drupal_ui/components/upgrade-analysis-report-tables.css\";}}}s:16:\"node/drupal.node\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:24:\"node/drupal.node.preview\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/node.preview.css\";s:25:\"css/node/node.preview.css\";}}}s:9:\"node/form\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:22:\"node/drupal.node.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/node.admin.css\";s:23:\"css/node/node.admin.css\";}}}s:19:\"quickedit/quickedit\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:24:\"css/quickedit.module.css\";s:34:\"css/quickedit/quickedit.module.css\";}s:5:\"theme\";a:2:{s:23:\"css/quickedit.theme.css\";s:33:\"css/quickedit/quickedit.theme.css\";s:29:\"css/quickedit.icons.theme.css\";s:39:\"css/quickedit/quickedit.icons.theme.css\";}}}s:34:\"settings_tray/drupal.settings_tray\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:3:{s:28:\"css/settings_tray.module.css\";s:42:\"css/settings_tray/settings_tray.module.css\";s:28:\"css/settings_tray.motion.css\";s:42:\"css/settings_tray/settings_tray.motion.css\";s:29:\"css/settings_tray.toolbar.css\";s:43:\"css/settings_tray/settings_tray.toolbar.css\";}s:5:\"theme\";a:1:{s:27:\"css/settings_tray.theme.css\";s:41:\"css/settings_tray/settings_tray.theme.css\";}}}s:24:\"shortcut/drupal.shortcut\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:2:{s:22:\"css/shortcut.theme.css\";s:31:\"css/shortcut/shortcut.theme.css\";s:28:\"css/shortcut.icons.theme.css\";s:37:\"css/shortcut/shortcut.icons.theme.css\";}}}s:28:\"simpletest/drupal.simpletest\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:25:\"css/simpletest.module.css\";s:36:\"css/simpletest/simpletest.module.css\";}}}s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:22:{s:39:\"css/components/ajax-progress.module.css\";s:46:\"css/system/components/ajax-progress.module.css\";s:31:\"css/components/align.module.css\";s:38:\"css/system/components/align.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:53:\"css/system/components/autocomplete-loading.module.css\";s:36:\"css/components/fieldgroup.module.css\";s:43:\"css/system/components/fieldgroup.module.css\";s:42:\"css/components/container-inline.module.css\";s:49:\"css/system/components/container-inline.module.css\";s:34:\"css/components/clearfix.module.css\";s:41:\"css/system/components/clearfix.module.css\";s:33:\"css/components/details.module.css\";s:40:\"css/system/components/details.module.css\";s:32:\"css/components/hidden.module.css\";s:39:\"css/system/components/hidden.module.css\";s:35:\"css/components/item-list.module.css\";s:42:\"css/system/components/item-list.module.css\";s:28:\"css/components/js.module.css\";s:35:\"css/system/components/js.module.css\";s:32:\"css/components/nowrap.module.css\";s:39:\"css/system/components/nowrap.module.css\";s:44:\"css/components/position-container.module.css\";s:51:\"css/system/components/position-container.module.css\";s:34:\"css/components/progress.module.css\";s:41:\"css/system/components/progress.module.css\";s:42:\"css/components/reset-appearance.module.css\";s:49:\"css/system/components/reset-appearance.module.css\";s:32:\"css/components/resize.module.css\";s:39:\"css/system/components/resize.module.css\";s:39:\"css/components/sticky-header.module.css\";s:46:\"css/system/components/sticky-header.module.css\";s:40:\"css/components/system-status-counter.css\";s:47:\"css/system/components/system-status-counter.css\";s:48:\"css/components/system-status-report-counters.css\";s:55:\"css/system/components/system-status-report-counters.css\";s:52:\"css/components/system-status-report-general-info.css\";s:59:\"css/system/components/system-status-report-general-info.css\";s:35:\"css/components/tabledrag.module.css\";s:42:\"css/system/components/tabledrag.module.css\";s:35:\"css/components/tablesort.module.css\";s:42:\"css/system/components/tablesort.module.css\";s:36:\"css/components/tree-child.module.css\";s:43:\"css/system/components/tree-child.module.css\";}}}s:12:\"system/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/system.admin.css\";s:27:\"css/system/system.admin.css\";}}}s:18:\"system/maintenance\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/system.maintenance.css\";s:33:\"css/system/system.maintenance.css\";}}}s:11:\"system/diff\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/system.diff.css\";s:26:\"css/system/system.diff.css\";}}}s:24:\"taxonomy/drupal.taxonomy\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/taxonomy.theme.css\";s:31:\"css/taxonomy/taxonomy.theme.css\";}}}s:15:\"toolbar/toolbar\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/toolbar.module.css\";s:30:\"css/toolbar/toolbar.module.css\";}s:5:\"theme\";a:2:{s:21:\"css/toolbar.theme.css\";s:29:\"css/toolbar/toolbar.theme.css\";s:27:\"css/toolbar.icons.theme.css\";s:35:\"css/toolbar/toolbar.icons.theme.css\";}}}s:20:\"toolbar/toolbar.menu\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:20:\"css/toolbar.menu.css\";s:28:\"css/toolbar/toolbar.menu.css\";}}}s:17:\"tour/tour-styling\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/tour.module.css\";s:24:\"css/tour/tour.module.css\";}}}s:26:\"update/drupal.update.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/update.admin.theme.css\";s:33:\"css/update/update.admin.theme.css\";}}}s:16:\"user/drupal.user\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/user.module.css\";s:24:\"css/user/user.module.css\";}}}s:22:\"user/drupal.user.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/user.admin.css\";s:23:\"css/user/user.admin.css\";}}}s:22:\"user/drupal.user.icons\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:24:\"css/user.icons.admin.css\";s:29:\"css/user/user.icons.admin.css\";}}}s:18:\"views/views.module\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/views.module.css\";s:26:\"css/views/views.module.css\";}}}s:22:\"views_ui/admin.styling\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/views_ui.admin.css\";s:31:\"css/views_ui/views_ui.admin.css\";}s:5:\"theme\";a:2:{s:28:\"css/views_ui.admin.theme.css\";s:37:\"css/views_ui/views_ui.admin.theme.css\";s:27:\"css/views_ui.contextual.css\";s:36:\"css/views_ui/views_ui.contextual.css\";}}}}s:17:\"core/themes/seven\";a:6:{s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:3:{s:67:\"/core/themes/stable/css/system/components/system-status-counter.css\";s:40:\"css/components/system-status-counter.css\";s:75:\"/core/themes/stable/css/system/components/system-status-report-counters.css\";s:48:\"css/components/system-status-report-counters.css\";s:79:\"/core/themes/stable/css/system/components/system-status-report-general-info.css\";s:52:\"css/components/system-status-report-general-info.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";b:0;}}}s:14:\"core/jquery.ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:21:\"core/jquery.ui.dialog\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:46:\"assets/vendor/jquery.ui/themes/base/dialog.css\";b:0;}}}s:13:\"classy/dialog\";s:25:\"seven/seven.drupal.dialog\";s:11:\"classy/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:26:\"css/components/details.css\";b:0;}}}}}s:18:\"\0*\0librariesExtend\";a:9:{s:16:\"user/drupal.user\";a:1:{i:0;s:11:\"classy/user\";}s:22:\"core/drupal.dropbutton\";a:1:{i:0;s:17:\"classy/dropbutton\";}s:18:\"core/drupal.dialog\";a:1:{i:0;s:13:\"classy/dialog\";}s:16:\"file/drupal.file\";a:1:{i:0;s:11:\"classy/file\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:15:\"classy/progress\";}s:13:\"core/ckeditor\";a:1:{i:0;s:21:\"seven/ckeditor-dialog\";}s:25:\"core/drupal.vertical-tabs\";a:1:{i:0;s:19:\"seven/vertical-tabs\";}s:14:\"core/jquery.ui\";a:1:{i:0;s:21:\"seven/seven.jquery.ui\";}s:17:\"tour/tour-styling\";a:1:{i:0;s:18:\"seven/tour-styling\";}}}',-1,1579254128.373,1,'','0'),('theme.active_theme.yorkshire',_binary 'O:29:\"Drupal\\Core\\Theme\\ActiveTheme\":13:{s:7:\"\0*\0name\";s:9:\"yorkshire\";s:7:\"\0*\0logo\";s:34:\"themes/druadmin_lte_theme/logo.svg\";s:7:\"\0*\0path\";s:25:\"themes/druadmin_lte_theme\";s:9:\"\0*\0engine\";s:4:\"twig\";s:8:\"\0*\0owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:13:\"\0*\0baseThemes\";N;s:22:\"\0*\0baseThemeExtensions\";a:2:{s:6:\"classy\";O:31:\"Drupal\\Core\\Extension\\Extension\":17:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:34:\"core/themes/classy/classy.info.yml\";s:11:\"\0*\0filename\";N;s:7:\"subpath\";s:13:\"themes/classy\";s:6:\"origin\";s:4:\"core\";s:4:\"info\";a:20:{s:4:\"name\";s:6:\"Classy\";s:4:\"type\";s:5:\"theme\";s:11:\"description\";s:176:\"A base theme with sensible default CSS classes added. Learn how to use Classy as a base theme in the <a href=\"https://www.drupal.org/docs/8/theming\">Drupal 8 Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:5:\"8.7.0\";s:4:\"core\";s:3:\"8.x\";s:6:\"hidden\";b:1;s:9:\"libraries\";a:3:{i:0;s:11:\"classy/base\";i:1;s:15:\"classy/messages\";i:2;s:14:\"core/normalize\";}s:16:\"libraries-extend\";a:5:{s:16:\"user/drupal.user\";a:1:{i:0;s:11:\"classy/user\";}s:22:\"core/drupal.dropbutton\";a:1:{i:0;s:17:\"classy/dropbutton\";}s:18:\"core/drupal.dialog\";a:1:{i:0;s:13:\"classy/dialog\";}s:16:\"file/drupal.file\";a:1:{i:0;s:11:\"classy/file\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:15:\"classy/progress\";}}s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:10:\"base theme\";s:6:\"stable\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:12:\"primary_menu\";s:12:\"Primary menu\";s:14:\"secondary_menu\";s:14:\"Secondary menu\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";}s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:33:\"core/themes/classy/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:6:\"stable\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:3:{s:6:\"bartik\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"classy\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}s:5:\"seven\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"classy\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}s:9:\"yorkshire\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"classy\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}}s:8:\"requires\";a:1:{s:6:\"stable\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:6:\"stable\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}}s:4:\"sort\";i:-1;s:10:\"sub_themes\";a:3:{s:6:\"bartik\";s:6:\"Bartik\";s:5:\"seven\";s:5:\"Seven\";s:9:\"yorkshire\";s:11:\"DruAdminLTE\";}s:11:\"base_themes\";a:1:{s:6:\"stable\";s:6:\"Stable\";}s:9:\"libraries\";a:3:{i:0;s:11:\"classy/base\";i:1;s:15:\"classy/messages\";i:2;s:14:\"core/normalize\";}s:6:\"engine\";s:4:\"twig\";s:10:\"base_theme\";s:6:\"stable\";}s:6:\"stable\";O:31:\"Drupal\\Core\\Extension\\Extension\":14:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:34:\"core/themes/stable/stable.info.yml\";s:11:\"\0*\0filename\";s:12:\"stable.theme\";s:7:\"subpath\";s:13:\"themes/stable\";s:6:\"origin\";s:4:\"core\";s:4:\"info\";a:18:{s:4:\"name\";s:6:\"Stable\";s:4:\"type\";s:5:\"theme\";s:11:\"description\";s:62:\"A default base theme using Drupal 8.0.0\'s core markup and CSS.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:5:\"8.7.0\";s:4:\"core\";s:3:\"8.x\";s:6:\"hidden\";b:1;s:18:\"libraries-override\";a:51:{s:24:\"block/drupal.block.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/block.admin.css\";s:25:\"css/block/block.admin.css\";}}}s:24:\"ckeditor/drupal.ckeditor\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:16:\"css/ckeditor.css\";s:25:\"css/ckeditor/ckeditor.css\";}}}s:51:\"ckeditor/drupal.ckeditor.plugins.drupalimagecaption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:62:\"css/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";s:71:\"css/ckeditor/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";}}}s:41:\"ckeditor/drupal.ckeditor.plugins.language\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:42:\"css/plugins/language/ckeditor.language.css\";s:51:\"css/ckeditor/plugins/language/ckeditor.language.css\";}}}s:30:\"ckeditor/drupal.ckeditor.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/ckeditor.admin.css\";s:31:\"css/ckeditor/ckeditor.admin.css\";}}}s:11:\"color/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/color.admin.css\";s:25:\"css/color/color.admin.css\";}}}s:50:\"config_translation/drupal.config_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:32:\"css/config_translation.admin.css\";s:51:\"css/config_translation/config_translation.admin.css\";}}}s:52:\"content_translation/drupal.content_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:33:\"css/content_translation.admin.css\";s:53:\"css/content_translation/content_translation.admin.css\";}}}s:37:\"content_moderation/content_moderation\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:33:\"css/content_moderation.module.css\";s:52:\"css/content_moderation/content_moderation.module.css\";}s:5:\"theme\";a:1:{s:32:\"css/content_moderation.theme.css\";s:51:\"css/content_moderation/content_moderation.theme.css\";}}}s:34:\"contextual/drupal.contextual-links\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:25:\"css/contextual.module.css\";s:36:\"css/contextual/contextual.module.css\";}s:5:\"theme\";a:2:{s:24:\"css/contextual.theme.css\";s:35:\"css/contextual/contextual.theme.css\";s:30:\"css/contextual.icons.theme.css\";s:41:\"css/contextual/contextual.icons.theme.css\";}}}s:36:\"contextual/drupal.contextual-toolbar\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:26:\"css/contextual.toolbar.css\";s:37:\"css/contextual/contextual.toolbar.css\";}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:2:{s:4:\"base\";a:4:{s:32:\"misc/dialog/off-canvas.reset.css\";s:36:\"css/core/dialog/off-canvas.reset.css\";s:31:\"misc/dialog/off-canvas.base.css\";s:35:\"css/core/dialog/off-canvas.base.css\";s:26:\"misc/dialog/off-canvas.css\";s:30:\"css/core/dialog/off-canvas.css\";s:32:\"misc/dialog/off-canvas.theme.css\";s:36:\"css/core/dialog/off-canvas.theme.css\";}s:9:\"component\";a:8:{s:33:\"misc/dialog/off-canvas.motion.css\";s:37:\"css/core/dialog/off-canvas.motion.css\";s:33:\"misc/dialog/off-canvas.button.css\";s:37:\"css/core/dialog/off-canvas.button.css\";s:31:\"misc/dialog/off-canvas.form.css\";s:35:\"css/core/dialog/off-canvas.form.css\";s:32:\"misc/dialog/off-canvas.table.css\";s:36:\"css/core/dialog/off-canvas.table.css\";s:34:\"misc/dialog/off-canvas.details.css\";s:38:\"css/core/dialog/off-canvas.details.css\";s:36:\"misc/dialog/off-canvas.tabledrag.css\";s:40:\"css/core/dialog/off-canvas.tabledrag.css\";s:37:\"misc/dialog/off-canvas.dropbutton.css\";s:41:\"css/core/dialog/off-canvas.dropbutton.css\";s:33:\"misc/dialog/off-canvas.layout.css\";s:37:\"css/core/dialog/off-canvas.layout.css\";}}}s:22:\"core/drupal.dropbutton\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:30:\"misc/dropbutton/dropbutton.css\";s:34:\"css/core/dropbutton/dropbutton.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";s:26:\"css/core/vertical-tabs.css\";}}}s:18:\"dblog/drupal.dblog\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/dblog.module.css\";s:26:\"css/dblog/dblog.module.css\";}}}s:24:\"field_ui/drupal.field_ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/field_ui.admin.css\";s:31:\"css/field_ui/field_ui.admin.css\";}}}s:16:\"file/drupal.file\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/file.admin.css\";s:23:\"css/file/file.admin.css\";}}}s:26:\"filter/drupal.filter.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:20:\"filter/drupal.filter\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:14:\"filter/caption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/filter.caption.css\";s:29:\"css/filter/filter.caption.css\";}}}s:11:\"image/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/image.admin.css\";s:25:\"css/image/image.admin.css\";}}}s:35:\"image/quickedit.inPlaceEditor.image\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:21:\"css/editors/image.css\";s:27:\"css/image/editors/image.css\";}s:5:\"theme\";a:1:{s:27:\"css/editors/image.theme.css\";s:33:\"css/image/editors/image.theme.css\";}}}s:30:\"language/drupal.language.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/language.admin.css\";s:31:\"css/language/language.admin.css\";}}}s:36:\"layout_builder/drupal.layout_builder\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/layout-builder.css\";s:37:\"css/layout_builder/layout-builder.css\";}}}s:26:\"locale/drupal.locale.admin\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/locale.admin.css\";s:27:\"css/locale/locale.admin.css\";}}}s:22:\"media/oembed.formatter\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:24:\"css/oembed.formatter.css\";s:30:\"css/media/oembed.formatter.css\";}}}s:18:\"media/oembed.frame\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/oembed.frame.css\";s:26:\"css/media/oembed.frame.css\";}}}s:33:\"menu_ui/drupal.menu_ui.adminforms\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:21:\"css/menu_ui.admin.css\";s:29:\"css/menu_ui/menu_ui.admin.css\";}}}s:22:\"migrate_drupal_ui/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:49:\"css/components/upgrade-analysis-report-tables.css\";s:67:\"css/migrate_drupal_ui/components/upgrade-analysis-report-tables.css\";}}}s:16:\"node/drupal.node\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:24:\"node/drupal.node.preview\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/node.preview.css\";s:25:\"css/node/node.preview.css\";}}}s:9:\"node/form\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:22:\"node/drupal.node.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/node.admin.css\";s:23:\"css/node/node.admin.css\";}}}s:19:\"quickedit/quickedit\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:24:\"css/quickedit.module.css\";s:34:\"css/quickedit/quickedit.module.css\";}s:5:\"theme\";a:2:{s:23:\"css/quickedit.theme.css\";s:33:\"css/quickedit/quickedit.theme.css\";s:29:\"css/quickedit.icons.theme.css\";s:39:\"css/quickedit/quickedit.icons.theme.css\";}}}s:34:\"settings_tray/drupal.settings_tray\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:3:{s:28:\"css/settings_tray.module.css\";s:42:\"css/settings_tray/settings_tray.module.css\";s:28:\"css/settings_tray.motion.css\";s:42:\"css/settings_tray/settings_tray.motion.css\";s:29:\"css/settings_tray.toolbar.css\";s:43:\"css/settings_tray/settings_tray.toolbar.css\";}s:5:\"theme\";a:1:{s:27:\"css/settings_tray.theme.css\";s:41:\"css/settings_tray/settings_tray.theme.css\";}}}s:24:\"shortcut/drupal.shortcut\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:2:{s:22:\"css/shortcut.theme.css\";s:31:\"css/shortcut/shortcut.theme.css\";s:28:\"css/shortcut.icons.theme.css\";s:37:\"css/shortcut/shortcut.icons.theme.css\";}}}s:28:\"simpletest/drupal.simpletest\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:25:\"css/simpletest.module.css\";s:36:\"css/simpletest/simpletest.module.css\";}}}s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:22:{s:39:\"css/components/ajax-progress.module.css\";s:46:\"css/system/components/ajax-progress.module.css\";s:31:\"css/components/align.module.css\";s:38:\"css/system/components/align.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:53:\"css/system/components/autocomplete-loading.module.css\";s:36:\"css/components/fieldgroup.module.css\";s:43:\"css/system/components/fieldgroup.module.css\";s:42:\"css/components/container-inline.module.css\";s:49:\"css/system/components/container-inline.module.css\";s:34:\"css/components/clearfix.module.css\";s:41:\"css/system/components/clearfix.module.css\";s:33:\"css/components/details.module.css\";s:40:\"css/system/components/details.module.css\";s:32:\"css/components/hidden.module.css\";s:39:\"css/system/components/hidden.module.css\";s:35:\"css/components/item-list.module.css\";s:42:\"css/system/components/item-list.module.css\";s:28:\"css/components/js.module.css\";s:35:\"css/system/components/js.module.css\";s:32:\"css/components/nowrap.module.css\";s:39:\"css/system/components/nowrap.module.css\";s:44:\"css/components/position-container.module.css\";s:51:\"css/system/components/position-container.module.css\";s:34:\"css/components/progress.module.css\";s:41:\"css/system/components/progress.module.css\";s:42:\"css/components/reset-appearance.module.css\";s:49:\"css/system/components/reset-appearance.module.css\";s:32:\"css/components/resize.module.css\";s:39:\"css/system/components/resize.module.css\";s:39:\"css/components/sticky-header.module.css\";s:46:\"css/system/components/sticky-header.module.css\";s:40:\"css/components/system-status-counter.css\";s:47:\"css/system/components/system-status-counter.css\";s:48:\"css/components/system-status-report-counters.css\";s:55:\"css/system/components/system-status-report-counters.css\";s:52:\"css/components/system-status-report-general-info.css\";s:59:\"css/system/components/system-status-report-general-info.css\";s:35:\"css/components/tabledrag.module.css\";s:42:\"css/system/components/tabledrag.module.css\";s:35:\"css/components/tablesort.module.css\";s:42:\"css/system/components/tablesort.module.css\";s:36:\"css/components/tree-child.module.css\";s:43:\"css/system/components/tree-child.module.css\";}}}s:12:\"system/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/system.admin.css\";s:27:\"css/system/system.admin.css\";}}}s:18:\"system/maintenance\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/system.maintenance.css\";s:33:\"css/system/system.maintenance.css\";}}}s:11:\"system/diff\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/system.diff.css\";s:26:\"css/system/system.diff.css\";}}}s:24:\"taxonomy/drupal.taxonomy\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/taxonomy.theme.css\";s:31:\"css/taxonomy/taxonomy.theme.css\";}}}s:15:\"toolbar/toolbar\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/toolbar.module.css\";s:30:\"css/toolbar/toolbar.module.css\";}s:5:\"theme\";a:2:{s:21:\"css/toolbar.theme.css\";s:29:\"css/toolbar/toolbar.theme.css\";s:27:\"css/toolbar.icons.theme.css\";s:35:\"css/toolbar/toolbar.icons.theme.css\";}}}s:20:\"toolbar/toolbar.menu\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:20:\"css/toolbar.menu.css\";s:28:\"css/toolbar/toolbar.menu.css\";}}}s:17:\"tour/tour-styling\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/tour.module.css\";s:24:\"css/tour/tour.module.css\";}}}s:26:\"update/drupal.update.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/update.admin.theme.css\";s:33:\"css/update/update.admin.theme.css\";}}}s:16:\"user/drupal.user\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/user.module.css\";s:24:\"css/user/user.module.css\";}}}s:22:\"user/drupal.user.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/user.admin.css\";s:23:\"css/user/user.admin.css\";}}}s:22:\"user/drupal.user.icons\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:24:\"css/user.icons.admin.css\";s:29:\"css/user/user.icons.admin.css\";}}}s:18:\"views/views.module\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/views.module.css\";s:26:\"css/views/views.module.css\";}}}s:22:\"views_ui/admin.styling\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/views_ui.admin.css\";s:31:\"css/views_ui/views_ui.admin.css\";}s:5:\"theme\";a:2:{s:28:\"css/views_ui.admin.theme.css\";s:37:\"css/views_ui/views_ui.admin.theme.css\";s:27:\"css/views_ui.contextual.css\";s:36:\"css/views_ui/views_ui.contextual.css\";}}}}s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:12:\"primary_menu\";s:12:\"Primary menu\";s:14:\"secondary_menu\";s:14:\"Secondary menu\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";}s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:33:\"core/themes/stable/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:9:\"libraries\";a:0:{}s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:4:{s:6:\"classy\";r:86;s:6:\"bartik\";r:86;s:5:\"seven\";r:86;s:9:\"yorkshire\";r:86;}s:8:\"requires\";a:0:{}s:4:\"sort\";i:0;s:10:\"sub_themes\";a:4:{s:6:\"bartik\";s:6:\"Bartik\";s:6:\"classy\";s:6:\"Classy\";s:5:\"seven\";s:5:\"Seven\";s:9:\"yorkshire\";s:11:\"DruAdminLTE\";}s:6:\"engine\";s:4:\"twig\";}}s:12:\"\0*\0extension\";O:31:\"Drupal\\Core\\Extension\\Extension\":16:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:44:\"themes/druadmin_lte_theme/yorkshire.info.yml\";s:11:\"\0*\0filename\";s:15:\"yorkshire.theme\";s:7:\"subpath\";s:25:\"themes/druadmin_lte_theme\";s:6:\"origin\";s:0:\"\";s:4:\"info\";a:20:{s:4:\"name\";s:11:\"DruAdminLTE\";s:11:\"description\";s:57:\"Drupal 8 admin theme based on AdminLTE by Almaseed Studio\";s:10:\"base theme\";s:6:\"classy\";s:7:\"package\";s:6:\"Custom\";s:4:\"type\";s:5:\"theme\";s:9:\"libraries\";a:1:{i:0;s:14:\"yorkshire/base\";}s:7:\"regions\";a:8:{s:5:\"brand\";s:13:\"Site Branding\";s:6:\"header\";s:6:\"Header\";s:3:\"top\";s:3:\"Top\";s:7:\"content\";s:7:\"Content\";s:6:\"bottom\";s:6:\"Bottom\";s:7:\"sidebar\";s:7:\"Sidebar\";s:6:\"footer\";s:6:\"Footer\";s:26:\"navbar_right_notifications\";s:26:\"Navbar Right Notifications\";}s:8:\"features\";a:2:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";}s:7:\"version\";s:7:\"8.x-1.0\";s:4:\"core\";s:3:\"8.x\";s:7:\"project\";s:18:\"druadmin_lte_theme\";s:9:\"datestamp\";i:1519506484;s:5:\"mtime\";i:1571232816;s:6:\"engine\";s:4:\"twig\";s:10:\"screenshot\";s:40:\"themes/druadmin_lte_theme/screenshot.png\";s:3:\"php\";s:5:\"5.5.9\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:6:\"classy\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:0:{}s:8:\"requires\";a:2:{s:6:\"classy\";r:81;s:6:\"stable\";r:86;}s:4:\"sort\";i:-4;s:11:\"base_themes\";a:2:{s:6:\"stable\";s:6:\"Stable\";s:6:\"classy\";s:6:\"Classy\";}s:9:\"libraries\";a:1:{i:0;s:14:\"yorkshire/base\";}s:6:\"engine\";s:4:\"twig\";s:10:\"base_theme\";s:6:\"classy\";}s:20:\"\0*\0styleSheetsRemove\";a:0:{}s:12:\"\0*\0libraries\";a:4:{i:0;s:11:\"classy/base\";i:1;s:15:\"classy/messages\";i:2;s:14:\"core/normalize\";i:3;s:14:\"yorkshire/base\";}s:10:\"\0*\0regions\";a:8:{s:5:\"brand\";s:13:\"Site Branding\";s:6:\"header\";s:6:\"Header\";s:3:\"top\";s:3:\"Top\";s:7:\"content\";s:7:\"Content\";s:6:\"bottom\";s:6:\"Bottom\";s:7:\"sidebar\";s:7:\"Sidebar\";s:6:\"footer\";s:6:\"Footer\";s:26:\"navbar_right_notifications\";s:26:\"Navbar Right Notifications\";}s:20:\"\0*\0librariesOverride\";a:1:{s:18:\"core/themes/stable\";a:51:{s:24:\"block/drupal.block.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/block.admin.css\";s:25:\"css/block/block.admin.css\";}}}s:24:\"ckeditor/drupal.ckeditor\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:16:\"css/ckeditor.css\";s:25:\"css/ckeditor/ckeditor.css\";}}}s:51:\"ckeditor/drupal.ckeditor.plugins.drupalimagecaption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:62:\"css/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";s:71:\"css/ckeditor/plugins/drupalimagecaption/ckeditor.drupalimagecaption.css\";}}}s:41:\"ckeditor/drupal.ckeditor.plugins.language\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:42:\"css/plugins/language/ckeditor.language.css\";s:51:\"css/ckeditor/plugins/language/ckeditor.language.css\";}}}s:30:\"ckeditor/drupal.ckeditor.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/ckeditor.admin.css\";s:31:\"css/ckeditor/ckeditor.admin.css\";}}}s:11:\"color/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/color.admin.css\";s:25:\"css/color/color.admin.css\";}}}s:50:\"config_translation/drupal.config_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:32:\"css/config_translation.admin.css\";s:51:\"css/config_translation/config_translation.admin.css\";}}}s:52:\"content_translation/drupal.content_translation.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:33:\"css/content_translation.admin.css\";s:53:\"css/content_translation/content_translation.admin.css\";}}}s:37:\"content_moderation/content_moderation\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:33:\"css/content_moderation.module.css\";s:52:\"css/content_moderation/content_moderation.module.css\";}s:5:\"theme\";a:1:{s:32:\"css/content_moderation.theme.css\";s:51:\"css/content_moderation/content_moderation.theme.css\";}}}s:34:\"contextual/drupal.contextual-links\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:25:\"css/contextual.module.css\";s:36:\"css/contextual/contextual.module.css\";}s:5:\"theme\";a:2:{s:24:\"css/contextual.theme.css\";s:35:\"css/contextual/contextual.theme.css\";s:30:\"css/contextual.icons.theme.css\";s:41:\"css/contextual/contextual.icons.theme.css\";}}}s:36:\"contextual/drupal.contextual-toolbar\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:26:\"css/contextual.toolbar.css\";s:37:\"css/contextual/contextual.toolbar.css\";}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:2:{s:4:\"base\";a:4:{s:32:\"misc/dialog/off-canvas.reset.css\";s:36:\"css/core/dialog/off-canvas.reset.css\";s:31:\"misc/dialog/off-canvas.base.css\";s:35:\"css/core/dialog/off-canvas.base.css\";s:26:\"misc/dialog/off-canvas.css\";s:30:\"css/core/dialog/off-canvas.css\";s:32:\"misc/dialog/off-canvas.theme.css\";s:36:\"css/core/dialog/off-canvas.theme.css\";}s:9:\"component\";a:8:{s:33:\"misc/dialog/off-canvas.motion.css\";s:37:\"css/core/dialog/off-canvas.motion.css\";s:33:\"misc/dialog/off-canvas.button.css\";s:37:\"css/core/dialog/off-canvas.button.css\";s:31:\"misc/dialog/off-canvas.form.css\";s:35:\"css/core/dialog/off-canvas.form.css\";s:32:\"misc/dialog/off-canvas.table.css\";s:36:\"css/core/dialog/off-canvas.table.css\";s:34:\"misc/dialog/off-canvas.details.css\";s:38:\"css/core/dialog/off-canvas.details.css\";s:36:\"misc/dialog/off-canvas.tabledrag.css\";s:40:\"css/core/dialog/off-canvas.tabledrag.css\";s:37:\"misc/dialog/off-canvas.dropbutton.css\";s:41:\"css/core/dialog/off-canvas.dropbutton.css\";s:33:\"misc/dialog/off-canvas.layout.css\";s:37:\"css/core/dialog/off-canvas.layout.css\";}}}s:22:\"core/drupal.dropbutton\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:30:\"misc/dropbutton/dropbutton.css\";s:34:\"css/core/dropbutton/dropbutton.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";s:26:\"css/core/vertical-tabs.css\";}}}s:18:\"dblog/drupal.dblog\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/dblog.module.css\";s:26:\"css/dblog/dblog.module.css\";}}}s:24:\"field_ui/drupal.field_ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/field_ui.admin.css\";s:31:\"css/field_ui/field_ui.admin.css\";}}}s:16:\"file/drupal.file\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/file.admin.css\";s:23:\"css/file/file.admin.css\";}}}s:26:\"filter/drupal.filter.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:20:\"filter/drupal.filter\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/filter.admin.css\";s:27:\"css/filter/filter.admin.css\";}}}s:14:\"filter/caption\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/filter.caption.css\";s:29:\"css/filter/filter.caption.css\";}}}s:11:\"image/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:19:\"css/image.admin.css\";s:25:\"css/image/image.admin.css\";}}}s:35:\"image/quickedit.inPlaceEditor.image\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:21:\"css/editors/image.css\";s:27:\"css/image/editors/image.css\";}s:5:\"theme\";a:1:{s:27:\"css/editors/image.theme.css\";s:33:\"css/image/editors/image.theme.css\";}}}s:30:\"language/drupal.language.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/language.admin.css\";s:31:\"css/language/language.admin.css\";}}}s:36:\"layout_builder/drupal.layout_builder\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/layout-builder.css\";s:37:\"css/layout_builder/layout-builder.css\";}}}s:26:\"locale/drupal.locale.admin\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/locale.admin.css\";s:27:\"css/locale/locale.admin.css\";}}}s:22:\"media/oembed.formatter\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:24:\"css/oembed.formatter.css\";s:30:\"css/media/oembed.formatter.css\";}}}s:18:\"media/oembed.frame\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/oembed.frame.css\";s:26:\"css/media/oembed.frame.css\";}}}s:33:\"menu_ui/drupal.menu_ui.adminforms\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:21:\"css/menu_ui.admin.css\";s:29:\"css/menu_ui/menu_ui.admin.css\";}}}s:22:\"migrate_drupal_ui/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:49:\"css/components/upgrade-analysis-report-tables.css\";s:67:\"css/migrate_drupal_ui/components/upgrade-analysis-report-tables.css\";}}}s:16:\"node/drupal.node\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:24:\"node/drupal.node.preview\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/node.preview.css\";s:25:\"css/node/node.preview.css\";}}}s:9:\"node/form\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";s:24:\"css/node/node.module.css\";}}}s:22:\"node/drupal.node.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/node.admin.css\";s:23:\"css/node/node.admin.css\";}}}s:19:\"quickedit/quickedit\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:24:\"css/quickedit.module.css\";s:34:\"css/quickedit/quickedit.module.css\";}s:5:\"theme\";a:2:{s:23:\"css/quickedit.theme.css\";s:33:\"css/quickedit/quickedit.theme.css\";s:29:\"css/quickedit.icons.theme.css\";s:39:\"css/quickedit/quickedit.icons.theme.css\";}}}s:34:\"settings_tray/drupal.settings_tray\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:3:{s:28:\"css/settings_tray.module.css\";s:42:\"css/settings_tray/settings_tray.module.css\";s:28:\"css/settings_tray.motion.css\";s:42:\"css/settings_tray/settings_tray.motion.css\";s:29:\"css/settings_tray.toolbar.css\";s:43:\"css/settings_tray/settings_tray.toolbar.css\";}s:5:\"theme\";a:1:{s:27:\"css/settings_tray.theme.css\";s:41:\"css/settings_tray/settings_tray.theme.css\";}}}s:24:\"shortcut/drupal.shortcut\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:2:{s:22:\"css/shortcut.theme.css\";s:31:\"css/shortcut/shortcut.theme.css\";s:28:\"css/shortcut.icons.theme.css\";s:37:\"css/shortcut/shortcut.icons.theme.css\";}}}s:28:\"simpletest/drupal.simpletest\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:25:\"css/simpletest.module.css\";s:36:\"css/simpletest/simpletest.module.css\";}}}s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:22:{s:39:\"css/components/ajax-progress.module.css\";s:46:\"css/system/components/ajax-progress.module.css\";s:31:\"css/components/align.module.css\";s:38:\"css/system/components/align.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:53:\"css/system/components/autocomplete-loading.module.css\";s:36:\"css/components/fieldgroup.module.css\";s:43:\"css/system/components/fieldgroup.module.css\";s:42:\"css/components/container-inline.module.css\";s:49:\"css/system/components/container-inline.module.css\";s:34:\"css/components/clearfix.module.css\";s:41:\"css/system/components/clearfix.module.css\";s:33:\"css/components/details.module.css\";s:40:\"css/system/components/details.module.css\";s:32:\"css/components/hidden.module.css\";s:39:\"css/system/components/hidden.module.css\";s:35:\"css/components/item-list.module.css\";s:42:\"css/system/components/item-list.module.css\";s:28:\"css/components/js.module.css\";s:35:\"css/system/components/js.module.css\";s:32:\"css/components/nowrap.module.css\";s:39:\"css/system/components/nowrap.module.css\";s:44:\"css/components/position-container.module.css\";s:51:\"css/system/components/position-container.module.css\";s:34:\"css/components/progress.module.css\";s:41:\"css/system/components/progress.module.css\";s:42:\"css/components/reset-appearance.module.css\";s:49:\"css/system/components/reset-appearance.module.css\";s:32:\"css/components/resize.module.css\";s:39:\"css/system/components/resize.module.css\";s:39:\"css/components/sticky-header.module.css\";s:46:\"css/system/components/sticky-header.module.css\";s:40:\"css/components/system-status-counter.css\";s:47:\"css/system/components/system-status-counter.css\";s:48:\"css/components/system-status-report-counters.css\";s:55:\"css/system/components/system-status-report-counters.css\";s:52:\"css/components/system-status-report-general-info.css\";s:59:\"css/system/components/system-status-report-general-info.css\";s:35:\"css/components/tabledrag.module.css\";s:42:\"css/system/components/tabledrag.module.css\";s:35:\"css/components/tablesort.module.css\";s:42:\"css/system/components/tablesort.module.css\";s:36:\"css/components/tree-child.module.css\";s:43:\"css/system/components/tree-child.module.css\";}}}s:12:\"system/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/system.admin.css\";s:27:\"css/system/system.admin.css\";}}}s:18:\"system/maintenance\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/system.maintenance.css\";s:33:\"css/system/system.maintenance.css\";}}}s:11:\"system/diff\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/system.diff.css\";s:26:\"css/system/system.diff.css\";}}}s:24:\"taxonomy/drupal.taxonomy\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"css/taxonomy.theme.css\";s:31:\"css/taxonomy/taxonomy.theme.css\";}}}s:15:\"toolbar/toolbar\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/toolbar.module.css\";s:30:\"css/toolbar/toolbar.module.css\";}s:5:\"theme\";a:2:{s:21:\"css/toolbar.theme.css\";s:29:\"css/toolbar/toolbar.theme.css\";s:27:\"css/toolbar.icons.theme.css\";s:35:\"css/toolbar/toolbar.icons.theme.css\";}}}s:20:\"toolbar/toolbar.menu\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:20:\"css/toolbar.menu.css\";s:28:\"css/toolbar/toolbar.menu.css\";}}}s:17:\"tour/tour-styling\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/tour.module.css\";s:24:\"css/tour/tour.module.css\";}}}s:26:\"update/drupal.update.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:26:\"css/update.admin.theme.css\";s:33:\"css/update/update.admin.theme.css\";}}}s:16:\"user/drupal.user\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/user.module.css\";s:24:\"css/user/user.module.css\";}}}s:22:\"user/drupal.user.admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:18:\"css/user.admin.css\";s:23:\"css/user/user.admin.css\";}}}s:22:\"user/drupal.user.icons\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:24:\"css/user.icons.admin.css\";s:29:\"css/user/user.icons.admin.css\";}}}s:18:\"views/views.module\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:20:\"css/views.module.css\";s:26:\"css/views/views.module.css\";}}}s:22:\"views_ui/admin.styling\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/views_ui.admin.css\";s:31:\"css/views_ui/views_ui.admin.css\";}s:5:\"theme\";a:2:{s:28:\"css/views_ui.admin.theme.css\";s:37:\"css/views_ui/views_ui.admin.theme.css\";s:27:\"css/views_ui.contextual.css\";s:36:\"css/views_ui/views_ui.contextual.css\";}}}}}s:18:\"\0*\0librariesExtend\";a:5:{s:16:\"user/drupal.user\";a:1:{i:0;s:11:\"classy/user\";}s:22:\"core/drupal.dropbutton\";a:1:{i:0;s:17:\"classy/dropbutton\";}s:18:\"core/drupal.dialog\";a:1:{i:0;s:13:\"classy/dialog\";}s:16:\"file/drupal.file\";a:1:{i:0;s:11:\"classy/file\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:15:\"classy/progress\";}}}',-1,1578495055.729,1,'','0'),('theme_registry:runtime:clidentcastelo',_binary 'a:186:{s:11:\"admin_block\";N;s:19:\"admin_block_content\";N;s:10:\"admin_page\";N;s:16:\"authorize_report\";N;s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:5:\"block\";s:4:\"path\";s:32:\"themes/bootstrap/templates/block\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:22;s:20:\"bootstrap_preprocess\";i:24;s:31:\"clidentcastelo_preprocess_block\";}}s:11:\"block__bare\";a:7:{s:8:\"template\";s:11:\"block--bare\";s:4:\"path\";s:32:\"themes/bootstrap/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:26:\"block__local_actions_block\";N;s:24:\"block__local_tasks_block\";a:7:{s:8:\"template\";s:24:\"block--local-tasks-block\";s:4:\"path\";s:32:\"themes/bootstrap/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:23:\"block__page_title_block\";a:7:{s:8:\"template\";s:23:\"block--page-title-block\";s:4:\"path\";s:32:\"themes/bootstrap/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:13:\"block__search\";N;s:13:\"block__system\";a:7:{s:8:\"template\";s:13:\"block--system\";s:4:\"path\";s:32:\"themes/bootstrap/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:28:\"block__system_branding_block\";N;s:24:\"block__system_menu_block\";N;s:33:\"block__system_menu_block__account\";N;s:30:\"block__system_menu_block__main\";a:7:{s:8:\"template\";s:30:\"block--system-menu-block--main\";s:4:\"path\";s:32:\"themes/bootstrap/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:28:\"block__system_messages_block\";a:7:{s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:28:\"block--system-messages-block\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}s:14:\"render element\";s:8:\"elements\";}s:41:\"block__views_block__node_auxiliar_block_2\";a:7:{s:8:\"template\";s:41:\"block--views-block--node_auxiliar-block-2\";s:4:\"path\";s:38:\"themes/clidentcastelo/templates/blocks\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:36:\"block__views_block__servicos_block_3\";a:7:{s:8:\"template\";s:36:\"block--views-block--servicos-block-3\";s:4:\"path\";s:38:\"themes/clidentcastelo/templates/blocks\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:20:\"bootstrap_preprocess\";i:12;s:31:\"clidentcastelo_preprocess_block\";}}s:22:\"block_content_add_list\";N;s:18:\"bootstrap_carousel\";N;s:18:\"bootstrap_dropdown\";N;s:15:\"bootstrap_modal\";N;s:15:\"bootstrap_panel\";N;s:10:\"breadcrumb\";N;s:10:\"checkboxes\";N;s:25:\"ckeditor_settings_toolbar\";N;s:17:\"color_scheme_form\";N;s:7:\"comment\";N;s:12:\"confirm_form\";N;s:9:\"container\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:9:\"container\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_container\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}}s:17:\"crop_crop_summary\";N;s:19:\"ctools_wizard_trail\";N;s:25:\"ctools_wizard_trail_links\";N;s:13:\"datetime_form\";N;s:16:\"datetime_wrapper\";N;s:7:\"details\";N;s:18:\"dropbutton_wrapper\";N;s:15:\"entity_add_list\";N;s:33:\"eu_cookie_compliance_popup_agreed\";a:6:{s:8:\"template\";s:33:\"eu_cookie_compliance_popup_agreed\";s:9:\"variables\";a:7:{s:7:\"message\";N;s:11:\"hide_button\";N;s:16:\"find_more_button\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:36:\"modules/contrib/eu_cookie_compliance\";s:4:\"path\";s:46:\"modules/contrib/eu_cookie_compliance/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:20:\"bootstrap_preprocess\";}}s:31:\"eu_cookie_compliance_popup_info\";a:6:{s:8:\"template\";s:31:\"eu_cookie_compliance_popup_info\";s:9:\"variables\";a:16:{s:7:\"message\";N;s:12:\"agree_button\";N;s:15:\"disagree_button\";N;s:22:\"secondary_button_label\";N;s:20:\"primary_button_class\";N;s:22:\"secondary_button_class\";N;s:17:\"cookie_categories\";N;s:29:\"save_preferences_button_label\";N;s:25:\"fix_first_cookie_category\";N;s:26:\"privacy_settings_tab_label\";N;s:29:\"withdraw_button_on_info_popup\";b:0;s:6:\"method\";s:7:\"default\";s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:36:\"modules/contrib/eu_cookie_compliance\";s:4:\"path\";s:46:\"modules/contrib/eu_cookie_compliance/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:20:\"bootstrap_preprocess\";}}s:47:\"eu_cookie_compliance_popup_info_consent_default\";N;s:29:\"eu_cookie_compliance_withdraw\";a:6:{s:8:\"template\";s:29:\"eu_cookie_compliance_withdraw\";s:9:\"variables\";a:7:{s:25:\"withdraw_tab_button_label\";N;s:7:\"message\";N;s:28:\"withdraw_action_button_label\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:36:\"modules/contrib/eu_cookie_compliance\";s:4:\"path\";s:46:\"modules/contrib/eu_cookie_compliance/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:20:\"bootstrap_preprocess\";}}s:9:\"feed_icon\";N;s:5:\"field\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:5:\"field\";s:4:\"path\";s:32:\"themes/bootstrap/templates/field\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:4;s:26:\"quickedit_preprocess_field\";i:10;s:20:\"bootstrap_preprocess\";}}s:14:\"field__comment\";N;s:20:\"field__node__created\";a:7:{s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/node\";s:8:\"template\";s:20:\"field--node--created\";s:4:\"path\";s:27:\"core/modules/node/templates\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:4;s:26:\"quickedit_preprocess_field\";i:10;s:20:\"bootstrap_preprocess\";}s:14:\"render element\";s:7:\"element\";}s:18:\"field__node__title\";a:7:{s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/node\";s:8:\"template\";s:18:\"field--node--title\";s:4:\"path\";s:27:\"core/modules/node/templates\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:4;s:26:\"quickedit_preprocess_field\";i:10;s:20:\"bootstrap_preprocess\";}s:14:\"render element\";s:7:\"element\";}s:16:\"field__node__uid\";a:7:{s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/node\";s:8:\"template\";s:16:\"field--node--uid\";s:4:\"path\";s:27:\"core/modules/node/templates\";s:20:\"preprocess functions\";a:7:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:4;s:26:\"quickedit_preprocess_field\";i:10;s:20:\"bootstrap_preprocess\";i:12;s:31:\"rdf_preprocess_field__node__uid\";}s:14:\"render element\";s:7:\"element\";}s:25:\"field_multiple_value_form\";N;s:14:\"field_ui_table\";N;s:8:\"fieldset\";N;s:10:\"file_audio\";N;s:9:\"file_link\";N;s:17:\"file_managed_file\";N;s:16:\"file_upload_help\";N;s:10:\"file_video\";N;s:20:\"file_widget_multiple\";N;s:14:\"filter_caption\";N;s:17:\"filter_guidelines\";N;s:11:\"filter_tips\";N;s:4:\"form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:4:\"form\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_form\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:12:\"form_element\";a:7:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:12:\"form-element\";s:4:\"path\";s:32:\"themes/bootstrap/templates/input\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_form_element\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:12:\"form_element\";}s:18:\"form_element_label\";a:7:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:18:\"form-element-label\";s:4:\"path\";s:32:\"themes/bootstrap/templates/input\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:38:\"template_preprocess_form_element_label\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:18:\"form_element_label\";}s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"html\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:8:\"template\";s:4:\"html\";s:4:\"path\";s:31:\"themes/clidentcastelo/templates\";s:20:\"preprocess functions\";a:9:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"metatag_preprocess_html\";i:4;s:34:\"metatag_open_graph_preprocess_html\";i:5;s:20:\"node_preprocess_html\";i:6;s:19:\"rdf_preprocess_html\";i:7;s:23:\"toolbar_preprocess_html\";i:16;s:20:\"bootstrap_preprocess\";}}s:5:\"image\";a:6:{s:9:\"variables\";a:13:{s:3:\"uri\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}s:5:\"sizes\";N;s:6:\"srcset\";a:0:{}s:10:\"style_name\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:5:\"image\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_image\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"rdf_preprocess_image\";i:8;s:20:\"bootstrap_preprocess\";}}s:12:\"image_anchor\";N;s:18:\"image_crop_summary\";N;s:15:\"image_formatter\";a:8:{s:9:\"variables\";a:8:{s:4:\"item\";N;s:15:\"item_attributes\";N;s:3:\"url\";N;s:11:\"image_style\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"file\";s:15:\"image.field.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/image\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/image/image.field.inc\";}s:8:\"template\";s:15:\"image-formatter\";s:4:\"path\";s:28:\"core/modules/image/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_image_formatter\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:20:\"image_resize_summary\";N;s:20:\"image_rotate_summary\";N;s:28:\"image_scale_and_crop_summary\";N;s:19:\"image_scale_summary\";N;s:11:\"image_style\";a:6:{s:9:\"variables\";a:11:{s:10:\"style_name\";N;s:3:\"uri\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/image\";s:8:\"template\";s:11:\"image-style\";s:4:\"path\";s:28:\"core/modules/image/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:31:\"template_preprocess_image_style\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:19:\"image_style_preview\";N;s:12:\"image_widget\";N;s:11:\"indentation\";N;s:5:\"input\";a:7:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:5:\"input\";s:4:\"path\";s:32:\"themes/bootstrap/templates/input\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:5:\"input\";}s:13:\"input__button\";a:8:{s:8:\"template\";s:13:\"input--button\";s:4:\"path\";s:32:\"themes/bootstrap/templates/input\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"input\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:13:\"input__button\";}s:20:\"input__button__split\";N;s:19:\"input__form_control\";a:8:{s:8:\"template\";s:19:\"input--form-control\";s:4:\"path\";s:32:\"themes/bootstrap/templates/input\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"input\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:5:\"input\";}s:12:\"install_page\";N;s:9:\"item_list\";N;s:40:\"item_list__bootstrap_carousel_indicators\";N;s:19:\"item_list__dropdown\";N;s:31:\"language_content_settings_table\";N;s:35:\"language_negotiation_configure_form\";N;s:28:\"link_formatter_link_separate\";N;s:5:\"links\";a:7:{s:9:\"variables\";a:8:{s:5:\"links\";a:0:{}s:10:\"attributes\";a:1:{s:5:\"class\";a:2:{i:0;s:5:\"links\";i:1;s:5:\"links\";}}s:7:\"heading\";a:0:{}s:16:\"set_active_class\";b:0;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:5:\"links\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_links\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:5:\"links\";}s:29:\"locale_translation_last_check\";N;s:30:\"locale_translation_update_info\";N;s:16:\"maintenance_page\";N;s:21:\"maintenance_task_list\";N;s:4:\"mark\";N;s:4:\"menu\";a:7:{s:9:\"variables\";a:7:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:4:\"menu\";s:4:\"path\";s:31:\"themes/bootstrap/templates/menu\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:4:\"menu\";}s:13:\"menu__account\";N;s:10:\"menu__main\";a:8:{s:8:\"template\";s:10:\"menu--main\";s:4:\"path\";s:31:\"themes/bootstrap/templates/menu\";s:9:\"variables\";a:7:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:4:\"menu\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:4:\"menu\";}s:13:\"menu__toolbar\";a:8:{s:9:\"base hook\";s:4:\"menu\";s:9:\"variables\";a:6:{s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:20:\"core/modules/toolbar\";s:8:\"template\";s:13:\"menu--toolbar\";s:4:\"path\";s:30:\"core/modules/toolbar/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:4:\"menu\";}s:17:\"menu_local_action\";N;s:15:\"menu_local_task\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:15:\"menu-local-task\";s:4:\"path\";s:31:\"themes/bootstrap/templates/menu\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_menu_local_task\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}}s:16:\"menu_local_tasks\";a:6:{s:9:\"variables\";a:6:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:16:\"menu-local-tasks\";s:4:\"path\";s:31:\"themes/bootstrap/templates/menu\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:4;s:20:\"bootstrap_preprocess\";}}s:4:\"node\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:8:\"template\";s:4:\"node\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:14;s:20:\"bootstrap_preprocess\";}}s:13:\"node__2__full\";a:7:{s:8:\"template\";s:13:\"node--2--full\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:13:\"node__3__full\";a:7:{s:8:\"template\";s:13:\"node--3--full\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:20:\"node__noticias__full\";a:7:{s:8:\"template\";s:20:\"node--noticias--full\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:22:\"node__noticias__teaser\";a:7:{s:8:\"template\";s:22:\"node--noticias--teaser\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:16:\"node__page__full\";a:7:{s:8:\"template\";s:16:\"node--page--full\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:15:\"node__slideshow\";a:7:{s:8:\"template\";s:15:\"node--slideshow\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:12:\"node__teaser\";a:7:{s:8:\"template\";s:12:\"node--teaser\";s:4:\"path\";s:36:\"themes/clidentcastelo/templates/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:23:\"support_preprocess_node\";i:6;s:21:\"views_preprocess_node\";i:7;s:20:\"bootstrap_preprocess\";}}s:13:\"node_add_list\";N;s:14:\"node_edit_form\";N;s:23:\"off_canvas_page_wrapper\";a:6:{s:9:\"variables\";a:5:{s:8:\"children\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:23:\"off-canvas-page-wrapper\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:20:\"bootstrap_preprocess\";}}s:4:\"page\";a:7:{s:14:\"render element\";s:4:\"page\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:8:\"template\";s:4:\"page\";s:4:\"path\";s:31:\"themes/clidentcastelo/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";i:16;s:30:\"clidentcastelo_preprocess_page\";}s:20:\"bootstrap preprocess\";s:4:\"page\";}s:10:\"page_title\";a:6:{s:9:\"variables\";a:5:{s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:10:\"page-title\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:31:\"quickedit_preprocess_page_title\";i:3;s:30:\"shortcut_preprocess_page_title\";i:8;s:20:\"bootstrap_preprocess\";}}s:5:\"pager\";a:6:{s:14:\"render element\";s:5:\"pager\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:5:\"pager\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_pager\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}}s:12:\"progress_bar\";N;s:6:\"radios\";N;s:12:\"rdf_metadata\";a:6:{s:9:\"variables\";a:5:{s:8:\"metadata\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"core/modules/rdf\";s:8:\"template\";s:12:\"rdf-metadata\";s:4:\"path\";s:26:\"core/modules/rdf/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_rdf_metadata\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:11:\"rdf_wrapper\";N;s:6:\"region\";a:7:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:6:\"region\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}s:20:\"bootstrap preprocess\";s:6:\"region\";}s:18:\"region__no_wrapper\";N;s:13:\"search_result\";N;s:6:\"select\";N;s:15:\"status_messages\";a:6:{s:9:\"variables\";a:6:{s:15:\"status_headings\";a:0:{}s:12:\"message_list\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:8:\"template\";s:15:\"status-messages\";s:4:\"path\";s:33:\"themes/bootstrap/templates/system\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:4;s:20:\"bootstrap_preprocess\";}}s:13:\"status_report\";N;s:21:\"status_report_counter\";N;s:26:\"status_report_general_info\";N;s:21:\"status_report_grouped\";N;s:18:\"status_report_page\";N;s:18:\"system_admin_index\";N;s:18:\"system_config_form\";N;s:22:\"system_modules_details\";N;s:24:\"system_modules_uninstall\";N;s:18:\"system_themes_page\";N;s:5:\"table\";N;s:19:\"tablesort_indicator\";N;s:13:\"taxonomy_term\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:21:\"core/modules/taxonomy\";s:8:\"template\";s:13:\"taxonomy-term\";s:4:\"path\";s:31:\"core/modules/taxonomy/templates\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_taxonomy_term\";i:2;s:21:\"contextual_preprocess\";i:3;s:28:\"rdf_preprocess_taxonomy_term\";i:4;s:32:\"support_preprocess_taxonomy_term\";i:5;s:20:\"bootstrap_preprocess\";}}s:24:\"taxonomy_term__parcerias\";a:7:{s:8:\"template\";s:24:\"taxonomy-term--parcerias\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/terms\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:13:\"taxonomy_term\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_taxonomy_term\";i:2;s:21:\"contextual_preprocess\";i:3;s:28:\"rdf_preprocess_taxonomy_term\";i:4;s:32:\"support_preprocess_taxonomy_term\";i:5;s:20:\"bootstrap_preprocess\";}}s:23:\"taxonomy_term__servicos\";a:7:{s:8:\"template\";s:23:\"taxonomy-term--servicos\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/terms\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:13:\"taxonomy_term\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_taxonomy_term\";i:2;s:21:\"contextual_preprocess\";i:3;s:28:\"rdf_preprocess_taxonomy_term\";i:4;s:32:\"support_preprocess_taxonomy_term\";i:5;s:20:\"bootstrap_preprocess\";}}s:19:\"text_format_wrapper\";N;s:8:\"textarea\";N;s:4:\"time\";N;s:15:\"token_tree_link\";N;s:7:\"toolbar\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:20:\"core/modules/toolbar\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:30:\"core/modules/toolbar/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_toolbar\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:4:\"user\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/user\";s:8:\"template\";s:4:\"user\";s:4:\"path\";s:27:\"core/modules/user/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_user\";i:2;s:21:\"contextual_preprocess\";i:3;s:19:\"rdf_preprocess_user\";i:4;s:20:\"bootstrap_preprocess\";}}s:8:\"username\";a:6:{s:9:\"variables\";a:7:{s:7:\"account\";N;s:10:\"attributes\";a:0:{}s:12:\"link_options\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/user\";s:8:\"template\";s:8:\"username\";s:4:\"path\";s:27:\"core/modules/user/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:28:\"template_preprocess_username\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"rdf_preprocess_username\";i:4;s:20:\"bootstrap_preprocess\";}}s:13:\"vertical_tabs\";N;s:18:\"views_exposed_form\";N;s:21:\"views_form_views_form\";N;s:16:\"views_mini_pager\";a:7:{s:9:\"variables\";a:10:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"tags\";a:0:{}s:8:\"quantity\";i:9;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"path\";s:32:\"themes/bootstrap/templates/views\";s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-mini-pager\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_mini_pager\";i:2;s:21:\"contextual_preprocess\";i:6;s:20:\"bootstrap_preprocess\";}}s:32:\"views_ui_build_group_filter_form\";N;s:18:\"views_ui_container\";N;s:27:\"views_ui_display_tab_bucket\";N;s:28:\"views_ui_display_tab_setting\";N;s:27:\"views_ui_expose_filter_form\";N;s:30:\"views_ui_rearrange_filter_form\";N;s:27:\"views_ui_style_plugin_table\";N;s:27:\"views_ui_view_displays_list\";N;s:18:\"views_ui_view_info\";N;s:29:\"views_ui_view_preview_section\";N;s:28:\"views_ui_views_listing_table\";N;s:10:\"views_view\";a:7:{s:9:\"variables\";a:17:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"path\";s:32:\"themes/bootstrap/templates/views\";s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:10:\"views-view\";s:4:\"type\";s:10:\"base_theme\";s:10:\"theme path\";s:16:\"themes/bootstrap\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";i:8;s:20:\"bootstrap_preprocess\";}}s:34:\"views_view__node_auxiliar__block_2\";a:8:{s:8:\"template\";s:34:\"views-view--node_auxiliar--block-2\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:17:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";i:4;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:25:\"views_view__team__block_1\";a:8:{s:8:\"template\";s:25:\"views-view--team--block-1\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:17:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";i:4;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:16:\"views_view_field\";a:8:{s:4:\"file\";s:15:\"views.theme.inc\";s:9:\"variables\";a:7:{s:4:\"view\";N;s:5:\"field\";N;s:3:\"row\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/views\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-view-field\";s:4:\"path\";s:28:\"core/modules/views/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_view_field\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:17:\"views_view_fields\";a:7:{s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:3:\"row\";N;s:11:\"field_alias\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"path\";s:28:\"core/modules/views/templates\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:17:\"views-view-fields\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/views\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_views_view_fields\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:41:\"views_view_fields__node_auxiliar__block_2\";a:8:{s:8:\"template\";s:41:\"views-view-fields--node_auxiliar--block-2\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:3:\"row\";N;s:11:\"field_alias\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:17:\"views_view_fields\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_views_view_fields\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:15:\"views_view_grid\";N;s:19:\"views_view_grouping\";N;s:15:\"views_view_list\";N;s:15:\"views_view_opml\";N;s:19:\"views_view_row_opml\";N;s:18:\"views_view_row_rss\";N;s:14:\"views_view_rss\";N;s:18:\"views_view_summary\";N;s:30:\"views_view_summary_unformatted\";N;s:16:\"views_view_table\";N;s:22:\"views_view_unformatted\";a:7:{s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:4:\"path\";s:28:\"core/modules/views/templates\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:22:\"views-view-unformatted\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/views\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}}s:41:\"views_view_unformatted__noticias__block_1\";a:8:{s:8:\"template\";s:41:\"views-view-unformatted--noticias--block-1\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:22:\"views_view_unformatted\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:41:\"views_view_unformatted__noticias__block_2\";N;s:42:\"views_view_unformatted__parcerias__block_1\";a:8:{s:8:\"template\";s:42:\"views-view-unformatted--parcerias--block-1\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:22:\"views_view_unformatted\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:41:\"views_view_unformatted__servicos__block_2\";a:8:{s:8:\"template\";s:41:\"views-view-unformatted--servicos--block-2\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:22:\"views_view_unformatted\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:41:\"views_view_unformatted__servicos__block_3\";a:8:{s:8:\"template\";s:41:\"views-view-unformatted--servicos--block-3\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:22:\"views_view_unformatted\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:42:\"views_view_unformatted__slideshow__block_1\";a:8:{s:8:\"template\";s:42:\"views-view-unformatted--slideshow--block-1\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:22:\"views_view_unformatted\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:37:\"views_view_unformatted__team__block_1\";a:8:{s:8:\"template\";s:37:\"views-view-unformatted--team--block-1\";s:4:\"path\";s:37:\"themes/clidentcastelo/templates/views\";s:9:\"variables\";a:8:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;s:7:\"context\";a:0:{}s:4:\"icon\";N;s:13:\"icon_position\";s:6:\"before\";s:9:\"icon_only\";b:0;}s:9:\"base hook\";s:22:\"views_view_unformatted\";s:4:\"type\";s:5:\"theme\";s:10:\"theme path\";s:21:\"themes/clidentcastelo\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"bootstrap_preprocess\";}s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}}s:10:\"block_list\";N;s:21:\"container__help_block\";N;}',-1,1578495007.002,1,'theme_registry','90'),('theme_registry:runtime:seven',_binary 'a:151:{s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:8:\"template\";s:5:\"block\";s:4:\"path\";s:34:\"core/themes/classy/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:44;s:22:\"seven_preprocess_block\";}}s:22:\"block_content_add_list\";N;s:25:\"ckeditor_settings_toolbar\";N;s:17:\"color_scheme_form\";N;s:7:\"comment\";N;s:14:\"field__comment\";N;s:17:\"crop_crop_summary\";N;s:19:\"ctools_wizard_trail\";N;s:25:\"ctools_wizard_trail_links\";N;s:14:\"field_ui_table\";N;s:9:\"file_link\";N;s:17:\"file_managed_file\";N;s:10:\"file_audio\";N;s:10:\"file_video\";N;s:20:\"file_widget_multiple\";N;s:16:\"file_upload_help\";N;s:11:\"filter_tips\";N;s:19:\"text_format_wrapper\";N;s:17:\"filter_guidelines\";N;s:14:\"filter_caption\";N;s:11:\"image_style\";N;s:19:\"image_style_preview\";N;s:12:\"image_anchor\";N;s:20:\"image_resize_summary\";N;s:19:\"image_scale_summary\";N;s:18:\"image_crop_summary\";N;s:28:\"image_scale_and_crop_summary\";N;s:20:\"image_rotate_summary\";N;s:12:\"image_widget\";N;s:15:\"image_formatter\";N;s:35:\"language_negotiation_configure_form\";N;s:31:\"language_content_settings_table\";N;s:28:\"link_formatter_link_separate\";N;s:29:\"locale_translation_last_check\";N;s:30:\"locale_translation_update_info\";N;s:4:\"node\";N;s:13:\"node_add_list\";N;s:14:\"node_edit_form\";N;s:18:\"field__node__title\";N;s:16:\"field__node__uid\";N;s:20:\"field__node__created\";N;s:11:\"rdf_wrapper\";N;s:12:\"rdf_metadata\";N;s:13:\"search_result\";N;s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"html\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:8:\"template\";s:4:\"html\";s:4:\"path\";s:35:\"core/themes/classy/templates/layout\";s:20:\"preprocess functions\";a:9:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"metatag_preprocess_html\";i:4;s:34:\"metatag_open_graph_preprocess_html\";i:5;s:20:\"node_preprocess_html\";i:6;s:19:\"rdf_preprocess_html\";i:7;s:23:\"toolbar_preprocess_html\";i:32;s:21:\"seven_preprocess_html\";}}s:4:\"page\";a:6:{s:14:\"render element\";s:4:\"page\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:8:\"template\";s:4:\"page\";s:4:\"path\";s:27:\"core/themes/seven/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";}}s:10:\"page_title\";a:6:{s:9:\"variables\";a:1:{s:5:\"title\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:10:\"page-title\";s:4:\"path\";s:36:\"core/themes/classy/templates/content\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:31:\"quickedit_preprocess_page_title\";i:3;s:30:\"shortcut_preprocess_page_title\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:6:\"region\";s:4:\"path\";s:35:\"core/themes/classy/templates/layout\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"time\";N;s:13:\"datetime_form\";N;s:16:\"datetime_wrapper\";N;s:15:\"status_messages\";N;s:5:\"links\";a:6:{s:9:\"variables\";a:4:{s:5:\"links\";a:0:{}s:10:\"attributes\";a:1:{s:5:\"class\";a:4:{i:0;s:5:\"links\";i:1;s:5:\"links\";i:2;s:5:\"links\";i:3;s:5:\"links\";}}s:7:\"heading\";a:0:{}s:16:\"set_active_class\";b:0;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"links\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_links\";i:2;s:21:\"contextual_preprocess\";i:6;s:23:\"stable_preprocess_links\";}}s:18:\"dropbutton_wrapper\";a:6:{s:9:\"variables\";a:1:{s:8:\"children\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:18:\"dropbutton-wrapper\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:5:\"image\";N;s:10:\"breadcrumb\";a:6:{s:9:\"variables\";a:1:{s:5:\"links\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:10:\"breadcrumb\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_breadcrumb\";i:2;s:21:\"contextual_preprocess\";}}s:5:\"table\";a:6:{s:9:\"variables\";a:9:{s:6:\"header\";N;s:4:\"rows\";N;s:6:\"footer\";N;s:10:\"attributes\";a:0:{}s:7:\"caption\";N;s:9:\"colgroups\";a:0:{}s:6:\"sticky\";b:0;s:10:\"responsive\";b:1;s:5:\"empty\";s:0:\"\";}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"table\";s:4:\"path\";s:36:\"core/themes/classy/templates/dataset\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_table\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"tablesort_indicator\";a:6:{s:9:\"variables\";a:1:{s:5:\"style\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:19:\"tablesort-indicator\";s:4:\"path\";s:34:\"core/themes/stable/templates/admin\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:4:\"mark\";N;s:9:\"item_list\";N;s:9:\"feed_icon\";N;s:12:\"progress_bar\";N;s:11:\"indentation\";N;s:16:\"maintenance_page\";N;s:12:\"install_page\";N;s:21:\"maintenance_task_list\";N;s:16:\"authorize_report\";N;s:5:\"pager\";a:6:{s:14:\"render element\";s:5:\"pager\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"pager\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_pager\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"menu\";a:6:{s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:4:\"menu\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";}}s:15:\"menu_local_task\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:8:\"template\";s:15:\"menu-local-task\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_menu_local_task\";i:2;s:21:\"contextual_preprocess\";i:12;s:32:\"seven_preprocess_menu_local_task\";}}s:17:\"menu_local_action\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:8:\"template\";s:17:\"menu-local-action\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_menu_local_action\";i:2;s:21:\"contextual_preprocess\";i:12;s:34:\"seven_preprocess_menu_local_action\";}}s:16:\"menu_local_tasks\";a:6:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:8:\"template\";s:16:\"menu-local-tasks\";s:4:\"path\";s:27:\"core/themes/seven/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:16;s:33:\"seven_preprocess_menu_local_tasks\";}}s:5:\"input\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"input\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";}}s:6:\"select\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:6:\"select\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_select\";i:2;s:21:\"contextual_preprocess\";}}s:8:\"fieldset\";N;s:7:\"details\";N;s:6:\"radios\";N;s:10:\"checkboxes\";N;s:4:\"form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:4:\"form\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_form\";i:2;s:21:\"contextual_preprocess\";}}s:8:\"textarea\";N;s:12:\"form_element\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:12:\"form-element\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_form_element\";i:2;s:21:\"contextual_preprocess\";}}s:18:\"form_element_label\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:18:\"form-element-label\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:38:\"template_preprocess_form_element_label\";i:2;s:21:\"contextual_preprocess\";}}s:13:\"vertical_tabs\";N;s:9:\"container\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:9:\"container\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_container\";i:2;s:21:\"contextual_preprocess\";}}s:5:\"field\";N;s:25:\"field_multiple_value_form\";N;s:28:\"block__system_branding_block\";N;s:28:\"block__system_messages_block\";a:7:{s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:28:\"block--system-messages-block\";s:4:\"path\";s:34:\"core/themes/stable/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:22:\"seven_preprocess_block\";}s:14:\"render element\";s:8:\"elements\";}s:24:\"block__system_menu_block\";N;s:18:\"system_themes_page\";N;s:18:\"system_config_form\";N;s:12:\"confirm_form\";N;s:22:\"system_modules_details\";N;s:24:\"system_modules_uninstall\";N;s:18:\"status_report_page\";N;s:13:\"status_report\";N;s:21:\"status_report_grouped\";N;s:21:\"status_report_counter\";N;s:26:\"status_report_general_info\";N;s:10:\"admin_page\";N;s:11:\"admin_block\";N;s:19:\"admin_block_content\";N;s:18:\"system_admin_index\";N;s:15:\"entity_add_list\";N;s:23:\"off_canvas_page_wrapper\";a:6:{s:9:\"variables\";a:1:{s:8:\"children\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:23:\"off-canvas-page-wrapper\";s:4:\"path\";s:36:\"core/themes/stable/templates/content\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:13:\"taxonomy_term\";N;s:15:\"token_tree_link\";N;s:7:\"toolbar\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_toolbar\";i:2;s:21:\"contextual_preprocess\";}}s:13:\"menu__toolbar\";a:7:{s:9:\"base hook\";s:4:\"menu\";s:9:\"variables\";a:3:{s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}s:9:\"menu_name\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:13:\"menu--toolbar\";s:4:\"path\";s:39:\"core/themes/stable/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"user\";N;s:8:\"username\";a:6:{s:9:\"variables\";a:3:{s:7:\"account\";N;s:10:\"attributes\";a:0:{}s:12:\"link_options\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:8:\"username\";s:4:\"path\";s:33:\"core/themes/classy/templates/user\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:28:\"template_preprocess_username\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"rdf_preprocess_username\";}}s:28:\"views_ui_display_tab_setting\";N;s:27:\"views_ui_display_tab_bucket\";N;s:30:\"views_ui_rearrange_filter_form\";N;s:27:\"views_ui_expose_filter_form\";N;s:18:\"views_ui_view_info\";N;s:28:\"views_ui_views_listing_table\";N;s:27:\"views_ui_view_displays_list\";N;s:32:\"views_ui_build_group_filter_form\";N;s:27:\"views_ui_style_plugin_table\";N;s:29:\"views_ui_view_preview_section\";N;s:18:\"views_ui_container\";N;s:16:\"views_mini_pager\";N;s:16:\"views_view_field\";a:8:{s:4:\"file\";s:15:\"views.theme.inc\";s:9:\"variables\";a:3:{s:4:\"view\";N;s:5:\"field\";N;s:3:\"row\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-view-field\";s:4:\"path\";s:34:\"core/themes/stable/templates/views\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_view_field\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"views_view_grouping\";N;s:10:\"views_view\";a:7:{s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:4:\"path\";s:34:\"core/themes/classy/templates/views\";s:8:\"includes\";a:4:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";i:2;s:34:\"core/modules/views/views.theme.inc\";i:3;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:10:\"views-view\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}}s:19:\"views_view_row_opml\";N;s:17:\"views_view_fields\";N;s:18:\"views_view_row_rss\";N;s:14:\"views_view_rss\";N;s:16:\"views_view_table\";a:7:{s:9:\"variables\";a:4:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;}s:4:\"path\";s:34:\"core/themes/classy/templates/views\";s:8:\"includes\";a:4:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";i:2;s:34:\"core/modules/views/views.theme.inc\";i:3;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-view-table\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_view_table\";i:2;s:21:\"contextual_preprocess\";i:3;s:42:\"draggableviews_preprocess_views_view_table\";}}s:15:\"views_view_opml\";N;s:15:\"views_view_list\";N;s:30:\"views_view_summary_unformatted\";N;s:22:\"views_view_unformatted\";N;s:18:\"views_view_summary\";N;s:15:\"views_view_grid\";N;s:21:\"views_form_views_form\";N;s:18:\"views_exposed_form\";a:8:{s:4:\"file\";s:15:\"views.theme.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"includes\";a:4:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";i:2;s:34:\"core/modules/views/views.theme.inc\";i:3;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:18:\"views-exposed-form\";s:4:\"path\";s:34:\"core/themes/classy/templates/views\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:38:\"template_preprocess_views_exposed_form\";i:2;s:21:\"contextual_preprocess\";}}s:31:\"eu_cookie_compliance_popup_info\";N;s:47:\"eu_cookie_compliance_popup_info_consent_default\";N;s:33:\"eu_cookie_compliance_popup_agreed\";N;s:29:\"eu_cookie_compliance_withdraw\";N;s:26:\"block__local_actions_block\";a:7:{s:8:\"template\";s:26:\"block--local-actions-block\";s:4:\"path\";s:27:\"core/themes/seven/templates\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:17:\"core/themes/seven\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:22:\"seven_preprocess_block\";}}s:24:\"block__local_tasks_block\";a:7:{s:8:\"template\";s:24:\"block--local-tasks-block\";s:4:\"path\";s:34:\"core/themes/classy/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:22:\"seven_preprocess_block\";}}s:24:\"block__search_form_block\";N;s:11:\"links__node\";N;s:25:\"item_list__search_results\";N;s:16:\"field__text_long\";N;s:11:\"field__text\";N;s:24:\"field__text_with_summary\";N;}',-1,1579254232.944,1,'theme_registry','90'),('theme_registry:runtime:yorkshire',_binary 'a:162:{s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:5:\"block\";s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:88;s:26:\"yorkshire_preprocess_block\";}}s:22:\"block_content_add_list\";N;s:25:\"ckeditor_settings_toolbar\";N;s:17:\"color_scheme_form\";N;s:7:\"comment\";N;s:14:\"field__comment\";N;s:17:\"crop_crop_summary\";N;s:19:\"ctools_wizard_trail\";N;s:25:\"ctools_wizard_trail_links\";N;s:14:\"field_ui_table\";N;s:9:\"file_link\";a:6:{s:9:\"variables\";a:3:{s:4:\"file\";N;s:11:\"description\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:9:\"file-link\";s:4:\"path\";s:34:\"core/themes/classy/templates/field\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_file_link\";i:2;s:21:\"contextual_preprocess\";}}s:17:\"file_managed_file\";N;s:10:\"file_audio\";N;s:10:\"file_video\";N;s:20:\"file_widget_multiple\";a:8:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:14:\"file.field.inc\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"includes\";a:4:{i:0;s:32:\"core/modules/file/file.field.inc\";i:1;s:32:\"core/modules/file/file.field.inc\";i:2;s:32:\"core/modules/file/file.field.inc\";i:3;s:32:\"core/modules/file/file.field.inc\";}s:8:\"template\";s:20:\"file-widget-multiple\";s:4:\"path\";s:41:\"core/themes/classy/templates/content-edit\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:40:\"template_preprocess_file_widget_multiple\";i:2;s:21:\"contextual_preprocess\";}}s:16:\"file_upload_help\";a:8:{s:9:\"variables\";a:3:{s:11:\"description\";N;s:17:\"upload_validators\";N;s:11:\"cardinality\";N;}s:4:\"file\";s:14:\"file.field.inc\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"includes\";a:4:{i:0;s:32:\"core/modules/file/file.field.inc\";i:1;s:32:\"core/modules/file/file.field.inc\";i:2;s:32:\"core/modules/file/file.field.inc\";i:3;s:32:\"core/modules/file/file.field.inc\";}s:8:\"template\";s:16:\"file-upload-help\";s:4:\"path\";s:41:\"core/themes/classy/templates/content-edit\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_file_upload_help\";i:2;s:21:\"contextual_preprocess\";}}s:11:\"filter_tips\";a:6:{s:9:\"variables\";a:2:{s:4:\"tips\";N;s:4:\"long\";b:0;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:11:\"filter-tips\";s:4:\"path\";s:41:\"core/themes/classy/templates/content-edit\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:31:\"template_preprocess_filter_tips\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"text_format_wrapper\";a:6:{s:9:\"variables\";a:3:{s:8:\"children\";N;s:11:\"description\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:19:\"text-format-wrapper\";s:4:\"path\";s:41:\"core/themes/classy/templates/content-edit\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:39:\"template_preprocess_text_format_wrapper\";i:2;s:21:\"contextual_preprocess\";}}s:17:\"filter_guidelines\";a:6:{s:9:\"variables\";a:1:{s:6:\"format\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:17:\"filter-guidelines\";s:4:\"path\";s:41:\"core/themes/classy/templates/content-edit\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_filter_guidelines\";i:2;s:21:\"contextual_preprocess\";}}s:14:\"filter_caption\";N;s:11:\"image_style\";a:6:{s:9:\"variables\";a:7:{s:10:\"style_name\";N;s:3:\"uri\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:11:\"image-style\";s:4:\"path\";s:34:\"core/themes/classy/templates/field\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:31:\"template_preprocess_image_style\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"image_style_preview\";N;s:12:\"image_anchor\";N;s:20:\"image_resize_summary\";N;s:19:\"image_scale_summary\";N;s:18:\"image_crop_summary\";N;s:28:\"image_scale_and_crop_summary\";N;s:20:\"image_rotate_summary\";N;s:12:\"image_widget\";a:8:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:15:\"image.field.inc\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"includes\";a:4:{i:0;s:34:\"core/modules/image/image.field.inc\";i:1;s:34:\"core/modules/image/image.field.inc\";i:2;s:34:\"core/modules/image/image.field.inc\";i:3;s:34:\"core/modules/image/image.field.inc\";}s:8:\"template\";s:12:\"image-widget\";s:4:\"path\";s:41:\"core/themes/classy/templates/content-edit\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_image_widget\";i:2;s:21:\"contextual_preprocess\";}}s:15:\"image_formatter\";N;s:35:\"language_negotiation_configure_form\";N;s:31:\"language_content_settings_table\";N;s:28:\"link_formatter_link_separate\";N;s:29:\"locale_translation_last_check\";N;s:30:\"locale_translation_update_info\";N;s:4:\"node\";N;s:13:\"node_add_list\";N;s:14:\"node_edit_form\";N;s:18:\"field__node__title\";N;s:16:\"field__node__uid\";N;s:20:\"field__node__created\";N;s:11:\"rdf_wrapper\";N;s:12:\"rdf_metadata\";N;s:13:\"search_result\";N;s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"html\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:4:\"html\";s:4:\"path\";s:42:\"themes/druadmin_lte_theme/templates/layout\";s:20:\"preprocess functions\";a:9:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"metatag_preprocess_html\";i:4;s:34:\"metatag_open_graph_preprocess_html\";i:5;s:20:\"node_preprocess_html\";i:6;s:19:\"rdf_preprocess_html\";i:7;s:23:\"toolbar_preprocess_html\";i:64;s:25:\"yorkshire_preprocess_html\";}}s:4:\"page\";a:6:{s:14:\"render element\";s:4:\"page\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:4:\"page\";s:4:\"path\";s:42:\"themes/druadmin_lte_theme/templates/layout\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";i:24;s:25:\"yorkshire_preprocess_page\";}}s:10:\"page_title\";a:6:{s:9:\"variables\";a:1:{s:5:\"title\";N;}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:10:\"page-title\";s:4:\"path\";s:42:\"themes/druadmin_lte_theme/templates/layout\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:31:\"quickedit_preprocess_page_title\";i:3;s:30:\"shortcut_preprocess_page_title\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:6:\"region\";s:4:\"path\";s:42:\"themes/druadmin_lte_theme/templates/layout\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"time\";N;s:13:\"datetime_form\";N;s:16:\"datetime_wrapper\";N;s:15:\"status_messages\";a:6:{s:9:\"variables\";a:2:{s:15:\"status_headings\";a:0:{}s:12:\"message_list\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:15:\"status-messages\";s:4:\"path\";s:33:\"core/themes/classy/templates/misc\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:5:\"links\";a:6:{s:9:\"variables\";a:4:{s:5:\"links\";a:0:{}s:10:\"attributes\";a:1:{s:5:\"class\";a:4:{i:0;s:5:\"links\";i:1;s:5:\"links\";i:2;s:5:\"links\";i:3;s:5:\"links\";}}s:7:\"heading\";a:0:{}s:16:\"set_active_class\";b:0;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"links\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_links\";i:2;s:21:\"contextual_preprocess\";i:6;s:23:\"stable_preprocess_links\";}}s:18:\"dropbutton_wrapper\";a:6:{s:9:\"variables\";a:1:{s:8:\"children\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:18:\"dropbutton-wrapper\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:5:\"image\";a:6:{s:9:\"variables\";a:9:{s:3:\"uri\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}s:5:\"sizes\";N;s:6:\"srcset\";a:0:{}s:10:\"style_name\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"image\";s:4:\"path\";s:34:\"core/themes/classy/templates/field\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_image\";i:2;s:21:\"contextual_preprocess\";i:3;s:20:\"rdf_preprocess_image\";}}s:10:\"breadcrumb\";N;s:5:\"table\";a:6:{s:9:\"variables\";a:9:{s:6:\"header\";N;s:4:\"rows\";N;s:6:\"footer\";N;s:10:\"attributes\";a:0:{}s:7:\"caption\";N;s:9:\"colgroups\";a:0:{}s:6:\"sticky\";b:0;s:10:\"responsive\";b:1;s:5:\"empty\";s:0:\"\";}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:5:\"table\";s:4:\"path\";s:43:\"themes/druadmin_lte_theme/templates/dataset\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_table\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"tablesort_indicator\";N;s:4:\"mark\";N;s:9:\"item_list\";N;s:9:\"feed_icon\";N;s:12:\"progress_bar\";N;s:11:\"indentation\";a:6:{s:9:\"variables\";a:1:{s:4:\"size\";i:1;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:11:\"indentation\";s:4:\"path\";s:34:\"core/themes/stable/templates/admin\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:16:\"maintenance_page\";N;s:12:\"install_page\";N;s:21:\"maintenance_task_list\";N;s:16:\"authorize_report\";N;s:5:\"pager\";a:6:{s:14:\"render element\";s:5:\"pager\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:5:\"pager\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_pager\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"menu\";a:6:{s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:4:\"menu\";s:4:\"path\";s:46:\"themes/druadmin_lte_theme/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:24;s:25:\"yorkshire_preprocess_menu\";}}s:15:\"menu_local_task\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:15:\"menu-local-task\";s:4:\"path\";s:46:\"themes/druadmin_lte_theme/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_menu_local_task\";i:2;s:21:\"contextual_preprocess\";}}s:17:\"menu_local_action\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:17:\"menu-local-action\";s:4:\"path\";s:46:\"themes/druadmin_lte_theme/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_menu_local_action\";i:2;s:21:\"contextual_preprocess\";i:24;s:38:\"yorkshire_preprocess_menu_local_action\";}}s:16:\"menu_local_tasks\";a:6:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:16:\"menu-local-tasks\";s:4:\"path\";s:46:\"themes/druadmin_lte_theme/templates/navigation\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:5:\"input\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:5:\"input\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";}}s:6:\"select\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:6:\"select\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_select\";i:2;s:21:\"contextual_preprocess\";}}s:8:\"fieldset\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:8:\"fieldset\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:28:\"template_preprocess_fieldset\";i:2;s:21:\"contextual_preprocess\";}}s:7:\"details\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:7:\"details\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_details\";i:2;s:21:\"contextual_preprocess\";}}s:6:\"radios\";N;s:10:\"checkboxes\";N;s:4:\"form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:4:\"form\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_form\";i:2;s:21:\"contextual_preprocess\";}}s:8:\"textarea\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:8:\"textarea\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:28:\"template_preprocess_textarea\";i:2;s:21:\"contextual_preprocess\";}}s:12:\"form_element\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:12:\"form-element\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_form_element\";i:2;s:21:\"contextual_preprocess\";}}s:18:\"form_element_label\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:18:\"form-element-label\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:38:\"template_preprocess_form_element_label\";i:2;s:21:\"contextual_preprocess\";}}s:13:\"vertical_tabs\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:13:\"vertical-tabs\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_vertical_tabs\";i:2;s:21:\"contextual_preprocess\";}}s:9:\"container\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:9:\"container\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_container\";i:2;s:21:\"contextual_preprocess\";}}s:5:\"field\";N;s:25:\"field_multiple_value_form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:25:\"field-multiple-value-form\";s:4:\"path\";s:33:\"core/themes/classy/templates/form\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:45:\"template_preprocess_field_multiple_value_form\";i:2;s:21:\"contextual_preprocess\";}}s:28:\"block__system_branding_block\";N;s:28:\"block__system_messages_block\";N;s:24:\"block__system_menu_block\";a:7:{s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:8:\"template\";s:24:\"block--system-menu-block\";s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:26:\"yorkshire_preprocess_block\";}}s:18:\"system_themes_page\";N;s:18:\"system_config_form\";N;s:12:\"confirm_form\";N;s:22:\"system_modules_details\";N;s:24:\"system_modules_uninstall\";N;s:18:\"status_report_page\";N;s:13:\"status_report\";N;s:21:\"status_report_grouped\";N;s:21:\"status_report_counter\";N;s:26:\"status_report_general_info\";N;s:10:\"admin_page\";N;s:11:\"admin_block\";N;s:19:\"admin_block_content\";N;s:18:\"system_admin_index\";N;s:15:\"entity_add_list\";N;s:23:\"off_canvas_page_wrapper\";a:6:{s:9:\"variables\";a:1:{s:8:\"children\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:23:\"off-canvas-page-wrapper\";s:4:\"path\";s:36:\"core/themes/stable/templates/content\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:13:\"taxonomy_term\";N;s:15:\"token_tree_link\";N;s:7:\"toolbar\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/classy\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:39:\"core/themes/classy/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_toolbar\";i:2;s:21:\"contextual_preprocess\";}}s:13:\"menu__toolbar\";a:7:{s:9:\"base hook\";s:4:\"menu\";s:9:\"variables\";a:3:{s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}s:9:\"menu_name\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"template\";s:13:\"menu--toolbar\";s:4:\"path\";s:39:\"core/themes/stable/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:3;s:25:\"yorkshire_preprocess_menu\";}}s:4:\"user\";N;s:8:\"username\";N;s:28:\"views_ui_display_tab_setting\";N;s:27:\"views_ui_display_tab_bucket\";N;s:30:\"views_ui_rearrange_filter_form\";N;s:27:\"views_ui_expose_filter_form\";N;s:18:\"views_ui_view_info\";N;s:28:\"views_ui_views_listing_table\";N;s:27:\"views_ui_view_displays_list\";N;s:32:\"views_ui_build_group_filter_form\";N;s:27:\"views_ui_style_plugin_table\";N;s:29:\"views_ui_view_preview_section\";N;s:18:\"views_ui_container\";N;s:16:\"views_mini_pager\";N;s:16:\"views_view_field\";a:8:{s:4:\"file\";s:15:\"views.theme.inc\";s:9:\"variables\";a:3:{s:4:\"view\";N;s:5:\"field\";N;s:3:\"row\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:18:\"core/themes/stable\";s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-view-field\";s:4:\"path\";s:34:\"core/themes/stable/templates/views\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_view_field\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"views_view_grouping\";N;s:10:\"views_view\";a:7:{s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/views\";s:8:\"includes\";a:8:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";i:2;s:34:\"core/modules/views/views.theme.inc\";i:3;s:34:\"core/modules/views/views.theme.inc\";i:4;s:34:\"core/modules/views/views.theme.inc\";i:5;s:34:\"core/modules/views/views.theme.inc\";i:6;s:34:\"core/modules/views/views.theme.inc\";i:7;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:10:\"views-view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";i:32;s:31:\"yorkshire_preprocess_views_view\";}}s:19:\"views_view_row_opml\";N;s:17:\"views_view_fields\";N;s:18:\"views_view_row_rss\";N;s:14:\"views_view_rss\";N;s:16:\"views_view_table\";a:7:{s:9:\"variables\";a:4:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;}s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/views\";s:8:\"includes\";a:8:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";i:2;s:34:\"core/modules/views/views.theme.inc\";i:3;s:34:\"core/modules/views/views.theme.inc\";i:4;s:34:\"core/modules/views/views.theme.inc\";i:5;s:34:\"core/modules/views/views.theme.inc\";i:6;s:34:\"core/modules/views/views.theme.inc\";i:7;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-view-table\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_view_table\";i:2;s:21:\"contextual_preprocess\";i:3;s:42:\"draggableviews_preprocess_views_view_table\";}}s:15:\"views_view_opml\";N;s:15:\"views_view_list\";N;s:30:\"views_view_summary_unformatted\";N;s:22:\"views_view_unformatted\";N;s:18:\"views_view_summary\";N;s:15:\"views_view_grid\";N;s:21:\"views_form_views_form\";N;s:18:\"views_exposed_form\";N;s:31:\"eu_cookie_compliance_popup_info\";a:6:{s:8:\"template\";s:31:\"eu_cookie_compliance_popup_info\";s:9:\"variables\";a:12:{s:7:\"message\";N;s:12:\"agree_button\";N;s:15:\"disagree_button\";N;s:22:\"secondary_button_label\";N;s:20:\"primary_button_class\";N;s:22:\"secondary_button_class\";N;s:17:\"cookie_categories\";N;s:29:\"save_preferences_button_label\";N;s:25:\"fix_first_cookie_category\";N;s:26:\"privacy_settings_tab_label\";N;s:29:\"withdraw_button_on_info_popup\";b:0;s:6:\"method\";s:7:\"default\";}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:36:\"modules/contrib/eu_cookie_compliance\";s:4:\"path\";s:46:\"modules/contrib/eu_cookie_compliance/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:47:\"eu_cookie_compliance_popup_info_consent_default\";N;s:33:\"eu_cookie_compliance_popup_agreed\";a:6:{s:8:\"template\";s:33:\"eu_cookie_compliance_popup_agreed\";s:9:\"variables\";a:3:{s:7:\"message\";N;s:11:\"hide_button\";N;s:16:\"find_more_button\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:36:\"modules/contrib/eu_cookie_compliance\";s:4:\"path\";s:46:\"modules/contrib/eu_cookie_compliance/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:29:\"eu_cookie_compliance_withdraw\";a:6:{s:8:\"template\";s:29:\"eu_cookie_compliance_withdraw\";s:9:\"variables\";a:3:{s:25:\"withdraw_tab_button_label\";N;s:7:\"message\";N;s:28:\"withdraw_action_button_label\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:36:\"modules/contrib/eu_cookie_compliance\";s:4:\"path\";s:46:\"modules/contrib/eu_cookie_compliance/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:26:\"block__local_actions_block\";a:7:{s:8:\"template\";s:26:\"block--local-actions-block\";s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:26:\"yorkshire_preprocess_block\";}}s:24:\"block__local_tasks_block\";a:7:{s:8:\"template\";s:24:\"block--local-tasks-block\";s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:26:\"yorkshire_preprocess_block\";}}s:24:\"block__search_form_block\";N;s:11:\"links__node\";N;s:25:\"item_list__search_results\";N;s:16:\"field__text_long\";N;s:11:\"field__text\";N;s:24:\"field__text_with_summary\";N;s:17:\"block__searchform\";N;s:30:\"block__page_manager_page_block\";N;s:24:\"block__system_main_block\";a:7:{s:8:\"template\";s:24:\"block--system-main-block\";s:4:\"path\";s:41:\"themes/druadmin_lte_theme/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"language_preprocess_block\";i:5;s:24:\"menu_ui_preprocess_block\";i:6;s:21:\"node_preprocess_block\";i:7;s:23:\"search_preprocess_block\";i:8;s:25:\"shortcut_preprocess_block\";i:9;s:23:\"system_preprocess_block\";i:10;s:21:\"user_preprocess_block\";i:11;s:26:\"yorkshire_preprocess_block\";}}s:36:\"block__page_manager_page_system_main\";N;s:17:\"page__user__login\";N;s:20:\"page__user__password\";N;s:33:\"region__page_manager_page_content\";N;s:15:\"region__content\";a:7:{s:8:\"template\";s:15:\"region--content\";s:4:\"path\";s:42:\"themes/druadmin_lte_theme/templates/layout\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:6:\"region\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}}s:15:\"input__checkbox\";a:7:{s:8:\"template\";s:15:\"input--checkbox\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"input\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";}}s:12:\"input__radio\";N;s:13:\"input__submit\";a:7:{s:8:\"template\";s:13:\"input--submit\";s:4:\"path\";s:40:\"themes/druadmin_lte_theme/templates/form\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"input\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:25:\"themes/druadmin_lte_theme\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";}}}',-1,1579254252.400,1,'theme_registry','90'),('user_permissions_hash:anonymous',_binary '64adc74819fd65d9d3871fc117dc9b4f934de16a14c863b5df90e785d3f411f9',-1,1578481111.752,0,'config:user.role.anonymous','21'),('user_permissions_hash:authenticated,colaborador',_binary 'bc1f1e6de42927cd35adcfdf2870ddb58c08f16827b6acd2f747d7458cff8d0d',-1,1578495037.546,0,'config:user.role.authenticated config:user.role.colaborador','26');
/*!40000 ALTER TABLE `cache_bootstrap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_config`
--

DROP TABLE IF EXISTS `cache_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_config` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_config`
--

LOCK TABLES `cache_config` WRITE;
/*!40000 ALTER TABLE `cache_config` DISABLE KEYS */;
INSERT INTO `cache_config` VALUES ('automated_cron.settings',_binary 'a:3:{s:8:\"interval\";i:10800;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.760,1,'','0'),('block.block.backoffice',_binary 'a:12:{s:4:\"uuid\";s:36:\"d7523947-0031-4983-b5d0-2f67f7ce732f\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:22:\"system.menu.backoffice\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:2:\"id\";s:10:\"backoffice\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:7:\"sidebar\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:28:\"system_menu_block:backoffice\";s:8:\"settings\";a:7:{s:2:\"id\";s:28:\"system_menu_block:backoffice\";s:5:\"label\";s:10:\"Backoffice\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:0;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.611,1,'','0'),('block.block.backofficeblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"872cbc99-1516-4736-8e0e-6b80a8e16960\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:7:\"support\";i:1;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:2:\"id\";s:15:\"backofficeblock\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:8:\"bo_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:8:\"bo_block\";s:5:\"label\";s:15:\"Backofficeblock\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:17:\"/admin/backoffice\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.611,1,'','0'),('block.block.bartik_account_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"9ce8bd53-c9ba-4283-aaac-a0cfa976c72e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"system.menu.account\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8a31Ywc1t2zlddGd3bmDrFMefWqgSK2E02ceFdr-bfc\";}s:2:\"id\";s:19:\"bartik_account_menu\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:14:\"secondary_menu\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:25:\"system_menu_block:account\";s:8:\"settings\";a:7:{s:2:\"id\";s:25:\"system_menu_block:account\";s:5:\"label\";s:17:\"User account menu\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:1;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_branding',_binary 'a:13:{s:4:\"uuid\";s:36:\"3d23a10c-5a8c-4af6-936a-3b1e3d3b7424\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NDwadleLD3YVSbDUaakxyYZyINYtkFtOVGShfq4kWy8\";}s:2:\"id\";s:15:\"bartik_branding\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_branding_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:21:\"system_branding_block\";s:5:\"label\";s:13:\"Site branding\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:7:\"visible\";s:13:\"use_site_logo\";b:1;s:13:\"use_site_name\";b:1;s:15:\"use_site_slogan\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"b657c10a-0227-4b75-93fa-0fffdb64d703\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"oXUb3JZR2WW5VOdw4HrhRicCsq51mCgLfRyvheG68ck\";}s:2:\"id\";s:18:\"bartik_breadcrumbs\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"a172be9a-4902-4891-ae2d-573beb121c85\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9EoWV2Lot6FVSr50t4hoKgiz1LIXYWNG-IIPYsWxBqo\";}s:2:\"id\";s:14:\"bartik_content\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_footer',_binary 'a:13:{s:4:\"uuid\";s:36:\"2392396f-45a2-4535-a967-c8ce487e82d5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:18:\"system.menu.footer\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8zRjTNbfNAJ94lQpZDu6MkyD87GYJ2zpH9VQPVmRbcM\";}s:2:\"id\";s:13:\"bartik_footer\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:12:\"footer_fifth\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:24:\"system_menu_block:footer\";s:8:\"settings\";a:7:{s:2:\"id\";s:24:\"system_menu_block:footer\";s:5:\"label\";s:11:\"Footer menu\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:0;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"9ef01b8e-16af-4de8-bca1-fcd06c344ead\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"13GQpeITIJsp1kyPniXtWZfyFH87vb1xxJCHifL4UeE\";}s:2:\"id\";s:20:\"bartik_local_actions\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-20;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"c86fb31f-4263-4046-987e-56c13386b67d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"X9I1OB0W3WlWtrK-CNcg6hNWwa8wficanpH8pYnDZDE\";}s:2:\"id\";s:18:\"bartik_local_tasks\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-40;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:4:\"Tabs\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";s:7:\"primary\";b:1;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_main_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"dee36634-580f-48ad-a4f4-0795ab939258\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ChCx7DYNUrPTt5uiRdQAPDKJQMc-_SyAQTrZh8H0o-c\";}s:2:\"id\";s:16:\"bartik_main_menu\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:12:\"primary_menu\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:22:\"system_menu_block:main\";s:8:\"settings\";a:7:{s:2:\"id\";s:22:\"system_menu_block:main\";s:5:\"label\";s:15:\"Main navigation\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:1;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"78add455-51b9-4da7-95b2-2da8d23674b2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KHQIJ7Vfl25lTjzIc7qIvnuistt-Mw2O0kG4jCofmkI\";}s:2:\"id\";s:15:\"bartik_messages\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"273e92b5-e5f3-4a1c-b9c8-0f89e2e574e4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7rR9chwXvdM2H8OYMAYx9Zj3GGlPMrZp_M3ZA4thYTk\";}s:2:\"id\";s:17:\"bartik_page_title\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-50;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_powered',_binary 'a:13:{s:4:\"uuid\";s:36:\"a2c1c661-6c92-49fa-92e9-b599c05f8320\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jQQUUWN2Uxr5qZtc9zcJKBCxpKY8orN1u2HPqYYRQDI\";}s:2:\"id\";s:14:\"bartik_powered\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:12:\"footer_fifth\";s:6:\"weight\";i:10;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_powered_by_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_powered_by_block\";s:5:\"label\";s:17:\"Powered by Drupal\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_search',_binary 'a:13:{s:4:\"uuid\";s:36:\"ab824bec-cef9-401c-aa2d-c696846af069\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"za-39d5WDUg6XvbyqSnuVYEeq6QM4qKJxW8MnoAha5A\";}s:2:\"id\";s:13:\"bartik_search\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:13:\"sidebar_first\";s:6:\"weight\";i:-1;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:6:\"Search\";s:8:\"provider\";s:6:\"search\";s:13:\"label_display\";s:7:\"visible\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bartik_tools',_binary 'a:13:{s:4:\"uuid\";s:36:\"8a544233-7e72-44b1-b0ce-9598216cb3ae\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:17:\"system.menu.tools\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:6:\"bartik\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rH6PpAn7-RScha1rGkohGAYSSh_1OVeZzioJPzPw6O4\";}s:2:\"id\";s:12:\"bartik_tools\";s:5:\"theme\";s:6:\"bartik\";s:6:\"region\";s:13:\"sidebar_first\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_menu_block:tools\";s:8:\"settings\";a:7:{s:2:\"id\";s:23:\"system_menu_block:tools\";s:5:\"label\";s:5:\"Tools\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:7:\"visible\";s:5:\"level\";i:1;s:5:\"depth\";i:0;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.559,1,'','0'),('block.block.bootstrap_account_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"66a44b8e-2ac7-4d33-a21f-cbbb9277080e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"system.menu.account\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"R2K_qX0ZUMbUL6ie_-S9tZVjvqmlWKlscikgeRv9vhw\";}s:2:\"id\";s:22:\"bootstrap_account_menu\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:22:\"navigation_collapsible\";s:6:\"weight\";i:11;s:8:\"provider\";N;s:6:\"plugin\";s:25:\"system_menu_block:account\";s:8:\"settings\";a:7:{s:2:\"id\";s:25:\"system_menu_block:account\";s:5:\"label\";s:17:\"User account menu\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:2;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_branding',_binary 'a:13:{s:4:\"uuid\";s:36:\"acfed88f-84e1-4323-b537-ff02164f3c3a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Cy3vkpYrD1O5JG-BeEnokF0bByHYDEa8CBfWivB4_SQ\";}s:2:\"id\";s:18:\"bootstrap_branding\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:10:\"navigation\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_branding_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:21:\"system_branding_block\";s:5:\"label\";s:13:\"Site branding\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:13:\"use_site_logo\";b:1;s:13:\"use_site_name\";b:1;s:15:\"use_site_slogan\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"b88ba347-9a9d-4527-8b91-297aa3cfaeca\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"wDR9JKEATSWldBjw8du8s3G2zjEYeQf88nlld11hMLo\";}s:2:\"id\";s:21:\"bootstrap_breadcrumbs\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-100;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"6a9e9cae-48c2-434d-bab4-abe6bf66f17f\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fNNLN48MSGSLiqwIFywCuxH2Dk_IxDbaP0kYhg_IPrg\";}s:2:\"id\";s:17:\"bootstrap_content\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_footer',_binary 'a:13:{s:4:\"uuid\";s:36:\"293316b1-b357-4c10-b1c7-51a92a3b4c91\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:18:\"system.menu.footer\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"h06zhb3xV9_2_3Zy9NsyylL7YBaEDlMwMEqNwAn8kMo\";}s:2:\"id\";s:16:\"bootstrap_footer\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:24:\"system_menu_block:footer\";s:8:\"settings\";a:7:{s:2:\"id\";s:24:\"system_menu_block:footer\";s:5:\"label\";s:11:\"Footer menu\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:0;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"f0f13d27-5f1b-4911-8e3b-6901c87acd69\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ffxthelqQF8xcr4GTG4HlaNNsluiHftN0pujmQpW0bQ\";}s:2:\"id\";s:23:\"bootstrap_local_actions\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:20;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"a5a9e671-a85e-4cb0-9ea3-6e76c6fae640\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"qHdtze2DZ2mFfaJadxjZz6epm92_SN9SAFY4yJGl8Fo\";}s:2:\"id\";s:21:\"bootstrap_local_tasks\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:10;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:4:\"Tabs\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";s:7:\"primary\";b:1;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_main_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"f3a55cdb-250f-4adc-bbe4-ffbe088ba07e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"GT_zYl7I9VAILH8OxMRe-VDvFadCDHxRcnmBc5xEmf0\";}s:2:\"id\";s:19:\"bootstrap_main_menu\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:22:\"navigation_collapsible\";s:6:\"weight\";i:10;s:8:\"provider\";N;s:6:\"plugin\";s:22:\"system_menu_block:main\";s:8:\"settings\";a:7:{s:2:\"id\";s:22:\"system_menu_block:main\";s:5:\"label\";s:15:\"Main navigation\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:2;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"48584fc0-94f3-4dac-8a2e-f1d1d25a961a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9RnnTUBcn0WRWXfrGOnId2H0Q31uQUeu_F5TnDxl2yg\";}s:2:\"id\";s:18:\"bootstrap_messages\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-50;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"f0ea09f9-46e5-4c18-9cab-c791c5650b60\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1TQP4b3ZnlzvIH9bj6cpCz_SyUHdJjLQkZnHpikjjhw\";}s:2:\"id\";s:20:\"bootstrap_page_title\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_powered',_binary 'a:13:{s:4:\"uuid\";s:36:\"87d43cbd-7748-413c-878e-18c22ccb9813\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"iggZSiUKz4mYP1YPJ8SsUfFu79HIgOTt6IDy3Up59aM\";}s:2:\"id\";s:17:\"bootstrap_powered\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_powered_by_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_powered_by_block\";s:5:\"label\";s:17:\"Powered by Drupal\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_search',_binary 'a:13:{s:4:\"uuid\";s:36:\"ee598fbf-3c65-457b-8bbb-de8fca7fee52\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"F3d5hyAFunLh4PhGviJF019fHn1Z3_zy5gzsQ0tX1K0\";}s:2:\"id\";s:16:\"bootstrap_search\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:14:\"sidebar_second\";s:6:\"weight\";i:-1;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:6:\"Search\";s:8:\"provider\";s:6:\"search\";s:13:\"label_display\";s:7:\"visible\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.bootstrap_tools',_binary 'a:13:{s:4:\"uuid\";s:36:\"b9102924-ac43-4d5a-82dd-2638d35301e9\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:17:\"system.menu.tools\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"bootstrap\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"f3Dd5TnUiFDjFZp9yEGJInwt6cUzs7O6SvLTFTATSlU\";}s:2:\"id\";s:15:\"bootstrap_tools\";s:5:\"theme\";s:9:\"bootstrap\";s:6:\"region\";s:14:\"sidebar_second\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_menu_block:tools\";s:8:\"settings\";a:7:{s:2:\"id\";s:23:\"system_menu_block:tools\";s:5:\"label\";s:5:\"Tools\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:7:\"visible\";s:5:\"level\";i:1;s:5:\"depth\";i:0;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.573,1,'','0'),('block.block.clidentcastelo_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"bc05c14e-56d8-423e-88c0-b3c9a20ecdf0\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9EoWV2Lot6FVSr50t4hoKgiz1LIXYWNG-IIPYsWxBqo\";}s:2:\"id\";s:22:\"clidentcastelo_content\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-9;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:30:\"Conteúdo da página principal\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.clidentcastelo_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"8e6170ca-24c2-4925-9cb8-47df10ecc083\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"13GQpeITIJsp1kyPniXtWZfyFH87vb1xxJCHifL4UeE\";}s:2:\"id\";s:28:\"clidentcastelo_local_actions\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:35:\"Ações principais do administrador\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.clidentcastelo_main_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"f26ad07b-4325-49c7-b8d9-6d9d6cc558b1\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ChCx7DYNUrPTt5uiRdQAPDKJQMc-_SyAQTrZh8H0o-c\";}s:2:\"id\";s:24:\"clidentcastelo_main_menu\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:10:\"navigation\";s:6:\"weight\";i:-3;s:8:\"provider\";N;s:6:\"plugin\";s:22:\"system_menu_block:main\";s:8:\"settings\";a:7:{s:2:\"id\";s:22:\"system_menu_block:main\";s:5:\"label\";s:21:\"Navegação principal\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:5:\"level\";i:1;s:5:\"depth\";i:1;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.clidentcastelo_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"73029eb1-a65c-471d-bfec-9ec0d92a719a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KHQIJ7Vfl25lTjzIc7qIvnuistt-Mw2O0kG4jCofmkI\";}s:2:\"id\";s:23:\"clidentcastelo_messages\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:19:\"Mensagens de estado\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.clidentcastelo_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"19be2694-cbb5-4ecc-b20e-e9880e487b95\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7rR9chwXvdM2H8OYMAYx9Zj3GGlPMrZp_M3ZA4thYTk\";}s:2:\"id\";s:25:\"clidentcastelo_page_title\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-11;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:18:\"Título da página\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"<front>\";s:6:\"negate\";b:1;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.mapblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"4201f149-2c80-433d-85f3-95ab2157fc6c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:7:\"support\";i:1;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:8:\"mapblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"map_contact_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"map_contact_block\";s:5:\"label\";s:9:\"Map block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:10:\"/contactos\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.newsblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"9d340dac-16b1-4574-88d5-47a589dc3cc5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:7:\"support\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:9:\"newsblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"news_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"news_block\";s:5:\"label\";s:10:\"News block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.phonetopblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"f1129ac2-0293-44d0-981e-5cbb4f468796\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:7:\"support\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:13:\"phonetopblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"navigation_top\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:14:\"phonetop_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:14:\"phonetop_block\";s:5:\"label\";s:15:\"Phone Top block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.scheduletopblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"2c8f9dcb-f1cb-4436-a579-fe533901bcaa\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:7:\"support\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:16:\"scheduletopblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"navigation_top\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"scheduletop_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"scheduletop_block\";s:5:\"label\";s:18:\"Schedule Top block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.servicesblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"34ea465c-c880-4366-96a9-3704c4330f8e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:7:\"support\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:13:\"servicesblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:-3;s:8:\"provider\";N;s:6:\"plugin\";s:14:\"services_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:14:\"services_block\";s:5:\"label\";s:14:\"Services block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.seven_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"0da635e0-b240-4220-b9b1-07e1b6d701c8\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WWu2OQswgCztl9OeXjD1stexIEMZsSgPMYIdC-JHx9c\";}s:2:\"id\";s:17:\"seven_breadcrumbs\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.567,1,'','0'),('block.block.seven_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"7c6f46ae-0b5e-4dc2-9233-08b5e908e5c2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YRY68JWkaUiGeZlWMv1nzeIgDm0ZZwXYgpqUpLFzwAY\";}s:2:\"id\";s:13:\"seven_content\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.567,1,'','0'),('block.block.seven_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"03d49a18-c10b-4a25-bb7e-e49eda391bec\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HHryZVJbeKi9WnuBGC8FOhBZmBnk2G1H6KxFuy-rC9A\";}s:2:\"id\";s:19:\"seven_local_actions\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.567,1,'','0'),('block.block.seven_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"4a8193c9-31e9-47c8-a1b5-5613775bfe6a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XJqWwLt1LDCnazcEN6QkJmCLjk4R0__-8s0OO9xeNjg\";}s:2:\"id\";s:14:\"seven_messages\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.567,1,'','0'),('block.block.seven_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"84110647-f5e7-45b1-b654-a9e014232b7b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZSpc3IoSaLd0PkB02nxjVPBMztIdsTdHek9SiGaqZ_c\";}s:2:\"id\";s:16:\"seven_page_title\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-30;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.567,1,'','0'),('block.block.seven_primary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"13e56201-84ca-4ecf-a9ab-89ab5e68099e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ddy1OsBbWxjwEI8VL1viD4I69qcLHOkul4BxbTqLBTs\";}s:2:\"id\";s:25:\"seven_primary_local_tasks\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:22:\"Separadores primários\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1578481106.567,1,'','0'),('block.block.seven_secondary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"cced5cd3-49a4-4ee1-956a-e354b909e720\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"seven\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QeZBeCilQfeET3GeW6ZtJkEiwROADTZktFgKWwPieD4\";}s:2:\"id\";s:27:\"seven_secondary_local_tasks\";s:5:\"theme\";s:5:\"seven\";s:6:\"region\";s:11:\"pre_content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:24:\"Separadores secundários\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1578481106.566,1,'','0'),('block.block.sitebranding',_binary 'a:12:{s:4:\"uuid\";s:36:\"494d2309-5161-416e-bb02-6bedfc93d092\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:2:\"id\";s:12:\"sitebranding\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_branding_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:21:\"system_branding_block\";s:5:\"label\";s:13:\"Site branding\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";s:13:\"use_site_logo\";b:1;s:13:\"use_site_name\";b:0;s:15:\"use_site_slogan\";b:0;}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:17:\"/admin/backoffice\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.611,1,'','0'),('block.block.tabs',_binary 'a:12:{s:4:\"uuid\";s:36:\"ec1dd6b5-4ff7-48e6-9cc5-f03ff737fd6f\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:4:\"tabs\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-11;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:4:\"Tabs\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";s:7:\"primary\";b:1;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.talkcontactblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"4789914e-60fe-4556-b571-6d94c1189578\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:7:\"support\";i:1;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:16:\"talkcontactblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-9;s:8:\"provider\";N;s:6:\"plugin\";s:18:\"talk_contact_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:18:\"talk_contact_block\";s:5:\"label\";s:18:\"Talk Contact block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:10:\"/contactos\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.talktousblock',_binary 'a:12:{s:4:\"uuid\";s:36:\"8a804bed-d2a2-4437-99ec-6607b6cbb505\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:7:\"support\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:13:\"talktousblock\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"talk_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"talk_block\";s:5:\"label\";s:16:\"Talk to us block\";s:8:\"provider\";s:7:\"support\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.594,1,'','0'),('block.block.views_block__node_auxiliar_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"cbf54958-0b94-4ec4-9b59-f0c4b4b31593\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:24:\"views.view.node_auxiliar\";}s:6:\"module\";a:3:{i:0;s:4:\"node\";i:1;s:6:\"system\";i:2;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:34:\"views_block__node_auxiliar_block_1\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-8;s:8:\"provider\";N;s:6:\"plugin\";s:33:\"views_block:node_auxiliar-block_1\";s:8:\"settings\";a:7:{s:2:\"id\";s:33:\"views_block:node_auxiliar-block_1\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:1:\"0\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";s:15:\"context_mapping\";a:0:{}}s:10:\"visibility\";a:2:{s:9:\"node_type\";a:4:{s:2:\"id\";s:9:\"node_type\";s:7:\"bundles\";a:1:{s:4:\"page\";s:4:\"page\";}s:6:\"negate\";b:0;s:15:\"context_mapping\";a:1:{s:4:\"node\";s:29:\"@node.node_route_context:node\";}}s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"<front>\";s:6:\"negate\";b:1;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__node_auxiliar_block_2',_binary 'a:12:{s:4:\"uuid\";s:36:\"bc99f714-ca26-498b-af75-0b40c0eadbfa\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:24:\"views.view.node_auxiliar\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:34:\"views_block__node_auxiliar_block_2\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:33:\"views_block:node_auxiliar-block_2\";s:8:\"settings\";a:7:{s:2:\"id\";s:33:\"views_block:node_auxiliar-block_2\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:7:\"visible\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";s:15:\"context_mapping\";a:0:{}}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"<front>\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__noticias_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"231bdd8a-9d7c-402b-85eb-ccb6ded60ebc\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"views.view.noticias\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:29:\"views_block__noticias_block_1\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:28:\"views_block:noticias-block_1\";s:8:\"settings\";a:6:{s:2:\"id\";s:28:\"views_block:noticias-block_1\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:1:\"0\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"/node/8\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__noticias_block_2',_binary 'a:12:{s:4:\"uuid\";s:36:\"f62f0cf2-1c33-4e5f-82e2-200baab0e418\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"views.view.noticias\";}s:6:\"module\";a:2:{i:0;s:6:\"ctools\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:29:\"views_block__noticias_block_2\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:28:\"views_block:noticias-block_2\";s:8:\"settings\";a:7:{s:2:\"id\";s:28:\"views_block:noticias-block_2\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:7:\"visible\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";s:15:\"context_mapping\";a:0:{}}s:10:\"visibility\";a:1:{s:18:\"entity_bundle:node\";a:4:{s:2:\"id\";s:18:\"entity_bundle:node\";s:7:\"bundles\";a:1:{s:8:\"noticias\";s:8:\"noticias\";}s:6:\"negate\";b:0;s:15:\"context_mapping\";a:1:{s:4:\"node\";s:29:\"@node.node_route_context:node\";}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__parcerias_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"c5cab07f-6fbd-44be-84e0-35395076613c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:20:\"views.view.parcerias\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:30:\"views_block__parcerias_block_1\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-6;s:8:\"provider\";N;s:6:\"plugin\";s:29:\"views_block:parcerias-block_1\";s:8:\"settings\";a:6:{s:2:\"id\";s:29:\"views_block:parcerias-block_1\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:1:\"0\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"/node/6\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__servicos_block_2',_binary 'a:12:{s:4:\"uuid\";s:36:\"f6d2f716-ec95-4a31-a29a-373f41e8bd78\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"views.view.servicos\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:29:\"views_block__servicos_block_2\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-8;s:8:\"provider\";N;s:6:\"plugin\";s:28:\"views_block:servicos-block_2\";s:8:\"settings\";a:6:{s:2:\"id\";s:28:\"views_block:servicos-block_2\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:1:\"0\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"/node/4\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__servicos_block_3',_binary 'a:12:{s:4:\"uuid\";s:36:\"dca844c3-e646-4ba6-aedc-2137614f0510\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"views.view.servicos\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:29:\"views_block__servicos_block_3\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-6;s:8:\"provider\";N;s:6:\"plugin\";s:28:\"views_block:servicos-block_3\";s:8:\"settings\";a:6:{s:2:\"id\";s:28:\"views_block:servicos-block_3\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:7:\"visible\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"<front>\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__slideshow_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"c07150ed-73d7-4d6f-ad09-905ebbe81728\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:20:\"views.view.slideshow\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:30:\"views_block__slideshow_block_1\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:11:\"content_top\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:29:\"views_block:slideshow-block_1\";s:8:\"settings\";a:6:{s:2:\"id\";s:29:\"views_block:slideshow-block_1\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:1:\"0\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"<front>\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.views_block__team_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"75881ca6-1916-4088-a267-28400b635c53\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:15:\"views.view.team\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"clidentcastelo\";}}s:2:\"id\";s:25:\"views_block__team_block_1\";s:5:\"theme\";s:14:\"clidentcastelo\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:24:\"views_block:team-block_1\";s:8:\"settings\";a:6:{s:2:\"id\";s:24:\"views_block:team-block_1\";s:5:\"label\";s:0:\"\";s:8:\"provider\";s:5:\"views\";s:13:\"label_display\";s:7:\"visible\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"/node/3\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.594,1,'','0'),('block.block.yorkshire_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"96a46ed5-e189-4c5a-b83d-a2f9d912c692\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9EoWV2Lot6FVSr50t4hoKgiz1LIXYWNG-IIPYsWxBqo\";}s:2:\"id\";s:17:\"yorkshire_content\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:1;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:30:\"Conteúdo da página principal\";s:8:\"provider\";s:6:\"system\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.611,1,'','0'),('block.block.yorkshire_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"9a7d110f-2a65-4c66-8524-4c59542d1349\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"13GQpeITIJsp1kyPniXtWZfyFH87vb1xxJCHifL4UeE\";}s:2:\"id\";s:23:\"yorkshire_local_actions\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:35:\"Ações principais do administrador\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:0:{}}',-1,1578481106.611,1,'','0'),('block.block.yorkshire_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"d8dc880d-bad0-499b-8cd0-2c726e5caa17\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7rR9chwXvdM2H8OYMAYx9Zj3GGlPMrZp_M3ZA4thYTk\";}s:2:\"id\";s:20:\"yorkshire_page_title\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:3:\"top\";s:6:\"weight\";i:-1;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:18:\"Título da página\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:5:\"pages\";s:7:\"<front>\";s:6:\"negate\";b:1;s:15:\"context_mapping\";a:0:{}}}}',-1,1578481106.611,1,'','0'),('block.block.yorkshire_tabs',_binary 'a:12:{s:4:\"uuid\";s:36:\"4b02a1a2-df61-4ad7-ae69-4b6f8ada6883\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:9:\"yorkshire\";}}s:2:\"id\";s:14:\"yorkshire_tabs\";s:5:\"theme\";s:9:\"yorkshire\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-1;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:4:\"Tabs\";s:8:\"provider\";s:4:\"core\";s:13:\"label_display\";s:1:\"0\";s:7:\"primary\";b:1;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1578481106.611,1,'','0'),('block_content.type.basic',_binary 'a:9:{s:4:\"uuid\";s:36:\"bed6a6be-d36b-42d7-a4b0-bb6e38dd8e51\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo\";}s:2:\"id\";s:5:\"basic\";s:5:\"label\";s:13:\"Bloco básico\";s:8:\"revision\";i:0;s:11:\"description\";s:56:\"Um bloco básico contém um título e um corpo de texto.\";}',-1,1578481107.056,1,'','0'),('bootstrap.settings',_binary 'a:6:{s:7:\"schemas\";a:1:{s:9:\"bootstrap\";i:8000;}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1uFogeFphl0Hg6oVCacZZ8mM_0wMZ7PS_RrmLbK5tf0\";}s:7:\"favicon\";a:4:{s:8:\"mimetype\";s:24:\"image/vnd.microsoft.icon\";s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:1;}s:4:\"logo\";a:3:{s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481109.072,1,'','0'),('clidentcastelo.settings',_binary 'a:15:{s:7:\"schemas\";a:2:{s:9:\"bootstrap\";i:8000;s:14:\"clidentcastelo\";i:8000;}s:7:\"favicon\";a:4:{s:8:\"mimetype\";s:10:\"image/jpeg\";s:4:\"path\";s:22:\"public://favicon_1.jpg\";s:3:\"url\";s:72:\"http://localhost/clidentcastelo/public/sites/default/files/favicon_1.jpg\";s:11:\"use_default\";b:0;}s:4:\"logo\";a:3:{s:4:\"path\";s:19:\"public://logo_1.jpg\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:0;}s:16:\"table_responsive\";s:2:\"-1\";s:12:\"region_wells\";a:11:{s:14:\"navigation_top\";s:0:\"\";s:10:\"navigation\";s:0:\"\";s:22:\"navigation_collapsible\";s:0:\"\";s:6:\"header\";s:0:\"\";s:11:\"highlighted\";s:0:\"\";s:4:\"help\";s:0:\"\";s:7:\"content\";s:0:\"\";s:14:\"content_bottom\";s:0:\"\";s:13:\"sidebar_first\";s:0:\"\";s:14:\"sidebar_second\";s:0:\"\";s:6:\"footer\";s:0:\"\";}s:9:\"cdn_theme\";s:9:\"bootstrap\";s:22:\"cdn_cache_ttl_versions\";s:6:\"604800\";s:20:\"cdn_cache_ttl_themes\";s:6:\"604800\";s:20:\"cdn_cache_ttl_assets\";s:1:\"0\";s:21:\"cdn_cache_ttl_library\";s:1:\"0\";s:24:\"reset_http_request_cache\";s:0:\"\";s:5:\"table\";s:0:\"\";s:15:\"fluid_container\";i:0;s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:1;}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481109.091,1,'','0'),('color.theme.bootstrap',_binary 'b:0;',-1,1578481111.622,1,'','0'),('color.theme.classy',_binary 'b:0;',-1,1578495056.598,1,'','0'),('color.theme.clidentcastelo',_binary 'b:0;',-1,1578481112.233,1,'','0'),('color.theme.seven',_binary 'b:0;',-1,1579254129.966,1,'','0'),('color.theme.yorkshire',_binary 'b:0;',-1,1578495056.607,1,'','0'),('comment.type.comment',_binary 'a:9:{s:4:\"uuid\";s:36:\"eec3734c-1d52-40a6-abd9-e706d1b74f77\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA\";}s:2:\"id\";s:7:\"comment\";s:5:\"label\";s:25:\"Comentários predefinidos\";s:21:\"target_entity_type_id\";s:4:\"node\";s:11:\"description\";s:29:\"Permite comentar em conteúdo\";}',-1,1578481107.063,1,'','0'),('contact.form.fale_connosco',_binary 'a:11:{s:4:\"uuid\";s:36:\"4fcc776e-85c0-4ce2-8524-a8a9c6ffe2e7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:13:\"fale_connosco\";s:5:\"label\";s:13:\"Fale connosco\";s:10:\"recipients\";a:1:{i:0;s:21:\"pmctenreiro@gmail.com\";}s:5:\"reply\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"message\";s:78:\"Mensagem enviada!\r\nIremos entrar em contacto consigo o mais rápido possível.\";s:8:\"redirect\";s:10:\"/contactos\";}',-1,1578481107.068,1,'','0'),('contact.form.personal',_binary 'a:12:{s:4:\"uuid\";s:36:\"18b5dd9a-233c-4078-8864-0d7b1f4a67ad\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I\";}s:2:\"id\";s:8:\"personal\";s:5:\"label\";s:31:\"Formulário de contacto pessoal\";s:10:\"recipients\";a:0:{}s:5:\"reply\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"message\";s:27:\"A sua mensagem foi enviada.\";s:8:\"redirect\";s:0:\"\";}',-1,1578481107.068,1,'','0'),('core.base_field_override.block_content.basic.changed',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.default_langcode',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.id',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.info',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.langcode',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.metatag',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.reusable',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.revision_created',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.revision_default',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.revision_id',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.revision_log',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.revision_translation_affected',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.revision_user',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.status',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.type',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.block_content.basic.uuid',_binary 'b:0;',-1,1578481107.391,1,'','0'),('core.base_field_override.comment.comment.changed',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.cid',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.comment_type',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.created',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.default_langcode',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.entity_id',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.entity_type',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.field_name',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.homepage',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.hostname',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.langcode',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.mail',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.name',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.pid',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.status',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.subject',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.thread',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.uid',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.comment.comment.uuid',_binary 'b:0;',-1,1578481107.398,1,'','0'),('core.base_field_override.contact_message.fale_connosco.contact_form',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.copy',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.langcode',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.mail',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.message',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.name',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.recipient',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.subject',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.fale_connosco.uuid',_binary 'b:0;',-1,1578481110.034,1,'','0'),('core.base_field_override.contact_message.personal.contact_form',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.copy',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.langcode',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.mail',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.message',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.name',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.recipient',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.subject',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.contact_message.personal.uuid',_binary 'b:0;',-1,1578481110.042,1,'','0'),('core.base_field_override.crop.horizontal.cid',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.default_langcode',_binary 'b:0;',-1,1578481110.067,1,'','0'),('core.base_field_override.crop.horizontal.entity_id',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.entity_type',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.height',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.langcode',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.revision_default',_binary 'b:0;',-1,1578481110.067,1,'','0'),('core.base_field_override.crop.horizontal.revision_log',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.revision_timestamp',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.revision_translation_affected',_binary 'b:0;',-1,1578481110.067,1,'','0'),('core.base_field_override.crop.horizontal.revision_uid',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.type',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.uri',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.uuid',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.vid',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.width',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.x',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.horizontal.y',_binary 'b:0;',-1,1578481110.066,1,'','0'),('core.base_field_override.crop.vertical.cid',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.default_langcode',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.entity_id',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.entity_type',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.height',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.langcode',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.revision_default',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.revision_log',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.revision_timestamp',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.revision_translation_affected',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.revision_uid',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.type',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.uri',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.uuid',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.vid',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.width',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.x',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical.y',_binary 'b:0;',-1,1578481110.112,1,'','0'),('core.base_field_override.crop.vertical_team.cid',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.default_langcode',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.entity_id',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.entity_type',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.height',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.langcode',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.revision_default',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.revision_log',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.revision_timestamp',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.revision_translation_affected',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.revision_uid',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.type',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.uri',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.uuid',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.vid',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.width',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.x',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.vertical_team.y',_binary 'b:0;',-1,1578481110.116,1,'','0'),('core.base_field_override.crop.wide.cid',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.default_langcode',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.entity_id',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.entity_type',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.height',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.langcode',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.revision_default',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.revision_log',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.revision_timestamp',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.revision_translation_affected',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.revision_uid',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.type',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.uri',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.uuid',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.vid',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.width',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.x',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.crop.wide.y',_binary 'b:0;',-1,1578481110.121,1,'','0'),('core.base_field_override.file.file.changed',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.created',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.fid',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.filemime',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.filename',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.filesize',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.langcode',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.status',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.uid',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.uri',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.file.file.uuid',_binary 'b:0;',-1,1578481111.780,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.bundle',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.changed',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.default_langcode',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.description',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.enabled',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.expanded',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.external',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.id',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.langcode',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.link',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.menu_name',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.metatag',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.parent',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.rediscover',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_created',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_default',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_id',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_log_message',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_translation_affected',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_user',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.title',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.uuid',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.weight',_binary 'b:0;',-1,1578481108.224,1,'','0'),('core.base_field_override.node.equipa.changed',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.created',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.default_langcode',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.langcode',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.menu_link',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.metatag',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.nid',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.path',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"5285f527-557a-43d0-b210-6496ec9ba8d4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:16:\"node.type.equipa\";}}s:2:\"id\";s:19:\"node.equipa.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:6:\"equipa\";s:5:\"label\";s:30:\"Promovido à página principal\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:6:\"Ligado\";s:9:\"off_label\";s:9:\"Desligado\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.revision_default',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.revision_log',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.revision_timestamp',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.revision_translation_affected',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.revision_uid',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.status',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.sticky',_binary 'b:0;',-1,1578481107.413,1,'','0'),('core.base_field_override.node.equipa.title',_binary 'a:16:{s:4:\"uuid\";s:36:\"47f6db2b-b475-4b37-b321-db065d5dd604\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:16:\"node.type.equipa\";}}s:2:\"id\";s:17:\"node.equipa.title\";s:10:\"field_name\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:6:\"equipa\";s:5:\"label\";s:4:\"Nome\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.type',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.uid',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.uuid',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.equipa.vid',_binary 'b:0;',-1,1578481107.412,1,'','0'),('core.base_field_override.node.noticias.changed',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.created',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.default_langcode',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.langcode',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.menu_link',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.metatag',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.nid',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.path',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"9c223e4f-b506-4f29-a2ab-6b708ca75754\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:18:\"node.type.noticias\";}}s:2:\"id\";s:21:\"node.noticias.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"noticias\";s:5:\"label\";s:30:\"Promovido à página principal\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:6:\"Ligado\";s:9:\"off_label\";s:9:\"Desligado\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.revision_default',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.revision_log',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.revision_timestamp',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.revision_translation_affected',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.revision_uid',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.status',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.sticky',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.title',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.type',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.uid',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.uuid',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.noticias.vid',_binary 'b:0;',-1,1578481107.423,1,'','0'),('core.base_field_override.node.page.changed',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.created',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.default_langcode',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.langcode',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.menu_link',_binary 'b:0;',-1,1578481107.437,1,'','0'),('core.base_field_override.node.page.metatag',_binary 'b:0;',-1,1578481107.437,1,'','0'),('core.base_field_override.node.page.nid',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.path',_binary 'b:0;',-1,1578481107.437,1,'','0'),('core.base_field_override.node.page.promote',_binary 'a:17:{s:4:\"uuid\";s:36:\"f76bb045-9229-42d8-b1e0-df82f6befddd\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:14:\"node.type.page\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ\";}s:2:\"id\";s:17:\"node.page.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:30:\"Promovido à página principal\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:6:\"Ligado\";s:9:\"off_label\";s:9:\"Desligado\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.revision_default',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.revision_log',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.revision_timestamp',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.revision_translation_affected',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.revision_uid',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.status',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.sticky',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.title',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.type',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.uid',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.uuid',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.page.vid',_binary 'b:0;',-1,1578481107.436,1,'','0'),('core.base_field_override.node.parceria.changed',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.created',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.default_langcode',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.langcode',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.menu_link',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.metatag',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.nid',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.path',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"3e470719-bb7f-42e7-87d3-f77999d973db\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:18:\"node.type.parceria\";}}s:2:\"id\";s:21:\"node.parceria.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"parceria\";s:5:\"label\";s:30:\"Promovido à página principal\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:6:\"Ligado\";s:9:\"off_label\";s:9:\"Desligado\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.revision_default',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.revision_log',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.revision_timestamp',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.revision_translation_affected',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.revision_uid',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.status',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.sticky',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.title',_binary 'a:16:{s:4:\"uuid\";s:36:\"a8bea569-56a2-4b00-8cca-aead4aa1d64c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:18:\"node.type.parceria\";}}s:2:\"id\";s:19:\"node.parceria.title\";s:10:\"field_name\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"parceria\";s:5:\"label\";s:6:\"Titulo\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.type',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.uid',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.uuid',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.parceria.vid',_binary 'b:0;',-1,1578481107.449,1,'','0'),('core.base_field_override.node.slideshow.changed',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.created',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.default_langcode',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.langcode',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.menu_link',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.metatag',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.nid',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.path',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"4c9082e5-e43c-4b31-8a43-e34af68ca7b0\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:19:\"node.type.slideshow\";}}s:2:\"id\";s:22:\"node.slideshow.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"slideshow\";s:5:\"label\";s:30:\"Promovido à página principal\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:6:\"Ligado\";s:9:\"off_label\";s:9:\"Desligado\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.revision_default',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.revision_log',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.revision_timestamp',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.revision_translation_affected',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.revision_uid',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.status',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.sticky',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.title',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.type',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.uid',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.uuid',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.node.slideshow.vid',_binary 'b:0;',-1,1578481107.460,1,'','0'),('core.base_field_override.shortcut.default.default_langcode',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.id',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.langcode',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.link',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.metatag',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.shortcut_set',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.title',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.uuid',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.shortcut.default.weight',_binary 'b:0;',-1,1578481110.147,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.changed',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.default_langcode',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.description',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.langcode',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.metatag',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.name',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.parent',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.path',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.revision_created',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.revision_default',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.revision_id',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.revision_log_message',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.revision_translation_affected',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.revision_user',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.status',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.tid',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.uuid',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.vid',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.parcerias.weight',_binary 'b:0;',-1,1578481107.485,1,'','0'),('core.base_field_override.taxonomy_term.servicos.changed',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.default_langcode',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.description',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.langcode',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.metatag',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.name',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.parent',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.path',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.revision_created',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.revision_default',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.revision_id',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.revision_log_message',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.revision_translation_affected',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.revision_user',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.status',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.tid',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.uuid',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.vid',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.taxonomy_term.servicos.weight',_binary 'b:0;',-1,1578481107.493,1,'','0'),('core.base_field_override.user.user.access',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.changed',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.created',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.default_langcode',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.init',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.langcode',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.login',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.mail',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.metatag',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.name',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.pass',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.path',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.preferred_admin_langcode',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.preferred_langcode',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.roles',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.status',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.timezone',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.uid',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.base_field_override.user.user.uuid',_binary 'b:0;',-1,1578481107.131,1,'','0'),('core.date_format.fallback',_binary 'a:9:{s:4:\"uuid\";s:36:\"7bd78518-a281-49b2-9103-090d51cef4f5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE\";}s:2:\"id\";s:8:\"fallback\";s:5:\"label\";s:26:\"Formato de data de recurso\";s:6:\"locked\";b:1;s:7:\"pattern\";s:14:\"D, m/d/Y - H:i\";}',-1,1578481110.002,1,'','0'),('core.date_format.html_date',_binary 'a:9:{s:4:\"uuid\";s:36:\"7a4785f6-d29c-4cbc-aea8-f3d3f19bd3e2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk\";}s:2:\"id\";s:9:\"html_date\";s:5:\"label\";s:12:\"Data de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"Y-m-d\";}',-1,1578481109.517,1,'','0'),('core.date_format.html_datetime',_binary 'a:9:{s:4:\"uuid\";s:36:\"1a9d8cd1-c056-41c1-bf24-deecc60fac71\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE\";}s:2:\"id\";s:13:\"html_datetime\";s:5:\"label\";s:19:\"Data e Hora de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:13:\"Y-m-d\\TH:i:sO\";}',-1,1578481110.002,1,'','0'),('core.date_format.html_month',_binary 'a:9:{s:4:\"uuid\";s:36:\"2b84e6a6-e3d5-4e3f-9706-2cb2042e2580\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM\";}s:2:\"id\";s:10:\"html_month\";s:5:\"label\";s:12:\"Mês de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:3:\"Y-m\";}',-1,1578481110.002,1,'','0'),('core.date_format.html_time',_binary 'a:9:{s:4:\"uuid\";s:36:\"c304378a-bae8-4a54-827b-f358115c57ab\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE\";}s:2:\"id\";s:9:\"html_time\";s:5:\"label\";s:12:\"Hora de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"H:i:s\";}',-1,1578481109.521,1,'','0'),('core.date_format.html_week',_binary 'a:9:{s:4:\"uuid\";s:36:\"f6e9d310-e1b9-4634-aee0-bb03a31478df\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY\";}s:2:\"id\";s:9:\"html_week\";s:5:\"label\";s:14:\"Semana de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"Y-\\WW\";}',-1,1578481110.002,1,'','0'),('core.date_format.html_year',_binary 'a:9:{s:4:\"uuid\";s:36:\"b1388d2e-9199-4868-bc09-b9af14495b0b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk\";}s:2:\"id\";s:9:\"html_year\";s:5:\"label\";s:11:\"Ano de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:1:\"Y\";}',-1,1578481110.002,1,'','0'),('core.date_format.html_yearless_date',_binary 'a:9:{s:4:\"uuid\";s:36:\"97fda90c-3fa1-4a9a-9cff-b282210264a8\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc\";}s:2:\"id\";s:18:\"html_yearless_date\";s:5:\"label\";s:20:\"Data sem ano de HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:3:\"m-d\";}',-1,1578481110.002,1,'','0'),('core.date_format.long',_binary 'a:9:{s:4:\"uuid\";s:36:\"a5bb9b9a-abe7-41b8-a6e0-c916a5d6548e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo\";}s:2:\"id\";s:4:\"long\";s:5:\"label\";s:22:\"Data longa predefinida\";s:6:\"locked\";b:0;s:7:\"pattern\";s:24:\"l, d \\d\\e F \\d\\e Y - H:i\";}',-1,1578481109.990,1,'','0'),('core.date_format.medium',_binary 'a:9:{s:4:\"uuid\";s:36:\"0e09bed9-3bed-4680-aa6d-ca15526f2918\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE\";}s:2:\"id\";s:6:\"medium\";s:5:\"label\";s:28:\"Data intermédia predefinida\";s:6:\"locked\";b:0;s:7:\"pattern\";s:12:\"D, Y-m-d H:i\";}',-1,1578481109.987,1,'','0'),('core.date_format.short',_binary 'a:9:{s:4:\"uuid\";s:36:\"ed5e4a69-7426-4d3b-b70d-c40073555a95\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA\";}s:2:\"id\";s:5:\"short\";s:5:\"label\";s:22:\"Data curta predefinida\";s:6:\"locked\";b:0;s:7:\"pattern\";s:9:\"Y-m-d H:i\";}',-1,1578481109.984,1,'','0'),('core.date_format.simples',_binary 'a:8:{s:4:\"uuid\";s:36:\"5c1009f6-5140-4f73-b3e0-1dbf47de3fc3\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:7:\"simples\";s:5:\"label\";s:7:\"Simples\";s:6:\"locked\";b:0;s:7:\"pattern\";s:8:\"l, d-m-Y\";}',-1,1578481110.002,1,'','0'),('core.entity_form_display.node.page.default',_binary 'a:11:{s:4:\"uuid\";s:36:\"73bae3b7-9c75-4b92-ba5a-c3d309763ef0\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:26:\"field.field.node.page.body\";i:1;s:34:\"field.field.node.page.field_imagem\";i:2;s:21:\"image.style.thumbnail\";i:3;s:14:\"node.type.page\";}s:6:\"module\";a:3:{i:0;s:17:\"image_widget_crop\";i:1;s:4:\"path\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sb0qCkzU_8mNq29NehYAU8jCBXWPLeX0UN8sYFVGVcw\";}s:2:\"id\";s:17:\"node.page.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:3:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:12:\"field_imagem\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:8:{s:14:\"show_crop_area\";b:1;s:17:\"show_default_crop\";b:1;s:19:\"preview_image_style\";s:9:\"thumbnail\";s:24:\"crop_preview_image_style\";s:6:\"medium\";s:9:\"crop_list\";a:1:{i:0;s:4:\"wide\";}s:19:\"crop_types_required\";a:1:{i:0;s:4:\"wide\";}s:18:\"progress_indicator\";s:8:\"throbber\";s:20:\"warn_multiple_usages\";b:0;}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:17:\"image_widget_crop\";s:6:\"region\";s:7:\"content\";}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:20:\"third_party_settings\";a:0:{}}s:5:\"title\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:5:{s:7:\"created\";b:1;s:8:\"langcode\";b:1;s:7:\"promote\";b:1;s:6:\"sticky\";b:1;s:3:\"uid\";b:1;}}',-1,1578495060.238,1,'','0'),('core.entity_form_display.node.page.edit',_binary 'b:0;',-1,1578495060.238,1,'','0'),('core.entity_form_display.node.slideshow.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"feb8c7f5-9dc1-4ea4-8416-cd41045e9b09\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:38:\"field.field.node.slideshow.field_botao\";i:1;s:49:\"field.field.node.slideshow.field_imagem_slideshow\";i:2;s:37:\"field.field.node.slideshow.field_text\";i:3;s:21:\"image.style.thumbnail\";i:4;s:19:\"node.type.slideshow\";}s:6:\"module\";a:3:{i:0;s:17:\"image_widget_crop\";i:1;s:4:\"link\";i:2;s:4:\"text\";}}s:2:\"id\";s:22:\"node.slideshow.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:9:\"slideshow\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:11:\"field_botao\";a:5:{s:6:\"weight\";i:3;s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"link_default\";s:6:\"region\";s:7:\"content\";}s:22:\"field_imagem_slideshow\";a:5:{s:6:\"weight\";i:1;s:8:\"settings\";a:8:{s:14:\"show_crop_area\";b:1;s:17:\"show_default_crop\";b:1;s:20:\"warn_multiple_usages\";b:1;s:19:\"preview_image_style\";s:9:\"thumbnail\";s:24:\"crop_preview_image_style\";s:6:\"medium\";s:9:\"crop_list\";a:1:{i:0;s:4:\"wide\";}s:19:\"crop_types_required\";a:1:{i:0;s:4:\"wide\";}s:18:\"progress_indicator\";s:8:\"throbber\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:17:\"image_widget_crop\";s:6:\"region\";s:7:\"content\";}s:10:\"field_text\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:13:\"text_textarea\";s:6:\"region\";s:7:\"content\";}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:20:\"third_party_settings\";a:0:{}}s:5:\"title\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:6:{s:7:\"created\";b:1;s:8:\"langcode\";b:1;s:4:\"path\";b:1;s:7:\"promote\";b:1;s:6:\"sticky\";b:1;s:3:\"uid\";b:1;}}',-1,1578495069.629,1,'','0'),('core.entity_form_display.node.slideshow.edit',_binary 'b:0;',-1,1578495310.291,1,'','0'),('core.entity_form_display.taxonomy_term.servicos.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"c7fc2c2f-04f4-43b9-9bdb-befde55bc990\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:53:\"field.field.taxonomy_term.servicos.field_icon_servico\";i:1;s:21:\"image.style.thumbnail\";i:2;s:28:\"taxonomy.vocabulary.servicos\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"text\";}}s:2:\"id\";s:30:\"taxonomy_term.servicos.default\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:8:\"servicos\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:11:\"description\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_icon_servico\";a:5:{s:6:\"weight\";i:0;s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:11:\"image_image\";s:6:\"region\";s:7:\"content\";}s:4:\"name\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:8:\"langcode\";b:1;s:4:\"path\";b:1;}}',-1,1579196174.306,1,'','0'),('core.entity_form_display.user.user.default',_binary 'a:11:{s:4:\"uuid\";s:36:\"a77de034-23ba-429d-9565-3f755208069c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:34:\"field.field.user.user.user_picture\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"K-1rBM8mTIkFp9RqOC2tMRUukOQ1xbRCfSKK8dEddnA\";}s:2:\"id\";s:17:\"user.user.default\";s:16:\"targetEntityType\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:7:\"account\";a:4:{s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:6:{s:7:\"contact\";b:1;s:8:\"langcode\";b:1;s:8:\"language\";b:1;s:4:\"path\";b:1;s:8:\"timezone\";b:1;s:12:\"user_picture\";b:1;}}',-1,1578495055.710,1,'','0'),('core.entity_form_mode.user.register',_binary 'a:9:{s:4:\"uuid\";s:36:\"e8a6e700-c2c6-4de3-a30d-fa0786935f59\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI\";}s:2:\"id\";s:13:\"user.register\";s:5:\"label\";s:12:\"Inscrever-se\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1578481111.179,1,'','0'),('core.entity_view_display.file.file.token',_binary 'b:0;',-1,1578481111.808,1,'','0'),('core.entity_view_display.node.equipa.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"3be9060a-5dcd-4a3c-ad66-380eac11233c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:39:\"field.field.node.equipa.field_descricao\";i:1;s:34:\"field.field.node.equipa.field_foto\";i:2;s:16:\"node.type.equipa\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:2:\"id\";s:19:\"node.equipa.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:6:\"equipa\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:15:\"field_descricao\";a:6:{s:6:\"weight\";i:101;s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:6:\"string\";s:6:\"region\";s:7:\"content\";}s:10:\"field_foto\";a:6:{s:6:\"weight\";i:102;s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:0:\"\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:6:\"weight\";i:100;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1578481552.125,1,'','0'),('core.entity_view_display.node.equipa.full',_binary 'b:0;',-1,1580769691.710,1,'','0'),('core.entity_view_display.node.equipa.search_index',_binary 'b:0;',-1,1578486712.535,1,'','0'),('core.entity_view_display.node.equipa.teaser',_binary 'a:10:{s:4:\"uuid\";s:36:\"7d5155af-7ac1-497d-aa2d-62d802729cf6\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:39:\"field.field.node.equipa.field_descricao\";i:2;s:34:\"field.field.node.equipa.field_foto\";i:3;s:16:\"image.style.team\";i:4;s:16:\"node.type.equipa\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:2:\"id\";s:18:\"node.equipa.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:6:\"equipa\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:2:{s:15:\"field_descricao\";a:6:{s:4:\"type\";s:6:\"string\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:10:\"field_foto\";a:6:{s:4:\"type\";s:5:\"image\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:4:\"team\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1578481552.125,1,'','0'),('core.entity_view_display.node.equipa.token',_binary 'b:0;',-1,1580769691.791,1,'','0'),('core.entity_view_display.node.noticias.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"c80a9688-b259-40b0-a4b8-5cbe440d2742\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:30:\"field.field.node.noticias.body\";i:1;s:48:\"field.field.node.noticias.field_imagem_slideshow\";i:2;s:24:\"image.style.horizontal_1\";i:3;s:18:\"node.type.noticias\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:4:\"text\";i:2;s:4:\"user\";}}s:2:\"id\";s:21:\"node.noticias.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:8:\"noticias\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:22:\"field_imagem_slideshow\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:12:\"horizontal_1\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1578481566.037,1,'','0'),('core.entity_view_display.node.noticias.full',_binary 'b:0;',-1,1578483666.495,1,'','0'),('core.entity_view_display.node.noticias.search_index',_binary 'b:0;',-1,1578486712.593,1,'','0'),('core.entity_view_display.node.noticias.teaser',_binary 'a:10:{s:4:\"uuid\";s:36:\"ede1fc7b-d186-4b13-be60-5b4f17d1d83d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:30:\"field.field.node.noticias.body\";i:2;s:48:\"field.field.node.noticias.field_imagem_slideshow\";i:3;s:24:\"image.style.horizontal_1\";i:4;s:18:\"node.type.noticias\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:4:\"text\";i:2;s:4:\"user\";}}s:2:\"id\";s:20:\"node.noticias.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:8:\"noticias\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";i:1;s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:22:\"field_imagem_slideshow\";a:6:{s:4:\"type\";s:5:\"image\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:12:\"horizontal_1\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1578481566.037,1,'','0'),('core.entity_view_display.node.noticias.token',_binary 'b:0;',-1,1578483666.530,1,'','0'),('core.entity_view_display.node.page.default',_binary 'a:11:{s:4:\"uuid\";s:36:\"89656809-9638-4510-971b-a56947341a6d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:26:\"field.field.node.page.body\";i:1;s:34:\"field.field.node.page.field_imagem\";i:2;s:14:\"node.type.page\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:4:\"text\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"g1S3_GLaxq4l3I9RIca5Mlz02MxI2KmOquZpHw59akM\";}s:2:\"id\";s:17:\"node.page.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:12:\"field_imagem\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:0:\"\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1578481111.756,1,'','0'),('core.entity_view_display.node.page.full',_binary 'b:0;',-1,1578481111.756,1,'','0'),('core.entity_view_display.node.page.search_index',_binary 'b:0;',-1,1578486712.811,1,'','0'),('core.entity_view_display.node.page.teaser',_binary 'a:11:{s:4:\"uuid\";s:36:\"7829493b-f2db-4dbd-8b0e-cad2156068f5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:26:\"field.field.node.page.body\";i:2;s:14:\"node.type.page\";}s:6:\"module\";a:2:{i:0;s:4:\"text\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cSv5lDnbIgDug475Hdz3woED2XMqYv3awI-J9u1JLbY\";}s:2:\"id\";s:16:\"node.page.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:20:\"third_party_settings\";a:0:{}}s:5:\"links\";a:2:{s:6:\"weight\";i:101;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1578481186.247,1,'','0'),('core.entity_view_display.node.page.token',_binary 'b:0;',-1,1578481111.797,1,'','0'),('core.entity_view_display.node.slideshow.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"40f2a5cf-a88f-4e3a-a6c8-6626083dc72d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:38:\"field.field.node.slideshow.field_botao\";i:1;s:49:\"field.field.node.slideshow.field_imagem_slideshow\";i:2;s:37:\"field.field.node.slideshow.field_text\";i:3;s:22:\"image.style.horizontal\";i:4;s:19:\"node.type.slideshow\";}s:6:\"module\";a:4:{i:0;s:5:\"image\";i:1;s:4:\"link\";i:2;s:4:\"text\";i:3;s:4:\"user\";}}s:2:\"id\";s:22:\"node.slideshow.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:9:\"slideshow\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:11:\"field_botao\";a:6:{s:6:\"weight\";i:104;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:80;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:0:\"\";s:6:\"target\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:4:\"link\";s:6:\"region\";s:7:\"content\";}s:22:\"field_imagem_slideshow\";a:6:{s:6:\"weight\";i:102;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:10:\"horizontal\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}s:10:\"field_text\";a:6:{s:6:\"weight\";i:103;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"text_default\";s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1578481112.132,1,'','0'),('core.entity_view_display.node.slideshow.full',_binary 'b:0;',-1,1578495123.862,1,'','0'),('core.entity_view_display.node.slideshow.search_index',_binary 'b:0;',-1,1578503431.903,1,'','0'),('core.entity_view_display.node.slideshow.token',_binary 'b:0;',-1,1578495123.899,1,'','0'),('core.entity_view_display.taxonomy_term.parcerias.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"58bc4589-cb51-46bd-8ce2-7b79eb91e3ee\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:49:\"field.field.taxonomy_term.parcerias.field_ligacao\";i:1;s:50:\"field.field.taxonomy_term.parcerias.field_logotipo\";i:2;s:21:\"image.style.thumbnail\";i:3;s:29:\"taxonomy.vocabulary.parcerias\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"link\";}}s:2:\"id\";s:31:\"taxonomy_term.parcerias.default\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:9:\"parcerias\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:13:\"field_ligacao\";a:6:{s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:80;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:4:\"link\";s:6:\"region\";s:7:\"content\";}s:14:\"field_logotipo\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:11:\"description\";b:1;s:8:\"langcode\";b:1;}}',-1,1578481736.262,1,'','0'),('core.entity_view_display.taxonomy_term.parcerias.token',_binary 'b:0;',-1,1578481736.262,1,'','0'),('core.entity_view_display.taxonomy_term.servicos.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"3292c4a7-693c-4e71-9532-e446860e2432\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:53:\"field.field.taxonomy_term.servicos.field_icon_servico\";i:1;s:28:\"taxonomy.vocabulary.servicos\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"text\";}}s:2:\"id\";s:30:\"taxonomy_term.servicos.default\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:8:\"servicos\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:11:\"description\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_icon_servico\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:0:\"\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1578481112.453,1,'','0'),('core.entity_view_display.taxonomy_term.servicos.full',_binary 'a:10:{s:4:\"uuid\";s:36:\"0a892ed3-5e93-40cb-8b41-fda4d185c277\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:40:\"core.entity_view_mode.taxonomy_term.full\";i:1;s:53:\"field.field.taxonomy_term.servicos.field_icon_servico\";i:2;s:21:\"image.style.thumbnail\";i:3;s:28:\"taxonomy.vocabulary.servicos\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"text\";}}s:2:\"id\";s:27:\"taxonomy_term.servicos.full\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:8:\"servicos\";s:4:\"mode\";s:4:\"full\";s:7:\"content\";a:2:{s:11:\"description\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_icon_servico\";a:6:{s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1578483663.338,1,'','0'),('core.entity_view_display.taxonomy_term.servicos.token',_binary 'a:10:{s:4:\"uuid\";s:36:\"934c3008-6119-4f66-b58e-41db540ff040\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_view_mode.taxonomy_term.token\";i:1;s:53:\"field.field.taxonomy_term.servicos.field_icon_servico\";i:2;s:21:\"image.style.thumbnail\";i:3;s:28:\"taxonomy.vocabulary.servicos\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:28:\"taxonomy_term.servicos.token\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:8:\"servicos\";s:4:\"mode\";s:5:\"token\";s:7:\"content\";a:1:{s:18:\"field_icon_servico\";a:6:{s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:5:\"image\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:11:\"description\";b:1;s:8:\"langcode\";b:1;}}',-1,1578481112.453,1,'','0'),('core.entity_view_display.user.user.default',_binary 'a:11:{s:4:\"uuid\";s:36:\"cc9f0d35-9683-4349-aac3-e5a679fecbcf\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.field.user.user.user_picture\";i:1;s:21:\"image.style.thumbnail\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"V51QPCKkgNREKtSmB9Iu2wmAMEpktVpnzklWaZV8UYo\";}s:2:\"id\";s:17:\"user.user.default\";s:16:\"targetEntityType\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:10:\"member_for\";a:2:{s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}s:12:\"user_picture\";a:6:{s:4:\"type\";s:5:\"image\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:7:\"content\";}s:20:\"third_party_settings\";a:0:{}s:5:\"label\";s:6:\"hidden\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1578481109.353,1,'','0'),('core.entity_view_display.user.user.full',_binary 'b:0;',-1,1578481109.353,1,'','0'),('core.entity_view_display.user.user.token',_binary 'b:0;',-1,1578481109.976,1,'','0'),('core.entity_view_mode.block.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"28364c1b-52e1-4f30-ac20-4182fc67f024\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"block\";}}s:2:\"id\";s:11:\"block.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:5:\"block\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.block_content.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"8325a72b-998f-4973-815a-be12c2da95b8\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg\";}s:2:\"id\";s:18:\"block_content.full\";s:5:\"label\";s:8:\"Completo\";s:16:\"targetEntityType\";s:13:\"block_content\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.block_content.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"078c9dd0-3eab-4460-8471-9e2d7c12f9e6\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:2:\"id\";s:19:\"block_content.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:13:\"block_content\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.comment.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"0b294298-d058-42f6-89f4-2997e6acb06c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA\";}s:2:\"id\";s:12:\"comment.full\";s:5:\"label\";s:20:\"Comentário completo\";s:16:\"targetEntityType\";s:7:\"comment\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.comment.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"b0738783-b880-4ef0-980c-e6f84b8dab06\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:2:\"id\";s:13:\"comment.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:7:\"comment\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.contact_message.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"f0b0bfb1-fbd2-4292-bc6d-bea8729df5ac\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"contact\";}}s:2:\"id\";s:21:\"contact_message.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:15:\"contact_message\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.file.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"1ae2f754-c821-4095-b763-89d37a810eb8\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:2:\"id\";s:10:\"file.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"file\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.menu_link_content.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"945dd70f-2e04-499f-ac90-2529f2cdcb15\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:17:\"menu_link_content\";}}s:2:\"id\";s:23:\"menu_link_content.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:17:\"menu_link_content\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.node.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"dbd5e158-8a59-4c0d-99b1-0f5a5f1b664d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk\";}s:2:\"id\";s:9:\"node.full\";s:5:\"label\";s:18:\"Conteúdo completo\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.node.rss',_binary 'a:9:{s:4:\"uuid\";s:36:\"a1afbc01-0769-43d9-bf2a-d95e37f7a5ed\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU\";}s:2:\"id\";s:8:\"node.rss\";s:5:\"label\";s:3:\"RSS\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.node.search_index',_binary 'a:9:{s:4:\"uuid\";s:36:\"577dafdc-e346-466f-8eac-e032bad3c71b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY\";}s:2:\"id\";s:17:\"node.search_index\";s:5:\"label\";s:19:\"Índice de pesquisa\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.node.search_result',_binary 'a:9:{s:4:\"uuid\";s:36:\"bf3f0036-19dd-4fbb-8e5d-0912e466a850\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM\";}s:2:\"id\";s:18:\"node.search_result\";s:5:\"label\";s:32:\"Search result highlighting input\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.node.teaser',_binary 'a:9:{s:4:\"uuid\";s:36:\"e479a080-b8bd-4f14-b2dd-d52294d0f2d7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4\";}s:2:\"id\";s:11:\"node.teaser\";s:5:\"label\";s:6:\"Resumo\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.node.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"73008490-9b46-4fbd-8b0a-0fa2a1cfeee2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:10:\"node.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.shortcut.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"85ce4aa6-1dbc-4686-af33-a2b31095aa88\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"shortcut\";}}s:2:\"id\";s:14:\"shortcut.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:8:\"shortcut\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.taxonomy_term.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"73023ddc-e8cd-4a96-9f58-2f8f8f38924b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE\";}s:2:\"id\";s:18:\"taxonomy_term.full\";s:5:\"label\";s:26:\"Página do termo Taxonomia\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.taxonomy_term.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"5949fbc2-ca67-4dd0-af97-15f80284c19c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:2:\"id\";s:19:\"taxonomy_term.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.tour.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"4e7d6663-7326-4ca4-83e3-3af376e3c9b7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"tour\";}}s:2:\"id\";s:10:\"tour.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"tour\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.user.compact',_binary 'a:9:{s:4:\"uuid\";s:36:\"ba791174-a0c5-40ed-b697-91123bb233ee\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g\";}s:2:\"id\";s:12:\"user.compact\";s:5:\"label\";s:8:\"Compacto\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.user.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"85aa75a0-0c1a-481b-8a90-2f5092cfa0ec\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM\";}s:2:\"id\";s:9:\"user.full\";s:5:\"label\";s:19:\"Conta de utilizador\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.entity_view_mode.user.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"93d828f5-b597-4fa3-9b39-1bf3075e6c97\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:10:\"user.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1578481109.342,1,'','0'),('core.extension',_binary 'a:5:{s:6:\"module\";a:64:{s:13:\"admin_toolbar\";i:0;s:33:\"admin_toolbar_links_access_filter\";i:0;s:19:\"admin_toolbar_tools\";i:0;s:14:\"automated_cron\";i:0;s:8:\"big_pipe\";i:0;s:5:\"block\";i:0;s:13:\"block_content\";i:0;s:10:\"breakpoint\";i:0;s:8:\"ckeditor\";i:0;s:16:\"ckeditor_youtube\";i:0;s:5:\"color\";i:0;s:7:\"comment\";i:0;s:6:\"config\";i:0;s:7:\"contact\";i:0;s:13:\"contact_block\";i:0;s:10:\"contextual\";i:0;s:4:\"crop\";i:0;s:6:\"ctools\";i:0;s:8:\"datetime\";i:0;s:5:\"dblog\";i:0;s:5:\"devel\";i:0;s:14:\"draggableviews\";i:0;s:18:\"dynamic_page_cache\";i:0;s:6:\"editor\";i:0;s:5:\"field\";i:0;s:8:\"field_ui\";i:0;s:4:\"file\";i:0;s:6:\"filter\";i:0;s:16:\"form_placeholder\";i:0;s:7:\"history\";i:0;s:8:\"honeypot\";i:0;s:5:\"image\";i:0;s:17:\"image_widget_crop\";i:0;s:4:\"kint\";i:0;s:8:\"language\";i:0;s:4:\"link\";i:0;s:6:\"locale\";i:0;s:7:\"menu_ui\";i:0;s:7:\"metatag\";i:0;s:18:\"metatag_open_graph\";i:0;s:4:\"node\";i:0;s:7:\"options\";i:0;s:10:\"page_cache\";i:0;s:4:\"path\";i:0;s:9:\"quickedit\";i:0;s:3:\"rdf\";i:0;s:6:\"search\";i:0;s:6:\"seckit\";i:0;s:8:\"shortcut\";i:0;s:7:\"support\";i:0;s:17:\"switch_page_theme\";i:0;s:6:\"system\";i:0;s:8:\"taxonomy\";i:0;s:4:\"text\";i:0;s:5:\"token\";i:0;s:7:\"toolbar\";i:0;s:4:\"tour\";i:0;s:4:\"user\";i:0;s:8:\"views_ui\";i:0;s:17:\"menu_link_content\";i:1;s:8:\"pathauto\";i:1;s:5:\"views\";i:10;s:8:\"standard\";i:1000;s:20:\"eu_cookie_compliance\";i:1001;}s:5:\"theme\";a:7:{s:6:\"stable\";i:0;s:6:\"classy\";i:0;s:6:\"bartik\";i:0;s:5:\"seven\";i:0;s:9:\"bootstrap\";i:0;s:14:\"clidentcastelo\";i:0;s:9:\"yorkshire\";i:0;}s:7:\"profile\";s:8:\"standard\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481105.438,1,'','0'),('core.menu.static_menu_link_overrides',_binary 'a:3:{s:11:\"definitions\";a:2:{s:18:\"contact__site_page\";a:5:{s:7:\"enabled\";b:1;s:9:\"menu_name\";s:6:\"footer\";s:6:\"parent\";s:0:\"\";s:6:\"weight\";i:0;s:8:\"expanded\";b:0;}s:20:\"standard__front_page\";a:5:{s:7:\"enabled\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";s:8:\"expanded\";b:0;s:6:\"weight\";i:-50;}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"o4bYR9ZupWb3AsOIizTUG4g-nu1mdJqA59UB7QT-ifQ\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.439,1,'','0'),('crop.settings',_binary 'a:3:{s:23:\"flush_derivative_images\";b:1;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7eGOTSG7bRv_AAqu-Ls8CSnob7zPF1ez-lD2OLZgBHs\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495123.674,1,'','0'),('crop.type.horizontal',_binary 'a:12:{s:4:\"uuid\";s:36:\"82ff4860-a738-42e5-b920-6266d7c582a4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"label\";s:10:\"Horizontal\";s:2:\"id\";s:10:\"horizontal\";s:11:\"description\";s:0:\"\";s:12:\"aspect_ratio\";s:3:\"4:3\";s:16:\"soft_limit_width\";N;s:17:\"soft_limit_height\";N;s:16:\"hard_limit_width\";N;s:17:\"hard_limit_height\";N;}',-1,1578481107.072,1,'','0'),('crop.type.vertical',_binary 'a:12:{s:4:\"uuid\";s:36:\"96b3d866-eca4-4564-86db-6c3609476606\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"label\";s:8:\"Vertical\";s:2:\"id\";s:8:\"vertical\";s:11:\"description\";s:0:\"\";s:12:\"aspect_ratio\";s:3:\"3:4\";s:16:\"soft_limit_width\";N;s:17:\"soft_limit_height\";N;s:16:\"hard_limit_width\";N;s:17:\"hard_limit_height\";N;}',-1,1578481107.072,1,'','0'),('crop.type.vertical_team',_binary 'a:12:{s:4:\"uuid\";s:36:\"a5269c6e-4b21-43e3-b33d-f16dfa390ee5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"label\";s:13:\"Vertical team\";s:2:\"id\";s:13:\"vertical_team\";s:11:\"description\";s:0:\"\";s:12:\"aspect_ratio\";s:3:\"1:1\";s:16:\"soft_limit_width\";N;s:17:\"soft_limit_height\";N;s:16:\"hard_limit_width\";N;s:17:\"hard_limit_height\";N;}',-1,1578481107.072,1,'','0'),('crop.type.wide',_binary 'a:12:{s:4:\"uuid\";s:36:\"9b744016-07f9-4efe-a48f-e0ab64ba54f5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"label\";s:4:\"Wide\";s:2:\"id\";s:4:\"wide\";s:11:\"description\";s:0:\"\";s:12:\"aspect_ratio\";s:3:\"6:2\";s:16:\"soft_limit_width\";i:1024;s:17:\"soft_limit_height\";i:200;s:16:\"hard_limit_width\";N;s:17:\"hard_limit_height\";N;}',-1,1578481107.072,1,'','0'),('dblog.settings',_binary 'a:3:{s:9:\"row_limit\";i:1000;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578486712.420,1,'','0'),('devel.settings',_binary 'a:9:{s:10:\"page_alter\";b:0;s:9:\"raw_names\";b:0;s:14:\"error_handlers\";a:1:{i:1;i:1;}s:13:\"rebuild_theme\";b:0;s:22:\"debug_mail_file_format\";s:31:\"%to-%subject-%datetime.mail.txt\";s:20:\"debug_mail_directory\";s:23:\"temporary://devel-mails\";s:12:\"devel_dumper\";s:7:\"default\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8SYa5OOpQGdg4wnttb0LFNuG6GmivsS2qNv9sTH9gDI\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.832,1,'','0'),('devel.toolbar.settings',_binary 'a:3:{s:13:\"toolbar_items\";a:7:{i:0;s:25:\"devel.admin_settings_link\";i:1;s:17:\"devel.cache_clear\";i:2;s:28:\"devel.container_info.service\";i:3;s:18:\"devel.menu_rebuild\";i:4;s:15:\"devel.reinstall\";i:5;s:16:\"devel.route_info\";i:6;s:14:\"devel.run_cron\";}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"IQjf_ytthngZTAk_MU8-74VecArWD3G5g0oEH6PM6GA\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481110.309,1,'','0'),('editor.editor.basic_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"93ee2475-ffd3-4cf2-8183-826399cd9c34\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:24:\"filter.format.basic_html\";}s:6:\"module\";a:1:{i:0;s:8:\"ckeditor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AqlPmO16LvJI4D0Ih6u4GFQIzqr5OnLgAUSjcUGWk2g\";}s:6:\"format\";s:10:\"basic_html\";s:6:\"editor\";s:8:\"ckeditor\";s:8:\"settings\";a:2:{s:7:\"toolbar\";a:1:{s:4:\"rows\";a:1:{i:0;a:6:{i:0;a:2:{s:4:\"name\";s:10:\"Formatting\";s:5:\"items\";a:2:{i:0;s:4:\"Bold\";i:1;s:6:\"Italic\";}}i:1;a:2:{s:4:\"name\";s:7:\"Linking\";s:5:\"items\";a:2:{i:0;s:10:\"DrupalLink\";i:1;s:12:\"DrupalUnlink\";}}i:2;a:2:{s:4:\"name\";s:5:\"Lists\";s:5:\"items\";a:2:{i:0;s:12:\"BulletedList\";i:1;s:12:\"NumberedList\";}}i:3;a:2:{s:4:\"name\";s:5:\"Media\";s:5:\"items\";a:2:{i:0;s:10:\"Blockquote\";i:1;s:11:\"DrupalImage\";}}i:4;a:2:{s:4:\"name\";s:16:\"Block Formatting\";s:5:\"items\";a:1:{i:0;s:6:\"Format\";}}i:5;a:2:{s:4:\"name\";s:5:\"Tools\";s:5:\"items\";a:1:{i:0;s:6:\"Source\";}}}}}s:7:\"plugins\";a:1:{s:11:\"stylescombo\";a:1:{s:6:\"styles\";s:0:\"\";}}}s:12:\"image_upload\";a:5:{s:6:\"status\";b:1;s:6:\"scheme\";s:6:\"public\";s:9:\"directory\";s:13:\"inline-images\";s:8:\"max_size\";s:0:\"\";s:14:\"max_dimensions\";a:2:{s:5:\"width\";i:0;s:6:\"height\";i:0;}}}',-1,1578481192.650,1,'','0'),('editor.editor.full_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"dd4735d4-3a13-4997-8b34-88cfc06ff2f3\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"filter.format.full_html\";}s:6:\"module\";a:1:{i:0;s:8:\"ckeditor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"967ijj7p6i7rwrYl7r08WQFeCY_c23YAh0h8u-w_CXM\";}s:6:\"format\";s:9:\"full_html\";s:6:\"editor\";s:8:\"ckeditor\";s:8:\"settings\";a:2:{s:7:\"toolbar\";a:1:{s:4:\"rows\";a:1:{i:0;a:7:{i:0;a:2:{s:4:\"name\";s:7:\"Actions\";s:5:\"items\";a:6:{i:0;s:4:\"Undo\";i:1;s:4:\"Redo\";i:2;s:3:\"Cut\";i:3;s:5:\"Paste\";i:4;s:4:\"Copy\";i:5;s:9:\"PasteText\";}}i:1;a:2:{s:4:\"name\";s:10:\"Formatting\";s:5:\"items\";a:11:{i:0;s:11:\"JustifyLeft\";i:1;s:13:\"JustifyCenter\";i:2;s:12:\"JustifyRight\";i:3;s:12:\"JustifyBlock\";i:4;s:4:\"Bold\";i:5;s:6:\"Italic\";i:6;s:6:\"Strike\";i:7;s:11:\"Superscript\";i:8;s:9:\"Subscript\";i:9;s:1:\"-\";i:10;s:12:\"RemoveFormat\";}}i:2;a:2:{s:4:\"name\";s:7:\"Linking\";s:5:\"items\";a:2:{i:0;s:10:\"DrupalLink\";i:1;s:12:\"DrupalUnlink\";}}i:3;a:2:{s:4:\"name\";s:5:\"Lists\";s:5:\"items\";a:2:{i:0;s:12:\"BulletedList\";i:1;s:12:\"NumberedList\";}}i:4;a:2:{s:4:\"name\";s:5:\"Media\";s:5:\"items\";a:5:{i:0;s:10:\"Blockquote\";i:1;s:11:\"DrupalImage\";i:2;s:5:\"Table\";i:3;s:14:\"HorizontalRule\";i:4;s:7:\"Youtube\";}}i:5;a:2:{s:4:\"name\";s:16:\"Block Formatting\";s:5:\"items\";a:1:{i:0;s:6:\"Format\";}}i:6;a:2:{s:4:\"name\";s:5:\"Tools\";s:5:\"items\";a:2:{i:0;s:10:\"ShowBlocks\";i:1;s:6:\"Source\";}}}}}s:7:\"plugins\";a:2:{s:11:\"stylescombo\";a:1:{s:6:\"styles\";s:0:\"\";}s:8:\"language\";a:1:{s:13:\"language_list\";s:2:\"un\";}}}s:12:\"image_upload\";a:5:{s:6:\"status\";b:1;s:6:\"scheme\";s:6:\"public\";s:9:\"directory\";s:13:\"inline-images\";s:8:\"max_size\";s:0:\"\";s:14:\"max_dimensions\";a:2:{s:5:\"width\";N;s:6:\"height\";N;}}}',-1,1578481192.650,1,'','0'),('editor.editor.pure_html',_binary 'b:0;',-1,1579254251.921,1,'','0'),('editor.editor.restricted_html',_binary 'b:0;',-1,1579254251.921,1,'','0'),('eu_cookie_compliance.settings',_binary 'a:58:{s:15:\"cookie_lifetime\";i:100;s:6:\"domain\";s:0:\"\";s:14:\"domains_option\";i:1;s:12:\"domains_list\";s:0:\"\";s:7:\"eu_only\";N;s:10:\"eu_only_js\";N;s:13:\"exclude_paths\";s:58:\"/admin\r\n/admin/*\r\n/batch\r\n/node/add*\r\n/node/*/*\r\n/user/*/*\";s:19:\"exclude_admin_theme\";b:0;s:8:\"langcode\";s:5:\"pt-pt\";s:12:\"popup_agreed\";a:2:{s:5:\"value\";s:108:\"<h2>Thank you for accepting cookies</h2><p>You can now hide this message or find out more about cookies.</p>\";s:6:\"format\";s:15:\"restricted_html\";}s:26:\"popup_agree_button_message\";s:13:\"Ok, continuar\";s:20:\"popup_agreed_enabled\";b:0;s:12:\"popup_bg_hex\";s:6:\"1f3e75\";s:27:\"popup_clicking_confirmation\";b:0;s:28:\"popup_scrolling_confirmation\";b:0;s:11:\"popup_delay\";i:1000;s:20:\"show_disagree_button\";b:1;s:29:\"popup_disagree_button_message\";s:18:\"Mais informações\";s:13:\"popup_enabled\";b:1;s:30:\"popup_find_more_button_message\";s:18:\"Mais informações\";s:12:\"popup_height\";N;s:17:\"popup_hide_agreed\";b:0;s:25:\"popup_hide_button_message\";s:4:\"Hide\";s:10:\"popup_info\";a:2:{s:5:\"value\";s:101:\"<h2>Este site utiliza cookies.</h2><p> Ao navegar no site estará a consentir a sua utilização.</p>\";s:6:\"format\";s:15:\"restricted_html\";}s:17:\"mobile_popup_info\";a:2:{s:5:\"value\";s:0:\"\";s:6:\"format\";s:10:\"basic_html\";}s:19:\"popup_info_template\";s:3:\"new\";s:17:\"mobile_breakpoint\";i:768;s:10:\"popup_link\";s:8:\"/node/13\";s:21:\"popup_link_new_window\";b:1;s:14:\"popup_position\";b:0;s:18:\"fixed_top_position\";b:1;s:14:\"popup_text_hex\";s:6:\"ffffff\";s:11:\"popup_width\";s:4:\"100%\";s:12:\"use_bare_css\";b:0;s:26:\"disagree_do_not_show_popup\";b:0;s:11:\"reload_page\";b:0;s:11:\"cookie_name\";s:0:\"\";s:13:\"exclude_uid_1\";b:0;s:33:\"better_support_for_screen_readers\";b:0;s:18:\"use_mobile_message\";b:0;s:6:\"method\";s:6:\"opt_in\";s:21:\"disagree_button_label\";s:11:\"Não aceito\";s:20:\"disabled_javascripts\";s:0:\"\";s:19:\"whitelisted_cookies\";s:0:\"\";s:22:\"consent_storage_method\";s:12:\"do_not_store\";s:16:\"withdraw_message\";a:2:{s:5:\"value\";s:125:\"<h2>We use cookies on this site to enhance your user experience</h2><p>You have given your consent for us to set cookies.</p>\";s:6:\"format\";s:15:\"restricted_html\";}s:28:\"withdraw_action_button_label\";s:16:\"Withdraw consent\";s:25:\"withdraw_tab_button_label\";s:16:\"Privacy settings\";s:16:\"withdraw_enabled\";b:0;s:17:\"cookie_categories\";s:0:\"\";s:30:\"enable_save_preferences_button\";b:1;s:29:\"save_preferences_button_label\";s:16:\"Save preferences\";s:34:\"accept_all_categories_button_label\";s:18:\"Accept all cookies\";s:25:\"fix_first_cookie_category\";b:1;s:32:\"select_all_categories_by_default\";b:0;s:29:\"withdraw_button_on_info_popup\";b:0;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AiM4hI1afDR1mudSs5v2hwDmYDtq5-Nrf8HoxvCakR0\";}s:14:\"cookie_session\";i:0;}',-1,1578481107.753,1,'','0'),('field.field.block_content.basic.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"d8fede68-d5ef-402a-bd3b-2a54ebe2acba\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:24:\"block_content.type.basic\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"R__6wc-rMfFMO8d7jcgqnqiA92j8spKhcc5MiqecrMc\";}s:2:\"id\";s:24:\"block_content.basic.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:5:\"basic\";s:5:\"label\";s:5:\"Corpo\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"display_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1578481107.387,1,'','0'),('field.field.comment.comment.comment_body',_binary 'a:17:{s:4:\"uuid\";s:36:\"05f1ffc4-da50-43d7-8367-3c71f2b10a32\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:20:\"comment.type.comment\";i:1;s:34:\"field.storage.comment.comment_body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs\";}s:2:\"id\";s:28:\"comment.comment.comment_body\";s:10:\"field_name\";s:12:\"comment_body\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";s:7:\"comment\";s:5:\"label\";s:8:\"Comentar\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1578481107.395,1,'','0'),('field.field.node.equipa.field_descricao',_binary 'a:16:{s:4:\"uuid\";s:36:\"435b264b-8e69-4317-a191-2d4f9576f364\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.node.field_descricao\";i:1;s:16:\"node.type.equipa\";}}s:2:\"id\";s:27:\"node.equipa.field_descricao\";s:10:\"field_name\";s:15:\"field_descricao\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:6:\"equipa\";s:5:\"label\";s:11:\"Descrição\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1578481107.417,1,'','0'),('field.field.node.equipa.field_foto',_binary 'a:16:{s:4:\"uuid\";s:36:\"1d16e906-bc86-4e08-8c97-a6a0919cc2c2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:29:\"field.storage.node.field_foto\";i:1;s:16:\"node.type.equipa\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:22:\"node.equipa.field_foto\";s:10:\"field_name\";s:10:\"field_foto\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:6:\"equipa\";s:5:\"label\";s:4:\"Foto\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:1;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:36:\"88e87318-43ce-42d8-92ad-5128858fc3d3\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";i:435;s:6:\"height\";i:580;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.418,1,'','0'),('field.field.node.noticias.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"a9715380-1758-44a8-a74d-4c61cd409f77\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:18:\"node.type.noticias\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:18:\"node.noticias.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"noticias\";s:5:\"label\";s:5:\"Texto\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"display_summary\";b:1;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1578481107.406,1,'','0'),('field.field.node.noticias.field_imagem_slideshow',_binary 'a:16:{s:4:\"uuid\";s:36:\"c398c284-2b12-47fc-9e03-d1574513b5dd\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.node.field_imagem_slideshow\";i:1;s:18:\"node.type.noticias\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:36:\"node.noticias.field_imagem_slideshow\";s:10:\"field_name\";s:22:\"field_imagem_slideshow\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"noticias\";s:5:\"label\";s:7:\"Imagens\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:1;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.430,1,'','0'),('field.field.node.page.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"cf725370-2649-4b07-952d-e72e7dc639fd\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rUop-8b6hvxxDYbv-KobTfNIBNbPY9qOPl8f6kBNSpw\";}s:2:\"id\";s:14:\"node.page.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:5:\"Corpo\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"display_summary\";b:1;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1578481107.403,1,'','0'),('field.field.node.page.field_imagem',_binary 'a:16:{s:4:\"uuid\";s:36:\"e40c2c55-388a-48ea-a0f6-1f91f6ad05b4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"field.storage.node.field_imagem\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:22:\"node.page.field_imagem\";s:10:\"field_name\";s:12:\"field_imagem\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:6:\"Imagem\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.444,1,'','0'),('field.field.node.parceria.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"f731cac4-8f18-46f7-b709-0bb505d5d46d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:18:\"node.type.parceria\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:18:\"node.parceria.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"parceria\";s:5:\"label\";s:11:\"Descrição\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"display_summary\";b:1;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1578481107.409,1,'','0'),('field.field.node.parceria.field_imagem',_binary 'a:16:{s:4:\"uuid\";s:36:\"2da6d30e-8de2-4ffa-9a0f-33ce0788a179\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"field.storage.node.field_imagem\";i:1;s:18:\"node.type.parceria\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:26:\"node.parceria.field_imagem\";s:10:\"field_name\";s:12:\"field_imagem\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"parceria\";s:5:\"label\";s:6:\"Imagem\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:1;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.454,1,'','0'),('field.field.node.parceria.field_ligacao',_binary 'a:16:{s:4:\"uuid\";s:36:\"c88f9982-f22d-4d72-95d9-83080d7a4901\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"field.storage.node.field_ligacao\";i:1;s:18:\"node.type.parceria\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:2:\"id\";s:27:\"node.parceria.field_ligacao\";s:10:\"field_name\";s:13:\"field_ligacao\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:8:\"parceria\";s:5:\"label\";s:9:\"Ligação\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"link_type\";i:16;s:5:\"title\";i:1;}s:10:\"field_type\";s:4:\"link\";}',-1,1578481107.454,1,'','0'),('field.field.node.slideshow.field_botao',_binary 'a:16:{s:4:\"uuid\";s:36:\"bc87ee34-0d36-4ab7-b326-94983cfde7d6\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"field.storage.node.field_botao\";i:1;s:19:\"node.type.slideshow\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:2:\"id\";s:26:\"node.slideshow.field_botao\";s:10:\"field_name\";s:11:\"field_botao\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"slideshow\";s:5:\"label\";s:6:\"Botão\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"link_type\";i:17;s:5:\"title\";i:2;}s:10:\"field_type\";s:4:\"link\";}',-1,1578481107.467,1,'','0'),('field.field.node.slideshow.field_imagem_slideshow',_binary 'a:16:{s:4:\"uuid\";s:36:\"95a276ac-6660-429f-b152-06f99eb3a61c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.node.field_imagem_slideshow\";i:1;s:19:\"node.type.slideshow\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:37:\"node.slideshow.field_imagem_slideshow\";s:10:\"field_name\";s:22:\"field_imagem_slideshow\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"slideshow\";s:5:\"label\";s:6:\"Imagem\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:1;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.467,1,'','0'),('field.field.node.slideshow.field_text',_binary 'a:16:{s:4:\"uuid\";s:36:\"18df14ff-97ad-4aba-b0c8-c21d57c8c4b1\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:29:\"field.storage.node.field_text\";i:1;s:19:\"node.type.slideshow\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:25:\"node.slideshow.field_text\";s:10:\"field_name\";s:10:\"field_text\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"slideshow\";s:5:\"label\";s:5:\"Texto\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1578481107.467,1,'','0'),('field.field.taxonomy_term.parcerias.field_ligacao',_binary 'a:16:{s:4:\"uuid\";s:36:\"6b96ad2e-3771-4da2-9ac8-61c98ff7f99f\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.taxonomy_term.field_ligacao\";i:1;s:29:\"taxonomy.vocabulary.parcerias\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:2:\"id\";s:37:\"taxonomy_term.parcerias.field_ligacao\";s:10:\"field_name\";s:13:\"field_ligacao\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:9:\"parcerias\";s:5:\"label\";s:9:\"Ligação\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"link_type\";i:17;s:5:\"title\";i:0;}s:10:\"field_type\";s:4:\"link\";}',-1,1578481107.488,1,'','0'),('field.field.taxonomy_term.parcerias.field_logotipo',_binary 'a:16:{s:4:\"uuid\";s:36:\"4469393e-3701-47f7-8c2d-1446103c16ac\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:42:\"field.storage.taxonomy_term.field_logotipo\";i:1;s:29:\"taxonomy.vocabulary.parcerias\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:38:\"taxonomy_term.parcerias.field_logotipo\";s:10:\"field_name\";s:14:\"field_logotipo\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:9:\"parcerias\";s:5:\"label\";s:8:\"Logotipo\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.488,1,'','0'),('field.field.taxonomy_term.servicos.field_icon_servico',_binary 'a:16:{s:4:\"uuid\";s:36:\"d132f346-ace8-4074-859f-a9ada98bad03\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"field.storage.taxonomy_term.field_icon_servico\";i:1;s:28:\"taxonomy.vocabulary.servicos\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:41:\"taxonomy_term.servicos.field_icon_servico\";s:10:\"field_name\";s:18:\"field_icon_servico\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:6:\"bundle\";s:8:\"servicos\";s:5:\"label\";s:13:\"Icon serviço\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.482,1,'','0'),('field.field.user.user.user_picture',_binary 'a:17:{s:4:\"uuid\";s:36:\"b513547c-587b-42f3-b9e9-b12cebc703f7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:31:\"field.storage.user.user_picture\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Iiq0AttdhgbebJwabSFwQQ1ORn64GoGz0xSZ_eyCJ8A\";}s:2:\"id\";s:22:\"user.user.user_picture\";s:10:\"field_name\";s:12:\"user_picture\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:5:\"label\";s:7:\"Retrato\";s:11:\"description\";s:28:\"A sua face ou imagem virtual\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:14:\"file_directory\";s:40:\"pictures/[date:custom:Y]-[date:custom:m]\";s:12:\"max_filesize\";s:0:\"\";s:9:\"alt_field\";b:0;s:11:\"title_field\";b:0;s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:18:\"alt_field_required\";b:0;s:20:\"title_field_required\";b:0;s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:5:\"image\";}',-1,1578481107.136,1,'','0'),('field.settings',_binary 'a:3:{s:16:\"purge_batch_size\";i:50;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578486712.456,1,'','0'),('field.storage.block_content.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"76048c52-e0f9-4076-8802-cd60e2357021\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc\";}s:2:\"id\";s:18:\"block_content.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:17:\"text_with_summary\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}',-1,1578481107.252,1,'','0'),('field.storage.comment.comment_body',_binary 'a:17:{s:4:\"uuid\";s:36:\"2e49353e-ee8f-4f19-8318-6dc7aedc2ef3\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"comment\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw\";}s:2:\"id\";s:20:\"comment.comment_body\";s:10:\"field_name\";s:12:\"comment_body\";s:11:\"entity_type\";s:7:\"comment\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}',-1,1578481107.260,1,'','0'),('field.storage.node.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"51108ff6-aa55-407d-8e42-4c7ff9791b79\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY\";}s:2:\"id\";s:9:\"node.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:17:\"text_with_summary\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_botao',_binary 'a:16:{s:4:\"uuid\";s:36:\"aaabfbdf-8fd6-4a80-9da9-a5917ccec914\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:4:\"node\";}}s:2:\"id\";s:16:\"node.field_botao\";s:10:\"field_name\";s:11:\"field_botao\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_descricao',_binary 'a:16:{s:4:\"uuid\";s:36:\"c2837b7d-fe12-4f6f-a880-e9bddf6687a3\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:20:\"node.field_descricao\";s:10:\"field_name\";s:15:\"field_descricao\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_foto',_binary 'a:16:{s:4:\"uuid\";s:36:\"fc6e1c2e-9815-4970-bdae-8e99b9a3c12d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"node\";}}s:2:\"id\";s:15:\"node.field_foto\";s:10:\"field_name\";s:10:\"field_foto\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_imagem',_binary 'a:16:{s:4:\"uuid\";s:36:\"da5dc94e-9c2e-47cf-ba39-c9dfede44950\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"node\";}}s:2:\"id\";s:17:\"node.field_imagem\";s:10:\"field_name\";s:12:\"field_imagem\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_imagem_slideshow',_binary 'a:16:{s:4:\"uuid\";s:36:\"8f120843-7856-45ed-b6cf-7b3c76bdf438\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"node\";}}s:2:\"id\";s:27:\"node.field_imagem_slideshow\";s:10:\"field_name\";s:22:\"field_imagem_slideshow\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_ligacao',_binary 'a:16:{s:4:\"uuid\";s:36:\"9d764835-c655-4c59-b9d2-d25dd3ca4f8b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:4:\"node\";}}s:2:\"id\";s:18:\"node.field_ligacao\";s:10:\"field_name\";s:13:\"field_ligacao\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.node.field_text',_binary 'a:16:{s:4:\"uuid\";s:36:\"ff139954-3d51-435d-bd91-bf77a4e85e7d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"text\";}}s:2:\"id\";s:15:\"node.field_text\";s:10:\"field_name\";s:10:\"field_text\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.352,1,'','0'),('field.storage.taxonomy_term.field_icon_servico',_binary 'a:16:{s:4:\"uuid\";s:36:\"bac25d63-1129-4c07-84d9-763ad10ab074\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:8:\"taxonomy\";}}s:2:\"id\";s:32:\"taxonomy_term.field_icon_servico\";s:10:\"field_name\";s:18:\"field_icon_servico\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.374,1,'','0'),('field.storage.taxonomy_term.field_ligacao',_binary 'a:16:{s:4:\"uuid\";s:36:\"492b917b-e05a-494a-82d3-d7a9226fd0d9\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:8:\"taxonomy\";}}s:2:\"id\";s:27:\"taxonomy_term.field_ligacao\";s:10:\"field_name\";s:13:\"field_ligacao\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.374,1,'','0'),('field.storage.taxonomy_term.field_logotipo',_binary 'a:16:{s:4:\"uuid\";s:36:\"28e448ba-950c-456c-bf91-6b7bd184fc4b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:8:\"taxonomy\";}}s:2:\"id\";s:28:\"taxonomy_term.field_logotipo\";s:10:\"field_name\";s:14:\"field_logotipo\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.374,1,'','0'),('field.storage.user.user_picture',_binary 'a:17:{s:4:\"uuid\";s:36:\"91335614-cde7-46f2-b83d-f3340ad792ce\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6k-VBFilDLuzgSOT-77CFgHFlcd5D-kqRixtH89EShU\";}s:2:\"id\";s:17:\"user.user_picture\";s:10:\"field_name\";s:12:\"user_picture\";s:11:\"entity_type\";s:4:\"user\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1578481107.142,1,'','0'),('file.settings',_binary 'a:5:{s:11:\"description\";a:2:{s:4:\"type\";s:9:\"textfield\";s:6:\"length\";i:128;}s:4:\"icon\";a:1:{s:9:\"directory\";s:23:\"core/modules/file/icons\";}s:35:\"make_unused_managed_files_temporary\";b:0;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0aMkoXYnax5_tHI9C9zHs-K48KJ6K75PHtD9x-0nbgM\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495386.338,1,'','0'),('filter.format.basic_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"cdfa258c-5eb7-45f0-a65d-252dc39afa39\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:6:\"editor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"P8ddpAIKtawJDi5SzOwCzVnnNYqONewSTJ6Xn0dW_aQ\";}s:4:\"name\";s:12:\"HTML Básico\";s:6:\"format\";s:10:\"basic_html\";s:6:\"weight\";i:0;s:7:\"filters\";a:5:{s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:250:\"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <p> <br> <span> <img src alt height width data-entity-type data-entity-uuid data-align data-caption>\";s:16:\"filter_html_help\";b:0;s:20:\"filter_html_nofollow\";b:0;}}s:12:\"filter_align\";a:5:{s:2:\"id\";s:12:\"filter_align\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:7;s:8:\"settings\";a:0:{}}s:14:\"filter_caption\";a:5:{s:2:\"id\";s:14:\"filter_caption\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:8;s:8:\"settings\";a:0:{}}s:24:\"filter_html_image_secure\";a:5:{s:2:\"id\";s:24:\"filter_html_image_secure\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:9;s:8:\"settings\";a:0:{}}s:21:\"editor_file_reference\";a:5:{s:2:\"id\";s:21:\"editor_file_reference\";s:8:\"provider\";s:6:\"editor\";s:6:\"status\";b:1;s:6:\"weight\";i:11;s:8:\"settings\";a:0:{}}}}',-1,1578481111.875,1,'','0'),('filter.format.full_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"5bd7dff9-302a-4697-9a8d-c83bc85d36d7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:6:\"editor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw\";}s:4:\"name\";s:13:\"HTML Completo\";s:6:\"format\";s:9:\"full_html\";s:6:\"weight\";i:2;s:7:\"filters\";a:5:{s:12:\"filter_align\";a:5:{s:2:\"id\";s:12:\"filter_align\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:8;s:8:\"settings\";a:0:{}}s:14:\"filter_caption\";a:5:{s:2:\"id\";s:14:\"filter_caption\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:9;s:8:\"settings\";a:0:{}}s:20:\"filter_htmlcorrector\";a:5:{s:2:\"id\";s:20:\"filter_htmlcorrector\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:10;s:8:\"settings\";a:0:{}}s:21:\"editor_file_reference\";a:5:{s:2:\"id\";s:21:\"editor_file_reference\";s:8:\"provider\";s:6:\"editor\";s:6:\"status\";b:1;s:6:\"weight\";i:11;s:8:\"settings\";a:0:{}}s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:0;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:314:\"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <s> <sup> <sub> <img src alt data-entity-type data-entity-uuid data-align data-caption> <table> <caption> <tbody> <thead> <tfoot> <th> <td> <tr> <hr> <p> <h1> <pre>\";s:16:\"filter_html_help\";b:1;s:20:\"filter_html_nofollow\";b:0;}}}}',-1,1578481186.204,1,'','0'),('filter.format.plain_text',_binary 'a:9:{s:4:\"uuid\";s:36:\"6dc66197-1797-4fac-8a57-caa636e726d9\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ\";}s:4:\"name\";s:13:\"Texto simples\";s:6:\"format\";s:10:\"plain_text\";s:6:\"weight\";i:10;s:7:\"filters\";a:3:{s:18:\"filter_html_escape\";a:5:{s:2:\"id\";s:18:\"filter_html_escape\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:0:{}}s:10:\"filter_url\";a:5:{s:2:\"id\";s:10:\"filter_url\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:17:\"filter_url_length\";i:72;}}s:12:\"filter_autop\";a:5:{s:2:\"id\";s:12:\"filter_autop\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}}}}',-1,1578481192.753,1,'','0'),('filter.format.pure_html',_binary 'a:8:{s:4:\"uuid\";s:36:\"fd7cf5dc-c8a1-4deb-944b-9d430b6c4064\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:4:\"name\";s:9:\"Pure HTML\";s:6:\"format\";s:9:\"pure_html\";s:6:\"weight\";i:0;s:7:\"filters\";a:0:{}}',-1,1578481192.753,1,'','0'),('filter.format.restricted_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"8aab6712-af06-4849-9afe-195d4eabd852\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI\";}s:4:\"name\";s:13:\"HTML Restrito\";s:6:\"format\";s:15:\"restricted_html\";s:6:\"weight\";i:1;s:7:\"filters\";a:3:{s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:149:\"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>\";s:16:\"filter_html_help\";b:1;s:20:\"filter_html_nofollow\";b:0;}}s:12:\"filter_autop\";a:5:{s:2:\"id\";s:12:\"filter_autop\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}}s:10:\"filter_url\";a:5:{s:2:\"id\";s:10:\"filter_url\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:17:\"filter_url_length\";i:72;}}}}',-1,1578481110.253,1,'','0'),('filter.settings',_binary 'a:4:{s:15:\"fallback_format\";s:10:\"plain_text\";s:27:\"always_show_fallback_choice\";b:0;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481192.804,1,'','0'),('form_placeholder.settings',_binary 'a:5:{s:18:\"included_selectors\";s:0:\"\";s:18:\"excluded_selectors\";s:0:\"\";s:18:\"required_indicator\";s:6:\"append\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fvvuim-Xfi2KRJiSVE9-Lj7cD6aDfjQxQ3Xnoe0TG18\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495006.261,1,'','0'),('forum.settings',_binary 'b:0;',-1,1579197928.342,1,'','0'),('honeypot.settings',_binary 'a:9:{s:17:\"unprotected_forms\";a:5:{i:0;s:15:\"user_login_form\";i:1;s:11:\"search_form\";i:2;s:17:\"search_block_form\";i:3;s:18:\"views_exposed_form\";i:4;s:22:\"honeypot_settings_form\";}s:17:\"protect_all_forms\";b:1;s:3:\"log\";b:0;s:12:\"element_name\";s:4:\"city\";s:10:\"time_limit\";i:5;s:6:\"expire\";i:300;s:13:\"form_settings\";a:10:{s:18:\"user_register_form\";b:0;s:9:\"user_pass\";b:0;s:34:\"contact_message_fale_connosco_form\";b:0;s:29:\"contact_message_personal_form\";b:0;s:16:\"node_equipa_form\";b:0;s:18:\"node_noticias_form\";b:0;s:14:\"node_page_form\";b:0;s:18:\"node_parceria_form\";b:0;s:19:\"node_slideshow_form\";b:0;s:20:\"comment_comment_form\";b:0;}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9bVDfWSa_In6VzTXmy04jJ_3ZQobihKjO9isuuUCPaw\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578486712.476,1,'','0'),('image.settings',_binary 'a:5:{s:13:\"preview_image\";s:29:\"core/modules/image/sample.png\";s:26:\"allow_insecure_derivatives\";b:0;s:20:\"suppress_itok_output\";b:0;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481112.201,1,'','0'),('image.style.crop_thumbnail',_binary 'a:8:{s:4:\"uuid\";s:36:\"f88f58c0-15fa-4d42-952c-5dd0f01299ca\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"N1S0PHZeyxfFqgzB-sDeGPaxi0dDOL8NUiP_d6WXSV0\";}s:4:\"name\";s:14:\"crop_thumbnail\";s:5:\"label\";s:14:\"Crop thumbnail\";s:7:\"effects\";a:1:{s:36:\"8fc26706-68dc-4eb7-8121-33e3936ed55f\";a:4:{s:4:\"uuid\";s:36:\"8fc26706-68dc-4eb7-8121-33e3936ed55f\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:400;s:6:\"height\";N;s:7:\"upscale\";b:0;}}}}',-1,1578481110.140,1,'','0'),('image.style.horizontal',_binary 'a:7:{s:4:\"uuid\";s:36:\"d2a15c5d-126c-49e2-bf94-ac333273acdd\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:14:\"crop.type.wide\";}s:6:\"module\";a:1:{i:0;s:4:\"crop\";}}s:4:\"name\";s:10:\"horizontal\";s:5:\"label\";s:4:\"Wide\";s:7:\"effects\";a:1:{s:36:\"315a7453-d19f-466d-8eaf-4077f940b784\";a:4:{s:4:\"uuid\";s:36:\"315a7453-d19f-466d-8eaf-4077f940b784\";s:2:\"id\";s:9:\"crop_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:1:{s:9:\"crop_type\";s:4:\"wide\";}}}}',-1,1578481110.140,1,'','0'),('image.style.horizontal_1',_binary 'a:7:{s:4:\"uuid\";s:36:\"fb2d588e-4de4-49df-8d0f-1196e880390b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:20:\"crop.type.horizontal\";}s:6:\"module\";a:1:{i:0;s:4:\"crop\";}}s:4:\"name\";s:12:\"horizontal_1\";s:5:\"label\";s:10:\"Horizontal\";s:7:\"effects\";a:1:{s:36:\"35c46f88-4b85-4a43-ac38-42ced03be273\";a:4:{s:4:\"uuid\";s:36:\"35c46f88-4b85-4a43-ac38-42ced03be273\";s:2:\"id\";s:9:\"crop_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:1:{s:9:\"crop_type\";s:10:\"horizontal\";}}}}',-1,1578481110.140,1,'','0'),('image.style.large',_binary 'a:8:{s:4:\"uuid\";s:36:\"2a64df3b-9ddb-4fb3-99a3-73a557948438\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M\";}s:4:\"name\";s:5:\"large\";s:5:\"label\";s:17:\"Grande (480×480)\";s:7:\"effects\";a:1:{s:36:\"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d\";a:4:{s:4:\"uuid\";s:36:\"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:7:\"upscale\";b:0;}}}}',-1,1578481110.140,1,'','0'),('image.style.medium',_binary 'a:8:{s:4:\"uuid\";s:36:\"3cc8bf32-3f8b-486d-b6af-d6e43c80a8a4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0\";}s:4:\"name\";s:6:\"medium\";s:5:\"label\";s:17:\"Médio (220×220)\";s:7:\"effects\";a:1:{s:36:\"bddf0d06-42f9-4c75-a700-a33cafa25ea0\";a:4:{s:4:\"uuid\";s:36:\"bddf0d06-42f9-4c75-a700-a33cafa25ea0\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:220;s:6:\"height\";i:220;s:7:\"upscale\";b:0;}}}}',-1,1578481110.140,1,'','0'),('image.style.team',_binary 'a:7:{s:4:\"uuid\";s:36:\"5c327e54-f745-45c9-bef6-2cd74ec44de5\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"crop.type.vertical_team\";}s:6:\"module\";a:1:{i:0;s:4:\"crop\";}}s:4:\"name\";s:4:\"team\";s:5:\"label\";s:4:\"Team\";s:7:\"effects\";a:1:{s:36:\"9e348002-5267-4b98-a684-23cf6e77a863\";a:4:{s:4:\"uuid\";s:36:\"9e348002-5267-4b98-a684-23cf6e77a863\";s:2:\"id\";s:9:\"crop_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:1:{s:9:\"crop_type\";s:13:\"vertical_team\";}}}}',-1,1578481110.140,1,'','0'),('image.style.thumbnail',_binary 'a:8:{s:4:\"uuid\";s:36:\"47029b4d-936a-4a23-b6a6-ab179d8a96c8\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0\";}s:4:\"name\";s:9:\"thumbnail\";s:5:\"label\";s:20:\"Miniatura (100×100)\";s:7:\"effects\";a:1:{s:36:\"1cfec298-8620-4749-b100-ccb6c4500779\";a:4:{s:4:\"uuid\";s:36:\"1cfec298-8620-4749-b100-ccb6c4500779\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:7:\"upscale\";b:0;}}}}',-1,1578481110.140,1,'','0'),('image.style.vertical',_binary 'a:7:{s:4:\"uuid\";s:36:\"2f26f728-2ebd-4ff4-b82e-85ababb2ff35\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:18:\"crop.type.vertical\";}s:6:\"module\";a:1:{i:0;s:4:\"crop\";}}s:4:\"name\";s:8:\"vertical\";s:5:\"label\";s:8:\"Vertical\";s:7:\"effects\";a:1:{s:36:\"0e6cd9e2-f058-423d-bcdb-d7e1540e7b12\";a:4:{s:4:\"uuid\";s:36:\"0e6cd9e2-f058-423d-bcdb-d7e1540e7b12\";s:2:\"id\";s:9:\"crop_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:1:{s:9:\"crop_type\";s:8:\"vertical\";}}}}',-1,1578481110.140,1,'','0'),('image_widget_crop.settings',_binary 'a:3:{s:8:\"settings\";a:8:{s:11:\"library_url\";s:0:\"\";s:7:\"css_url\";s:0:\"\";s:24:\"crop_preview_image_style\";s:14:\"crop_thumbnail\";s:9:\"crop_list\";a:1:{s:4:\"wide\";s:4:\"wide\";}s:19:\"crop_types_required\";a:1:{s:4:\"wide\";s:4:\"wide\";}s:20:\"warn_multiple_usages\";b:1;s:17:\"show_default_crop\";b:1;s:14:\"show_crop_area\";b:0;}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JTiHOl3PIo9Nyv7j53xwY5OwbwJWwCItksgv_X-NcbE\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495060.780,1,'','0'),('language.content_settings.crop.wide',_binary 'b:0;',-1,1578495123.663,1,'','0'),('language.content_settings.file.file',_binary 'b:0;',-1,1578495088.238,1,'','0'),('language.content_settings.node.slideshow',_binary 'a:9:{s:4:\"uuid\";s:36:\"d26b45ed-4384-4f2e-af5a-a604a3663518\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:19:\"node.type.slideshow\";}}s:2:\"id\";s:14:\"node.slideshow\";s:21:\"target_entity_type_id\";s:4:\"node\";s:13:\"target_bundle\";s:9:\"slideshow\";s:16:\"default_langcode\";s:12:\"site_default\";s:18:\"language_alterable\";b:0;}',-1,1578495069.592,1,'','0'),('language.content_settings.taxonomy_term.servicos',_binary 'a:9:{s:4:\"uuid\";s:36:\"a4a6f5f1-6f03-4e96-8f81-6c46cce59152\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:28:\"taxonomy.vocabulary.servicos\";}}s:2:\"id\";s:22:\"taxonomy_term.servicos\";s:21:\"target_entity_type_id\";s:13:\"taxonomy_term\";s:13:\"target_bundle\";s:8:\"servicos\";s:16:\"default_langcode\";s:12:\"site_default\";s:18:\"language_alterable\";b:0;}',-1,1579197872.888,1,'','0'),('language.entity.pt-pt',_binary 'a:9:{s:4:\"uuid\";s:36:\"06ecc751-791a-477a-a084-c04a815b93a4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:5:\"pt-pt\";s:5:\"label\";s:20:\"Portuguese, Portugal\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:0;s:6:\"locked\";b:0;}',-1,1578481107.147,1,'','0'),('language.entity.und',_binary 'a:10:{s:4:\"uuid\";s:36:\"834562c7-70d9-4751-993b-aa9291d4040a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eNX6lLCKDaY83nCMh20My---y03KbiFlv802DKCCpvg\";}s:2:\"id\";s:3:\"und\";s:5:\"label\";s:17:\"Não especificado\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:2;s:6:\"locked\";b:1;}',-1,1578481107.147,1,'','0'),('language.entity.zxx',_binary 'a:10:{s:4:\"uuid\";s:36:\"33e1d15a-dd21-498b-901f-9db8f9e8e83a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"35CefWbnzaiytcg3acexxz_GTvuwIjYd_ZTcmmR-tXA\";}s:2:\"id\";s:3:\"zxx\";s:5:\"label\";s:15:\"Não aplicável\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:3;s:6:\"locked\";b:1;}',-1,1578481107.147,1,'','0'),('language.mappings',_binary 'a:3:{s:3:\"map\";a:10:{s:2:\"no\";s:2:\"nb\";s:2:\"pt\";s:5:\"pt-pt\";s:2:\"zh\";s:7:\"zh-hans\";s:5:\"zh-tw\";s:7:\"zh-hant\";s:5:\"zh-hk\";s:7:\"zh-hant\";s:5:\"zh-mo\";s:7:\"zh-hant\";s:6:\"zh-cht\";s:7:\"zh-hant\";s:5:\"zh-cn\";s:7:\"zh-hans\";s:5:\"zh-sg\";s:7:\"zh-hans\";s:6:\"zh-chs\";s:7:\"zh-hans\";}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EMWe7Yu4Q5eD-NUfNuQAWGBvYUNZPIinztEtONSmsDc\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481192.857,1,'','0'),('language.pt-pt:automated_cron.settings',_binary 'b:0;',-1,1578481108.762,1,'','0'),('language.pt-pt:block.block.backoffice',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block.block.backofficeblock',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block.block.bartik_account_menu',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_branding',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_breadcrumbs',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_content',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_footer',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_local_actions',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_local_tasks',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_main_menu',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_messages',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_page_title',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_powered',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_search',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bartik_tools',_binary 'b:0;',-1,1578481106.563,1,'','0'),('language.pt-pt:block.block.bootstrap_account_menu',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_branding',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_breadcrumbs',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_content',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_footer',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_local_actions',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_local_tasks',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_main_menu',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_messages',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_page_title',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_powered',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_search',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.bootstrap_tools',_binary 'b:0;',-1,1578481106.585,1,'','0'),('language.pt-pt:block.block.clidentcastelo_content',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.clidentcastelo_local_actions',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.clidentcastelo_main_menu',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.clidentcastelo_messages',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.clidentcastelo_page_title',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.mapblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.newsblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.phonetopblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.scheduletopblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.servicesblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.seven_breadcrumbs',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.seven_content',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.seven_local_actions',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.seven_messages',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.seven_page_title',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.seven_primary_local_tasks',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.seven_secondary_local_tasks',_binary 'b:0;',-1,1578481106.569,1,'','0'),('language.pt-pt:block.block.sitebranding',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block.block.tabs',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.talkcontactblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.talktousblock',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__node_auxiliar_block_1',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__node_auxiliar_block_2',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__noticias_block_1',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__noticias_block_2',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__parcerias_block_1',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__servicos_block_2',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__servicos_block_3',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__slideshow_block_1',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.views_block__team_block_1',_binary 'b:0;',-1,1578481106.600,1,'','0'),('language.pt-pt:block.block.yorkshire_content',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block.block.yorkshire_local_actions',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block.block.yorkshire_page_title',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block.block.yorkshire_tabs',_binary 'b:0;',-1,1578481106.620,1,'','0'),('language.pt-pt:block_content.type.basic',_binary 'b:0;',-1,1578481107.059,1,'','0'),('language.pt-pt:bootstrap.settings',_binary 'b:0;',-1,1578481109.073,1,'','0'),('language.pt-pt:clidentcastelo.settings',_binary 'b:0;',-1,1578481109.093,1,'','0'),('language.pt-pt:color.theme.bootstrap',_binary 'b:0;',-1,1578481111.625,1,'','0'),('language.pt-pt:color.theme.classy',_binary 'b:0;',-1,1578495056.600,1,'','0'),('language.pt-pt:color.theme.clidentcastelo',_binary 'b:0;',-1,1578481112.236,1,'','0'),('language.pt-pt:color.theme.seven',_binary 'b:0;',-1,1579254129.968,1,'','0'),('language.pt-pt:color.theme.yorkshire',_binary 'b:0;',-1,1578495056.609,1,'','0'),('language.pt-pt:comment.type.comment',_binary 'b:0;',-1,1578481107.065,1,'','0'),('language.pt-pt:contact.form.fale_connosco',_binary 'b:0;',-1,1578481107.070,1,'','0'),('language.pt-pt:contact.form.personal',_binary 'b:0;',-1,1578481107.070,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.changed',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.created',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.default_langcode',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.langcode',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.menu_link',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.metatag',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.nid',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.path',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.promote',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.revision_default',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.revision_log',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.revision_timestamp',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.revision_translation_affected',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.revision_uid',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.status',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.sticky',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.title',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.type',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.uid',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.uuid',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.equipa.vid',_binary 'b:0;',-1,1578481107.415,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.changed',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.created',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.default_langcode',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.langcode',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.menu_link',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.metatag',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.nid',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.path',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.promote',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.revision_default',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.revision_log',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.revision_timestamp',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.revision_translation_affected',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.revision_uid',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.status',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.sticky',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.title',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.type',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.uid',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.uuid',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.noticias.vid',_binary 'b:0;',-1,1578481107.426,1,'','0'),('language.pt-pt:core.base_field_override.node.page.changed',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.created',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.default_langcode',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.langcode',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.menu_link',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.metatag',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.nid',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.path',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.promote',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.revision_default',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.revision_log',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.revision_timestamp',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.revision_translation_affected',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.revision_uid',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.status',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.sticky',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.title',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.type',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.uid',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.uuid',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.page.vid',_binary 'b:0;',-1,1578481107.441,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.changed',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.created',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.default_langcode',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.langcode',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.menu_link',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.metatag',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.nid',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.path',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.promote',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.revision_default',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.revision_log',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.revision_timestamp',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.revision_translation_affected',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.revision_uid',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.status',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.sticky',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.title',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.type',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.uid',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.uuid',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.parceria.vid',_binary 'b:0;',-1,1578481107.452,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.changed',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.created',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.default_langcode',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.langcode',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.menu_link',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.metatag',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.nid',_binary 'b:0;',-1,1578481107.463,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.path',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.promote',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.revision_default',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.revision_log',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.revision_timestamp',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.revision_translation_affected',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.revision_uid',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.status',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.sticky',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.title',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.type',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.uid',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.uuid',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.base_field_override.node.slideshow.vid',_binary 'b:0;',-1,1578481107.464,1,'','0'),('language.pt-pt:core.date_format.fallback',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.date_format.html_date',_binary 'b:0;',-1,1578481109.520,1,'','0'),('language.pt-pt:core.date_format.html_datetime',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.date_format.html_month',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.date_format.html_time',_binary 'b:0;',-1,1578481109.523,1,'','0'),('language.pt-pt:core.date_format.html_week',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.date_format.html_year',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.date_format.html_yearless_date',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.date_format.long',_binary 'b:0;',-1,1578481109.992,1,'','0'),('language.pt-pt:core.date_format.medium',_binary 'b:0;',-1,1578481109.988,1,'','0'),('language.pt-pt:core.date_format.short',_binary 'b:0;',-1,1578481109.986,1,'','0'),('language.pt-pt:core.date_format.simples',_binary 'b:0;',-1,1578481110.005,1,'','0'),('language.pt-pt:core.entity_form_display.node.page.default',_binary 'b:0;',-1,1578495060.241,1,'','0'),('language.pt-pt:core.entity_form_display.node.page.edit',_binary 'b:0;',-1,1578495060.241,1,'','0'),('language.pt-pt:core.entity_form_display.node.slideshow.default',_binary 'b:0;',-1,1578495069.638,1,'','0'),('language.pt-pt:core.entity_form_display.node.slideshow.edit',_binary 'b:0;',-1,1578495310.293,1,'','0'),('language.pt-pt:core.entity_form_display.taxonomy_term.servicos.default',_binary 'b:0;',-1,1579196174.309,1,'','0'),('language.pt-pt:core.entity_form_display.user.user.default',_binary 'b:0;',-1,1578495055.714,1,'','0'),('language.pt-pt:core.entity_form_mode.user.register',_binary 'b:0;',-1,1578481111.181,1,'','0'),('language.pt-pt:core.entity_view_display.node.equipa.default',_binary 'b:0;',-1,1578481552.133,1,'','0'),('language.pt-pt:core.entity_view_display.node.equipa.full',_binary 'b:0;',-1,1580769691.718,1,'','0'),('language.pt-pt:core.entity_view_display.node.equipa.search_index',_binary 'b:0;',-1,1578486712.540,1,'','0'),('language.pt-pt:core.entity_view_display.node.equipa.teaser',_binary 'b:0;',-1,1578481552.133,1,'','0'),('language.pt-pt:core.entity_view_display.node.noticias.default',_binary 'b:0;',-1,1578481566.042,1,'','0'),('language.pt-pt:core.entity_view_display.node.noticias.full',_binary 'b:0;',-1,1578483666.497,1,'','0'),('language.pt-pt:core.entity_view_display.node.noticias.teaser',_binary 'b:0;',-1,1578481566.042,1,'','0'),('language.pt-pt:core.entity_view_display.node.page.default',_binary 'b:0;',-1,1578481111.758,1,'','0'),('language.pt-pt:core.entity_view_display.node.page.full',_binary 'b:0;',-1,1578481111.758,1,'','0'),('language.pt-pt:core.entity_view_display.node.page.search_index',_binary 'b:0;',-1,1578486712.812,1,'','0'),('language.pt-pt:core.entity_view_display.node.page.teaser',_binary 'b:0;',-1,1578481186.249,1,'','0'),('language.pt-pt:core.entity_view_display.node.slideshow.default',_binary 'b:0;',-1,1578481112.135,1,'','0'),('language.pt-pt:core.entity_view_display.node.slideshow.full',_binary 'b:0;',-1,1578495123.864,1,'','0'),('language.pt-pt:core.entity_view_display.taxonomy_term.parcerias.default',_binary 'b:0;',-1,1578481736.264,1,'','0'),('language.pt-pt:core.entity_view_display.taxonomy_term.parcerias.token',_binary 'b:0;',-1,1578481736.264,1,'','0'),('language.pt-pt:core.entity_view_display.taxonomy_term.servicos.default',_binary 'b:0;',-1,1578481112.455,1,'','0'),('language.pt-pt:core.entity_view_display.taxonomy_term.servicos.full',_binary 'b:0;',-1,1578483663.341,1,'','0'),('language.pt-pt:core.entity_view_display.taxonomy_term.servicos.token',_binary 'b:0;',-1,1578481112.455,1,'','0'),('language.pt-pt:core.entity_view_display.user.user.default',_binary 'b:0;',-1,1578481109.356,1,'','0'),('language.pt-pt:core.entity_view_display.user.user.full',_binary 'b:0;',-1,1578481109.356,1,'','0'),('language.pt-pt:core.entity_view_mode.block.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.block_content.full',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.block_content.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.comment.full',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.comment.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.contact_message.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.file.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.menu_link_content.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.node.full',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.node.rss',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.node.search_index',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.node.search_result',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.node.teaser',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.node.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.shortcut.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.taxonomy_term.full',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.taxonomy_term.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.tour.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.user.compact',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.user.full',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.entity_view_mode.user.token',_binary 'b:0;',-1,1578481109.345,1,'','0'),('language.pt-pt:core.extension',_binary 'b:0;',-1,1578481105.440,1,'','0'),('language.pt-pt:crop.settings',_binary 'b:0;',-1,1578495123.675,1,'','0'),('language.pt-pt:crop.type.horizontal',_binary 'b:0;',-1,1578481107.074,1,'','0'),('language.pt-pt:crop.type.vertical',_binary 'b:0;',-1,1578481107.074,1,'','0'),('language.pt-pt:crop.type.vertical_team',_binary 'b:0;',-1,1578481107.074,1,'','0'),('language.pt-pt:crop.type.wide',_binary 'b:0;',-1,1578481107.074,1,'','0'),('language.pt-pt:dblog.settings',_binary 'b:0;',-1,1578486712.422,1,'','0'),('language.pt-pt:devel.settings',_binary 'b:0;',-1,1578481108.839,1,'','0'),('language.pt-pt:devel.toolbar.settings',_binary 'b:0;',-1,1578481110.311,1,'','0'),('language.pt-pt:editor.editor.basic_html',_binary 'b:0;',-1,1578481192.652,1,'','0'),('language.pt-pt:editor.editor.full_html',_binary 'b:0;',-1,1578481192.652,1,'','0'),('language.pt-pt:editor.editor.pure_html',_binary 'b:0;',-1,1579254251.924,1,'','0'),('language.pt-pt:editor.editor.restricted_html',_binary 'b:0;',-1,1579254251.924,1,'','0'),('language.pt-pt:eu_cookie_compliance.settings',_binary 'b:0;',-1,1578481107.755,1,'','0'),('language.pt-pt:field.field.block_content.basic.body',_binary 'b:0;',-1,1578481107.389,1,'','0'),('language.pt-pt:field.field.comment.comment.comment_body',_binary 'b:0;',-1,1578481107.396,1,'','0'),('language.pt-pt:field.field.node.equipa.field_descricao',_binary 'b:0;',-1,1578481107.420,1,'','0'),('language.pt-pt:field.field.node.equipa.field_foto',_binary 'b:0;',-1,1578481107.420,1,'','0'),('language.pt-pt:field.field.node.noticias.body',_binary 'b:0;',-1,1578481107.408,1,'','0'),('language.pt-pt:field.field.node.noticias.field_imagem_slideshow',_binary 'b:0;',-1,1578481107.432,1,'','0'),('language.pt-pt:field.field.node.page.body',_binary 'b:0;',-1,1578481107.404,1,'','0'),('language.pt-pt:field.field.node.page.field_imagem',_binary 'b:0;',-1,1578481107.445,1,'','0'),('language.pt-pt:field.field.node.parceria.body',_binary 'b:0;',-1,1578481107.410,1,'','0'),('language.pt-pt:field.field.node.parceria.field_imagem',_binary 'b:0;',-1,1578481107.456,1,'','0'),('language.pt-pt:field.field.node.parceria.field_ligacao',_binary 'b:0;',-1,1578481107.456,1,'','0'),('language.pt-pt:field.field.node.slideshow.field_botao',_binary 'b:0;',-1,1578481107.469,1,'','0'),('language.pt-pt:field.field.node.slideshow.field_imagem_slideshow',_binary 'b:0;',-1,1578481107.469,1,'','0'),('language.pt-pt:field.field.node.slideshow.field_text',_binary 'b:0;',-1,1578481107.469,1,'','0'),('language.pt-pt:field.field.taxonomy_term.parcerias.field_ligacao',_binary 'b:0;',-1,1578481107.489,1,'','0'),('language.pt-pt:field.field.taxonomy_term.parcerias.field_logotipo',_binary 'b:0;',-1,1578481107.489,1,'','0'),('language.pt-pt:field.field.taxonomy_term.servicos.field_icon_servico',_binary 'b:0;',-1,1578481107.483,1,'','0'),('language.pt-pt:field.field.user.user.user_picture',_binary 'b:0;',-1,1578481107.138,1,'','0'),('language.pt-pt:field.settings',_binary 'b:0;',-1,1578486712.459,1,'','0'),('language.pt-pt:field.storage.block_content.body',_binary 'b:0;',-1,1578481107.253,1,'','0'),('language.pt-pt:field.storage.comment.comment_body',_binary 'b:0;',-1,1578481107.263,1,'','0'),('language.pt-pt:field.storage.node.body',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_botao',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_descricao',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_foto',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_imagem',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_imagem_slideshow',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_ligacao',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.node.field_text',_binary 'b:0;',-1,1578481107.354,1,'','0'),('language.pt-pt:field.storage.taxonomy_term.field_icon_servico',_binary 'b:0;',-1,1578481107.377,1,'','0'),('language.pt-pt:field.storage.taxonomy_term.field_ligacao',_binary 'b:0;',-1,1578481107.377,1,'','0'),('language.pt-pt:field.storage.taxonomy_term.field_logotipo',_binary 'b:0;',-1,1578481107.377,1,'','0'),('language.pt-pt:field.storage.user.user_picture',_binary 'b:0;',-1,1578481107.144,1,'','0'),('language.pt-pt:file.settings',_binary 'b:0;',-1,1578495386.342,1,'','0'),('language.pt-pt:filter.format.basic_html',_binary 'b:0;',-1,1578481111.877,1,'','0'),('language.pt-pt:filter.format.full_html',_binary 'b:0;',-1,1578481186.207,1,'','0'),('language.pt-pt:filter.format.plain_text',_binary 'b:0;',-1,1578481192.786,1,'','0'),('language.pt-pt:filter.format.pure_html',_binary 'b:0;',-1,1578481192.786,1,'','0'),('language.pt-pt:filter.format.restricted_html',_binary 'b:0;',-1,1578481110.255,1,'','0'),('language.pt-pt:filter.settings',_binary 'b:0;',-1,1578481192.806,1,'','0'),('language.pt-pt:form_placeholder.settings',_binary 'b:0;',-1,1578495006.266,1,'','0'),('language.pt-pt:forum.settings',_binary 'b:0;',-1,1579197928.343,1,'','0'),('language.pt-pt:honeypot.settings',_binary 'b:0;',-1,1578486712.478,1,'','0'),('language.pt-pt:image.settings',_binary 'b:0;',-1,1578481112.204,1,'','0'),('language.pt-pt:image.style.crop_thumbnail',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.horizontal',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.horizontal_1',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.large',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.medium',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.team',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.thumbnail',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image.style.vertical',_binary 'b:0;',-1,1578481110.142,1,'','0'),('language.pt-pt:image_widget_crop.settings',_binary 'b:0;',-1,1578495060.782,1,'','0'),('language.pt-pt:language.content_settings.node.slideshow',_binary 'b:0;',-1,1578495069.598,1,'','0'),('language.pt-pt:language.content_settings.taxonomy_term.servicos',_binary 'b:0;',-1,1579197872.904,1,'','0'),('language.pt-pt:language.entity.pt-pt',_binary 'b:0;',-1,1578481107.148,1,'','0'),('language.pt-pt:language.entity.und',_binary 'b:0;',-1,1578481107.148,1,'','0'),('language.pt-pt:language.entity.zxx',_binary 'b:0;',-1,1578481107.148,1,'','0'),('language.pt-pt:language.mappings',_binary 'b:0;',-1,1578481192.858,1,'','0'),('language.pt-pt:language.types',_binary 'b:0;',-1,1578481108.251,1,'','0'),('language.pt-pt:locale.settings',_binary 'b:0;',-1,1578481107.162,1,'','0'),('language.pt-pt:metatag.metatag_defaults.403',_binary 'b:0;',-1,1578541505.301,1,'','0'),('language.pt-pt:metatag.metatag_defaults.404',_binary 'b:0;',-1,1578483656.632,1,'','0'),('language.pt-pt:metatag.metatag_defaults.front',_binary 'b:0;',-1,1578481111.792,1,'','0'),('language.pt-pt:metatag.metatag_defaults.global',_binary 'b:0;',-1,1578481109.923,1,'','0'),('language.pt-pt:metatag.metatag_defaults.node',_binary 'b:0;',-1,1578481186.187,1,'','0'),('language.pt-pt:metatag.metatag_defaults.taxonomy_term',_binary 'b:0;',-1,1578483663.415,1,'','0'),('language.pt-pt:metatag.metatag_defaults.user',_binary 'b:0;',-1,1578481109.925,1,'','0'),('language.pt-pt:node.settings',_binary 'b:0;',-1,1578481107.782,1,'','0'),('language.pt-pt:node.type.equipa',_binary 'b:0;',-1,1578481107.078,1,'','0'),('language.pt-pt:node.type.noticias',_binary 'b:0;',-1,1578481107.078,1,'','0'),('language.pt-pt:node.type.page',_binary 'b:0;',-1,1578481107.078,1,'','0'),('language.pt-pt:node.type.parceria',_binary 'b:0;',-1,1578481107.078,1,'','0'),('language.pt-pt:node.type.slideshow',_binary 'b:0;',-1,1578481107.078,1,'','0'),('language.pt-pt:pathauto.pattern.noticias',_binary 'b:0;',-1,1578495060.408,1,'','0'),('language.pt-pt:pathauto.pattern.pagina',_binary 'b:0;',-1,1578495060.408,1,'','0'),('language.pt-pt:pathauto.pattern.services',_binary 'b:0;',-1,1579197928.339,1,'','0'),('language.pt-pt:pathauto.settings',_binary 'b:0;',-1,1578481107.121,1,'','0'),('language.pt-pt:rdf.mapping.node.page',_binary 'b:0;',-1,1578481111.773,1,'','0'),('language.pt-pt:rdf.mapping.user.user',_binary 'b:0;',-1,1578481109.367,1,'','0'),('language.pt-pt:search.page.node_search',_binary 'a:1:{s:5:\"label\";s:9:\"Conteúdo\";}',-1,1578481106.746,1,'','0'),('language.pt-pt:search.page.user_search',_binary 'a:1:{s:5:\"label\";s:12:\"Utilizadores\";}',-1,1578481106.746,1,'','0'),('language.pt-pt:search.settings',_binary 'b:0;',-1,1578481106.748,1,'','0'),('language.pt-pt:seckit.settings',_binary 'b:0;',-1,1578481108.851,1,'','0'),('language.pt-pt:seven.settings',_binary 'b:0;',-1,1579254129.540,1,'','0'),('language.pt-pt:shortcut.set.default',_binary 'b:0;',-1,1578481107.082,1,'','0'),('language.pt-pt:simpletest.settings',_binary 'b:0;',-1,1578481106.081,1,'','0'),('language.pt-pt:switch_page_theme.settings',_binary 'b:0;',-1,1578481108.978,1,'','0'),('language.pt-pt:system.action.comment_delete_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.comment_publish_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.comment_save_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.comment_unpublish_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_delete_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_make_sticky_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_make_unsticky_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_promote_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_publish_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_save_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_unpromote_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.node_unpublish_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.pathauto_update_alias_node',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.pathauto_update_alias_user',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_add_role_action.administrator',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_add_role_action.colaborador',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_block_user_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_cancel_user_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_remove_role_action.administrator',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_remove_role_action.colaborador',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.action.user_unblock_user_action',_binary 'b:0;',-1,1578481106.942,1,'','0'),('language.pt-pt:system.cron',_binary 'b:0;',-1,1578486712.381,1,'','0'),('language.pt-pt:system.date',_binary 'b:0;',-1,1578481107.248,1,'','0'),('language.pt-pt:system.file',_binary 'b:0;',-1,1578481110.138,1,'','0'),('language.pt-pt:system.image',_binary 'b:0;',-1,1578481112.176,1,'','0'),('language.pt-pt:system.image.gd',_binary 'b:0;',-1,1578495088.940,1,'','0'),('language.pt-pt:system.logging',_binary 'b:0;',-1,1578481111.273,1,'','0'),('language.pt-pt:system.menu.account',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.menu.admin',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.menu.backoffice',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.menu.devel',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.menu.footer',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.menu.main',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.menu.tools',_binary 'b:0;',-1,1578481109.634,1,'','0'),('language.pt-pt:system.performance',_binary 'b:0;',-1,1578481108.896,1,'','0'),('language.pt-pt:system.site',_binary 'b:0;',-1,1578481108.981,1,'','0'),('language.pt-pt:system.theme',_binary 'b:0;',-1,1578481108.985,1,'','0'),('language.pt-pt:system.theme.global',_binary 'b:0;',-1,1578481109.070,1,'','0'),('language.pt-pt:taxonomy.settings',_binary 'b:0;',-1,1578495123.650,1,'','0'),('language.pt-pt:taxonomy.vocabulary.parcerias',_binary 'b:0;',-1,1578481107.087,1,'','0'),('language.pt-pt:taxonomy.vocabulary.servicos',_binary 'b:0;',-1,1578481107.087,1,'','0'),('language.pt-pt:user.flood',_binary 'b:0;',-1,1578495024.946,1,'','0'),('language.pt-pt:user.role.administrator',_binary 'b:0;',-1,1578481110.483,1,'','0'),('language.pt-pt:user.role.anonymous',_binary 'b:0;',-1,1578481111.655,1,'','0'),('language.pt-pt:user.role.authenticated',_binary 'b:0;',-1,1578481110.483,1,'','0'),('language.pt-pt:user.role.colaborador',_binary 'b:0;',-1,1578486712.560,1,'','0'),('language.pt-pt:user.settings',_binary 'b:0;',-1,1578481107.154,1,'','0'),('language.pt-pt:views.settings',_binary 'b:0;',-1,1578481106.640,1,'','0'),('language.pt-pt:views.view.archive',_binary 'a:3:{s:5:\"label\";s:8:\"Ficheiro\";s:11:\"description\";s:27:\"Todo o conteúdo, por mês.\";s:7:\"display\";a:3:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:4:{s:5:\"title\";s:14:\"Arquivo mensal\";s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:1:{s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";}}}}s:7:\"block_1\";a:2:{s:13:\"display_title\";s:5:\"Bloco\";s:15:\"display_options\";a:1:{s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:1:{s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";}}}}s:6:\"page_1\";a:1:{s:13:\"display_title\";s:7:\"Página\";}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.backoffice',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.block_content',_binary 'a:3:{s:5:\"label\";s:35:\"Biblioteca de blocos personalizados\";s:11:\"description\";s:40:\"Encontrar e gerir blocos personalizados.\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:5:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:4:\"tags\";a:2:{s:8:\"previous\";s:12:\"‹ Anterior\";s:4:\"next\";s:12:\"Seguinte ›\";}s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}}}s:6:\"fields\";a:4:{s:4:\"info\";a:2:{s:5:\"label\";s:20:\"Descrição do bloco\";s:9:\"separator\";s:2:\", \";}s:4:\"type\";a:2:{s:5:\"label\";s:10:\"Tipo Bloco\";s:9:\"separator\";s:2:\", \";}s:7:\"changed\";a:1:{s:5:\"label\";s:10:\"Atualizado\";}s:10:\"operations\";a:1:{s:5:\"label\";s:11:\"Operações\";}}s:7:\"filters\";a:2:{s:4:\"info\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:20:\"Descrição do bloco\";}}s:4:\"type\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:10:\"Tipo Bloco\";}}}s:5:\"title\";s:35:\"Biblioteca de blocos personalizados\";}}s:6:\"page_1\";a:2:{s:13:\"display_title\";s:7:\"Página\";s:15:\"display_options\";a:1:{s:4:\"menu\";a:1:{s:5:\"title\";s:35:\"Biblioteca de blocos personalizados\";}}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.comment',_binary 'a:3:{s:5:\"label\";s:12:\"Comentários\";s:11:\"description\";s:31:\"Encontrar e gerir comentários.\";s:7:\"display\";a:3:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:7:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ anterior\";s:4:\"next\";s:12:\"seguinte ›\";s:5:\"first\";s:11:\"« primeira\";s:4:\"last\";s:10:\"última »\";}s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}}}s:6:\"fields\";a:8:{s:17:\"comment_bulk_form\";a:1:{s:12:\"action_title\";s:6:\"Ação\";}s:7:\"subject\";a:2:{s:5:\"label\";s:7:\"Assunto\";s:9:\"separator\";s:2:\", \";}s:3:\"uid\";a:1:{s:9:\"separator\";s:2:\", \";}s:4:\"name\";a:2:{s:5:\"label\";s:5:\"Autor\";s:9:\"separator\";s:2:\", \";}s:9:\"entity_id\";a:2:{s:5:\"label\";s:11:\"Colocado em\";s:9:\"separator\";s:2:\", \";}s:7:\"changed\";a:2:{s:5:\"label\";s:10:\"Atualizado\";s:9:\"separator\";s:2:\", \";}s:10:\"operations\";a:1:{s:5:\"label\";s:11:\"Operações\";}s:6:\"name_1\";a:1:{s:9:\"separator\";s:2:\", \";}}s:7:\"filters\";a:3:{s:7:\"subject\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:7:\"Assunto\";}}s:7:\"combine\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:13:\"Nome do autor\";}}s:8:\"langcode\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:6:\"Idioma\";}}}s:5:\"title\";s:12:\"Comentários\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:26:\"Não existem comentários.\";}}s:13:\"use_more_text\";s:4:\"mais\";}}s:14:\"page_published\";a:2:{s:13:\"display_title\";s:23:\"Comentários publicados\";s:15:\"display_options\";a:2:{s:4:\"menu\";a:2:{s:5:\"title\";s:12:\"Comentários\";s:11:\"description\";s:23:\"Comentários publicados\";}s:19:\"display_description\";s:34:\"A Lista de comentários aprovados.\";}}s:15:\"page_unapproved\";a:2:{s:13:\"display_title\";s:27:\"Comentários não aprovados\";s:15:\"display_options\";a:4:{s:4:\"menu\";a:2:{s:5:\"title\";s:27:\"Comentários não aprovados\";s:11:\"description\";s:27:\"Comentários não aprovados\";}s:19:\"display_description\";s:39:\"A lista de comentários não aprovados.\";s:7:\"filters\";a:3:{s:7:\"subject\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:7:\"Assunto\";}}s:7:\"combine\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:13:\"Nome do autor\";}}s:8:\"langcode\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:6:\"Idioma\";}}}s:6:\"fields\";a:8:{s:17:\"comment_bulk_form\";a:1:{s:12:\"action_title\";s:6:\"Ação\";}s:7:\"subject\";a:2:{s:5:\"label\";s:7:\"Assunto\";s:9:\"separator\";s:2:\", \";}s:3:\"uid\";a:1:{s:9:\"separator\";s:2:\", \";}s:4:\"name\";a:2:{s:5:\"label\";s:5:\"Autor\";s:9:\"separator\";s:2:\", \";}s:9:\"entity_id\";a:2:{s:5:\"label\";s:11:\"Colocado em\";s:9:\"separator\";s:2:\", \";}s:7:\"changed\";a:2:{s:5:\"label\";s:10:\"Atualizado\";s:9:\"separator\";s:2:\", \";}s:10:\"operations\";a:1:{s:5:\"label\";s:11:\"Operações\";}s:6:\"name_1\";a:1:{s:9:\"separator\";s:2:\", \";}}}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.comments_recent',_binary 'a:3:{s:5:\"label\";s:21:\"Comentários recentes\";s:11:\"description\";s:22:\"Comentários recentes.\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:2:{s:5:\"title\";s:21:\"Comentários recentes\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:26:\"Não existem comentários.\";}}}}s:7:\"block_1\";a:2:{s:13:\"display_title\";s:5:\"Bloco\";s:15:\"display_options\";a:2:{s:17:\"block_description\";s:21:\"Comentários recentes\";s:14:\"block_category\";s:14:\"Listas (Views)\";}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.content',_binary 'a:3:{s:5:\"label\";s:9:\"Conteúdo\";s:11:\"description\";s:28:\"Encontrar e gerir conteúdo.\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:15:\"display_options\";a:6:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:6:\"Filtro\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:1:{s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ Anterior\";s:4:\"next\";s:12:\"Seguinte ›\";s:5:\"first\";s:11:\"« Primeira\";s:4:\"last\";s:10:\"Última »\";}}}s:6:\"fields\";a:6:{s:5:\"title\";a:1:{s:5:\"label\";s:7:\"Título\";}s:4:\"type\";a:2:{s:5:\"label\";s:17:\"Tipo de conteúdo\";s:9:\"separator\";s:2:\", \";}s:4:\"name\";a:1:{s:5:\"label\";s:5:\"Autor\";}s:6:\"status\";a:2:{s:5:\"label\";s:6:\"Estado\";s:8:\"settings\";a:2:{s:18:\"format_custom_true\";s:9:\"Publicado\";s:19:\"format_custom_false\";s:14:\"Não publicado\";}}s:7:\"changed\";a:1:{s:5:\"label\";s:10:\"Atualizado\";}s:10:\"operations\";a:1:{s:5:\"label\";s:11:\"Operações\";}}s:7:\"filters\";a:4:{s:5:\"title\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:7:\"Título\";}}s:4:\"type\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:17:\"Tipo de conteúdo\";}}s:6:\"status\";a:2:{s:6:\"expose\";a:1:{s:5:\"label\";s:6:\"Estado\";}s:10:\"group_info\";a:2:{s:5:\"label\";s:22:\"Estado da publicação\";s:11:\"group_items\";a:2:{i:1;a:1:{s:5:\"title\";s:9:\"Publicado\";}i:2;a:1:{s:5:\"title\";s:14:\"Não publicado\";}}}}s:8:\"langcode\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:6:\"Idioma\";}}}s:5:\"title\";s:9:\"Conteúdo\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:26:\"Conteúdo não disponível\";}}}s:13:\"display_title\";s:9:\"Principal\";}s:6:\"page_1\";a:2:{s:15:\"display_options\";a:2:{s:4:\"menu\";a:1:{s:5:\"title\";s:9:\"Conteúdo\";}s:11:\"tab_options\";a:2:{s:5:\"title\";s:9:\"Conteúdo\";s:11:\"description\";s:27:\"Encontrar e gerir conteúdo\";}}s:13:\"display_title\";s:7:\"Página\";}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.content_recent',_binary 'a:3:{s:5:\"label\";s:17:\"Conteúdo recente\";s:11:\"description\";s:18:\"Conteúdo recente.\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:5:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:6:\"fields\";a:1:{s:7:\"changed\";a:1:{s:9:\"separator\";s:2:\", \";}}s:5:\"title\";s:17:\"Conteúdo recente\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:26:\"Conteúdo não disponível\";}}s:13:\"use_more_text\";s:4:\"Mais\";}}s:7:\"block_1\";a:1:{s:13:\"display_title\";s:5:\"Bloco\";}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.files',_binary 'a:3:{s:5:\"label\";s:9:\"Ficheiros\";s:11:\"description\";s:28:\"Encontrar e gerir ficheiros.\";s:7:\"display\";a:3:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:6:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:6:\"Filtro\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:4:\"tags\";a:2:{s:8:\"previous\";s:12:\"‹ Anterior\";s:4:\"next\";s:12:\"Seguinte ›\";}s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}}}s:6:\"fields\";a:8:{s:3:\"fid\";a:1:{s:5:\"label\";s:3:\"Fid\";}s:8:\"filename\";a:2:{s:5:\"label\";s:4:\"Nome\";s:9:\"separator\";s:2:\", \";}s:8:\"filemime\";a:1:{s:5:\"label\";s:9:\"Tipo MIME\";}s:8:\"filesize\";a:1:{s:5:\"label\";s:7:\"Tamanho\";}s:6:\"status\";a:2:{s:5:\"label\";s:6:\"Estado\";s:8:\"settings\";a:2:{s:19:\"format_custom_false\";s:11:\"Temporário\";s:18:\"format_custom_true\";s:10:\"Permanente\";}}s:7:\"created\";a:1:{s:5:\"label\";s:20:\"Data de carregamento\";}s:7:\"changed\";a:1:{s:5:\"label\";s:13:\"Data alterada\";}s:5:\"count\";a:1:{s:5:\"label\";s:12:\"Utilizado em\";}}s:7:\"filters\";a:3:{s:8:\"filename\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:16:\"Nome do ficheiro\";}}s:8:\"filemime\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:9:\"Tipo MIME\";}}s:6:\"status\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:6:\"Estado\";}}}s:5:\"title\";s:9:\"Ficheiros\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:27:\"Sem ficheiros disponíveis.\";}}}}s:6:\"page_1\";a:2:{s:13:\"display_title\";s:19:\"Resumo de ficheiros\";s:15:\"display_options\";a:1:{s:4:\"menu\";a:1:{s:5:\"title\";s:9:\"Ficheiros\";}}}s:6:\"page_2\";a:1:{s:15:\"display_options\";a:3:{s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:4:\"tags\";a:2:{s:8:\"previous\";s:12:\"‹ Anterior\";s:4:\"next\";s:12:\"Seguinte ›\";}s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}}}s:6:\"fields\";a:4:{s:12:\"entity_label\";a:1:{s:5:\"label\";s:8:\"Entidade\";}s:4:\"type\";a:1:{s:5:\"label\";s:16:\"Tipo de entidade\";}s:6:\"module\";a:1:{s:5:\"label\";s:20:\"A registar o módulo\";}s:5:\"count\";a:1:{s:5:\"label\";s:20:\"Nº de Utilizações\";}}s:9:\"arguments\";a:1:{s:3:\"fid\";a:2:{s:9:\"exception\";a:1:{s:5:\"title\";s:5:\"Todos\";}s:5:\"title\";s:65:\"Informação de utilização de ficheiro para {{ arguments.fid }}\";}}}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.frontpage',_binary 'a:3:{s:5:\"label\";s:17:\"A página inicial\";s:11:\"description\";s:51:\"Todo o conteúdo promovido para a primeira página.\";s:7:\"display\";a:3:{s:7:\"default\";a:2:{s:15:\"display_options\";a:3:{s:5:\"empty\";a:1:{s:5:\"title\";a:1:{s:5:\"title\";s:23:\"Bem-vindo a [site:name]\";}}s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ Anterior\";s:4:\"next\";s:12:\"Seguinte ›\";s:5:\"first\";s:11:\"« Primeira\";s:4:\"last\";s:10:\"Última »\";}}}}s:13:\"display_title\";s:9:\"Principal\";}s:6:\"feed_1\";a:1:{s:13:\"display_title\";s:4:\"Feed\";}s:6:\"page_1\";a:1:{s:13:\"display_title\";s:7:\"Página\";}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.glossary',_binary 'a:3:{s:5:\"label\";s:10:\"Glossário\";s:11:\"description\";s:28:\"Todo o conteúdo, por letra.\";s:7:\"display\";a:3:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:3:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:6:\"fields\";a:3:{s:5:\"title\";a:1:{s:5:\"label\";s:7:\"Título\";}s:4:\"name\";a:1:{s:5:\"label\";s:5:\"Autor\";}s:7:\"changed\";a:1:{s:5:\"label\";s:21:\"Última atualização\";}}}}s:12:\"attachment_1\";a:1:{s:13:\"display_title\";s:5:\"Anexo\";}s:6:\"page_1\";a:2:{s:13:\"display_title\";s:7:\"Página\";s:15:\"display_options\";a:1:{s:4:\"menu\";a:1:{s:5:\"title\";s:10:\"Glossário\";}}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.news',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.node_auxiliar',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.noticias',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.parcerias',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.servicos',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.slideshow',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.taxonomy_term',_binary 'a:2:{s:5:\"label\";s:18:\"Termo de taxonomia\";s:7:\"display\";a:3:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:3:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:9:\"arguments\";a:1:{s:3:\"tid\";a:2:{s:9:\"exception\";a:1:{s:5:\"title\";s:5:\"Todos\";}s:5:\"title\";s:19:\"{{ arguments.tid }}\";}}}}s:6:\"feed_1\";a:1:{s:13:\"display_title\";s:4:\"Feed\";}s:6:\"page_1\";a:1:{s:13:\"display_title\";s:7:\"Página\";}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.team',_binary 'b:0;',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.user_admin_people',_binary 'a:3:{s:5:\"label\";s:7:\"Pessoas\";s:11:\"description\";s:55:\"Encontrar e gerir pessoas a interagir com o teu sítio.\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:7:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:6:\"Filtro\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ Anterior\";s:4:\"next\";s:12:\"Seguinte ›\";s:5:\"first\";s:11:\"« Primeira\";s:4:\"last\";s:10:\"Última »\";}s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}}}s:6:\"fields\";a:8:{s:14:\"user_bulk_form\";a:1:{s:5:\"label\";s:22:\"Atualização em massa\";}s:4:\"name\";a:1:{s:5:\"label\";s:18:\"Nome de utilizador\";}s:6:\"status\";a:2:{s:5:\"label\";s:6:\"Estado\";s:8:\"settings\";a:2:{s:18:\"format_custom_true\";s:5:\"Ativo\";s:19:\"format_custom_false\";s:9:\"Bloqueado\";}}s:15:\"roles_target_id\";a:1:{s:5:\"label\";s:20:\"Grupos de utilizador\";}s:7:\"created\";a:1:{s:5:\"label\";s:12:\"Membro desde\";}s:6:\"access\";a:1:{s:5:\"label\";s:14:\"Último acesso\";}s:10:\"operations\";a:1:{s:5:\"label\";s:11:\"Operações\";}s:4:\"mail\";a:1:{s:9:\"separator\";s:2:\", \";}}s:7:\"filters\";a:4:{s:7:\"combine\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:21:\"Nome ou email contém\";}}s:6:\"status\";a:1:{s:10:\"group_info\";a:2:{s:5:\"label\";s:6:\"Estado\";s:11:\"group_items\";a:2:{i:1;a:1:{s:5:\"title\";s:5:\"Ativo\";}i:2;a:1:{s:5:\"title\";s:9:\"Bloqueado\";}}}}s:15:\"roles_target_id\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:5:\"Grupo\";}}s:10:\"permission\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:10:\"Permissão\";}}}s:5:\"title\";s:7:\"Pessoas\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:27:\"Nenhuma pessoa disponível.\";}}s:13:\"use_more_text\";s:4:\"mais\";}}s:6:\"page_1\";a:2:{s:13:\"display_title\";s:7:\"Página\";s:15:\"display_options\";a:2:{s:4:\"menu\";a:2:{s:5:\"title\";s:5:\"Lista\";s:11:\"description\";s:55:\"Encontrar e gerir pessoas a interagir com o teu sítio.\";}s:11:\"tab_options\";a:2:{s:5:\"title\";s:7:\"Pessoas\";s:11:\"description\";s:51:\"Gerir contas de utilizadores, grupos e permissões.\";}}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.watchdog',_binary 'a:2:{s:11:\"description\";s:29:\"Mensagens de registo recentes\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:6:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:6:\"Filtro\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"pager\";a:1:{s:7:\"options\";a:2:{s:6:\"expose\";a:3:{s:20:\"items_per_page_label\";s:17:\"Itens por página\";s:32:\"items_per_page_options_all_label\";s:9:\"- Todos -\";s:12:\"offset_label\";s:12:\"Deslocamento\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:6:\"fields\";a:7:{s:7:\"nothing\";a:1:{s:11:\"admin_label\";s:6:\"Ícone\";}s:8:\"severity\";a:1:{s:5:\"label\";s:10:\"Severidade\";}s:4:\"type\";a:1:{s:5:\"label\";s:4:\"Tipo\";}s:9:\"timestamp\";a:1:{s:5:\"label\";s:4:\"Data\";}s:7:\"message\";a:2:{s:5:\"label\";s:8:\"Mensagem\";s:5:\"alter\";a:1:{s:3:\"alt\";s:13:\"{{ message }}\";}}s:4:\"name\";a:2:{s:5:\"label\";s:10:\"Utilizador\";s:9:\"separator\";s:2:\", \";}s:4:\"link\";a:1:{s:5:\"label\";s:11:\"Operações\";}}s:7:\"filters\";a:2:{s:4:\"type\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:4:\"Tipo\";}}s:8:\"severity\";a:1:{s:6:\"expose\";a:1:{s:5:\"label\";s:10:\"Severidade\";}}}s:5:\"title\";s:29:\"Mensagens de registo recentes\";s:5:\"empty\";a:1:{s:4:\"area\";a:2:{s:11:\"admin_label\";s:30:\"Não há mensagens no registo.\";s:7:\"content\";s:30:\"Não há mensagens no registo.\";}}}}s:4:\"page\";a:1:{s:13:\"display_title\";s:7:\"Página\";}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.who_s_new',_binary 'a:3:{s:5:\"label\";s:18:\"Novos utilizadores\";s:11:\"description\";s:65:\"Mostra uma lista de contas de utilizador mais recentes no sítio.\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:2:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:5:\"title\";s:18:\"Novos utilizadores\";}}s:7:\"block_1\";a:2:{s:13:\"display_title\";s:18:\"Novos utilizadores\";s:15:\"display_options\";a:3:{s:19:\"display_description\";s:31:\"Uma lista de utilizadores novos\";s:17:\"block_description\";s:18:\"Novos utilizadores\";s:14:\"block_category\";s:10:\"Utilizador\";}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:views.view.who_s_online',_binary 'a:2:{s:5:\"label\";s:23:\"Bloco quem está ligado\";s:7:\"display\";a:2:{s:7:\"default\";a:2:{s:13:\"display_title\";s:9:\"Principal\";s:15:\"display_options\";a:5:{s:12:\"exposed_form\";a:1:{s:7:\"options\";a:5:{s:13:\"submit_button\";s:7:\"Aplicar\";s:18:\"reset_button_label\";s:9:\"Reiniciar\";s:19:\"exposed_sorts_label\";s:11:\"Ordenar por\";s:14:\"sort_asc_label\";s:10:\"Ascendente\";s:15:\"sort_desc_label\";s:11:\"Descendente\";}}s:7:\"filters\";a:1:{s:6:\"access\";a:1:{s:6:\"expose\";a:2:{s:5:\"label\";s:14:\"Último acesso\";s:11:\"description\";s:118:\"Um utilizador é considerado \"ligado\" por este intervalo de tempo, após ter visualizado uma página pela última vez.\";}}}s:5:\"title\";s:20:\"Utilizadores ligados\";s:6:\"header\";a:1:{s:6:\"result\";a:1:{s:7:\"content\";s:47:\"Atualmente, existem @total utilizadores ligaos.\";}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:1:{s:7:\"content\";s:43:\"Atualmente, existem 0 utilizadores ligados.\";}}}}s:18:\"who_s_online_block\";a:2:{s:13:\"display_title\";s:20:\"Utilizadores ligados\";s:15:\"display_options\";a:2:{s:17:\"block_description\";s:20:\"Utilizadores ligados\";s:19:\"display_description\";s:69:\"Uma lista de utilizadores que estão atualmente com sessão iniciada.\";}}}}',-1,1578481106.823,1,'','0'),('language.pt-pt:yorkshire.settings',_binary 'b:0;',-1,1578495056.337,1,'','0'),('language.types',_binary 'a:5:{s:3:\"all\";a:3:{i:0;s:18:\"language_interface\";i:1;s:16:\"language_content\";i:2;s:12:\"language_url\";}s:12:\"configurable\";a:1:{i:0;s:18:\"language_interface\";}s:11:\"negotiation\";a:3:{s:16:\"language_content\";a:1:{s:7:\"enabled\";a:1:{s:18:\"language-interface\";i:0;}}s:12:\"language_url\";a:1:{s:7:\"enabled\";a:2:{s:12:\"language-url\";i:0;s:21:\"language-url-fallback\";i:1;}}s:18:\"language_interface\";a:1:{s:7:\"enabled\";a:1:{s:12:\"language-url\";i:0;}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dqouFqVseNJNvEjsoYKxbinFOITuCxYhi4y2OTNQP_8\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.251,1,'','0'),('locale.settings',_binary 'a:6:{s:13:\"cache_strings\";b:1;s:17:\"translate_english\";b:0;s:10:\"javascript\";a:1:{s:9:\"directory\";s:9:\"languages\";}s:11:\"translation\";a:8:{s:10:\"use_source\";s:16:\"remote_and_local\";s:16:\"default_filename\";s:30:\"%project-%version.%language.po\";s:22:\"default_server_pattern\";s:87:\"https://ftp.drupal.org/files/translations/%core/%project/%project-%version.%language.po\";s:20:\"overwrite_customized\";b:0;s:24:\"overwrite_not_customized\";b:1;s:20:\"update_interval_days\";i:0;s:4:\"path\";s:32:\"sites/default/files/translations\";s:14:\"import_enabled\";b:1;}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cSdYeE-_AQETCNZnl8BMFS9-sVn5--VzAYILkpPBUbM\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481107.160,1,'','0'),('metatag.metatag_defaults.403',_binary 'a:8:{s:4:\"uuid\";s:36:\"0ebea157-598c-45ad-aa55-0eb7f72b28f6\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Da5YWhJdKLxaJ9gDRI1u5oCbm5WBxiiDgA4M1QrOEPQ\";}s:2:\"id\";s:3:\"403\";s:5:\"label\";s:17:\"403 access denied\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}',-1,1578541505.297,1,'','0'),('metatag.metatag_defaults.404',_binary 'a:8:{s:4:\"uuid\";s:36:\"ea859027-b8ae-45ab-8d7d-a9f3c956aa3c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"puBstSLDz8mbaWU357zaqQDBGMGsJzG0j-TQNQkjg20\";}s:2:\"id\";s:3:\"404\";s:5:\"label\";s:18:\"404 page not found\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}',-1,1578483656.630,1,'','0'),('metatag.metatag_defaults.front',_binary 'a:8:{s:4:\"uuid\";s:36:\"f8e4b73e-d8af-43dd-9c0b-feea7cef95cc\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1noCXlegCr5HFehQRF1ViXy1jhU1jZ_sNN99a8Sj5jo\";}s:2:\"id\";s:5:\"front\";s:5:\"label\";s:10:\"Front page\";s:4:\"tags\";a:10:{s:8:\"keywords\";s:185:\"Dentistas em Braga, Aparelhos de Correcção, Branqueamentos, Dentistas, Implantes, Implantologia, Ortodontia, Prótese Dentária, Tratamentos Dentários, Dentista Braga, Clínica Braga\";s:9:\"shortlink\";s:10:\"[site:url]\";s:5:\"title\";s:12:\"[node:title]\";s:13:\"canonical_url\";s:10:\"[site:url]\";s:11:\"description\";s:55:\"Cuidamos da sua higiene oral com empenho e dedicação.\";s:8:\"og_image\";s:72:\"[node:field_imagem:0:entity:url][node:field_imagem_slideshow:entity:url]\";s:12:\"og_image_url\";s:72:\"[node:field_imagem:0:entity:url][node:field_imagem_slideshow:entity:url]\";s:6:\"og_url\";s:10:\"[node:url]\";s:14:\"og_description\";s:55:\"Cuidamos da sua higiene oral com empenho e dedicação.\";s:8:\"og_title\";s:12:\"[node:title]\";}}',-1,1578481111.790,1,'','0'),('metatag.metatag_defaults.global',_binary 'a:8:{s:4:\"uuid\";s:36:\"3ac4a8aa-7568-47ec-b6bc-a87454b16407\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sL588ui1E_8-2c_UupwyYxcqX2OVyMFp3HTLbbFqvPc\";}s:2:\"id\";s:6:\"global\";s:5:\"label\";s:6:\"Global\";s:4:\"tags\";a:3:{s:8:\"keywords\";s:185:\"Dentistas em Braga, Aparelhos de Correcção, Branqueamentos, Dentistas, Implantes, Implantologia, Ortodontia, Prótese Dentária, Tratamentos Dentários, Dentista Braga, Clínica Braga\";s:5:\"title\";s:34:\"[current-page:title] | [site:name]\";s:13:\"canonical_url\";s:18:\"[current-page:url]\";}}',-1,1578481109.921,1,'','0'),('metatag.metatag_defaults.node',_binary 'a:8:{s:4:\"uuid\";s:36:\"70821af8-297f-4e82-be0a-0d1f903e9b89\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rpwvgyEURXLz_JjgMCrkS1rUv-0k3L79BpO-ReN7fDI\";}s:2:\"id\";s:4:\"node\";s:5:\"label\";s:7:\"Content\";s:4:\"tags\";a:10:{s:8:\"keywords\";s:185:\"Dentistas em Braga, Aparelhos de Correcção, Branqueamentos, Dentistas, Implantes, Implantologia, Ortodontia, Prótese Dentária, Tratamentos Dentários, Dentista Braga, Clínica Braga\";s:5:\"title\";s:26:\"[node:title] | [site:name]\";s:13:\"canonical_url\";s:10:\"[node:url]\";s:11:\"description\";s:14:\"[node:summary]\";s:7:\"og_type\";s:19:\"[node:content-type]\";s:8:\"og_image\";s:72:\"[node:field_imagem:0:entity:url][node:field_imagem_slideshow:entity:url]\";s:12:\"og_image_url\";s:72:\"[node:field_imagem:0:entity:url][node:field_imagem_slideshow:entity:url]\";s:6:\"og_url\";s:10:\"[node:url]\";s:14:\"og_description\";s:14:\"[node:summary]\";s:8:\"og_title\";s:34:\"[current-page:title] | [site:name]\";}}',-1,1578481186.184,1,'','0'),('metatag.metatag_defaults.node__equipa',_binary 'b:0;',-1,1580769691.786,1,'','0'),('metatag.metatag_defaults.node__noticias',_binary 'b:0;',-1,1578483666.525,1,'','0'),('metatag.metatag_defaults.node__page',_binary 'b:0;',-1,1578481186.189,1,'','0'),('metatag.metatag_defaults.node__slideshow',_binary 'b:0;',-1,1578495123.895,1,'','0'),('metatag.metatag_defaults.taxonomy_term',_binary 'a:8:{s:4:\"uuid\";s:36:\"d14e1022-0c9a-4e5b-a31f-906ccd12df74\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"92bXZdyYJ5xqukdfmGRr_CYcwm1vfuS8b8aJ7X_G7E0\";}s:2:\"id\";s:13:\"taxonomy_term\";s:5:\"label\";s:13:\"Taxonomy term\";s:4:\"tags\";a:3:{s:13:\"canonical_url\";s:10:\"[term:url]\";s:11:\"description\";s:18:\"[term:description]\";s:5:\"title\";s:25:\"[term:name] | [site:name]\";}}',-1,1578483663.411,1,'','0'),('metatag.metatag_defaults.taxonomy_term__servicos',_binary 'b:0;',-1,1578483663.417,1,'','0'),('metatag.metatag_defaults.user',_binary 'a:8:{s:4:\"uuid\";s:36:\"aa44ac8f-3d53-4894-a4ed-5f08386c4883\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MvQPTbQx0Vxwy0ordSHyixdZmLCMpvMdLD69dlwkrKc\";}s:2:\"id\";s:4:\"user\";s:5:\"label\";s:4:\"User\";s:4:\"tags\";a:3:{s:13:\"canonical_url\";s:10:\"[user:url]\";s:11:\"description\";s:11:\"[site:name]\";s:5:\"title\";s:33:\"[user:display-name] | [site:name]\";}}',-1,1578481109.924,1,'','0'),('metatag.metatag_defaults.user__user',_binary 'b:0;',-1,1578481109.927,1,'','0'),('node.settings',_binary 'a:3:{s:15:\"use_admin_theme\";b:1;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481107.780,1,'','0'),('node.type.equipa',_binary 'a:12:{s:4:\"uuid\";s:36:\"084480af-3f61-4875-8535-491449485fd4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:0:{}s:6:\"parent\";s:0:\"\";}}s:4:\"name\";s:6:\"Equipa\";s:4:\"type\";s:6:\"equipa\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:0;s:17:\"display_submitted\";b:0;}',-1,1578481107.076,1,'','0'),('node.type.noticias',_binary 'a:12:{s:4:\"uuid\";s:36:\"303e7b67-c9bd-4c08-b25f-cd5899b6a861\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:0:{}s:6:\"parent\";s:0:\"\";}}s:4:\"name\";s:8:\"Noticias\";s:4:\"type\";s:8:\"noticias\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:0;s:17:\"display_submitted\";b:0;}',-1,1578481107.076,1,'','0'),('node.type.page',_binary 'a:13:{s:4:\"uuid\";s:36:\"753fe972-4d23-48b7-be77-1c02a121b51e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc\";}s:4:\"name\";s:15:\"Página básica\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:0;s:17:\"display_submitted\";b:0;}',-1,1578481107.076,1,'','0'),('node.type.parceria',_binary 'a:12:{s:4:\"uuid\";s:36:\"30690457-49a0-4fe8-a9ed-f4098b64e385\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:0:{}s:6:\"parent\";s:0:\"\";}}s:4:\"name\";s:8:\"Parceria\";s:4:\"type\";s:8:\"parceria\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:0;s:17:\"display_submitted\";b:0;}',-1,1578481107.076,1,'','0'),('node.type.slideshow',_binary 'a:12:{s:4:\"uuid\";s:36:\"765cd9e9-98fc-4d62-ad62-4b179acc4e38\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:0:{}s:6:\"parent\";s:0:\"\";}}s:4:\"name\";s:9:\"Slideshow\";s:4:\"type\";s:9:\"slideshow\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:0;s:17:\"display_submitted\";b:0;}',-1,1578481107.076,1,'','0'),('pathauto.pattern.noticias',_binary 'a:12:{s:4:\"uuid\";s:36:\"be9b4031-ffba-4cc8-87f0-d277a220271a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:8:\"noticias\";s:5:\"label\";s:8:\"noticias\";s:4:\"type\";s:23:\"canonical_entities:node\";s:7:\"pattern\";s:21:\"noticias/[node:title]\";s:18:\"selection_criteria\";a:1:{s:36:\"7f38ea08-b78a-4df0-932a-c63e4f3ee655\";a:5:{s:2:\"id\";s:9:\"node_type\";s:7:\"bundles\";a:1:{s:8:\"noticias\";s:8:\"noticias\";}s:6:\"negate\";b:0;s:15:\"context_mapping\";a:1:{s:4:\"node\";s:4:\"node\";}s:4:\"uuid\";s:36:\"7f38ea08-b78a-4df0-932a-c63e4f3ee655\";}}s:15:\"selection_logic\";s:3:\"and\";s:6:\"weight\";i:-5;s:13:\"relationships\";a:0:{}}',-1,1578495060.399,1,'','0'),('pathauto.pattern.pagina',_binary 'a:12:{s:4:\"uuid\";s:36:\"b4b5d53b-5ce5-4abc-bf60-b673ee744743\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:6:\"pagina\";s:5:\"label\";s:7:\"Página\";s:4:\"type\";s:23:\"canonical_entities:node\";s:7:\"pattern\";s:12:\"[node:title]\";s:18:\"selection_criteria\";a:1:{s:36:\"05d563a4-bea6-41a6-a568-d5c4871c5169\";a:5:{s:2:\"id\";s:9:\"node_type\";s:7:\"bundles\";a:1:{s:4:\"page\";s:4:\"page\";}s:6:\"negate\";b:0;s:15:\"context_mapping\";a:1:{s:4:\"node\";s:4:\"node\";}s:4:\"uuid\";s:36:\"05d563a4-bea6-41a6-a568-d5c4871c5169\";}}s:15:\"selection_logic\";s:3:\"and\";s:6:\"weight\";i:-5;s:13:\"relationships\";a:0:{}}',-1,1578495060.399,1,'','0'),('pathauto.pattern.services',_binary 'a:12:{s:4:\"uuid\";s:36:\"2c55a926-9b18-4bbe-90ea-eff756cf0254\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:6:\"ctools\";i:1;s:8:\"taxonomy\";}}s:2:\"id\";s:8:\"services\";s:5:\"label\";s:8:\"services\";s:4:\"type\";s:32:\"canonical_entities:taxonomy_term\";s:7:\"pattern\";s:20:\"servicos/[term:name]\";s:18:\"selection_criteria\";a:1:{s:36:\"34190fbb-d72b-40e8-9edf-799bd47335f4\";a:5:{s:2:\"id\";s:27:\"entity_bundle:taxonomy_term\";s:7:\"bundles\";a:1:{s:8:\"servicos\";s:8:\"servicos\";}s:6:\"negate\";b:0;s:15:\"context_mapping\";a:1:{s:13:\"taxonomy_term\";s:13:\"taxonomy_term\";}s:4:\"uuid\";s:36:\"34190fbb-d72b-40e8-9edf-799bd47335f4\";}}s:15:\"selection_logic\";s:3:\"and\";s:6:\"weight\";i:-5;s:13:\"relationships\";a:0:{}}',-1,1579197928.337,1,'','0'),('pathauto.settings',_binary 'a:14:{s:20:\"enabled_entity_types\";a:1:{i:0;s:4:\"user\";}s:11:\"punctuation\";a:1:{s:6:\"hyphen\";i:1;}s:7:\"verbose\";b:0;s:9:\"separator\";s:1:\"-\";s:10:\"max_length\";i:100;s:20:\"max_component_length\";i:100;s:13:\"transliterate\";b:1;s:12:\"reduce_ascii\";b:0;s:4:\"case\";b:1;s:12:\"ignore_words\";s:134:\"a, an, as, at, before, but, by, for, from, is, in, into, like, of, off, on, onto, per, since, than, the, this, that, to, up, via, with\";s:13:\"update_action\";i:2;s:11:\"safe_tokens\";a:6:{i:0;s:5:\"alias\";i:1;s:4:\"path\";i:2;s:9:\"join-path\";i:3;s:9:\"login-url\";i:4;s:3:\"url\";i:5;s:9:\"url-brief\";}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SwvLp8snyPEExF41CaJJYdPUVomofLqtXvwciHc4cPg\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481107.119,1,'','0'),('rdf.mapping.node.equipa',_binary 'b:0;',-1,1578481552.153,1,'','0'),('rdf.mapping.node.noticias',_binary 'b:0;',-1,1578481566.055,1,'','0'),('rdf.mapping.node.page',_binary 'a:10:{s:4:\"uuid\";s:36:\"b72972dc-8044-4586-982d-365e756d7208\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"32LxRnl4Wesvzqyfp7HnD0-U9-wxrLBn76pqY5XGNAE\";}s:2:\"id\";s:9:\"node.page\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"types\";a:1:{i:0;s:14:\"schema:WebPage\";}s:13:\"fieldMappings\";a:6:{s:5:\"title\";a:1:{s:10:\"properties\";a:1:{i:0;s:11:\"schema:name\";}}s:7:\"created\";a:2:{s:10:\"properties\";a:1:{i:0;s:18:\"schema:dateCreated\";}s:17:\"datatype_callback\";a:1:{s:8:\"callable\";s:48:\"Drupal\\rdf\\CommonDataConverter::dateIso8601Value\";}}s:7:\"changed\";a:2:{s:10:\"properties\";a:1:{i:0;s:19:\"schema:dateModified\";}s:17:\"datatype_callback\";a:1:{s:8:\"callable\";s:48:\"Drupal\\rdf\\CommonDataConverter::dateIso8601Value\";}}s:4:\"body\";a:1:{s:10:\"properties\";a:1:{i:0;s:11:\"schema:text\";}}s:3:\"uid\";a:2:{s:10:\"properties\";a:1:{i:0;s:13:\"schema:author\";}s:12:\"mapping_type\";s:3:\"rel\";}s:13:\"comment_count\";a:2:{s:10:\"properties\";a:1:{i:0;s:23:\"schema:interactionCount\";}s:17:\"datatype_callback\";a:2:{s:8:\"callable\";s:51:\"Drupal\\rdf\\SchemaOrgDataConverter::interactionCount\";s:9:\"arguments\";a:1:{s:16:\"interaction_type\";s:12:\"UserComments\";}}}}}',-1,1578481111.771,1,'','0'),('rdf.mapping.node.slideshow',_binary 'b:0;',-1,1578481112.140,1,'','0'),('rdf.mapping.taxonomy_term.parcerias',_binary 'b:0;',-1,1578481736.271,1,'','0'),('rdf.mapping.taxonomy_term.servicos',_binary 'b:0;',-1,1578481112.459,1,'','0'),('rdf.mapping.user.user',_binary 'a:10:{s:4:\"uuid\";s:36:\"fe01a6d4-9424-46ae-8eac-c9c2e862b2cd\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TGTlmpYAtXxjtYMFA_A0vosE2c4R5MCQwLviIA5HUM0\";}s:2:\"id\";s:9:\"user.user\";s:16:\"targetEntityType\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:5:\"types\";a:1:{i:0;s:13:\"schema:Person\";}s:13:\"fieldMappings\";a:1:{s:4:\"name\";a:1:{s:10:\"properties\";a:1:{i:0;s:11:\"schema:name\";}}}}',-1,1578481109.365,1,'','0'),('search.page.node_search',_binary 'a:11:{s:4:\"uuid\";s:36:\"d9b45ecf-5f8e-40bd-9f90-2d655cd6afda\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U\";}s:2:\"id\";s:11:\"node_search\";s:5:\"label\";s:7:\"Content\";s:4:\"path\";s:4:\"node\";s:6:\"weight\";i:-10;s:6:\"plugin\";s:11:\"node_search\";s:13:\"configuration\";a:1:{s:8:\"rankings\";a:0:{}}}',-1,1578481106.744,1,'','0'),('search.page.user_search',_binary 'a:11:{s:4:\"uuid\";s:36:\"d1fee202-d658-4967-ac70-deb71a80fa5f\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A\";}s:2:\"id\";s:11:\"user_search\";s:5:\"label\";s:5:\"Users\";s:4:\"path\";s:4:\"user\";s:6:\"weight\";i:0;s:6:\"plugin\";s:11:\"user_search\";s:13:\"configuration\";a:0:{}}',-1,1578481106.744,1,'','0'),('search.settings',_binary 'a:6:{s:12:\"and_or_limit\";i:7;s:12:\"default_page\";s:11:\"node_search\";s:5:\"index\";a:4:{s:10:\"cron_limit\";i:100;s:11:\"overlap_cjk\";b:1;s:17:\"minimum_word_size\";i:3;s:11:\"tag_weights\";a:12:{s:2:\"h1\";i:25;s:2:\"h2\";i:18;s:2:\"h3\";i:15;s:2:\"h4\";i:14;s:2:\"h5\";i:9;s:2:\"h6\";i:6;s:1:\"u\";i:3;s:1:\"b\";i:3;s:1:\"i\";i:3;s:6:\"strong\";i:3;s:2:\"em\";i:3;s:1:\"a\";i:10;}}s:7:\"logging\";b:0;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481106.747,1,'','0'),('seckit.settings',_binary 'a:9:{s:10:\"seckit_xss\";a:2:{s:3:\"csp\";a:17:{s:8:\"checkbox\";b:1;s:13:\"vendor-prefix\";a:2:{s:1:\"x\";b:0;s:6:\"webkit\";b:0;}s:11:\"report-only\";b:0;s:11:\"default-src\";s:0:\"\";s:10:\"script-src\";s:0:\"\";s:10:\"object-src\";s:0:\"\";s:7:\"img-src\";s:0:\"\";s:9:\"media-src\";s:0:\"\";s:9:\"frame-src\";s:0:\"\";s:15:\"frame-ancestors\";s:0:\"\";s:9:\"child-src\";s:0:\"\";s:8:\"font-src\";s:0:\"\";s:11:\"connect-src\";s:0:\"\";s:10:\"report-uri\";s:21:\"/report-csp-violation\";s:11:\"upgrade-req\";b:0;s:10:\"policy-uri\";s:0:\"\";s:9:\"style-src\";s:0:\"\";}s:5:\"x_xss\";a:5:{s:27:\"seckit_x_xss_option_disable\";s:8:\"Disabled\";s:21:\"seckit_x_xss_option_0\";s:1:\"0\";s:21:\"seckit_x_xss_option_1\";s:2:\"1;\";s:27:\"seckit_x_xss_option_1_block\";s:13:\"1; mode=block\";s:6:\"select\";i:3;}}s:11:\"seckit_csrf\";a:2:{s:6:\"origin\";b:0;s:16:\"origin_whitelist\";s:0:\"\";}s:19:\"seckit_clickjacking\";a:4:{s:15:\"js_css_noscript\";b:1;s:16:\"noscript_message\";s:59:\"Sorry, you need to enable JavaScript to visit this website.\";s:7:\"x_frame\";s:1:\"1\";s:18:\"x_frame_allow_from\";s:0:\"\";}s:10:\"seckit_ssl\";a:4:{s:4:\"hsts\";b:0;s:15:\"hsts_subdomains\";b:0;s:12:\"hsts_max_age\";i:1000;s:12:\"hsts_preload\";b:0;}s:9:\"seckit_ct\";a:4:{s:9:\"expect_ct\";b:0;s:7:\"max_age\";i:86400;s:10:\"report_uri\";s:0:\"\";s:7:\"enforce\";b:0;}s:9:\"seckit_fp\";a:2:{s:14:\"feature_policy\";b:0;s:21:\"feature_policy_policy\";s:0:\"\";}s:14:\"seckit_various\";a:5:{s:11:\"from_origin\";b:1;s:23:\"from_origin_destination\";s:4:\"same\";s:15:\"referrer_policy\";b:1;s:22:\"referrer_policy_policy\";s:11:\"same-origin\";s:20:\"disable_autocomplete\";b:1;}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"x6bhN6WZwfVUI_LLMvRJIUW_2c26VTaBozbfXmJWmro\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.845,1,'','0'),('seven.settings',_binary 'a:1:{s:20:\"third_party_settings\";a:1:{s:8:\"shortcut\";a:1:{s:11:\"module_link\";b:1;}}}',-1,1579254129.537,1,'','0'),('shortcut.set.default',_binary 'a:7:{s:4:\"uuid\";s:36:\"ecb02edb-9fe5-4d5c-912c-dc621bfe1591\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI\";}s:2:\"id\";s:7:\"default\";s:5:\"label\";s:11:\"Predefinido\";}',-1,1578481107.081,1,'','0'),('simpletest.settings',_binary 'b:0;',-1,1578481106.080,1,'','0'),('switch_page_theme.settings',_binary 'a:1:{s:9:\"spt_table\";a:1:{i:0;a:7:{s:6:\"status\";s:1:\"1\";s:5:\"pages\";s:274:\"/node/*/edit\r\n/admin/structure/taxonomy/manage/servicos/add\r\n/user/*/edit\r\n/node/*/delete\r\n/node/*/remove\r\n/admin/backoffice\r\n/admin/backoffice/*\r\n/admin/backoffice/*/*\r\n/node/add/*\r\n/admin/structure/taxonomy/manage/*/overview\r\n/taxonomy/term/*/edit\r\n/taxonomy/term/*/delete\";s:5:\"theme\";s:9:\"yorkshire\";s:5:\"roles\";a:4:{s:13:\"administrator\";s:13:\"administrator\";s:11:\"colaborador\";s:11:\"colaborador\";s:9:\"anonymous\";i:0;s:13:\"authenticated\";i:0;}s:6:\"weight\";s:3:\"-10\";s:8:\"language\";a:1:{s:5:\"pt-pt\";i:0;}s:6:\"remove\";s:7:\"Remover\";}}}',-1,1578481108.976,1,'','0'),('system.action.comment_delete_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"b72839ed-3d10-4b31-8f6d-4e24644a72c2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ\";}s:2:\"id\";s:21:\"comment_delete_action\";s:5:\"label\";s:20:\"Eliminar comentário\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:28:\"entity:delete_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.comment_publish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"f9f976a7-ddcc-4b21-a0b3-05f04ee7c853\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0\";}s:2:\"id\";s:22:\"comment_publish_action\";s:5:\"label\";s:20:\"Publicar comentário\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:29:\"entity:publish_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.comment_save_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"095eebb8-131c-4c47-b7a8-b582d799474c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU\";}s:2:\"id\";s:19:\"comment_save_action\";s:5:\"label\";s:19:\"Guardar comentário\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:26:\"entity:save_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.comment_unpublish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"9c494ac2-1389-41d0-a729-a46004a6d862\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk\";}s:2:\"id\";s:24:\"comment_unpublish_action\";s:5:\"label\";s:23:\"Despublicar comentário\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:31:\"entity:unpublish_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_delete_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"d4575602-e9f2-44f9-8b95-4a5029c47f31\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg\";}s:2:\"id\";s:18:\"node_delete_action\";s:5:\"label\";s:14:\"Delete content\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:25:\"entity:delete_action:node\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_make_sticky_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"40f77e34-7880-485b-9068-2448362ea486\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0\";}s:2:\"id\";s:23:\"node_make_sticky_action\";s:5:\"label\";s:28:\"Tornar o conteúdo destacado\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:23:\"node_make_sticky_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_make_unsticky_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"71d1997a-0e69-4764-aace-154bd1d8556a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k\";}s:2:\"id\";s:25:\"node_make_unsticky_action\";s:5:\"label\";s:33:\"Tornar o conteúdo não destacado\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:25:\"node_make_unsticky_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_promote_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"d46b3be9-8817-41de-be7d-18780d6f1824\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U\";}s:2:\"id\";s:19:\"node_promote_action\";s:5:\"label\";s:41:\"Promover conteúdo para a página inicial\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:19:\"node_promote_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_publish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"cd2f440f-38cc-47fb-a1b4-4700294be679\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0\";}s:2:\"id\";s:19:\"node_publish_action\";s:5:\"label\";s:18:\"Publicar conteúdo\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:26:\"entity:publish_action:node\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_save_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"a1d20105-3e5c-4305-84a8-26425c924ef2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM\";}s:2:\"id\";s:16:\"node_save_action\";s:5:\"label\";s:17:\"Guardar conteúdo\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:23:\"entity:save_action:node\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_unpromote_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"038f2cdc-4c61-4ab6-9832-2a47736e5e4b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0\";}s:2:\"id\";s:21:\"node_unpromote_action\";s:5:\"label\";s:36:\"Remover conteúdo da página inicial\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:21:\"node_unpromote_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.node_unpublish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"926cd1cc-25e2-4c29-b350-1b6f911d2abf\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE\";}s:2:\"id\";s:21:\"node_unpublish_action\";s:5:\"label\";s:21:\"Despublicar conteúdo\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:28:\"entity:unpublish_action:node\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.pathauto_update_alias_node',_binary 'a:10:{s:4:\"uuid\";s:36:\"ec8137fd-6f78-48e9-b328-31a13aec8c3a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:6:\"module\";a:1:{i:0;s:8:\"pathauto\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lno8QThS348UX-kaUsagJtCnuPHKLXYnTQiF_9HSDWA\";}s:2:\"id\";s:26:\"pathauto_update_alias_node\";s:5:\"label\";s:16:\"Update URL alias\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:21:\"pathauto_update_alias\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.pathauto_update_alias_user',_binary 'a:10:{s:4:\"uuid\";s:36:\"555bc182-a0f7-4240-8229-8a2e6bc2ba61\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:6:\"module\";a:1:{i:0;s:8:\"pathauto\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"x_ok_ZsfA4Xk4B_hVW3O4-3PcNoK57nXLz_Dlletidg\";}s:2:\"id\";s:26:\"pathauto_update_alias_user\";s:5:\"label\";s:16:\"Update URL alias\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:21:\"pathauto_update_alias\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.user_add_role_action.administrator',_binary 'a:9:{s:4:\"uuid\";s:36:\"7e1f387d-e666-4509-9112-428e86c0c1c0\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"user.role.administrator\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:34:\"user_add_role_action.administrator\";s:5:\"label\";s:50:\"Add the Administrator role to the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:20:\"user_add_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:13:\"administrator\";}}',-1,1578481106.876,1,'','0'),('system.action.user_add_role_action.colaborador',_binary 'a:9:{s:4:\"uuid\";s:36:\"dec0fcb0-9d82-4ba4-ae20-a3dde657e873\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:21:\"user.role.colaborador\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:32:\"user_add_role_action.colaborador\";s:5:\"label\";s:48:\"Add the Colaborador role to the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:20:\"user_add_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:11:\"colaborador\";}}',-1,1578481106.876,1,'','0'),('system.action.user_block_user_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"7fe7d50c-0521-4945-8869-0673ae6c0791\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4\";}s:2:\"id\";s:22:\"user_block_user_action\";s:5:\"label\";s:43:\"Bloquear o(s) utilizador(es) selecionado(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:22:\"user_block_user_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.user_cancel_user_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"e41fce63-bcbf-4dd5-ace2-66093564cc2d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU\";}s:2:\"id\";s:23:\"user_cancel_user_action\";s:5:\"label\";s:51:\"Cancelar a(s) conta(s) de utilizador selecionada(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_cancel_user_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.action.user_remove_role_action.administrator',_binary 'a:9:{s:4:\"uuid\";s:36:\"e9380362-2a59-4296-a778-6e3b8497a21a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"user.role.administrator\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:37:\"user_remove_role_action.administrator\";s:5:\"label\";s:55:\"Remove the Administrator role from the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_remove_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:13:\"administrator\";}}',-1,1578481106.876,1,'','0'),('system.action.user_remove_role_action.colaborador',_binary 'a:9:{s:4:\"uuid\";s:36:\"aaeea397-5c7b-46b1-bba9-d194029dfdbf\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:21:\"user.role.colaborador\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:35:\"user_remove_role_action.colaborador\";s:5:\"label\";s:53:\"Remove the Colaborador role from the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_remove_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:11:\"colaborador\";}}',-1,1578481106.876,1,'','0'),('system.action.user_unblock_user_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"e1222af7-bd33-440a-8f71-27f243cca44d\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0\";}s:2:\"id\";s:24:\"user_unblock_user_action\";s:5:\"label\";s:46:\"Desbloquear o(s) utilizador(es) selecionado(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:24:\"user_unblock_user_action\";s:13:\"configuration\";a:0:{}}',-1,1578481106.876,1,'','0'),('system.cron',_binary 'a:4:{s:9:\"threshold\";a:2:{s:20:\"requirements_warning\";i:172800;s:18:\"requirements_error\";i:1209600;}s:7:\"logging\";i:1;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578486712.371,1,'','0'),('system.date',_binary 'a:5:{s:7:\"country\";a:1:{s:7:\"default\";s:2:\"PT\";}s:9:\"first_day\";i:0;s:8:\"timezone\";a:2:{s:7:\"default\";s:13:\"Europe/Lisbon\";s:4:\"user\";a:3:{s:12:\"configurable\";b:1;s:4:\"warn\";b:0;s:7:\"default\";i:0;}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"V9UurX2GPT05NWKG9f2GWQqFG2TRG8vczidwjpy7Woo\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481107.246,1,'','0'),('system.file',_binary 'a:6:{s:22:\"allow_insecure_uploads\";b:0;s:14:\"default_scheme\";s:6:\"public\";s:4:\"path\";a:1:{s:9:\"temporary\";s:4:\"/tmp\";}s:21:\"temporary_maximum_age\";i:21600;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t48gCU9DzYfjb3bAOIqHLzhL0ChBlXh6_5B5Pyo9t8g\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481110.136,1,'','0'),('system.image',_binary 'a:3:{s:7:\"toolkit\";s:2:\"gd\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481112.174,1,'','0'),('system.image.gd',_binary 'a:3:{s:12:\"jpeg_quality\";i:75;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495088.935,1,'','0'),('system.logging',_binary 'a:3:{s:11:\"error_level\";s:4:\"hide\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481111.272,1,'','0'),('system.menu.account',_binary 'a:9:{s:4:\"uuid\";s:36:\"7cc317cb-62fc-4d2d-9cdf-c88c9051f074\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw\";}s:2:\"id\";s:7:\"account\";s:5:\"label\";s:17:\"User account menu\";s:11:\"description\";s:55:\"Ligações relacionadas com a conta de utilizador ativa\";s:6:\"locked\";b:1;}',-1,1578481108.433,1,'','0'),('system.menu.admin',_binary 'a:9:{s:4:\"uuid\";s:36:\"fef37ed3-ae1d-4f84-8d04-46f0d4c1b186\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0\";}s:2:\"id\";s:5:\"admin\";s:5:\"label\";s:15:\"Administração\";s:11:\"description\";s:37:\"Ligações de tarefas administrativas\";s:6:\"locked\";b:1;}',-1,1578481108.433,1,'','0'),('system.menu.backoffice',_binary 'a:8:{s:4:\"uuid\";s:36:\"4c562eee-5844-4f1d-8fd3-fe7d09cd5f39\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:10:\"backoffice\";s:5:\"label\";s:10:\"Backoffice\";s:11:\"description\";s:0:\"\";s:6:\"locked\";b:0;}',-1,1578481108.433,1,'','0'),('system.menu.devel',_binary 'a:9:{s:4:\"uuid\";s:36:\"bace8d5c-27f7-40a0-8215-66cdf4a583da\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"devel\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"3V-l1uuTcyirYOGLPZV5HWaDfr02uEbWZJIwc8Byz-c\";}s:2:\"id\";s:5:\"devel\";s:5:\"label\";s:11:\"Development\";s:11:\"description\";s:30:\"Links related to Devel module.\";s:6:\"locked\";b:1;}',-1,1578481108.433,1,'','0'),('system.menu.footer',_binary 'a:9:{s:4:\"uuid\";s:36:\"09b02c1e-a7bc-4a19-b5cc-44e343ae315f\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc\";}s:2:\"id\";s:6:\"footer\";s:5:\"label\";s:7:\"Rodapé\";s:11:\"description\";s:34:\"Ligações de informação do site\";s:6:\"locked\";b:1;}',-1,1578481108.433,1,'','0'),('system.menu.main',_binary 'a:9:{s:4:\"uuid\";s:36:\"d3ab9724-76a1-4766-b6c1-1ce9010c1433\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8\";}s:2:\"id\";s:4:\"main\";s:5:\"label\";s:15:\"Main navigation\";s:11:\"description\";s:30:\"Ligações de secção do site\";s:6:\"locked\";b:1;}',-1,1578481108.433,1,'','0'),('system.menu.tools',_binary 'a:9:{s:4:\"uuid\";s:36:\"578c7a9f-7699-4506-99a4-2757f71506dc\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc\";}s:2:\"id\";s:5:\"tools\";s:5:\"label\";s:5:\"Tools\";s:11:\"description\";s:39:\"User tool links, often added by modules\";s:6:\"locked\";b:1;}',-1,1578481108.433,1,'','0'),('system.performance',_binary 'a:7:{s:5:\"cache\";a:1:{s:4:\"page\";a:1:{s:7:\"max_age\";i:300;}}s:3:\"css\";a:2:{s:10:\"preprocess\";b:1;s:4:\"gzip\";b:1;}s:8:\"fast_404\";a:4:{s:7:\"enabled\";b:1;s:5:\"paths\";s:69:\"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i\";s:13:\"exclude_paths\";s:27:\"/\\/(?:styles|imagecache)\\//\";s:4:\"html\";s:162:\"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL \"@path\" was not found on this server.</p></body></html>\";}s:2:\"js\";a:2:{s:10:\"preprocess\";b:1;s:4:\"gzip\";b:1;}s:20:\"stale_file_threshold\";i:2592000;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.856,1,'','0'),('system.site',_binary 'a:11:{s:4:\"uuid\";s:36:\"8a14cb6f-21dc-40da-a1c9-8f0ab8a51c1c\";s:4:\"name\";s:38:\"Clínica Medicina Dentária do Castelo\";s:4:\"mail\";s:21:\"pmctenreiro@gmail.com\";s:6:\"slogan\";s:0:\"\";s:4:\"page\";a:3:{i:403;s:0:\"\";i:404;s:0:\"\";s:5:\"front\";s:7:\"/node/2\";}s:18:\"admin_compact_mode\";b:0;s:17:\"weight_select_max\";i:100;s:8:\"langcode\";s:5:\"pt-pt\";s:16:\"default_langcode\";s:5:\"pt-pt\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yTxtFqBHnEWxQswuWvkjE8mKw2t8oKuCL1q8KnfHuGE\";}s:17:\"mail_notification\";s:0:\"\";}',-1,1578481108.980,1,'','0'),('system.theme',_binary 'a:4:{s:5:\"admin\";s:5:\"seven\";s:7:\"default\";s:14:\"clidentcastelo\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fOjer9hADYYnbCJVZMFZIIM1azTFWyg84ZkFDHfAbUg\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481108.984,1,'','0'),('system.theme.global',_binary 'a:5:{s:7:\"favicon\";a:4:{s:8:\"mimetype\";s:24:\"image/vnd.microsoft.icon\";s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:1;}s:4:\"logo\";a:3:{s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481109.067,1,'','0'),('taxonomy.settings',_binary 'a:5:{s:20:\"maintain_index_table\";b:1;s:17:\"override_selector\";b:0;s:20:\"terms_per_page_admin\";i:100;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495123.649,1,'','0'),('taxonomy.vocabulary.parcerias',_binary 'a:8:{s:4:\"uuid\";s:36:\"68db1957-a9a8-4074-982d-6c202c63bb6a\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:4:\"name\";s:9:\"Parcerias\";s:3:\"vid\";s:9:\"parcerias\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;}',-1,1578481107.085,1,'','0'),('taxonomy.vocabulary.servicos',_binary 'a:8:{s:4:\"uuid\";s:36:\"39fbcfe9-2158-4e50-843f-f60aa2f85633\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:4:\"name\";s:9:\"Serviços\";s:3:\"vid\";s:8:\"servicos\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;}',-1,1578481107.085,1,'','0'),('user.flood',_binary 'a:7:{s:8:\"uid_only\";b:0;s:8:\"ip_limit\";i:50;s:9:\"ip_window\";i:3600;s:10:\"user_limit\";i:5;s:11:\"user_window\";i:21600;s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495024.943,1,'','0'),('user.role.administrator',_binary 'a:10:{s:4:\"uuid\";s:36:\"d79a6508-910c-4ea9-8091-b2f2ab9e9381\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Om6FEO7vZZMkPIbVvfxtdkWerQ2PvQM4sWUd6Q3ZnfI\";}s:2:\"id\";s:13:\"administrator\";s:5:\"label\";s:13:\"Administrador\";s:6:\"weight\";i:2;s:8:\"is_admin\";b:1;s:11:\"permissions\";a:0:{}}',-1,1578481108.430,1,'','0'),('user.role.anonymous',_binary 'a:10:{s:4:\"uuid\";s:36:\"961c5660-e49a-4c86-bf74-bd3c7c6f92c7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"pq_mEIu_B4widZN7Ap81iCJSjShFFdcL0jEiCi8VrDk\";}s:2:\"id\";s:9:\"anonymous\";s:5:\"label\";s:19:\"Utilizador anónimo\";s:6:\"weight\";i:0;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:7:{i:0;s:15:\"access comments\";i:1;s:14:\"access content\";i:2;s:11:\"access kint\";i:3;s:29:\"access site-wide contact form\";i:4;s:34:\"display eu cookie compliance popup\";i:5;s:14:\"search content\";i:6;s:31:\"use text format restricted_html\";}}',-1,1578481108.430,1,'','0'),('user.role.authenticated',_binary 'a:10:{s:4:\"uuid\";s:36:\"12b35b38-e1b0-49b3-9b8d-f32ba3debb97\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"btW6TFHajhy7Eo6YUvdFiPh4TcPggo8GBXYctjV6zag\";}s:2:\"id\";s:13:\"authenticated\";s:5:\"label\";s:22:\"Utilizador autenticado\";s:6:\"weight\";i:1;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:10:{i:0;s:15:\"access comments\";i:1;s:14:\"access content\";i:2;s:11:\"access kint\";i:3;s:16:\"access shortcuts\";i:4;s:29:\"access site-wide contact form\";i:5;s:34:\"display eu cookie compliance popup\";i:6;s:13:\"post comments\";i:7;s:14:\"search content\";i:8;s:21:\"skip comment approval\";i:9;s:26:\"use text format basic_html\";}}',-1,1578481108.430,1,'','0'),('user.role.colaborador',_binary 'a:9:{s:4:\"uuid\";s:36:\"9af40685-9bb1-47e9-940f-d65b0aa50bb7\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:11:\"colaborador\";s:5:\"label\";s:11:\"Colaborador\";s:6:\"weight\";i:3;s:8:\"is_admin\";N;s:11:\"permissions\";a:35:{i:0;s:21:\"access draggableviews\";i:1;s:24:\"access taxonomy overview\";i:2;s:26:\"bypass honeypot protection\";i:3;s:21:\"create equipa content\";i:4;s:23:\"create noticias content\";i:5;s:19:\"create page content\";i:6;s:23:\"create parceria content\";i:7;s:24:\"create slideshow content\";i:8;s:25:\"create terms in parcerias\";i:9;s:24:\"create terms in servicos\";i:10;s:25:\"delete any equipa content\";i:11;s:27:\"delete any noticias content\";i:12;s:27:\"delete any parceria content\";i:13;s:28:\"delete any slideshow content\";i:14;s:25:\"delete own equipa content\";i:15;s:27:\"delete own noticias content\";i:16;s:23:\"delete own page content\";i:17;s:27:\"delete own parceria content\";i:18;s:28:\"delete own slideshow content\";i:19;s:25:\"delete terms in parcerias\";i:20;s:24:\"delete terms in servicos\";i:21;s:23:\"edit any equipa content\";i:22;s:25:\"edit any noticias content\";i:23;s:21:\"edit any page content\";i:24;s:25:\"edit any parceria content\";i:25;s:26:\"edit any slideshow content\";i:26;s:23:\"edit own equipa content\";i:27;s:25:\"edit own noticias content\";i:28;s:21:\"edit own page content\";i:29;s:25:\"edit own parceria content\";i:30;s:26:\"edit own slideshow content\";i:31;s:23:\"edit terms in parcerias\";i:32;s:22:\"edit terms in servicos\";i:33;s:25:\"use text format full_html\";i:34;s:28:\"view own unpublished content\";}}',-1,1578481108.430,1,'','0'),('user.settings',_binary 'a:9:{s:9:\"anonymous\";s:8:\"Anónimo\";s:11:\"verify_mail\";b:1;s:6:\"notify\";a:8:{s:14:\"cancel_confirm\";b:1;s:14:\"password_reset\";b:1;s:16:\"status_activated\";b:1;s:14:\"status_blocked\";b:0;s:15:\"status_canceled\";b:0;s:22:\"register_admin_created\";b:1;s:29:\"register_no_approval_required\";b:1;s:25:\"register_pending_approval\";b:1;}s:8:\"register\";s:10:\"admin_only\";s:13:\"cancel_method\";s:17:\"user_cancel_block\";s:22:\"password_reset_timeout\";i:86400;s:17:\"password_strength\";b:1;s:8:\"langcode\";s:5:\"pt-pt\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"w314Zp7B4NbrlV4KeeZLNSmTTpdJiv-KwZO2E1fSSK0\";}}',-1,1578481107.151,1,'','0'),('views.settings',_binary 'a:7:{s:17:\"display_extenders\";a:0:{}s:10:\"skip_cache\";b:0;s:13:\"sql_signature\";b:0;s:2:\"ui\";a:3:{s:4:\"show\";a:7:{s:18:\"additional_queries\";b:0;s:15:\"advanced_column\";b:0;s:14:\"master_display\";b:0;s:22:\"performance_statistics\";b:0;s:19:\"preview_information\";b:1;s:9:\"sql_query\";a:2:{s:7:\"enabled\";b:0;s:5:\"where\";s:5:\"above\";}s:13:\"display_embed\";b:0;}s:19:\"always_live_preview\";b:1;s:24:\"exposed_filter_any_label\";s:7:\"old_any\";}s:22:\"field_rewrite_elements\";a:29:{s:3:\"div\";s:3:\"DIV\";s:4:\"span\";s:4:\"SPAN\";s:2:\"h1\";s:2:\"H1\";s:2:\"h2\";s:2:\"H2\";s:2:\"h3\";s:2:\"H3\";s:2:\"h4\";s:2:\"H4\";s:2:\"h5\";s:2:\"H5\";s:2:\"h6\";s:2:\"H6\";s:1:\"p\";s:1:\"P\";s:6:\"header\";s:6:\"HEADER\";s:6:\"footer\";s:6:\"FOOTER\";s:7:\"article\";s:7:\"ARTICLE\";s:7:\"section\";s:7:\"SECTION\";s:5:\"aside\";s:5:\"ASIDE\";s:7:\"details\";s:7:\"DETAILS\";s:10:\"blockquote\";s:10:\"BLOCKQUOTE\";s:6:\"figure\";s:6:\"FIGURE\";s:7:\"address\";s:7:\"ADDRESS\";s:4:\"code\";s:4:\"CODE\";s:3:\"pre\";s:3:\"PRE\";s:3:\"var\";s:3:\"VAR\";s:4:\"samp\";s:4:\"SAMP\";s:3:\"kbd\";s:3:\"KBD\";s:6:\"strong\";s:6:\"STRONG\";s:2:\"em\";s:2:\"EM\";s:3:\"del\";s:3:\"DEL\";s:3:\"ins\";s:3:\"INS\";s:1:\"q\";s:1:\"Q\";s:1:\"s\";s:1:\"S\";}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"RaRd9EIcwA4u3qCSRLL8EnCicbda1kV__ASmVbyehvQ\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578481106.638,1,'','0'),('views.view.archive',_binary 'a:14:{s:4:\"uuid\";s:36:\"e30fb0ba-b72d-475f-8f15-9810715e51fe\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SRH1EhxAiIRj01P9xYv0h_LfIfWxjll0Yq-eDfjziFI\";}s:2:\"id\";s:7:\"archive\";s:5:\"label\";s:7:\"Archive\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:22:\"All content, by month.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:1:\"8\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:5:\"title\";s:15:\"Monthly archive\";s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:5:\"order\";s:4:\"DESC\";s:9:\"plugin_id\";s:4:\"date\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";}}s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:13:{s:2:\"id\";s:18:\"created_year_month\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:18:\"created_year_month\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:1;s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:7:\"summary\";a:2:{s:10:\"sort_order\";s:4:\"desc\";s:6:\"format\";s:15:\"default_summary\";}s:15:\"summary_options\";a:2:{s:8:\"override\";b:1;s:14:\"items_per_page\";i:30;}s:18:\"specify_validation\";b:1;s:9:\"plugin_id\";s:15:\"date_year_month\";s:11:\"entity_type\";s:4:\"node\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:0;s:6:\"expose\";a:1:{s:8:\"operator\";s:1:\"0\";}s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:8:\"language\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:6:\"fields\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:1:{s:9:\"arguments\";b:0;}s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:13:{s:2:\"id\";s:18:\"created_year_month\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:18:\"created_year_month\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:1;s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:7:\"summary\";a:1:{s:6:\"format\";s:15:\"default_summary\";}s:15:\"summary_options\";a:1:{s:14:\"items_per_page\";i:30;}s:18:\"specify_validation\";b:1;s:9:\"plugin_id\";s:15:\"date_year_month\";s:11:\"entity_type\";s:4:\"node\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:3:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:4:\"path\";s:7:\"archive\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.backoffice',_binary 'a:13:{s:4:\"uuid\";s:36:\"22abc69f-97e1-4aeb-a07e-7928c96e955e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:14:\"node.type.page\";i:2;s:23:\"user.role.administrator\";i:3;s:21:\"user.role.colaborador\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:2:\"id\";s:10:\"backoffice\";s:5:\"label\";s:10:\"Backoffice\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"role\";s:7:\"options\";a:1:{s:4:\"role\";a:2:{s:13:\"administrator\";s:13:\"administrator\";s:11:\"colaborador\";s:11:\"colaborador\";}}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:6:\"fields\";a:1:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:5:\"label\";s:0:\"\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:7:\"filters\";a:3:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:4:\"type\";a:7:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:4:\"page\";s:4:\"page\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}s:3:\"nid\";a:16:{s:2:\"id\";s:3:\"nid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"nid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"<=\";s:5:\"value\";a:3:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:1:\"0\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:11:\"placeholder\";s:0:\"\";s:15:\"min_placeholder\";s:0:\"\";s:15:\"max_placeholder\";s:0:\"\";}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"nid\";s:9:\"plugin_id\";s:7:\"numeric\";}}s:5:\"sorts\";a:0:{}s:5:\"title\";s:10:\"Backoffice\";s:6:\"header\";a:1:{s:4:\"area\";a:4:{s:2:\"id\";s:4:\"area\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:4:\"area\";s:9:\"plugin_id\";s:4:\"text\";}}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:10:\"user.roles\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:16:\"admin/backoffice\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:10:\"user.roles\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.block_content',_binary 'a:14:{s:4:\"uuid\";s:36:\"ab57685f-8407-4934-9a2f-5272a5a68d80\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BmeDSOTSaTVy5QLgxgJ5ye_ZseG5t88JXRP1apFoBkk\";}s:2:\"id\";s:13:\"block_content\";s:5:\"label\";s:20:\"Custom block library\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:30:\"Find and manage custom blocks.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:24:\"block_content_field_data\";s:10:\"base_field\";s:2:\"id\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:17:\"administer blocks\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:50;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:4:\"tags\";a:2:{s:8:\"previous\";s:12:\"‹ Previous\";s:4:\"next\";s:8:\"Next ›\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:4:{s:4:\"info\";s:4:\"info\";s:4:\"type\";s:4:\"type\";s:7:\"changed\";s:7:\"changed\";s:10:\"operations\";s:10:\"operations\";}s:4:\"info\";a:4:{s:4:\"info\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"operations\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"changed\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:4:{s:4:\"info\";a:37:{s:2:\"id\";s:4:\"info\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"info\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:17:\"Block description\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";N;s:12:\"entity_field\";s:4:\"info\";s:9:\"plugin_id\";s:5:\"field\";}s:4:\"type\";a:37:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Block type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:5:\"field\";}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:7:\"changed\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:9:\"plugin_id\";s:5:\"field\";}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:13:\"block_content\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;s:11:\"entity_type\";s:13:\"block_content\";s:9:\"plugin_id\";s:17:\"entity_operations\";}}s:7:\"filters\";a:3:{s:4:\"info\";a:16:{s:2:\"id\";s:4:\"info\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"info\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:7:\"info_op\";s:5:\"label\";s:17:\"Block description\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"info_op\";s:10:\"identifier\";s:4:\"info\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"info\";s:9:\"plugin_id\";s:6:\"string\";}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:10:\"Block type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}s:8:\"reusable\";a:16:{s:2:\"id\";s:8:\"reusable\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:8:\"reusable\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:8:\"reusable\";s:9:\"plugin_id\";s:7:\"boolean\";}}s:5:\"sorts\";a:0:{}s:5:\"title\";s:20:\"Custom block library\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:2:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:37:\"There are no custom blocks available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}s:27:\"block_content_listing_empty\";a:10:{s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:5:\"field\";s:27:\"block_content_listing_empty\";s:10:\"group_type\";s:5:\"group\";s:2:\"id\";s:27:\"block_content_listing_empty\";s:5:\"label\";s:0:\"\";s:12:\"relationship\";s:4:\"none\";s:5:\"table\";s:13:\"block_content\";s:9:\"plugin_id\";s:27:\"block_content_listing_empty\";s:11:\"entity_type\";s:13:\"block_content\";}}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:35:\"admin/structure/block/block-content\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:20:\"Custom block library\";s:11:\"description\";s:0:\"\";s:6:\"parent\";s:19:\"block.admin_display\";s:6:\"weight\";i:0;s:7:\"context\";s:1:\"0\";s:9:\"menu_name\";s:5:\"admin\";}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.comment',_binary 'a:14:{s:4:\"uuid\";s:36:\"b8a66ed8-782a-45c9-9c86-4ddd79bec5c6\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"comment\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cCq1vjj1qmyd39oBIUyOe8YPDsobJ5fZRhp2Xy5O7lA\";}s:2:\"id\";s:7:\"comment\";s:5:\"label\";s:8:\"Comments\";s:6:\"module\";s:7:\"comment\";s:11:\"description\";s:25:\"Find and manage comments.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:18:\"comment_field_data\";s:10:\"base_field\";s:3:\"cid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:26:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:19:\"administer comments\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:14:\"items_per_page\";i:50;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ previous\";s:4:\"next\";s:8:\"next ›\";s:5:\"first\";s:8:\"« first\";s:4:\"last\";s:7:\"last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:1;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:6:{s:17:\"comment_bulk_form\";s:17:\"comment_bulk_form\";s:7:\"subject\";s:7:\"subject\";s:3:\"uid\";s:3:\"uid\";s:9:\"entity_id\";s:9:\"entity_id\";s:7:\"changed\";s:7:\"changed\";s:10:\"operations\";s:10:\"operations\";}s:4:\"info\";a:6:{s:17:\"comment_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"subject\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"uid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"entity_id\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:10:\"operations\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"changed\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:8:{s:17:\"comment_bulk_form\";a:26:{s:2:\"id\";s:17:\"comment_bulk_form\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:17:\"comment_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"include\";s:16:\"selected_actions\";a:2:{i:0;s:21:\"comment_delete_action\";i:1;s:24:\"comment_unpublish_action\";}s:9:\"plugin_id\";s:17:\"comment_bulk_form\";s:11:\"entity_type\";s:7:\"comment\";}s:7:\"subject\";a:37:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Assunto\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:17:\"comment_permalink\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:5:\"field\";}s:3:\"uid\";a:37:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Author\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:9:\"{{ uid }}\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:16:\"comment_username\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";}s:9:\"entity_id\";a:37:{s:2:\"id\";s:9:\"entity_id\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:9:\"entity_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"Posted in\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:9:\"entity_id\";s:9:\"plugin_id\";s:16:\"commented_entity\";}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;s:11:\"entity_type\";s:7:\"comment\";s:9:\"plugin_id\";s:17:\"entity_operations\";}s:6:\"name_1\";a:37:{s:2:\"id\";s:6:\"name_1\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";}}s:7:\"filters\";a:4:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";}s:7:\"subject\";a:16:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:10:\"subject_op\";s:5:\"label\";s:7:\"Assunto\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"subject_op\";s:10:\"identifier\";s:7:\"subject\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:6:\"string\";}s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:11:\"Author name\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:10:\"identifier\";s:11:\"author_name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:6:\"name_1\";s:6:\"name_1\";}s:9:\"plugin_id\";s:7:\"combine\";}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";}}s:5:\"sorts\";a:1:{s:7:\"changed\";a:13:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:4:\"date\";}}s:5:\"title\";s:8:\"Comments\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:22:\"No comments available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:1;s:13:\"use_more_text\";s:4:\"more\";s:8:\"use_ajax\";b:0;s:23:\"hide_attachment_summary\";b:0;s:16:\"show_admin_links\";b:1;s:8:\"group_by\";b:0;s:9:\"css_class\";s:0:\"\";s:13:\"relationships\";a:1:{s:3:\"uid\";a:10:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:8:\"required\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:8:\"standard\";}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}}s:14:\"cache_metadata\";a:4:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:9:\"cacheable\";b:0;s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}s:14:\"page_published\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:14:\"page_published\";s:13:\"display_title\";s:18:\"Published comments\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:4:\"path\";s:21:\"admin/content/comment\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:8:\"Comments\";s:11:\"description\";s:18:\"Comments published\";s:6:\"parent\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"context\";s:1:\"0\";s:9:\"menu_name\";s:5:\"admin\";}s:19:\"display_description\";s:30:\"The approved comments listing.\";s:17:\"display_extenders\";a:0:{}s:13:\"exposed_block\";b:0;s:15:\"display_comment\";s:0:\"\";}s:14:\"cache_metadata\";a:4:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:9:\"cacheable\";b:0;s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}s:15:\"page_unapproved\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:15:\"page_unapproved\";s:13:\"display_title\";s:19:\"Unapproved comments\";s:8:\"position\";i:2;s:15:\"display_options\";a:8:{s:4:\"path\";s:30:\"admin/content/comment/approval\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:19:\"Unapproved comments\";s:11:\"description\";s:19:\"Comments unapproved\";s:6:\"parent\";s:0:\"\";s:6:\"weight\";i:1;s:7:\"context\";s:1:\"0\";s:9:\"menu_name\";s:5:\"admin\";}s:19:\"display_description\";s:32:\"The unapproved comments listing.\";s:7:\"filters\";a:4:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";}s:7:\"subject\";a:16:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:10:\"subject_op\";s:5:\"label\";s:7:\"Assunto\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"subject_op\";s:10:\"identifier\";s:7:\"subject\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:6:\"string\";}s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:11:\"Author Name\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:10:\"identifier\";s:11:\"author_name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:6:\"name_1\";s:6:\"name_1\";}s:9:\"plugin_id\";s:7:\"combine\";}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";}}s:8:\"defaults\";a:3:{s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;s:6:\"fields\";b:0;}s:17:\"display_extenders\";a:0:{}s:6:\"fields\";a:8:{s:17:\"comment_bulk_form\";a:26:{s:2:\"id\";s:17:\"comment_bulk_form\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:17:\"comment_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"include\";s:16:\"selected_actions\";a:2:{i:0;s:21:\"comment_delete_action\";i:1;s:22:\"comment_publish_action\";}s:9:\"plugin_id\";s:17:\"comment_bulk_form\";s:11:\"entity_type\";s:7:\"comment\";}s:7:\"subject\";a:37:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Assunto\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:17:\"comment_permalink\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:5:\"field\";}s:3:\"uid\";a:37:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Author\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:9:\"{{ uid }}\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:16:\"comment_username\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";}s:9:\"entity_id\";a:37:{s:2:\"id\";s:9:\"entity_id\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:9:\"entity_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"Posted in\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:9:\"entity_id\";s:9:\"plugin_id\";s:16:\"commented_entity\";}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;s:11:\"entity_type\";s:7:\"comment\";s:9:\"plugin_id\";s:17:\"entity_operations\";}s:6:\"name_1\";a:37:{s:2:\"id\";s:6:\"name_1\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}}s:14:\"cache_metadata\";a:4:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:9:\"cacheable\";b:0;s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.comments_recent',_binary 'a:14:{s:4:\"uuid\";s:36:\"156d64bd-02e0-4f43-9765-45c7120e73d3\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:7:\"comment\";i:1;s:4:\"node\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HacS-nsDH7uyoKhQHNyV_MNRClmPVuhU_fWZgNuEyIs\";}s:2:\"id\";s:15:\"comments_recent\";s:5:\"label\";s:15:\"Recent comments\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:16:\"Recent comments.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:18:\"comment_field_data\";s:10:\"base_field\";s:3:\"cid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:14:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:15:\"access comments\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"query\";a:1:{s:4:\"type\";s:11:\"views_query\";}s:12:\"exposed_form\";a:1:{s:4:\"type\";s:5:\"basic\";}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:2:{s:22:\"default_field_elements\";b:1;s:10:\"hide_empty\";b:0;}}s:13:\"relationships\";a:1:{s:4:\"node\";a:5:{s:5:\"field\";s:4:\"node\";s:2:\"id\";s:4:\"node\";s:5:\"table\";s:18:\"comment_field_data\";s:8:\"required\";b:1;s:9:\"plugin_id\";s:8:\"standard\";}}s:6:\"fields\";a:2:{s:7:\"subject\";a:26:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:9:\"plugin_id\";s:5:\"field\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;}s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:6:\"status\";}s:11:\"status_node\";a:10:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"node\";s:2:\"id\";s:11:\"status_node\";s:9:\"plugin_id\";s:7:\"boolean\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";}}s:5:\"sorts\";a:2:{s:7:\"created\";a:12:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:9:\"plugin_id\";s:4:\"date\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"created\";}s:3:\"cid\";a:11:{s:2:\"id\";s:3:\"cid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"cid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"cid\";}}s:5:\"title\";s:15:\"Recent comments\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:11:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:7:\"content\";s:22:\"No comments available.\";s:8:\"tokenize\";b:0;s:9:\"plugin_id\";s:11:\"text_custom\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:17:\"block_description\";s:15:\"Recent comments\";s:14:\"block_category\";s:13:\"Lists (Views)\";s:5:\"allow\";a:1:{s:14:\"items_per_page\";b:1;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.content',_binary 'a:14:{s:4:\"uuid\";s:36:\"1df76a5a-c771-4a41-b065-d7cd6f62cec2\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tS8PbpJX90aRFC3-UTgXzdqkq7_2frk2pz4TMijEebM\";}s:2:\"id\";s:7:\"content\";s:5:\"label\";s:7:\"Content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:24:\"Find and manage content.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:23:\"access content overview\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"query\";a:1:{s:4:\"type\";s:11:\"views_query\";}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:50;s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ Previous\";s:4:\"next\";s:8:\"Next ›\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:1;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:10:{s:14:\"node_bulk_form\";s:14:\"node_bulk_form\";s:5:\"title\";s:5:\"title\";s:4:\"type\";s:4:\"type\";s:4:\"name\";s:4:\"name\";s:6:\"status\";s:6:\"status\";s:7:\"changed\";s:7:\"changed\";s:9:\"edit_node\";s:9:\"edit_node\";s:11:\"delete_node\";s:11:\"delete_node\";s:10:\"dropbutton\";s:10:\"dropbutton\";s:9:\"timestamp\";s:5:\"title\";}s:4:\"info\";a:10:{s:14:\"node_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:5:\"title\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:9:\"edit_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"delete_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"dropbutton\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"timestamp\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"changed\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:7:{s:14:\"node_bulk_form\";a:14:{s:2:\"id\";s:14:\"node_bulk_form\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:14:\"node_bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:14:\"node_bulk_form\";s:11:\"entity_type\";s:4:\"node\";}s:5:\"title\";a:17:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:5:\"label\";s:5:\"Title\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";}s:4:\"type\";a:37:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:12:\"Content type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:5:\"field\";}s:4:\"name\";a:17:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:5:\"label\";s:6:\"Author\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:5:\"field\";s:4:\"type\";s:9:\"user_name\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";}s:6:\"status\";a:17:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:18:\"format_custom_true\";s:9:\"Published\";s:19:\"format_custom_false\";s:11:\"Unpublished\";}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";}s:7:\"changed\";a:17:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";}s:10:\"operations\";a:23:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;s:9:\"plugin_id\";s:17:\"entity_operations\";}}s:7:\"filters\";a:5:{s:5:\"title\";a:16:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:8:\"title_op\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:8:\"title_op\";s:10:\"identifier\";s:5:\"title\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:6:\"string\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:12:\"Content type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:6:\"bundle\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:16:\"Published status\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:9:\"Published\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:11:\"Unpublished\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:8:\"language\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";}s:12:\"status_extra\";a:8:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:12:\"status_extra\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";b:0;s:9:\"plugin_id\";s:11:\"node_status\";s:5:\"group\";i:1;s:11:\"entity_type\";s:4:\"node\";}}s:5:\"sorts\";a:0:{}s:5:\"title\";s:7:\"Content\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:6:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:21:\"No content available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:9:\"arguments\";a:0:{}s:13:\"relationships\";a:1:{s:3:\"uid\";a:6:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:11:\"admin_label\";s:6:\"author\";s:8:\"required\";b:1;s:9:\"plugin_id\";s:8:\"standard\";}}s:16:\"show_admin_links\";b:0;s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"display_plugin\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:2:\"id\";s:7:\"default\";s:8:\"position\";i:0;s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:21:\"user.node_grants:view\";i:6;s:16:\"user.permissions\";}s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:15:\"display_options\";a:4:{s:4:\"path\";s:18:\"admin/content/node\";s:4:\"menu\";a:6:{s:4:\"type\";s:11:\"default tab\";s:5:\"title\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:9:\"menu_name\";s:5:\"admin\";s:6:\"weight\";i:-10;s:7:\"context\";s:0:\"\";}s:11:\"tab_options\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:7:\"Content\";s:11:\"description\";s:23:\"Find and manage content\";s:9:\"menu_name\";s:5:\"admin\";s:6:\"weight\";i:-10;}s:17:\"display_extenders\";a:0:{}}s:14:\"display_plugin\";s:4:\"page\";s:13:\"display_title\";s:4:\"Page\";s:2:\"id\";s:6:\"page_1\";s:8:\"position\";i:1;s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:21:\"user.node_grants:view\";i:6;s:16:\"user.permissions\";}s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.content_recent',_binary 'a:14:{s:4:\"uuid\";s:36:\"bad0e56f-6b30-4388-9960-57f735f89bd9\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sqwEJaSgef4rCaRMf-JdNAdV_kCICU1SfQh5Wl2sUrc\";}s:2:\"id\";s:14:\"content_recent\";s:5:\"label\";s:14:\"Recent content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:15:\"Recent content.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:22:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:2:{s:5:\"title\";a:26:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";}}s:7:\"filters\";a:2:{s:12:\"status_extra\";a:15:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:12:\"status_extra\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";b:0;s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"node_status\";}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";}}s:5:\"sorts\";a:1:{s:7:\"changed\";a:13:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:4:\"date\";}}s:5:\"title\";s:14:\"Recent content\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:21:\"No content available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:10:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:8:\"required\";b:1;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:8:\"standard\";}}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"More\";s:8:\"link_url\";s:0:\"\";s:12:\"link_display\";s:1:\"0\";}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.files',_binary 'a:14:{s:4:\"uuid\";s:36:\"dfab2f1d-1c60-4f93-bff0-bd9e39af5dad\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rRWxAX-IQkJ5viACQRovRkC784EyCl9493GU_G23n2Q\";}s:2:\"id\";s:5:\"files\";s:5:\"label\";s:5:\"Files\";s:6:\"module\";s:4:\"file\";s:11:\"description\";s:22:\"Find and manage files.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:12:\"file_managed\";s:10:\"base_field\";s:3:\"fid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:19:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:21:\"access files overview\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:50;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:4:\"tags\";a:2:{s:8:\"previous\";s:12:\"‹ Previous\";s:4:\"next\";s:8:\"Next ›\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:8:{s:3:\"fid\";s:3:\"fid\";s:8:\"filename\";s:8:\"filename\";s:8:\"filemime\";s:8:\"filemime\";s:8:\"filesize\";s:8:\"filesize\";s:6:\"status\";s:6:\"status\";s:7:\"created\";s:7:\"created\";s:7:\"changed\";s:7:\"changed\";s:5:\"count\";s:5:\"count\";}s:4:\"info\";a:8:{s:3:\"fid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"filename\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"filemime\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:8:\"filesize\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:5:\"count\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}}s:7:\"default\";s:7:\"changed\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:8:{s:3:\"fid\";a:24:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:3:\"Fid\";s:7:\"exclude\";b:1;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:3:\"fid\";}s:8:\"filename\";a:36:{s:2:\"id\";s:8:\"filename\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filename\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:4:\"Name\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"file_link\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filename\";}s:8:\"filemime\";a:25:{s:2:\"id\";s:8:\"filemime\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filemime\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"MIME type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"file_filemime\";s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filemime\";}s:8:\"filesize\";a:25:{s:2:\"id\";s:8:\"filesize\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filesize\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:4:\"Size\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"file_size\";s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filesize\";}s:6:\"status\";a:26:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:9:\"Temporary\";s:18:\"format_custom_true\";s:9:\"Permanent\";}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:6:\"status\";}s:7:\"created\";a:26:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:11:\"Upload date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:7:\"created\";}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:12:\"Changed date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:7:\"changed\";}s:5:\"count\";a:30:{s:2:\"id\";s:5:\"count\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:5:\"count\";s:12:\"relationship\";s:3:\"fid\";s:10:\"group_type\";s:3:\"sum\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Used in\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:1;s:4:\"path\";s:35:\"admin/content/files/usage/{{ fid }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:13:\"set_precision\";b:0;s:9:\"precision\";i:0;s:7:\"decimal\";s:1:\".\";s:9:\"separator\";s:1:\",\";s:13:\"format_plural\";b:1;s:20:\"format_plural_string\";s:21:\"1 place@count places\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:9:\"plugin_id\";s:7:\"numeric\";}}s:7:\"filters\";a:3:{s:8:\"filename\";a:16:{s:2:\"id\";s:8:\"filename\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filename\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:4:\"word\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:11:\"filemime_op\";s:5:\"label\";s:8:\"Filename\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"filename_op\";s:10:\"identifier\";s:8:\"filename\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:6:\"string\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filename\";}s:8:\"filemime\";a:16:{s:2:\"id\";s:8:\"filemime\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filemime\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:4:\"word\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:11:\"filemime_op\";s:5:\"label\";s:9:\"MIME type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"filemime_op\";s:10:\"identifier\";s:8:\"filemime\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:6:\"string\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filemime\";}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:9:\"status_op\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:11:\"file_status\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:6:\"status\";}}s:5:\"sorts\";a:0:{}s:5:\"title\";s:5:\"Files\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:6:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:19:\"No files available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:1;}}s:9:\"arguments\";a:0:{}s:8:\"group_by\";b:1;s:16:\"show_admin_links\";b:1;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:14:\"Files overview\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:4:\"path\";s:19:\"admin/content/files\";s:4:\"menu\";a:6:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:5:\"Files\";s:11:\"description\";s:0:\"\";s:9:\"menu_name\";s:5:\"admin\";s:6:\"weight\";i:0;s:7:\"context\";s:0:\"\";}s:19:\"display_description\";s:0:\"\";s:8:\"defaults\";a:2:{s:5:\"pager\";b:1;s:13:\"relationships\";b:0;}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:0;}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_2\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:6:\"page_2\";s:13:\"display_title\";s:10:\"File usage\";s:8:\"position\";i:2;s:15:\"display_options\";a:15:{s:19:\"display_description\";s:0:\"\";s:4:\"path\";s:27:\"admin/content/files/usage/%\";s:5:\"empty\";a:0:{}s:8:\"defaults\";a:11:{s:5:\"empty\";b:0;s:5:\"pager\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;s:6:\"fields\";b:0;s:8:\"group_by\";b:0;s:5:\"title\";b:0;s:9:\"arguments\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:13:\"relationships\";b:0;}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:4:\"tags\";a:2:{s:8:\"previous\";s:12:\"‹ Previous\";s:4:\"next\";s:8:\"Next ›\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:7:\"filters\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:0:{}}s:6:\"fields\";a:4:{s:12:\"entity_label\";a:23:{s:2:\"id\";s:12:\"entity_label\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:12:\"entity_label\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Entity\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:14:\"link_to_entity\";b:1;s:9:\"plugin_id\";s:12:\"entity_label\";}s:4:\"type\";a:22:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:11:\"Entity type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:8:\"standard\";}s:6:\"module\";a:22:{s:2:\"id\";s:6:\"module\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:6:\"module\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:18:\"Registering module\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:8:\"standard\";}s:5:\"count\";a:30:{s:2:\"id\";s:5:\"count\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:5:\"count\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"Use count\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:13:\"set_precision\";b:0;s:9:\"precision\";i:0;s:7:\"decimal\";s:1:\".\";s:9:\"separator\";s:1:\",\";s:13:\"format_plural\";b:0;s:20:\"format_plural_string\";s:8:\"1@count\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:9:\"plugin_id\";s:7:\"numeric\";}}s:8:\"group_by\";b:0;s:5:\"title\";s:10:\"File usage\";s:9:\"arguments\";a:1:{s:3:\"fid\";a:23:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:1;s:5:\"title\";s:46:\"File usage information for {{ arguments.fid }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:14:\"items_per_page\";i:25;s:8:\"override\";b:0;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;s:9:\"plugin_id\";s:8:\"file_fid\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:3:\"fid\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:4:{s:12:\"entity_label\";s:12:\"entity_label\";s:4:\"type\";s:4:\"type\";s:6:\"module\";s:6:\"module\";s:5:\"count\";s:5:\"count\";}s:4:\"info\";a:4:{s:12:\"entity_label\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:6:\"module\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:5:\"count\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:12:\"entity_label\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:0:{}}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:1;}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.frontpage',_binary 'a:14:{s:4:\"uuid\";s:36:\"df684034-95fe-4f3e-b4e8-357051cb6e6e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"core.entity_view_mode.node.rss\";i:1;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ezK5Dw8P_4bqJdDQIiecSAJak9p1Wf1yDwHzTutGFuQ\";}s:2:\"id\";s:9:\"frontpage\";s:5:\"label\";s:9:\"Frontpage\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:39:\"All content promoted to the front page.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:3:{s:16:\"area_text_custom\";a:11:{s:11:\"admin_label\";s:0:\"\";s:7:\"content\";s:181:\"No front page content has been created yet.<br/>Follow the <a target=\"_blank\" href=\"https://www.drupal.org/docs/user_guide/en/index.html\">User Guide</a> to start building your site.\";s:5:\"empty\";b:1;s:5:\"field\";s:16:\"area_text_custom\";s:10:\"group_type\";s:5:\"group\";s:2:\"id\";s:16:\"area_text_custom\";s:5:\"label\";s:0:\"\";s:12:\"relationship\";s:4:\"none\";s:5:\"table\";s:5:\"views\";s:8:\"tokenize\";b:0;s:9:\"plugin_id\";s:11:\"text_custom\";}s:18:\"node_listing_empty\";a:10:{s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:5:\"field\";s:18:\"node_listing_empty\";s:10:\"group_type\";s:5:\"group\";s:2:\"id\";s:18:\"node_listing_empty\";s:5:\"label\";s:0:\"\";s:12:\"relationship\";s:4:\"none\";s:5:\"table\";s:4:\"node\";s:9:\"plugin_id\";s:18:\"node_listing_empty\";s:11:\"entity_type\";s:4:\"node\";}s:5:\"title\";a:10:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:5:\"title\";s:22:\"Welcome to [site:name]\";s:9:\"plugin_id\";s:5:\"title\";}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:7:\"filters\";a:3:{s:7:\"promote\";a:16:{s:11:\"admin_label\";s:0:\"\";s:6:\"expose\";a:10:{s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:5:\"label\";s:0:\"\";s:8:\"multiple\";b:0;s:8:\"operator\";s:0:\"\";s:11:\"operator_id\";s:0:\"\";s:8:\"remember\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:8:\"required\";b:0;s:12:\"use_operator\";b:0;}s:7:\"exposed\";b:0;s:5:\"field\";s:7:\"promote\";s:5:\"group\";i:1;s:10:\"group_info\";a:10:{s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"description\";s:0:\"\";s:11:\"group_items\";a:0:{}s:10:\"identifier\";s:0:\"\";s:5:\"label\";s:0:\"\";s:8:\"multiple\";b:0;s:8:\"optional\";b:1;s:8:\"remember\";b:0;s:6:\"widget\";s:6:\"select\";}s:10:\"group_type\";s:5:\"group\";s:2:\"id\";s:7:\"promote\";s:10:\"is_grouped\";b:0;s:8:\"operator\";s:1:\"=\";s:12:\"relationship\";s:4:\"none\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"value\";s:1:\"1\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"promote\";}s:6:\"status\";a:9:{s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"field\";s:6:\"status\";s:5:\"group\";i:1;s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"value\";s:1:\"1\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:8:\"language\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ Previous\";s:4:\"next\";s:8:\"Next ›\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:8:\"quantity\";i:9;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"sorts\";a:2:{s:6:\"sticky\";a:12:{s:11:\"admin_label\";s:0:\"\";s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:7:\"exposed\";b:0;s:5:\"field\";s:6:\"sticky\";s:10:\"group_type\";s:5:\"group\";s:2:\"id\";s:6:\"sticky\";s:5:\"order\";s:4:\"DESC\";s:12:\"relationship\";s:4:\"none\";s:5:\"table\";s:15:\"node_field_data\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"sticky\";}s:7:\"created\";a:13:{s:5:\"field\";s:7:\"created\";s:2:\"id\";s:7:\"created\";s:5:\"order\";s:4:\"DESC\";s:5:\"table\";s:15:\"node_field_data\";s:9:\"plugin_id\";s:4:\"date\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:5:\"title\";s:0:\"\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:13:\"relationships\";a:0:{}s:6:\"fields\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"display_plugin\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:2:\"id\";s:7:\"default\";s:8:\"position\";i:0;s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:14:\"url.query_args\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"feed_1\";a:6:{s:14:\"display_plugin\";s:4:\"feed\";s:2:\"id\";s:6:\"feed_1\";s:13:\"display_title\";s:4:\"Feed\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:14:\"sitename_title\";b:1;s:4:\"path\";s:7:\"rss.xml\";s:8:\"displays\";a:2:{s:6:\"page_1\";s:6:\"page_1\";s:7:\"default\";s:0:\"\";}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:3:\"rss\";s:7:\"options\";a:3:{s:11:\"description\";s:0:\"\";s:8:\"grouping\";a:0:{}s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:8:\"node_rss\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:3:\"rss\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:28:\"languages:language_interface\";i:1;s:21:\"user.node_grants:view\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:15:\"display_options\";a:2:{s:4:\"path\";s:4:\"node\";s:17:\"display_extenders\";a:0:{}}s:14:\"display_plugin\";s:4:\"page\";s:13:\"display_title\";s:4:\"Page\";s:2:\"id\";s:6:\"page_1\";s:8:\"position\";i:1;s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:14:\"url.query_args\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.glossary',_binary 'a:14:{s:4:\"uuid\";s:36:\"2dd6a88a-00f1-41ee-88e0-9de2aea7119e\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_12Vkw1VGBz_s0_W_LLVCrBPpioNSnB6zcd1lUAQubM\";}s:2:\"id\";s:8:\"glossary\";s:5:\"label\";s:8:\"Glossary\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:23:\"All content, by letter.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:1:\"8\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:8:\"use_ajax\";b:1;s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:36;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:6:\"fields\";a:3:{s:5:\"title\";a:24:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:5:\"Title\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";}s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:5:\"label\";s:6:\"Author\";s:12:\"relationship\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";s:4:\"type\";s:9:\"user_name\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:5:\"label\";s:11:\"Last update\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";}}s:9:\"arguments\";a:1:{s:5:\"title\";a:27:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:14:\"default_action\";s:7:\"default\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"a\";}s:7:\"summary\";a:1:{s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;s:8:\"glossary\";b:1;s:5:\"limit\";i:1;s:4:\"case\";s:5:\"upper\";s:9:\"path_case\";s:5:\"lower\";s:14:\"transform_dash\";b:0;s:9:\"plugin_id\";s:6:\"string\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:0:{}s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:8:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:9:\"plugin_id\";s:8:\"standard\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:8:\"required\";b:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:7:\"columns\";a:3:{s:5:\"title\";s:5:\"title\";s:4:\"name\";s:4:\"name\";s:7:\"changed\";s:7:\"changed\";}s:7:\"default\";s:5:\"title\";s:4:\"info\";a:3:{s:5:\"title\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}s:4:\"name\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}s:7:\"changed\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;s:5:\"order\";s:3:\"asc\";s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;s:22:\"default_field_elements\";b:1;}}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:0:{}s:7:\"filters\";a:1:{s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:8:\"language\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:12:\"attachment_1\";a:6:{s:2:\"id\";s:12:\"attachment_1\";s:13:\"display_title\";s:10:\"Attachment\";s:14:\"display_plugin\";s:10:\"attachment\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:0;}}s:8:\"defaults\";a:1:{s:9:\"arguments\";b:0;}s:9:\"arguments\";a:1:{s:5:\"title\";a:27:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"a\";}s:7:\"summary\";a:1:{s:6:\"format\";s:19:\"unformatted_summary\";}s:15:\"summary_options\";a:3:{s:14:\"items_per_page\";i:25;s:6:\"inline\";b:1;s:9:\"separator\";s:3:\" | \";}s:18:\"specify_validation\";b:1;s:8:\"glossary\";b:1;s:5:\"limit\";i:1;s:4:\"case\";s:5:\"upper\";s:9:\"path_case\";s:5:\"lower\";s:14:\"transform_dash\";b:0;s:9:\"plugin_id\";s:6:\"string\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:25:\"default_argument_skip_url\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";}}s:8:\"displays\";a:2:{s:7:\"default\";s:7:\"default\";s:6:\"page_1\";s:6:\"page_1\";}s:17:\"inherit_arguments\";b:0;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:4:\"path\";s:8:\"glossary\";s:4:\"menu\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:8:\"Glossary\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.news',_binary 'a:13:{s:4:\"uuid\";s:36:\"ef90c873-57bc-4aa2-bb83-045ddf52efbf\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:18:\"node.type.noticias\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:2:\"id\";s:4:\"news\";s:5:\"label\";s:4:\"News\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:5;s:6:\"offset\";i:0;}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:2:{s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:3:\"ver\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";}s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:65:\"<i class=\"fa fa-play\" aria-hidden=\"true\"></i> {{ title__value }} \";s:9:\"make_link\";b:1;s:4:\"path\";s:15:\"{{ view_node }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:4:\"type\";a:7:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:8:\"noticias\";s:8:\"noticias\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:5:\"order\";s:4:\"DESC\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";}}s:5:\"title\";s:4:\"News\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.node_auxiliar',_binary 'a:13:{s:4:\"uuid\";s:36:\"f201f20e-0309-488a-adff-2e1f8d6b6708\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"field.storage.node.field_imagem\";i:1;s:22:\"image.style.horizontal\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:4:\"node\";i:2;s:4:\"user\";}}s:2:\"id\";s:13:\"node_auxiliar\";s:5:\"label\";s:15:\"Node - auxiliar\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:5;s:6:\"offset\";i:0;}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:1:{s:12:\"field_imagem\";a:35:{s:2:\"id\";s:12:\"field_imagem\";s:5:\"table\";s:18:\"node__field_imagem\";s:5:\"field\";s:12:\"field_imagem\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:10:\"horizontal\";s:10:\"image_link\";s:0:\"\";}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:0;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}}s:7:\"filters\";a:1:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:5:\"order\";s:4:\"DESC\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";}}s:5:\"title\";s:15:\"Node - auxiliar\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:1:{s:3:\"nid\";a:23:{s:2:\"id\";s:3:\"nid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"nid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:14:\"default_action\";s:7:\"default\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:4:\"node\";s:24:\"default_argument_options\";a:0:{}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:14:\"items_per_page\";i:25;s:8:\"override\";b:0;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"nid\";s:9:\"plugin_id\";s:8:\"node_nid\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:1:{i:0;s:38:\"config:field.storage.node.field_imagem\";}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Image\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:19:\"display_description\";s:0:\"\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:1:{i:0;s:38:\"config:field.storage.node.field_imagem\";}}}s:7:\"block_2\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_2\";s:13:\"display_title\";s:15:\"Imagem contacto\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:17:\"display_extenders\";a:0:{}s:19:\"display_description\";s:0:\"\";s:9:\"arguments\";a:1:{s:3:\"nid\";a:23:{s:2:\"id\";s:3:\"nid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"nid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:14:\"default_action\";s:7:\"default\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"7\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:14:\"items_per_page\";i:25;s:8:\"override\";b:0;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"nid\";s:9:\"plugin_id\";s:8:\"node_nid\";}}s:8:\"defaults\";a:3:{s:9:\"arguments\";b:0;s:5:\"title\";b:0;s:6:\"fields\";b:0;}s:5:\"title\";s:21:\"Marque a sua consulta\";s:6:\"fields\";a:1:{s:12:\"field_imagem\";a:35:{s:2:\"id\";s:12:\"field_imagem\";s:5:\"table\";s:18:\"node__field_imagem\";s:5:\"field\";s:12:\"field_imagem\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:9:\"image_url\";s:8:\"settings\";a:1:{s:11:\"image_style\";s:10:\"horizontal\";}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:0;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:1:{i:0;s:38:\"config:field.storage.node.field_imagem\";}}}}}',-1,1578481106.791,1,'','0'),('views.view.noticias',_binary 'a:13:{s:4:\"uuid\";s:36:\"0811051c-9541-465a-b9f9-9702b4fa809c\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:18:\"node.type.noticias\";i:2;s:22:\"system.menu.backoffice\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:2:\"id\";s:8:\"noticias\";s:5:\"label\";s:8:\"Noticias\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:4:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:14:\"items_per_page\";i:16;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ anterior\";s:4:\"next\";s:12:\"seguinte ›\";s:5:\"first\";s:15:\"‹‹ primeira\";s:4:\"last\";s:14:\"última ››\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:6:\"teaser\";}}s:6:\"fields\";a:1:{s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:4:\"type\";a:7:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:8:\"noticias\";s:8:\"noticias\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:5:\"order\";s:4:\"DESC\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";}}s:5:\"title\";s:8:\"Noticias\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_2\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_2\";s:13:\"display_title\";s:17:\"Ver mais noticias\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:17:\"display_extenders\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:4;s:6:\"offset\";i:0;}}s:8:\"defaults\";a:3:{s:5:\"pager\";b:0;s:5:\"title\";b:0;s:9:\"arguments\";b:0;}s:5:\"title\";s:19:\"Veja mais notícias\";s:9:\"arguments\";a:1:{s:3:\"nid\";a:23:{s:2:\"id\";s:3:\"nid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"nid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:14:\"default_action\";s:7:\"default\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:4:\"node\";s:24:\"default_argument_options\";a:0:{}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:14:\"items_per_page\";i:25;s:8:\"override\";b:0;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:1;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"nid\";s:9:\"plugin_id\";s:8:\"node_nid\";}}s:19:\"display_description\";s:0:\"\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:14:\"type__noticias\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:14:\"type__noticias\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:3;s:15:\"display_options\";a:9:{s:17:\"display_extenders\";a:0:{}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:4:{s:5:\"title\";s:5:\"title\";s:7:\"created\";s:7:\"created\";s:6:\"status\";s:6:\"status\";s:9:\"edit_node\";s:9:\"edit_node\";}s:4:\"info\";a:4:{s:5:\"title\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"edit_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"created\";s:11:\"empty_table\";b:0;}}s:8:\"defaults\";a:5:{s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:6:\"teaser\";}}s:6:\"fields\";a:4:{s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Titulo\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"Criado em\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";}s:6:\"status\";a:37:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Estado\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:16:\"enabled-disabled\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";}s:9:\"edit_node\";a:26:{s:2:\"id\";s:9:\"edit_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"edit_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:6:\"editar\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:16:\"entity_link_edit\";}}s:4:\"path\";s:25:\"admin/backoffice/noticias\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:8:\"Listagem\";s:11:\"description\";s:0:\"\";s:8:\"expanded\";b:0;s:6:\"parent\";s:54:\"menu_link_content:a8bb57c2-3066-49af-8f26-cada8270c66d\";s:6:\"weight\";i:0;s:7:\"context\";s:1:\"0\";s:9:\"menu_name\";s:10:\"backoffice\";}s:7:\"filters\";a:3:{s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:9:\"Pesquisar\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:10:\"identifier\";s:7:\"combine\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";s:11:\"colaborador\";s:1:\"0\";}s:11:\"placeholder\";s:0:\"\";}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:1:{s:5:\"title\";s:5:\"title\";}s:9:\"plugin_id\";s:7:\"combine\";}s:4:\"type\";a:8:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:8:\"noticias\";s:8:\"noticias\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:5:\"group\";i:1;}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:7:\"Ativado\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";s:11:\"colaborador\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.parcerias',_binary 'a:13:{s:4:\"uuid\";s:36:\"7f5dd447-e5ea-477c-bdfd-2692a2f1379b\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"core.entity_view_mode.taxonomy_term.token\";i:1;s:29:\"taxonomy.vocabulary.parcerias\";}s:6:\"module\";a:2:{i:0;s:8:\"taxonomy\";i:1;s:4:\"user\";}}s:2:\"id\";s:9:\"parcerias\";s:5:\"label\";s:9:\"Parcerias\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:24:\"taxonomy_term_field_data\";s:10:\"base_field\";s:3:\"tid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:0;s:6:\"offset\";i:0;}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:2:{s:4:\"type\";s:20:\"entity:taxonomy_term\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:5:\"token\";}}s:6:\"fields\";a:1:{s:4:\"name\";a:38:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:4:\"name\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:4:\"name\";s:5:\"label\";s:0:\"\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:9:\"term_name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:14:\"convert_spaces\";b:0;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:3:\"vid\";a:7:{s:2:\"id\";s:3:\"vid\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:3:\"vid\";s:5:\"value\";a:1:{s:9:\"parcerias\";s:9:\"parcerias\";}s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:3:\"vid\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:5:\"sorts\";a:1:{s:6:\"weight\";a:12:{s:2:\"id\";s:6:\"weight\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:6:\"weight\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:3:\"ASC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:6:\"weight\";s:9:\"plugin_id\";s:8:\"standard\";}}s:5:\"title\";s:9:\"Parcerias\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.servicos',_binary 'a:13:{s:4:\"uuid\";s:36:\"3576240f-c398-4603-a997-7e95e734b778\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"core.entity_view_mode.taxonomy_term.token\";i:1;s:28:\"taxonomy.vocabulary.servicos\";}s:6:\"module\";a:2:{i:0;s:8:\"taxonomy\";i:1;s:4:\"user\";}}s:2:\"id\";s:8:\"servicos\";s:5:\"label\";s:9:\"Serviços\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:24:\"taxonomy_term_field_data\";s:10:\"base_field\";s:3:\"tid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:4:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:16:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:1:{s:6:\"offset\";i:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;s:22:\"default_field_elements\";b:1;}}s:6:\"fields\";a:2:{s:18:\"view_taxonomy_term\";a:26:{s:2:\"id\";s:18:\"view_taxonomy_term\";s:5:\"table\";s:18:\"taxonomy_term_data\";s:5:\"field\";s:18:\"view_taxonomy_term\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:3:\"ver\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:1;s:11:\"entity_type\";s:13:\"taxonomy_term\";s:9:\"plugin_id\";s:11:\"entity_link\";}s:4:\"name\";a:38:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:64:\"<i class=\"fa fa-play\" aria-hidden=\"true\"></i> {{ name__value }} \";s:9:\"make_link\";b:1;s:4:\"path\";s:24:\"{{ view_taxonomy_term }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:14:\"convert_spaces\";b:0;s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:9:\"term_name\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:3:\"vid\";a:7:{s:2:\"id\";s:3:\"vid\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:3:\"vid\";s:5:\"value\";a:1:{s:8:\"servicos\";s:8:\"servicos\";}s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:3:\"vid\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:5:\"sorts\";a:1:{s:6:\"weight\";a:12:{s:2:\"id\";s:6:\"weight\";s:5:\"table\";s:24:\"taxonomy_term_field_data\";s:5:\"field\";s:6:\"weight\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:3:\"ASC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"entity_type\";s:13:\"taxonomy_term\";s:12:\"entity_field\";s:6:\"weight\";s:9:\"plugin_id\";s:8:\"standard\";}}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_2\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_2\";s:13:\"display_title\";s:14:\"Block services\";s:8:\"position\";i:1;s:15:\"display_options\";a:5:{s:17:\"display_extenders\";a:0:{}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:8:\"defaults\";a:2:{s:5:\"style\";b:0;s:3:\"row\";b:0;}s:3:\"row\";a:2:{s:4:\"type\";s:20:\"entity:taxonomy_term\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:5:\"token\";}}s:19:\"display_description\";s:0:\"\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_3\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_3\";s:13:\"display_title\";s:19:\"Block services home\";s:8:\"position\";i:1;s:15:\"display_options\";a:12:{s:17:\"display_extenders\";a:0:{}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:8:\"defaults\";a:9:{s:5:\"style\";b:0;s:3:\"row\";b:0;s:5:\"pager\";b:0;s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";b:0;s:12:\"link_display\";b:0;s:8:\"link_url\";b:0;s:5:\"title\";b:0;}s:3:\"row\";a:2:{s:4:\"type\";s:20:\"entity:taxonomy_term\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:5:\"token\";}}s:19:\"display_description\";s:0:\"\";s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:4;s:6:\"offset\";i:0;}}s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:27:\"Conhecer todos os serviços\";s:12:\"link_display\";s:10:\"custom_url\";s:8:\"link_url\";s:7:\"/node/4\";s:5:\"title\";s:24:\"Serviços de excelência\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.slideshow',_binary 'a:13:{s:4:\"uuid\";s:36:\"164668ba-bb06-4f09-9c60-fe3aa5e464ee\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:19:\"node.type.slideshow\";i:1;s:22:\"system.menu.backoffice\";}s:6:\"module\";a:3:{i:0;s:14:\"draggableviews\";i:1;s:4:\"node\";i:2;s:4:\"user\";}}s:2:\"id\";s:9:\"slideshow\";s:5:\"label\";s:9:\"Slideshow\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:0;s:6:\"offset\";i:0;}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:7:\"default\";}}s:6:\"fields\";a:1:{s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:4:\"type\";a:7:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:9:\"slideshow\";s:9:\"slideshow\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:5:\"sorts\";a:1:{s:6:\"weight\";a:10:{s:2:\"id\";s:6:\"weight\";s:5:\"table\";s:24:\"draggableviews_structure\";s:5:\"field\";s:6:\"weight\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:3:\"ASC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:9:\"plugin_id\";s:8:\"standard\";}}s:5:\"title\";s:9:\"Slideshow\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:15:\"type__slideshow\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:15:\"type__slideshow\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:2;s:15:\"display_options\";a:9:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:26:\"admin/backoffice/slideshow\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:9:\"Slideshow\";s:11:\"description\";s:0:\"\";s:8:\"expanded\";b:0;s:6:\"parent\";s:54:\"menu_link_content:e51e9fa8-6d98-4d2c-95ca-8d7f7160ba8b\";s:6:\"weight\";i:0;s:7:\"context\";s:1:\"0\";s:9:\"menu_name\";s:10:\"backoffice\";}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:1:{s:5:\"title\";s:5:\"title\";}s:4:\"info\";a:1:{s:5:\"title\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:2:\"-1\";s:11:\"empty_table\";b:0;}}s:8:\"defaults\";a:5:{s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:7:\"default\";}}s:6:\"fields\";a:5:{s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:14:\"draggableviews\";a:27:{s:2:\"id\";s:14:\"draggableviews\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:14:\"draggableviews\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";N;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"nid\";s:9:\"plugin_id\";s:21:\"draggable_views_field\";}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"Criado em\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";}s:6:\"status\";a:37:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Estado\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:16:\"enabled-disabled\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";}s:9:\"edit_node\";a:26:{s:2:\"id\";s:9:\"edit_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"edit_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:6:\"editar\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:16:\"entity_link_edit\";}}s:7:\"filters\";a:1:{s:4:\"type\";a:7:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:9:\"slideshow\";s:9:\"slideshow\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.taxonomy_term',_binary 'a:14:{s:4:\"uuid\";s:36:\"d987416a-11d4-4a26-9d2d-3ef3cf5228da\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:3:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Gy5PaLdfFhtFSRqJxV-DBTF5AocKgNA2CsCNNEbvx4c\";}s:2:\"id\";s:13:\"taxonomy_term\";s:5:\"label\";s:13:\"Taxonomy term\";s:6:\"module\";s:8:\"taxonomy\";s:11:\"description\";s:45:\"Content belonging to a certain taxonomy term.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:1:\"8\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:5:\"sorts\";a:2:{s:6:\"sticky\";a:10:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:6:\"sticky\";s:5:\"order\";s:4:\"DESC\";s:9:\"plugin_id\";s:8:\"standard\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}}s:7:\"created\";a:11:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:7:\"created\";s:5:\"order\";s:4:\"DESC\";s:9:\"plugin_id\";s:4:\"date\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:1:{s:3:\"tid\";a:23:{s:2:\"id\";s:3:\"tid\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:3:\"tid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:0:\"\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:1;s:5:\"title\";s:19:\"{{ arguments.tid }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:14:\"items_per_page\";i:25;s:8:\"override\";b:0;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:20:\"entity:taxonomy_term\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:4:{s:6:\"access\";b:1;s:9:\"operation\";s:4:\"view\";s:8:\"multiple\";i:0;s:7:\"bundles\";a:0:{}}s:12:\"break_phrase\";b:0;s:9:\"add_table\";b:0;s:13:\"require_value\";b:0;s:17:\"reduce_duplicates\";b:0;s:9:\"plugin_id\";s:18:\"taxonomy_index_tid\";}}s:7:\"filters\";a:2:{s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:8:\"language\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";}s:6:\"status\";a:14:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:7:\"boolean\";}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:6:\"header\";a:1:{s:20:\"entity_taxonomy_term\";a:12:{s:2:\"id\";s:20:\"entity_taxonomy_term\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:20:\"entity_taxonomy_term\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:1;s:6:\"target\";s:23:\"{{ raw_arguments.tid }}\";s:9:\"view_mode\";s:4:\"full\";s:13:\"bypass_access\";b:0;s:9:\"plugin_id\";s:6:\"entity\";}}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:6:\"fields\";a:0:{}s:17:\"display_extenders\";a:0:{}s:8:\"link_url\";s:0:\"\";s:12:\"link_display\";s:6:\"page_1\";}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"feed_1\";a:6:{s:2:\"id\";s:6:\"feed_1\";s:13:\"display_title\";s:4:\"Feed\";s:14:\"display_plugin\";s:4:\"feed\";s:8:\"position\";i:2;s:15:\"display_options\";a:8:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;}}s:4:\"path\";s:20:\"taxonomy/term/%/feed\";s:8:\"displays\";a:2:{s:6:\"page_1\";s:6:\"page_1\";s:7:\"default\";s:1:\"0\";}s:5:\"style\";a:2:{s:4:\"type\";s:3:\"rss\";s:7:\"options\";a:3:{s:11:\"description\";s:0:\"\";s:8:\"grouping\";a:0:{}s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:8:\"node_rss\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:7:\"default\";}}s:17:\"display_extenders\";a:0:{}s:7:\"enabled\";b:0;}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:4:\"path\";s:15:\"taxonomy/term/%\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.team',_binary 'a:13:{s:4:\"uuid\";s:36:\"bac6a342-03f0-4875-bd58-ddea97b4d6f4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:8:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:34:\"field.storage.node.field_descricao\";i:2;s:29:\"field.storage.node.field_foto\";i:3;s:21:\"image.style.thumbnail\";i:4;s:16:\"node.type.equipa\";i:5;s:22:\"system.menu.backoffice\";i:6;s:23:\"user.role.administrator\";i:7;s:21:\"user.role.colaborador\";}s:6:\"module\";a:4:{i:0;s:14:\"draggableviews\";i:1;s:5:\"image\";i:2;s:4:\"node\";i:3;s:4:\"user\";}}s:2:\"id\";s:4:\"team\";s:5:\"label\";s:4:\"Team\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:6:\"teaser\";}}s:6:\"fields\";a:2:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:5:\"label\";s:0:\"\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:15:\"field_descricao\";a:35:{s:2:\"id\";s:15:\"field_descricao\";s:5:\"table\";s:21:\"node__field_descricao\";s:5:\"field\";s:15:\"field_descricao\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:0:\"\";}s:5:\"group\";i:1;}s:4:\"type\";a:7:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:5:\"value\";a:1:{s:6:\"equipa\";s:6:\"equipa\";}s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";}}s:5:\"sorts\";a:1:{s:6:\"weight\";a:10:{s:2:\"id\";s:6:\"weight\";s:5:\"table\";s:24:\"draggableviews_structure\";s:5:\"field\";s:6:\"weight\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:3:\"ASC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:9:\"plugin_id\";s:8:\"standard\";}}s:6:\"header\";a:1:{s:4:\"area\";a:10:{s:2:\"id\";s:4:\"area\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:4:\"area\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:0;s:8:\"tokenize\";b:0;s:7:\"content\";a:2:{s:5:\"value\";s:48:\"Os nossos profissionais abrangem várias áreas.\";s:6:\"format\";s:10:\"basic_html\";}s:9:\"plugin_id\";s:4:\"text\";}}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}s:5:\"title\";s:23:\"Conheça a nossa equipa\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:1:{i:0;s:41:\"config:field.storage.node.field_descricao\";}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:9:\"Team list\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:19:\"display_description\";s:0:\"\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:1:{i:0;s:41:\"config:field.storage.node.field_descricao\";}}}s:12:\"type__equipa\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:12:\"type__equipa\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:2;s:15:\"display_options\";a:10:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:21:\"admin/backoffice/team\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:6:\"Equipa\";s:11:\"description\";s:0:\"\";s:8:\"expanded\";b:0;s:6:\"parent\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"context\";s:1:\"0\";s:9:\"menu_name\";s:10:\"backoffice\";}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"role\";s:7:\"options\";a:1:{s:4:\"role\";a:2:{s:13:\"administrator\";s:13:\"administrator\";s:11:\"colaborador\";s:11:\"colaborador\";}}}s:8:\"defaults\";a:6:{s:6:\"access\";b:0;s:6:\"header\";b:0;s:5:\"pager\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;}s:6:\"header\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:1:{s:6:\"offset\";i:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:2:{s:5:\"title\";s:5:\"title\";s:15:\"field_descricao\";s:15:\"field_descricao\";}s:4:\"info\";a:2:{s:5:\"title\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:15:\"field_descricao\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:2:\"-1\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:6:\"fields\";a:5:{s:10:\"field_foto\";a:35:{s:2:\"id\";s:10:\"field_foto\";s:5:\"table\";s:16:\"node__field_foto\";s:5:\"field\";s:10:\"field_foto\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:5:\"label\";s:0:\"\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:9:\"plugin_id\";s:5:\"field\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:15:\"field_descricao\";a:35:{s:2:\"id\";s:15:\"field_descricao\";s:5:\"table\";s:21:\"node__field_descricao\";s:5:\"field\";s:15:\"field_descricao\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";}s:9:\"edit_node\";a:26:{s:2:\"id\";s:9:\"edit_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"edit_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:6:\"editar\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:16:\"entity_link_edit\";}s:14:\"draggableviews\";a:27:{s:2:\"id\";s:14:\"draggableviews\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:14:\"draggableviews\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";N;s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"nid\";s:9:\"plugin_id\";s:21:\"draggable_views_field\";}}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:10:\"user.roles\";}s:4:\"tags\";a:2:{i:0;s:41:\"config:field.storage.node.field_descricao\";i:1;s:36:\"config:field.storage.node.field_foto\";}}}}}',-1,1578481106.791,1,'','0'),('views.view.user_admin_people',_binary 'a:14:{s:4:\"uuid\";s:36:\"6a7fc1af-3412-476d-940d-7fa427affa90\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"wTJRNzsLVTenCALONNlVfgm_pBOlqucSPuVFLOD56ck\";}s:2:\"id\";s:17:\"user_admin_people\";s:5:\"label\";s:6:\"People\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:50:\"Find and manage people interacting with your site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:25:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:16:\"administer users\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:14:\"items_per_page\";i:50;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";i:0;s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ Previous\";s:4:\"next\";s:8:\"Next ›\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:10:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:7:\"columns\";a:8:{s:14:\"user_bulk_form\";s:14:\"user_bulk_form\";s:4:\"name\";s:4:\"name\";s:6:\"status\";s:6:\"status\";s:3:\"rid\";s:3:\"rid\";s:7:\"created\";s:7:\"created\";s:6:\"access\";s:6:\"access\";s:9:\"edit_node\";s:9:\"edit_node\";s:10:\"dropbutton\";s:10:\"dropbutton\";}s:4:\"info\";a:8:{s:14:\"user_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:3:\"rid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"access\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:9:\"edit_node\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:10:\"dropbutton\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"created\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:8:{s:14:\"user_bulk_form\";a:23:{s:2:\"id\";s:14:\"user_bulk_form\";s:5:\"table\";s:5:\"users\";s:5:\"field\";s:14:\"user_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:11:\"Bulk update\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:14:\"user_bulk_form\";s:11:\"entity_type\";s:4:\"user\";}s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:8:\"Username\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:5:\"field\";s:4:\"type\";s:9:\"user_name\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";}s:6:\"status\";a:26:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:5:\"field\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:18:\"format_custom_true\";s:6:\"Active\";s:19:\"format_custom_false\";s:7:\"Blocked\";}s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";}s:15:\"roles_target_id\";a:24:{s:2:\"id\";s:15:\"roles_target_id\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:15:\"roles_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:5:\"Roles\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:2:\"ul\";s:9:\"separator\";s:2:\", \";s:9:\"plugin_id\";s:10:\"user_roles\";}s:7:\"created\";a:26:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Member for\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:9:\"@interval\";s:11:\"past_format\";s:9:\"@interval\";s:11:\"granularity\";i:2;}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";}s:6:\"access\";a:26:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:11:\"Last access\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;}s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:5:\"users\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:17:\"entity_operations\";}s:4:\"mail\";a:37:{s:2:\"id\";s:4:\"mail\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"mail\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"basic_string\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:9:\"plugin_id\";s:5:\"field\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"mail\";}}s:7:\"filters\";a:6:{s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:22:\"Name or email contains\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:10:\"identifier\";s:4:\"user\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:4:\"mail\";s:4:\"mail\";}s:9:\"plugin_id\";s:7:\"combine\";}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:6:\"Active\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:7:\"Blocked\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";}s:15:\"roles_target_id\";a:15:{s:2:\"id\";s:15:\"roles_target_id\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:15:\"roles_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:18:\"roles_target_id_op\";s:5:\"label\";s:4:\"Role\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:18:\"roles_target_id_op\";s:10:\"identifier\";s:4:\"role\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;s:9:\"plugin_id\";s:10:\"user_roles\";}s:10:\"permission\";a:15:{s:2:\"id\";s:10:\"permission\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:10:\"permission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:13:\"permission_op\";s:5:\"label\";s:10:\"Permission\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:13:\"permission_op\";s:10:\"identifier\";s:10:\"permission\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;s:9:\"plugin_id\";s:16:\"user_permissions\";}s:16:\"default_langcode\";a:16:{s:2:\"id\";s:16:\"default_langcode\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:16:\"default_langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:16:\"default_langcode\";s:9:\"plugin_id\";s:7:\"boolean\";}s:7:\"uid_raw\";a:15:{s:2:\"id\";s:7:\"uid_raw\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"uid_raw\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:3:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:1:\"0\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:7:\"numeric\";s:11:\"entity_type\";s:4:\"user\";}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:9:\"plugin_id\";s:4:\"date\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";}}s:5:\"title\";s:6:\"People\";s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:20:\"No people available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"more\";s:15:\"display_comment\";s:0:\"\";s:8:\"use_ajax\";b:0;s:23:\"hide_attachment_summary\";b:0;s:16:\"show_admin_links\";b:1;s:8:\"group_by\";b:0;s:8:\"link_url\";s:0:\"\";s:12:\"link_display\";s:6:\"page_1\";s:9:\"css_class\";s:0:\"\";s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:4:\"path\";s:17:\"admin/people/list\";s:16:\"show_admin_links\";b:0;s:4:\"menu\";a:6:{s:4:\"type\";s:11:\"default tab\";s:5:\"title\";s:4:\"List\";s:11:\"description\";s:50:\"Find and manage people interacting with your site.\";s:9:\"menu_name\";s:5:\"admin\";s:6:\"weight\";i:-10;s:7:\"context\";s:0:\"\";}s:11:\"tab_options\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:6:\"People\";s:11:\"description\";s:45:\"Manage user accounts, roles, and permissions.\";s:9:\"menu_name\";s:5:\"admin\";s:6:\"weight\";i:0;}s:8:\"defaults\";a:1:{s:16:\"show_admin_links\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.watchdog',_binary 'a:14:{s:4:\"uuid\";s:36:\"02709bdf-6487-47f1-87b5-1a3787439885\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"dblog\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mRpCPs9ab0M-w_gYtSyRgFco6FohGMSbiN4DH4-xAxU\";}s:2:\"id\";s:8:\"watchdog\";s:5:\"label\";s:8:\"Watchdog\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:19:\"Recent log messages\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:8:\"watchdog\";s:10:\"base_field\";s:3:\"wid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:19:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:19:\"access site reports\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:0;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:14:\"items_per_page\";i:50;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:4:\"tags\";a:2:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:25:\"{{ type }} {{ severity }}\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:8:{s:7:\"nothing\";s:7:\"nothing\";s:3:\"wid\";s:3:\"wid\";s:8:\"severity\";s:8:\"severity\";s:4:\"type\";s:4:\"type\";s:9:\"timestamp\";s:9:\"timestamp\";s:7:\"message\";s:7:\"message\";s:4:\"name\";s:4:\"name\";s:4:\"link\";s:4:\"link\";}s:4:\"info\";a:8:{s:7:\"nothing\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:3:\"wid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:8:\"severity\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:9:\"timestamp\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"message\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:4:\"link\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}}s:7:\"default\";s:3:\"wid\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:8:{s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:4:\"Icon\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:4:\"icon\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;s:9:\"plugin_id\";s:6:\"custom\";}s:3:\"wid\";a:22:{s:2:\"id\";s:3:\"wid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"wid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:3:\"WID\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:8:\"standard\";}s:8:\"severity\";a:23:{s:2:\"id\";s:8:\"severity\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:8:\"severity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:8:\"Severity\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"machine_name\";b:0;s:9:\"plugin_id\";s:12:\"machine_name\";}s:4:\"type\";a:22:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:4:\"Type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:8:\"standard\";}s:9:\"timestamp\";a:25:{s:2:\"id\";s:9:\"timestamp\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:9:\"timestamp\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:4:\"Date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:9:\"plugin_id\";s:4:\"date\";}s:7:\"message\";a:23:{s:2:\"id\";s:7:\"message\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:7:\"message\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:8:\"Mensagem\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:1;s:4:\"path\";s:35:\"admin/reports/dblog/event/{{ wid }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:13:\"{{ message }}\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:56;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:1;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:1;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"replace_variables\";b:1;s:9:\"plugin_id\";s:13:\"dblog_message\";}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:4:\"User\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";}s:4:\"link\";a:22:{s:2:\"id\";s:4:\"link\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"link\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"plugin_id\";s:16:\"dblog_operations\";}}s:7:\"filters\";a:2:{s:4:\"type\";a:14:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:1;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:11:\"dblog_types\";}s:8:\"severity\";a:14:{s:2:\"id\";s:8:\"severity\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:8:\"severity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:11:{s:11:\"operator_id\";s:11:\"severity_op\";s:5:\"label\";s:8:\"Severity\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"severity_op\";s:10:\"identifier\";s:8:\"severity\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:1;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:11:\"in_operator\";}}s:5:\"sorts\";a:1:{s:3:\"wid\";a:10:{s:2:\"id\";s:3:\"wid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"wid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:9:\"plugin_id\";s:8:\"standard\";}}s:5:\"title\";s:19:\"Recent log messages\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:4:\"area\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:26:\"No log messages available.\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:26:\"No log messages available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:8:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:4:\"User\";s:8:\"required\";b:0;s:9:\"plugin_id\";s:8:\"standard\";}}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:9:\"css_class\";s:11:\"admin-dblog\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:4:\"page\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:4:\"page\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/reports/dblog\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.who_s_new',_binary 'a:14:{s:4:\"uuid\";s:36:\"e53b587a-db5c-4fec-b48e-f571a56a26bc\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"o_8fSWHZOVIbydZACGsSX09DtuJhqkRmNOzcVj-4bQI\";}s:2:\"id\";s:9:\"who_s_new\";s:5:\"label\";s:9:\"Who\'s new\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:53:\"Shows a list of the newest user accounts on the site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:5;s:6:\"offset\";i:0;}}s:5:\"style\";a:1:{s:4:\"type\";s:9:\"html_list\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:5:\"label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:4:\"type\";s:9:\"user_name\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:1:\"0\";}s:5:\"group\";i:1;s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\">\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:10:\"1970-01-01\";s:4:\"type\";s:4:\"date\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:4:\"date\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"order\";s:4:\"DESC\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:9:\"plugin_id\";s:4:\"date\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";}}s:5:\"title\";s:9:\"Who\'s new\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:9:\"Who\'s new\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:19:\"A list of new users\";s:17:\"block_description\";s:9:\"Who\'s new\";s:14:\"block_category\";s:4:\"User\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('views.view.who_s_online',_binary 'a:14:{s:4:\"uuid\";s:36:\"1307c84b-c5fc-4f5a-b428-337d8054e947\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"m0vmYmhrzMR6S_IC0UlK0Cl-q5lEvL8-EbxbbcDtk34\";}s:2:\"id\";s:12:\"who_s_online\";s:5:\"label\";s:18:\"Who\'s online block\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:93:\"Shows the user names of the most recently active users, and the total number of active users.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:4:\"core\";s:3:\"8.x\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access user profiles\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:10;s:6:\"offset\";i:0;}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:5:\"label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:4:\"type\";s:9:\"user_name\";s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:4:\"trim\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"html\";b:0;}s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exclude\";b:0;s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:16:\"hide_alter_empty\";b:1;s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:5:\"value\";s:1:\"1\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:2:\"id\";s:6:\"status\";s:6:\"expose\";a:1:{s:8:\"operator\";s:1:\"0\";}s:5:\"group\";i:1;s:9:\"plugin_id\";s:7:\"boolean\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\">=\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:11:\"-15 minutes\";s:4:\"type\";s:6:\"offset\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:10:{s:11:\"operator_id\";s:9:\"access_op\";s:5:\"label\";s:11:\"Last access\";s:11:\"description\";s:77:\"A user is considered online for this long after they have last viewed a page.\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"access_op\";s:10:\"identifier\";s:6:\"access\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:9:\"plugin_id\";s:4:\"date\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";}}s:5:\"sorts\";a:1:{s:6:\"access\";a:13:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:5:\"order\";s:4:\"DESC\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:7:\"exposed\";b:0;s:6:\"expose\";a:1:{s:5:\"label\";s:0:\"\";}s:11:\"granularity\";s:6:\"second\";s:9:\"plugin_id\";s:4:\"date\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";}}s:5:\"title\";s:12:\"Who\'s online\";s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:0;s:7:\"content\";s:40:\"There are currently @total users online.\";s:9:\"plugin_id\";s:6:\"result\";}}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:35:\"There are currently 0 users online.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}s:18:\"who_s_online_block\";a:6:{s:14:\"display_plugin\";s:5:\"block\";s:2:\"id\";s:18:\"who_s_online_block\";s:13:\"display_title\";s:12:\"Who\'s online\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:17:\"block_description\";s:12:\"Who\'s online\";s:19:\"display_description\";s:45:\"A list of users that are currently logged in.\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:7:\"max-age\";i:-1;s:4:\"tags\";a:0:{}}}}}',-1,1578481106.791,1,'','0'),('yorkshire.settings',_binary 'a:7:{s:8:\"features\";a:3:{s:4:\"logo\";i:1;s:4:\"name\";i:1;s:7:\"favicon\";i:1;}s:4:\"logo\";a:2:{s:11:\"use_default\";i:0;s:4:\"path\";s:19:\"public://logo_2.jpg\";}s:7:\"favicon\";a:3:{s:11:\"use_default\";i:0;s:4:\"path\";s:24:\"public://favicon_0_0.jpg\";s:8:\"mimetype\";s:10:\"image/jpeg\";}s:10:\"menu_icons\";s:99:\"Administration|fa-gears\r\nHome|fa-home\r\nMy account|fa-user\r\nLog out|fa-sign-out\r\nAdd content|fa-plus\";s:4:\"skin\";s:5:\"black\";s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mdCoJ3Ix8047Dsw8vGpqcrGZtmBom6gYAuNl6e7-rHY\";}s:8:\"langcode\";s:5:\"pt-pt\";}',-1,1578495056.335,1,'','0');
/*!40000 ALTER TABLE `cache_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_container`
--

DROP TABLE IF EXISTS `cache_container`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_container` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_container`
--

LOCK TABLES `cache_container` WRITE;
/*!40000 ALTER TABLE `cache_container` DISABLE KEYS */;
INSERT INTO `cache_container` VALUES ('service_container:prod:8.7.0::Linux:a:1:{i:0;s:66:\"/var/www/html/clidentcastelo_stg/public/sites/default/services.yml\";}',_binary 'a:5:{s:7:\"aliases\";a:5:{s:32:\"Psr\\Container\\ContainerInterface\";s:17:\"service_container\";s:56:\"Symfony\\Component\\DependencyInjection\\ContainerInterface\";s:17:\"service_container\";s:19:\"config.storage.sync\";s:22:\"config.storage.staging\";s:15:\"session_handler\";s:26:\"session_handler.write_safe\";s:12:\"element_info\";s:27:\"plugin.manager.element_info\";}s:10:\"parameters\";a:22:{s:18:\"kernel.environment\";s:4:\"prod\";s:17:\"container.modules\";a:64:{s:13:\"admin_toolbar\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:52:\"modules/contrib/admin_toolbar/admin_toolbar.info.yml\";s:8:\"filename\";s:20:\"admin_toolbar.module\";}s:33:\"admin_toolbar_links_access_filter\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:106:\"modules/contrib/admin_toolbar/admin_toolbar_links_access_filter/admin_toolbar_links_access_filter.info.yml\";s:8:\"filename\";s:40:\"admin_toolbar_links_access_filter.module\";}s:19:\"admin_toolbar_tools\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:78:\"modules/contrib/admin_toolbar/admin_toolbar_tools/admin_toolbar_tools.info.yml\";s:8:\"filename\";s:26:\"admin_toolbar_tools.module\";}s:14:\"automated_cron\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:51:\"core/modules/automated_cron/automated_cron.info.yml\";s:8:\"filename\";s:21:\"automated_cron.module\";}s:8:\"big_pipe\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/big_pipe/big_pipe.info.yml\";s:8:\"filename\";s:15:\"big_pipe.module\";}s:5:\"block\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:33:\"core/modules/block/block.info.yml\";s:8:\"filename\";s:12:\"block.module\";}s:13:\"block_content\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:49:\"core/modules/block_content/block_content.info.yml\";s:8:\"filename\";s:20:\"block_content.module\";}s:10:\"breakpoint\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:43:\"core/modules/breakpoint/breakpoint.info.yml\";s:8:\"filename\";s:17:\"breakpoint.module\";}s:8:\"ckeditor\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/ckeditor/ckeditor.info.yml\";s:8:\"filename\";s:15:\"ckeditor.module\";}s:16:\"ckeditor_youtube\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:58:\"modules/contrib/ckeditor_youtube/ckeditor_youtube.info.yml\";s:8:\"filename\";N;}s:5:\"color\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:33:\"core/modules/color/color.info.yml\";s:8:\"filename\";s:12:\"color.module\";}s:7:\"comment\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:37:\"core/modules/comment/comment.info.yml\";s:8:\"filename\";s:14:\"comment.module\";}s:6:\"config\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:35:\"core/modules/config/config.info.yml\";s:8:\"filename\";s:13:\"config.module\";}s:7:\"contact\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:37:\"core/modules/contact/contact.info.yml\";s:8:\"filename\";s:14:\"contact.module\";}s:13:\"contact_block\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:52:\"modules/contrib/contact_block/contact_block.info.yml\";s:8:\"filename\";N;}s:10:\"contextual\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:43:\"core/modules/contextual/contextual.info.yml\";s:8:\"filename\";s:17:\"contextual.module\";}s:4:\"crop\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:34:\"modules/contrib/crop/crop.info.yml\";s:8:\"filename\";s:11:\"crop.module\";}s:6:\"ctools\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:38:\"modules/contrib/ctools/ctools.info.yml\";s:8:\"filename\";s:13:\"ctools.module\";}s:8:\"datetime\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/datetime/datetime.info.yml\";s:8:\"filename\";s:15:\"datetime.module\";}s:5:\"dblog\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:33:\"core/modules/dblog/dblog.info.yml\";s:8:\"filename\";s:12:\"dblog.module\";}s:5:\"devel\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:36:\"modules/contrib/devel/devel.info.yml\";s:8:\"filename\";s:12:\"devel.module\";}s:14:\"draggableviews\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:53:\"modules/custom/draggableviews/draggableviews.info.yml\";s:8:\"filename\";s:21:\"draggableviews.module\";}s:18:\"dynamic_page_cache\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:59:\"core/modules/dynamic_page_cache/dynamic_page_cache.info.yml\";s:8:\"filename\";s:25:\"dynamic_page_cache.module\";}s:6:\"editor\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:35:\"core/modules/editor/editor.info.yml\";s:8:\"filename\";s:13:\"editor.module\";}s:5:\"field\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:33:\"core/modules/field/field.info.yml\";s:8:\"filename\";s:12:\"field.module\";}s:8:\"field_ui\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/field_ui/field_ui.info.yml\";s:8:\"filename\";s:15:\"field_ui.module\";}s:4:\"file\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/file/file.info.yml\";s:8:\"filename\";s:11:\"file.module\";}s:6:\"filter\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:35:\"core/modules/filter/filter.info.yml\";s:8:\"filename\";s:13:\"filter.module\";}s:16:\"form_placeholder\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:58:\"modules/contrib/form_placeholder/form_placeholder.info.yml\";s:8:\"filename\";s:23:\"form_placeholder.module\";}s:7:\"history\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:37:\"core/modules/history/history.info.yml\";s:8:\"filename\";s:14:\"history.module\";}s:8:\"honeypot\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:42:\"modules/contrib/honeypot/honeypot.info.yml\";s:8:\"filename\";s:15:\"honeypot.module\";}s:5:\"image\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:33:\"core/modules/image/image.info.yml\";s:8:\"filename\";s:12:\"image.module\";}s:17:\"image_widget_crop\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:60:\"modules/contrib/image_widget_crop/image_widget_crop.info.yml\";s:8:\"filename\";s:24:\"image_widget_crop.module\";}s:4:\"kint\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:40:\"modules/contrib/devel/kint/kint.info.yml\";s:8:\"filename\";s:11:\"kint.module\";}s:8:\"language\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/language/language.info.yml\";s:8:\"filename\";s:15:\"language.module\";}s:4:\"link\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/link/link.info.yml\";s:8:\"filename\";s:11:\"link.module\";}s:6:\"locale\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:35:\"core/modules/locale/locale.info.yml\";s:8:\"filename\";s:13:\"locale.module\";}s:7:\"menu_ui\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:37:\"core/modules/menu_ui/menu_ui.info.yml\";s:8:\"filename\";s:14:\"menu_ui.module\";}s:7:\"metatag\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:40:\"modules/contrib/metatag/metatag.info.yml\";s:8:\"filename\";s:14:\"metatag.module\";}s:18:\"metatag_open_graph\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:70:\"modules/contrib/metatag/metatag_open_graph/metatag_open_graph.info.yml\";s:8:\"filename\";s:25:\"metatag_open_graph.module\";}s:4:\"node\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/node/node.info.yml\";s:8:\"filename\";s:11:\"node.module\";}s:7:\"options\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:37:\"core/modules/options/options.info.yml\";s:8:\"filename\";s:14:\"options.module\";}s:10:\"page_cache\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:43:\"core/modules/page_cache/page_cache.info.yml\";s:8:\"filename\";s:17:\"page_cache.module\";}s:4:\"path\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/path/path.info.yml\";s:8:\"filename\";s:11:\"path.module\";}s:9:\"quickedit\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:41:\"core/modules/quickedit/quickedit.info.yml\";s:8:\"filename\";s:16:\"quickedit.module\";}s:3:\"rdf\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:29:\"core/modules/rdf/rdf.info.yml\";s:8:\"filename\";s:10:\"rdf.module\";}s:6:\"search\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:35:\"core/modules/search/search.info.yml\";s:8:\"filename\";s:13:\"search.module\";}s:6:\"seckit\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:38:\"modules/contrib/seckit/seckit.info.yml\";s:8:\"filename\";s:13:\"seckit.module\";}s:8:\"shortcut\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/shortcut/shortcut.info.yml\";s:8:\"filename\";s:15:\"shortcut.module\";}s:7:\"support\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"modules/custom/support/support.info.yml\";s:8:\"filename\";s:14:\"support.module\";}s:17:\"switch_page_theme\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:60:\"modules/contrib/switch_page_theme/switch_page_theme.info.yml\";s:8:\"filename\";N;}s:6:\"system\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:35:\"core/modules/system/system.info.yml\";s:8:\"filename\";s:13:\"system.module\";}s:8:\"taxonomy\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/taxonomy/taxonomy.info.yml\";s:8:\"filename\";s:15:\"taxonomy.module\";}s:4:\"text\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/text/text.info.yml\";s:8:\"filename\";s:11:\"text.module\";}s:5:\"token\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:36:\"modules/contrib/token/token.info.yml\";s:8:\"filename\";s:12:\"token.module\";}s:7:\"toolbar\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:37:\"core/modules/toolbar/toolbar.info.yml\";s:8:\"filename\";s:14:\"toolbar.module\";}s:4:\"tour\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/tour/tour.info.yml\";s:8:\"filename\";s:11:\"tour.module\";}s:4:\"user\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:31:\"core/modules/user/user.info.yml\";s:8:\"filename\";s:11:\"user.module\";}s:8:\"views_ui\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:39:\"core/modules/views_ui/views_ui.info.yml\";s:8:\"filename\";s:15:\"views_ui.module\";}s:17:\"menu_link_content\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:57:\"core/modules/menu_link_content/menu_link_content.info.yml\";s:8:\"filename\";s:24:\"menu_link_content.module\";}s:8:\"pathauto\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:42:\"modules/contrib/pathauto/pathauto.info.yml\";s:8:\"filename\";s:15:\"pathauto.module\";}s:5:\"views\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:33:\"core/modules/views/views.info.yml\";s:8:\"filename\";s:12:\"views.module\";}s:8:\"standard\";a:3:{s:4:\"type\";s:7:\"profile\";s:8:\"pathname\";s:40:\"core/profiles/standard/standard.info.yml\";s:8:\"filename\";s:16:\"standard.profile\";}s:20:\"eu_cookie_compliance\";a:3:{s:4:\"type\";s:6:\"module\";s:8:\"pathname\";s:66:\"modules/contrib/eu_cookie_compliance/eu_cookie_compliance.info.yml\";s:8:\"filename\";s:27:\"eu_cookie_compliance.module\";}}s:15:\"install_profile\";s:8:\"standard\";s:20:\"container.namespaces\";a:78:{s:20:\"Drupal\\admin_toolbar\";s:33:\"modules/contrib/admin_toolbar/src\";s:40:\"Drupal\\admin_toolbar_links_access_filter\";s:67:\"modules/contrib/admin_toolbar/admin_toolbar_links_access_filter/src\";s:26:\"Drupal\\admin_toolbar_tools\";s:53:\"modules/contrib/admin_toolbar/admin_toolbar_tools/src\";s:21:\"Drupal\\automated_cron\";s:31:\"core/modules/automated_cron/src\";s:15:\"Drupal\\big_pipe\";s:25:\"core/modules/big_pipe/src\";s:12:\"Drupal\\block\";s:22:\"core/modules/block/src\";s:20:\"Drupal\\block_content\";s:30:\"core/modules/block_content/src\";s:17:\"Drupal\\breakpoint\";s:27:\"core/modules/breakpoint/src\";s:15:\"Drupal\\ckeditor\";s:25:\"core/modules/ckeditor/src\";s:23:\"Drupal\\ckeditor_youtube\";s:36:\"modules/contrib/ckeditor_youtube/src\";s:12:\"Drupal\\color\";s:22:\"core/modules/color/src\";s:14:\"Drupal\\comment\";s:24:\"core/modules/comment/src\";s:13:\"Drupal\\config\";s:23:\"core/modules/config/src\";s:14:\"Drupal\\contact\";s:24:\"core/modules/contact/src\";s:20:\"Drupal\\contact_block\";s:33:\"modules/contrib/contact_block/src\";s:17:\"Drupal\\contextual\";s:27:\"core/modules/contextual/src\";s:11:\"Drupal\\crop\";s:24:\"modules/contrib/crop/src\";s:13:\"Drupal\\ctools\";s:26:\"modules/contrib/ctools/src\";s:15:\"Drupal\\datetime\";s:25:\"core/modules/datetime/src\";s:12:\"Drupal\\dblog\";s:22:\"core/modules/dblog/src\";s:12:\"Drupal\\devel\";s:25:\"modules/contrib/devel/src\";s:21:\"Drupal\\draggableviews\";s:33:\"modules/custom/draggableviews/src\";s:25:\"Drupal\\dynamic_page_cache\";s:35:\"core/modules/dynamic_page_cache/src\";s:13:\"Drupal\\editor\";s:23:\"core/modules/editor/src\";s:12:\"Drupal\\field\";s:22:\"core/modules/field/src\";s:15:\"Drupal\\field_ui\";s:25:\"core/modules/field_ui/src\";s:11:\"Drupal\\file\";s:21:\"core/modules/file/src\";s:13:\"Drupal\\filter\";s:23:\"core/modules/filter/src\";s:23:\"Drupal\\form_placeholder\";s:36:\"modules/contrib/form_placeholder/src\";s:14:\"Drupal\\history\";s:24:\"core/modules/history/src\";s:15:\"Drupal\\honeypot\";s:28:\"modules/contrib/honeypot/src\";s:12:\"Drupal\\image\";s:22:\"core/modules/image/src\";s:24:\"Drupal\\image_widget_crop\";s:37:\"modules/contrib/image_widget_crop/src\";s:11:\"Drupal\\kint\";s:30:\"modules/contrib/devel/kint/src\";s:15:\"Drupal\\language\";s:25:\"core/modules/language/src\";s:11:\"Drupal\\link\";s:21:\"core/modules/link/src\";s:13:\"Drupal\\locale\";s:23:\"core/modules/locale/src\";s:14:\"Drupal\\menu_ui\";s:24:\"core/modules/menu_ui/src\";s:14:\"Drupal\\metatag\";s:27:\"modules/contrib/metatag/src\";s:25:\"Drupal\\metatag_open_graph\";s:46:\"modules/contrib/metatag/metatag_open_graph/src\";s:11:\"Drupal\\node\";s:21:\"core/modules/node/src\";s:14:\"Drupal\\options\";s:24:\"core/modules/options/src\";s:17:\"Drupal\\page_cache\";s:27:\"core/modules/page_cache/src\";s:11:\"Drupal\\path\";s:21:\"core/modules/path/src\";s:16:\"Drupal\\quickedit\";s:26:\"core/modules/quickedit/src\";s:10:\"Drupal\\rdf\";s:20:\"core/modules/rdf/src\";s:13:\"Drupal\\search\";s:23:\"core/modules/search/src\";s:13:\"Drupal\\seckit\";s:26:\"modules/contrib/seckit/src\";s:15:\"Drupal\\shortcut\";s:25:\"core/modules/shortcut/src\";s:14:\"Drupal\\support\";s:26:\"modules/custom/support/src\";s:24:\"Drupal\\switch_page_theme\";s:37:\"modules/contrib/switch_page_theme/src\";s:13:\"Drupal\\system\";s:23:\"core/modules/system/src\";s:15:\"Drupal\\taxonomy\";s:25:\"core/modules/taxonomy/src\";s:11:\"Drupal\\text\";s:21:\"core/modules/text/src\";s:12:\"Drupal\\token\";s:25:\"modules/contrib/token/src\";s:14:\"Drupal\\toolbar\";s:24:\"core/modules/toolbar/src\";s:11:\"Drupal\\tour\";s:21:\"core/modules/tour/src\";s:11:\"Drupal\\user\";s:21:\"core/modules/user/src\";s:15:\"Drupal\\views_ui\";s:25:\"core/modules/views_ui/src\";s:24:\"Drupal\\menu_link_content\";s:34:\"core/modules/menu_link_content/src\";s:15:\"Drupal\\pathauto\";s:28:\"modules/contrib/pathauto/src\";s:12:\"Drupal\\views\";s:22:\"core/modules/views/src\";s:15:\"Drupal\\standard\";s:26:\"core/profiles/standard/src\";s:27:\"Drupal\\eu_cookie_compliance\";s:40:\"modules/contrib/eu_cookie_compliance/src\";s:18:\"Drupal\\Core\\Action\";s:27:\"core/lib/Drupal/Core/Action\";s:18:\"Drupal\\Core\\Config\";s:27:\"core/lib/Drupal/Core/Config\";s:20:\"Drupal\\Core\\Datetime\";s:29:\"core/lib/Drupal/Core/Datetime\";s:17:\"Drupal\\Core\\Field\";s:26:\"core/lib/Drupal/Core/Field\";s:17:\"Drupal\\Core\\Block\";s:26:\"core/lib/Drupal/Core/Block\";s:16:\"Drupal\\Core\\Menu\";s:25:\"core/lib/Drupal/Core/Menu\";s:22:\"Drupal\\Core\\Validation\";s:31:\"core/lib/Drupal/Core/Validation\";s:18:\"Drupal\\Core\\Entity\";s:27:\"core/lib/Drupal/Core/Entity\";s:18:\"Drupal\\Core\\Render\";s:27:\"core/lib/Drupal/Core/Render\";s:21:\"Drupal\\Core\\TypedData\";s:30:\"core/lib/Drupal/Core/TypedData\";s:22:\"Drupal\\Core\\ProxyClass\";s:31:\"core/lib/Drupal/Core/ProxyClass\";s:21:\"Drupal\\Core\\TempStore\";s:30:\"core/lib/Drupal/Core/TempStore\";s:16:\"Drupal\\Core\\Mail\";s:25:\"core/lib/Drupal/Core/Mail\";s:27:\"Drupal\\Component\\Annotation\";s:36:\"core/lib/Drupal/Component/Annotation\";}s:23:\"language.default_values\";a:9:{s:4:\"uuid\";s:36:\"06ecc751-791a-477a-a084-c04a815b93a4\";s:8:\"langcode\";s:5:\"pt-pt\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:5:\"pt-pt\";s:5:\"label\";s:20:\"Portuguese, Portugal\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:0;s:6:\"locked\";b:0;}s:23:\"session.storage.options\";a:4:{s:14:\"gc_probability\";i:1;s:10:\"gc_divisor\";i:100;s:14:\"gc_maxlifetime\";i:200000;s:15:\"cookie_lifetime\";i:2000000;}s:11:\"twig.config\";a:3:{s:5:\"debug\";b:0;s:11:\"auto_reload\";N;s:5:\"cache\";b:1;}s:15:\"renderer.config\";a:2:{s:23:\"required_cache_contexts\";a:3:{i:0;s:28:\"languages:language_interface\";i:1;s:5:\"theme\";i:2;s:16:\"user.permissions\";}s:27:\"auto_placeholder_conditions\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:2:{i:0;s:7:\"session\";i:1;s:4:\"user\";}s:4:\"tags\";a:0:{}}}s:16:\"factory.keyvalue\";a:1:{s:7:\"default\";s:17:\"keyvalue.database\";}s:40:\"http.response.debug_cacheability_headers\";b:0;s:26:\"factory.keyvalue.expirable\";a:1:{s:7:\"default\";s:27:\"keyvalue.expirable.database\";}s:16:\"filter_protocols\";a:13:{i:0;s:4:\"http\";i:1;s:5:\"https\";i:2;s:3:\"ftp\";i:3;s:4:\"news\";i:4;s:4:\"nntp\";i:5;s:3:\"tel\";i:6;s:6:\"telnet\";i:7;s:6:\"mailto\";i:8;s:3:\"irc\";i:9;s:3:\"ssh\";i:10;s:4:\"sftp\";i:11;s:6:\"webcal\";i:12;s:4:\"rtsp\";}s:11:\"cors.config\";a:7:{s:7:\"enabled\";b:0;s:14:\"allowedHeaders\";a:0:{}s:14:\"allowedMethods\";a:0:{}s:14:\"allowedOrigins\";a:1:{i:0;s:1:\"*\";}s:14:\"exposedHeaders\";b:0;s:6:\"maxAge\";b:0;s:19:\"supportsCredentials\";b:0;}s:16:\"tempstore.expire\";i:604800;s:11:\"persist_ids\";a:4:{i:0;s:12:\"class_loader\";i:1;s:6:\"kernel\";i:2;s:13:\"request_stack\";i:3;s:22:\"router.request_context\";}s:21:\"user.tempstore.expire\";i:604800;s:22:\"main_content_renderers\";a:7:{s:4:\"html\";s:26:\"main_content_renderer.html\";s:11:\"drupal_ajax\";s:26:\"main_content_renderer.ajax\";s:12:\"iframeupload\";s:26:\"main_content_renderer.ajax\";s:13:\"drupal_dialog\";s:28:\"main_content_renderer.dialog\";s:24:\"drupal_dialog.off_canvas\";s:32:\"main_content_renderer.off_canvas\";s:28:\"drupal_dialog.off_canvas_top\";s:36:\"main_content_renderer.off_canvas_top\";s:12:\"drupal_modal\";s:27:\"main_content_renderer.modal\";}s:19:\"twig_extension_hash\";s:43:\"yHnDyGBbi9KGd-x_Y3fyWZMmT83ijBuaLySOoNtnwcc\";s:10:\"cache_bins\";a:12:{s:12:\"cache.static\";s:6:\"static\";s:15:\"cache.bootstrap\";s:9:\"bootstrap\";s:12:\"cache.config\";s:6:\"config\";s:13:\"cache.default\";s:7:\"default\";s:12:\"cache.entity\";s:6:\"entity\";s:10:\"cache.menu\";s:4:\"menu\";s:12:\"cache.render\";s:6:\"render\";s:10:\"cache.data\";s:4:\"data\";s:15:\"cache.discovery\";s:9:\"discovery\";s:24:\"cache.dynamic_page_cache\";s:18:\"dynamic_page_cache\";s:10:\"cache.page\";s:4:\"page\";s:13:\"cache.toolbar\";s:7:\"toolbar\";}s:26:\"cache_default_bin_backends\";a:4:{s:6:\"static\";s:20:\"cache.backend.memory\";s:9:\"bootstrap\";s:25:\"cache.backend.chainedfast\";s:6:\"config\";s:25:\"cache.backend.chainedfast\";s:9:\"discovery\";s:25:\"cache.backend.chainedfast\";}s:14:\"cache_contexts\";a:24:{i:0;s:7:\"cookies\";i:1;s:7:\"headers\";i:2;s:2:\"ip\";i:3;s:9:\"languages\";i:4;s:14:\"request_format\";i:5;s:5:\"route\";i:6;s:24:\"route.menu_active_trails\";i:7;s:10:\"route.name\";i:8;s:7:\"session\";i:9;s:14:\"session.exists\";i:10;s:5:\"theme\";i:11;s:8:\"timezone\";i:12;s:3:\"url\";i:13;s:8:\"url.path\";i:14;s:17:\"url.path.is_front\";i:15;s:15:\"url.path.parent\";i:16;s:14:\"url.query_args\";i:17;s:21:\"url.query_args.pagers\";i:18;s:8:\"url.site\";i:19;s:4:\"user\";i:20;s:18:\"user.is_super_user\";i:21;s:16:\"user.node_grants\";i:22;s:16:\"user.permissions\";i:23;s:10:\"user.roles\";}s:24:\"authentication_providers\";a:1:{s:6:\"cookie\";s:4:\"user\";}}s:8:\"services\";a:565:{s:17:\"service_container\";s:196:\"a:4:{s:5:\"class\";s:56:\"Symfony\\Component\\DependencyInjection\\ContainerInterface\";s:9:\"synthetic\";b:1;s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"service_container\";}}\";s:12:\"class_loader\";s:115:\"a:3:{s:9:\"synthetic\";b:1;s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"class_loader\";}}\";s:6:\"kernel\";s:172:\"a:4:{s:5:\"class\";s:44:\"Symfony\\Component\\HttpKernel\\KernelInterface\";s:9:\"synthetic\";b:1;s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:6:\"kernel\";}}\";s:16:\"cache_context.ip\";s:364:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Cache\\Context\\IpCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"cache_context.ip\";}}\";s:21:\"cache_context.headers\";s:374:\"a:4:{s:5:\"class\";s:45:\"Drupal\\Core\\Cache\\Context\\HeadersCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"cache_context.headers\";}}\";s:21:\"cache_context.cookies\";s:374:\"a:4:{s:5:\"class\";s:45:\"Drupal\\Core\\Cache\\Context\\CookiesCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"cache_context.cookies\";}}\";s:21:\"cache_context.session\";s:374:\"a:4:{s:5:\"class\";s:45:\"Drupal\\Core\\Cache\\Context\\SessionCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"cache_context.session\";}}\";s:28:\"cache_context.session.exists\";s:500:\"a:4:{s:5:\"class\";s:51:\"Drupal\\Core\\Cache\\Context\\SessionExistsCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"session_configuration\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:28:\"cache_context.session.exists\";}}\";s:28:\"cache_context.request_format\";s:387:\"a:4:{s:5:\"class\";s:51:\"Drupal\\Core\\Cache\\Context\\RequestFormatCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:28:\"cache_context.request_format\";}}\";s:17:\"cache_context.url\";s:366:\"a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\Cache\\Context\\UrlCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"cache_context.url\";}}\";s:22:\"cache_context.url.site\";s:372:\"a:4:{s:5:\"class\";s:42:\"Drupal\\Core\\Cache\\Context\\SiteCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"cache_context.url.site\";}}\";s:22:\"cache_context.url.path\";s:372:\"a:4:{s:5:\"class\";s:42:\"Drupal\\Core\\Cache\\Context\\PathCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"cache_context.url.path\";}}\";s:29:\"cache_context.url.path.parent\";s:385:\"a:4:{s:5:\"class\";s:48:\"Drupal\\Core\\Cache\\Context\\PathParentCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:29:\"cache_context.url.path.parent\";}}\";s:31:\"cache_context.url.path.is_front\";s:387:\"a:4:{s:5:\"class\";s:49:\"Drupal\\Core\\Cache\\Context\\IsFrontPathCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"path.matcher\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:31:\"cache_context.url.path.is_front\";}}\";s:28:\"cache_context.url.query_args\";s:383:\"a:4:{s:5:\"class\";s:47:\"Drupal\\Core\\Cache\\Context\\QueryArgsCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:28:\"cache_context.url.query_args\";}}\";s:35:\"cache_context.url.query_args.pagers\";s:387:\"a:4:{s:5:\"class\";s:44:\"Drupal\\Core\\Cache\\Context\\PagersCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:35:\"cache_context.url.query_args.pagers\";}}\";s:19:\"cache_context.route\";s:376:\"a:4:{s:5:\"class\";s:43:\"Drupal\\Core\\Cache\\Context\\RouteCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"current_route_match\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"cache_context.route\";}}\";s:24:\"cache_context.route.name\";s:385:\"a:4:{s:5:\"class\";s:47:\"Drupal\\Core\\Cache\\Context\\RouteNameCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"current_route_match\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:24:\"cache_context.route.name\";}}\";s:38:\"cache_context.route.menu_active_trails\";s:444:\"a:4:{s:5:\"class\";s:54:\"Drupal\\Core\\Cache\\Context\\MenuActiveTrailsCacheContext\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:38:\"cache_context.route.menu_active_trails\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:18:\"cache_context.user\";s:367:\"a:4:{s:5:\"class\";s:42:\"Drupal\\Core\\Cache\\Context\\UserCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"cache_context.user\";}}\";s:30:\"cache_context.user.permissions\";s:516:\"a:4:{s:5:\"class\";s:56:\"Drupal\\Core\\Cache\\Context\\AccountPermissionsCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"user_permissions_hash_generator\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:30:\"cache_context.user.permissions\";}}\";s:24:\"cache_context.user.roles\";s:378:\"a:4:{s:5:\"class\";s:47:\"Drupal\\Core\\Cache\\Context\\UserRolesCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:24:\"cache_context.user.roles\";}}\";s:32:\"cache_context.user.is_super_user\";s:388:\"a:4:{s:5:\"class\";s:49:\"Drupal\\Core\\Cache\\Context\\IsSuperUserCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:32:\"cache_context.user.is_super_user\";}}\";s:23:\"cache_context.languages\";s:381:\"a:4:{s:5:\"class\";s:47:\"Drupal\\Core\\Cache\\Context\\LanguagesCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:23:\"cache_context.languages\";}}\";s:19:\"cache_context.theme\";s:370:\"a:4:{s:5:\"class\";s:43:\"Drupal\\Core\\Cache\\Context\\ThemeCacheContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"theme.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"cache_context.theme\";}}\";s:22:\"cache_context.timezone\";s:171:\"a:3:{s:5:\"class\";s:46:\"Drupal\\Core\\Cache\\Context\\TimeZoneCacheContext\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"cache_context.timezone\";}}\";s:13:\"cache_factory\";s:689:\"a:5:{s:5:\"class\";s:30:\"Drupal\\Core\\Cache\\CacheFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:26:\"cache_default_bin_backends\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:13:\"cache_factory\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:22:\"cache_contexts_manager\";s:463:\"a:4:{s:5:\"class\";s:46:\"Drupal\\Core\\Cache\\Context\\CacheContextsManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:14:\"cache_contexts\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"cache_contexts_manager\";}}\";s:22:\"cache_tags.invalidator\";s:890:\"a:4:{s:5:\"class\";s:38:\"Drupal\\Core\\Cache\\CacheTagsInvalidator\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"cache_tags.invalidator\";}s:5:\"calls\";a:3:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:1;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:2;a:2:{i:0;s:14:\"addInvalidator\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"cache_tags.invalidator.checksum\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:31:\"cache_tags.invalidator.checksum\";s:376:\"a:4:{s:5:\"class\";s:43:\"Drupal\\Core\\Cache\\DatabaseCacheTagsChecksum\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:31:\"cache_tags.invalidator.checksum\";}}\";s:25:\"cache.backend.chainedfast\";s:619:\"a:5:{s:5:\"class\";s:43:\"Drupal\\Core\\Cache\\ChainedFastBackendFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"cache.backend.chainedfast\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:22:\"cache.backend.database\";s:586:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Cache\\DatabaseBackendFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"cache_tags.invalidator.checksum\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"cache.backend.database\";}}\";s:18:\"cache.backend.apcu\";s:579:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Cache\\ApcuBackendFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:9:\"site.path\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"cache_tags.invalidator.checksum\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"cache.backend.apcu\";}}\";s:17:\"cache.backend.php\";s:378:\"a:4:{s:5:\"class\";s:35:\"Drupal\\Core\\Cache\\PhpBackendFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"cache_tags.invalidator.checksum\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"cache.backend.php\";}}\";s:20:\"cache.backend.memory\";s:161:\"a:3:{s:5:\"class\";s:38:\"Drupal\\Core\\Cache\\MemoryBackendFactory\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"cache.backend.memory\";}}\";s:12:\"cache.static\";s:332:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:6:\"static\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"cache.static\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:15:\"cache.bootstrap\";s:338:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:9:\"bootstrap\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:15:\"cache.bootstrap\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:12:\"cache.config\";s:332:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:6:\"config\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"cache.config\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:13:\"cache.default\";s:334:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:7:\"default\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:13:\"cache.default\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:12:\"cache.entity\";s:332:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:6:\"entity\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"cache.entity\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:10:\"cache.menu\";s:328:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:4:\"menu\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:10:\"cache.menu\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:12:\"cache.render\";s:332:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:6:\"render\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"cache.render\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:10:\"cache.data\";s:328:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:4:\"data\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:10:\"cache.data\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:15:\"cache.discovery\";s:338:\"a:5:{s:5:\"class\";s:39:\"Drupal\\Core\\Cache\\CacheBackendInterface\";s:9:\"arguments\";a:1:{i:0;s:9:\"discovery\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:15:\"cache.discovery\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:31:\"cache_router_rebuild_subscriber\";s:190:\"a:3:{s:5:\"class\";s:56:\"Drupal\\Core\\EventSubscriber\\CacheRouterRebuildSubscriber\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:31:\"cache_router_rebuild_subscriber\";}}\";s:25:\"page_cache_request_policy\";s:663:\"a:5:{s:5:\"class\";s:42:\"Drupal\\Core\\PageCache\\DefaultRequestPolicy\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"session_configuration\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"page_cache_request_policy\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:9:\"addPolicy\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:52:\"toolbar.page_cache_request_policy.allow_toolbar_path\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:26:\"page_cache_response_policy\";s:458:\"a:4:{s:5:\"class\";s:52:\"Drupal\\Core\\ProxyClass\\PageCache\\ChainResponsePolicy\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:56:\"drupal.proxy_original_service.page_cache_response_policy\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:26:\"page_cache_response_policy\";}}\";s:22:\"page_cache_kill_switch\";s:172:\"a:3:{s:5:\"class\";s:47:\"Drupal\\Core\\PageCache\\ResponsePolicy\\KillSwitch\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"page_cache_kill_switch\";}}\";s:14:\"config.manager\";s:1003:\"a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Config\\ConfigManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"config.typed\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"string_translation\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.storage\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"event_dispatcher\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"entity.repository\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:7;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"config.manager\";}}\";s:14:\"config.factory\";s:830:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Config\\ConfigFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.storage\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"event_dispatcher\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"config.typed\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"config.factory\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:11:\"addOverride\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:32:\"language.config_factory_override\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:26:\"config.importer_subscriber\";s:186:\"a:3:{s:5:\"class\";s:57:\"Drupal\\Core\\Config\\Importer\\FinalMissingContentSubscriber\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:26:\"config.importer_subscriber\";}}\";s:16:\"config.installer\";s:431:\"a:4:{s:5:\"class\";s:45:\"Drupal\\Core\\ProxyClass\\Config\\ConfigInstaller\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:46:\"drupal.proxy_original_service.config.installer\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"config.installer\";}}\";s:14:\"config.storage\";s:828:\"a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Config\\CachedStorage\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__iippmE3zvNM7poZWNLe9KCo1TBvrcSIYWA79dl3VOK4\";s:5:\"value\";a:4:{s:5:\"class\";s:34:\"Drupal\\Core\\Config\\DatabaseStorage\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}i:1;s:6:\"config\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;}s:6:\"shared\";b:0;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"cache.config\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"config.storage\";}}\";s:22:\"config.storage.staging\";s:242:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Core\\Config\\FileStorage\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"config.storage.staging\";}s:7:\"factory\";a:2:{i:0;s:37:\"Drupal\\Core\\Config\\FileStorageFactory\";i:1;s:7:\"getSync\";}}\";s:23:\"config.storage.snapshot\";s:386:\"a:4:{s:5:\"class\";s:34:\"Drupal\\Core\\Config\\DatabaseStorage\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}i:1;s:15:\"config_snapshot\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:23:\"config.storage.snapshot\";}}\";s:21:\"config.storage.schema\";s:435:\"a:4:{s:5:\"class\";s:42:\"Drupal\\Core\\Config\\ExtensionInstallStorage\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.storage\";s:15:\"invalidBehavior\";i:1;}i:1;s:13:\"config/schema\";i:2;s:0:\"\";i:3;b:1;i:4;s:8:\"standard\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"config.storage.schema\";}}\";s:12:\"config.typed\";s:1061:\"a:5:{s:5:\"class\";s:37:\"Drupal\\Core\\Config\\TypedConfigManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.storage\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"config.storage.schema\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"config.typed\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:30:\"setValidationConstraintManager\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"validation.constraint\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:15:\"context.handler\";s:159:\"a:3:{s:5:\"class\";s:41:\"Drupal\\Core\\Plugin\\Context\\ContextHandler\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:15:\"context.handler\";}}\";s:18:\"context.repository\";s:505:\"a:4:{s:5:\"class\";s:48:\"Drupal\\Core\\Plugin\\Context\\LazyContextRepository\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;a:3:{i:0;s:33:\"language.current_language_context\";i:1;s:23:\"node.node_route_context\";i:2;s:25:\"user.current_user_context\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"context.repository\";}}\";s:4:\"cron\";s:388:\"a:4:{s:5:\"class\";s:27:\"Drupal\\Core\\ProxyClass\\Cron\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:34:\"drupal.proxy_original_service.cron\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:4:\"cron\";}}\";s:14:\"diff.formatter\";s:353:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Core\\Diff\\DiffFormatter\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"diff.formatter\";}}\";s:8:\"database\";s:267:\"a:5:{s:5:\"class\";s:31:\"Drupal\\Core\\Database\\Connection\";s:9:\"arguments\";a:1:{i:0;s:7:\"default\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:8:\"database\";}s:7:\"factory\";a:2:{i:0;s:29:\"Drupal\\Core\\Database\\Database\";i:1;s:13:\"getConnection\";}}\";s:16:\"database.replica\";s:276:\"a:5:{s:5:\"class\";s:31:\"Drupal\\Core\\Database\\Connection\";s:9:\"arguments\";a:1:{i:0;s:7:\"replica\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"database.replica\";}s:7:\"factory\";a:2:{i:0;s:29:\"Drupal\\Core\\Database\\Database\";i:1;s:13:\"getConnection\";}}\";s:28:\"database.replica_kill_switch\";s:571:\"a:4:{s:5:\"class\";s:38:\"Drupal\\Core\\Database\\ReplicaKillSwitch\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"datetime.time\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:7:\"session\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:28:\"database.replica_kill_switch\";}}\";s:13:\"datetime.time\";s:351:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Component\\Datetime\\Time\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:13:\"datetime.time\";}}\";s:11:\"file_system\";s:565:\"a:4:{s:5:\"class\";s:27:\"Drupal\\Core\\File\\FileSystem\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:22:\"stream_wrapper_manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"logger.channel.file\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:11:\"file_system\";}}\";s:12:\"form_builder\";s:2413:\"a:4:{s:5:\"class\";s:28:\"Drupal\\Core\\Form\\FormBuilder\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:10:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"form_validator\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"form_submitter\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__PD3YmWYK-ozn4oUDwsLM6JbLqdgT2Qz4ywy4C3BTrxI\";s:5:\"value\";a:4:{s:5:\"class\";s:26:\"Drupal\\Core\\Form\\FormCache\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"keyvalue.expirable\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"csrf_token\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"logger.channel.form\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"page_cache_request_policy\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:8;}s:6:\"shared\";b:0;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"event_dispatcher\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.element_info\";s:15:\"invalidBehavior\";i:1;}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"theme.manager\";s:15:\"invalidBehavior\";i:1;}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"csrf_token\";s:15:\"invalidBehavior\";i:3;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:10;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"form_builder\";}}\";s:14:\"form_validator\";s:785:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Core\\Form\\FormValidator\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"string_translation\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"csrf_token\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"logger.channel.form\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"form_error_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"form_validator\";}}\";s:14:\"form_submitter\";s:457:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Core\\Form\\FormSubmitter\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"url_generator\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"form_submitter\";}}\";s:18:\"form_error_handler\";s:154:\"a:3:{s:5:\"class\";s:33:\"Drupal\\Core\\Form\\FormErrorHandler\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"form_error_handler\";}}\";s:8:\"keyvalue\";s:445:\"a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\KeyValueStore\\KeyValueFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:16:\"factory.keyvalue\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:8:\"keyvalue\";}}\";s:17:\"keyvalue.database\";s:486:\"a:4:{s:5:\"class\";s:49:\"Drupal\\Core\\KeyValueStore\\KeyValueDatabaseFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"serialization.phpserialize\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"keyvalue.database\";}}\";s:18:\"keyvalue.expirable\";s:475:\"a:4:{s:5:\"class\";s:50:\"Drupal\\Core\\KeyValueStore\\KeyValueExpirableFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:26:\"factory.keyvalue.expirable\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"keyvalue.expirable\";}}\";s:27:\"keyvalue.expirable.database\";s:505:\"a:4:{s:5:\"class\";s:58:\"Drupal\\Core\\KeyValueStore\\KeyValueDatabaseExpirableFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"serialization.phpserialize\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"keyvalue.expirable.database\";}}\";s:14:\"logger.factory\";s:635:\"a:4:{s:5:\"class\";s:39:\"Drupal\\Core\\Logger\\LoggerChannelFactory\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"logger.factory\";}s:5:\"calls\";a:2:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:1;a:2:{i:0;s:9:\"addLogger\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"logger.dblog\";s:15:\"invalidBehavior\";i:1;}i:1;i:0;}s:7:\"resolve\";b:1;}}}}\";s:22:\"logger.channel.default\";s:336:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Logger\\LoggerChannel\";s:9:\"arguments\";a:1:{i:0;s:6:\"system\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"logger.channel.default\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"logger.factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:18:\"logger.channel.php\";s:329:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Logger\\LoggerChannel\";s:9:\"arguments\";a:1:{i:0;s:3:\"php\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"logger.channel.php\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"logger.factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:20:\"logger.channel.image\";s:333:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Logger\\LoggerChannel\";s:9:\"arguments\";a:1:{i:0;s:5:\"image\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"logger.channel.image\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"logger.factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:19:\"logger.channel.cron\";s:331:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Logger\\LoggerChannel\";s:9:\"arguments\";a:1:{i:0;s:4:\"cron\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"logger.channel.cron\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"logger.factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:19:\"logger.channel.file\";s:331:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Logger\\LoggerChannel\";s:9:\"arguments\";a:1:{i:0;s:4:\"file\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"logger.channel.file\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"logger.factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:19:\"logger.channel.form\";s:331:\"a:5:{s:5:\"class\";s:32:\"Drupal\\Core\\Logger\\LoggerChannel\";s:9:\"arguments\";a:1:{i:0;s:4:\"form\";}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"logger.channel.form\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"logger.factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:3:\"get\";}}\";s:25:\"logger.log_message_parser\";s:163:\"a:3:{s:5:\"class\";s:35:\"Drupal\\Core\\Logger\\LogMessageParser\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"logger.log_message_parser\";}}\";s:18:\"serialization.json\";s:156:\"a:3:{s:5:\"class\";s:35:\"Drupal\\Component\\Serialization\\Json\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"serialization.json\";}}\";s:26:\"serialization.phpserialize\";s:172:\"a:3:{s:5:\"class\";s:43:\"Drupal\\Component\\Serialization\\PhpSerialize\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:26:\"serialization.phpserialize\";}}\";s:18:\"serialization.yaml\";s:156:\"a:3:{s:5:\"class\";s:35:\"Drupal\\Component\\Serialization\\Yaml\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"serialization.yaml\";}}\";s:8:\"settings\";s:215:\"a:4:{s:5:\"class\";s:25:\"Drupal\\Core\\Site\\Settings\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:8:\"settings\";}s:7:\"factory\";a:2:{i:0;s:25:\"Drupal\\Core\\Site\\Settings\";i:1;s:11:\"getInstance\";}}\";s:5:\"state\";s:329:\"a:4:{s:5:\"class\";s:23:\"Drupal\\Core\\State\\State\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"keyvalue\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:5:\"state\";}}\";s:5:\"queue\";s:585:\"a:5:{s:5:\"class\";s:30:\"Drupal\\Core\\Queue\\QueueFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:5:\"queue\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:14:\"queue.database\";s:354:\"a:4:{s:5:\"class\";s:38:\"Drupal\\Core\\Queue\\QueueDatabaseFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"queue.database\";}}\";s:20:\"path.alias_whitelist\";s:694:\"a:4:{s:5:\"class\";s:31:\"Drupal\\Core\\Path\\AliasWhitelist\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;s:20:\"path_alias_whitelist\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.bootstrap\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:4:\"lock\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"path.alias_storage\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"path.alias_whitelist\";}}\";s:18:\"path.alias_manager\";s:682:\"a:4:{s:5:\"class\";s:29:\"Drupal\\Core\\Path\\AliasManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"path.alias_storage\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"path.alias_whitelist\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"cache.data\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"path.alias_manager\";}}\";s:12:\"path.current\";s:353:\"a:4:{s:5:\"class\";s:33:\"Drupal\\Core\\Path\\CurrentPathStack\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:12:\"path.current\";}}\";s:11:\"http_client\";s:285:\"a:4:{s:5:\"class\";s:17:\"GuzzleHttp\\Client\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:11:\"http_client\";}s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"http_client_factory\";s:15:\"invalidBehavior\";i:1;}i:1;s:11:\"fromOptions\";}}\";s:19:\"http_client_factory\";s:1103:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Core\\Http\\ClientFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__2i5FjkeRC6Vc7PWR5LdG3PRuCttDvRDyMUY6XsHzapc\";s:5:\"value\";a:5:{s:5:\"class\";s:23:\"GuzzleHttp\\HandlerStack\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;s:7:\"factory\";a:2:{i:0;s:23:\"GuzzleHttp\\HandlerStack\";i:1;s:6:\"create\";}s:12:\"configurator\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__WjN_c7oQM_lsfryd4mPfbEhm7nV93eUSgEmLNALMX84\";s:5:\"value\";a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\Http\\HandlerStackConfigurator\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;a:0:{}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;}s:6:\"shared\";b:0;}i:1;s:9:\"configure\";}}s:6:\"shared\";b:0;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"http_client_factory\";}}\";s:33:\"plugin.manager.link_relation_type\";s:589:\"a:4:{s:5:\"class\";s:41:\"\\Drupal\\Core\\Http\\LinkRelationTypeManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:33:\"plugin.manager.link_relation_type\";}}\";s:16:\"theme.negotiator\";s:774:\"a:4:{s:5:\"class\";s:33:\"Drupal\\Core\\Theme\\ThemeNegotiator\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"access_check.theme\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}i:2;a:7:{i:0;s:31:\"theme.negotiator.ajax_base_page\";i:1;s:33:\"theme.negotiator.block.admin_demo\";i:2;s:29:\"theme.negotiator.system.batch\";i:3;s:33:\"theme.negotiator.system.db_update\";i:4;s:34:\"theme.negotiator.switch_page_theme\";i:5;s:28:\"theme.negotiator.admin_theme\";i:6;s:24:\"theme.negotiator.default\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"theme.negotiator\";}}\";s:24:\"theme.negotiator.default\";s:368:\"a:4:{s:5:\"class\";s:35:\"Drupal\\Core\\Theme\\DefaultNegotiator\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:24:\"theme.negotiator.default\";}}\";s:31:\"theme.negotiator.ajax_base_page\";s:587:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Theme\\AjaxBasePageNegotiator\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"csrf_token\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:31:\"theme.negotiator.ajax_base_page\";}}\";s:20:\"container.namespaces\";s:323:\"a:4:{s:5:\"class\";s:11:\"ArrayObject\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:20:\"container.namespaces\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"container.namespaces\";}}\";s:14:\"module_handler\";s:544:\"a:4:{s:5:\"class\";s:35:\"Drupal\\Core\\Extension\\ModuleHandler\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:17:\"container.modules\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.bootstrap\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"module_handler\";}}\";s:16:\"module_installer\";s:434:\"a:4:{s:5:\"class\";s:48:\"Drupal\\Core\\ProxyClass\\Extension\\ModuleInstaller\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:46:\"drupal.proxy_original_service.module_installer\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"module_installer\";}}\";s:21:\"extension.list.module\";s:1118:\"a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\Extension\\ModuleExtensionList\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:10:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;s:6:\"module\";i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache.default\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:11:\"info_parser\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:22:\"extension.list.profile\";s:15:\"invalidBehavior\";i:1;}i:8;s:8:\"standard\";i:9;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:17:\"container.modules\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:10;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"extension.list.module\";}}\";s:22:\"extension.list.profile\";s:813:\"a:4:{s:5:\"class\";s:42:\"Drupal\\Core\\Extension\\ProfileExtensionList\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;s:7:\"profile\";i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache.default\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:11:\"info_parser\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}i:6;s:8:\"standard\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:7;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"extension.list.profile\";}}\";s:20:\"extension.list.theme\";s:1032:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Extension\\ThemeExtensionList\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:9:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;s:5:\"theme\";i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache.default\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:11:\"info_parser\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"extension.list.theme_engine\";s:15:\"invalidBehavior\";i:1;}i:8;s:8:\"standard\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:9;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"extension.list.theme\";}}\";s:27:\"extension.list.theme_engine\";s:828:\"a:4:{s:5:\"class\";s:46:\"Drupal\\Core\\Extension\\ThemeEngineExtensionList\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;s:12:\"theme_engine\";i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"cache.default\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:11:\"info_parser\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}i:6;s:8:\"standard\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:7;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"extension.list.theme_engine\";}}\";s:27:\"content_uninstall_validator\";s:463:\"a:4:{s:5:\"class\";s:55:\"Drupal\\Core\\ProxyClass\\Entity\\ContentUninstallValidator\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:57:\"drupal.proxy_original_service.content_uninstall_validator\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"content_uninstall_validator\";}}\";s:35:\"required_module_uninstall_validator\";s:489:\"a:4:{s:5:\"class\";s:65:\"Drupal\\Core\\ProxyClass\\Extension\\RequiredModuleUninstallValidator\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:65:\"drupal.proxy_original_service.required_module_uninstall_validator\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:35:\"required_module_uninstall_validator\";}}\";s:13:\"theme_handler\";s:567:\"a:4:{s:5:\"class\";s:34:\"Drupal\\Core\\Extension\\ThemeHandler\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"app.root\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"extension.list.theme\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:13:\"theme_handler\";}}\";s:15:\"theme_installer\";s:1223:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Extension\\ThemeInstaller\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:9:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"theme_handler\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"config.installer\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.manager\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:30:\"asset.css.collection_optimizer\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"router.builder\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:22:\"logger.channel.default\";s:15:\"invalidBehavior\";i:1;}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:9;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:15:\"theme_installer\";}}\";s:14:\"entity.manager\";s:398:\"a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Entity\\EntityManager\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"entity.manager\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:19:\"entity.memory_cache\";s:163:\"a:3:{s:5:\"class\";s:41:\"Drupal\\Core\\Cache\\MemoryCache\\MemoryCache\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"entity.memory_cache\";}}\";s:19:\"entity_type.manager\";s:1179:\"a:5:{s:5:\"class\";s:36:\"Drupal\\Core\\Entity\\EntityTypeManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:6:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"string_translation\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:39:\"entity.last_installed_schema.repository\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:6;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"entity_type.manager\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:22:\"entity_type.repository\";s:375:\"a:4:{s:5:\"class\";s:39:\"Drupal\\Core\\Entity\\EntityTypeRepository\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"entity_type.repository\";}}\";s:23:\"entity_type.bundle.info\";s:807:\"a:4:{s:5:\"class\";s:39:\"Drupal\\Core\\Entity\\EntityTypeBundleInfo\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"typed_data_manager\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:23:\"entity_type.bundle.info\";}}\";s:17:\"entity.repository\";s:584:\"a:4:{s:5:\"class\";s:35:\"Drupal\\Core\\Entity\\EntityRepository\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"context.repository\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"entity.repository\";}}\";s:25:\"entity_display.repository\";s:702:\"a:4:{s:5:\"class\";s:42:\"Drupal\\Core\\Entity\\EntityDisplayRepository\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"entity_display.repository\";}}\";s:20:\"entity_field.manager\";s:1133:\"a:4:{s:5:\"class\";s:37:\"Drupal\\Core\\Entity\\EntityFieldManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:23:\"entity_type.bundle.info\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"entity_display.repository\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"typed_data_manager\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"keyvalue\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:8;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"entity_field.manager\";}}\";s:20:\"entity_type.listener\";s:722:\"a:4:{s:5:\"class\";s:37:\"Drupal\\Core\\Entity\\EntityTypeListener\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"entity_field.manager\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"event_dispatcher\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:39:\"entity.last_installed_schema.repository\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"entity_type.listener\";}}\";s:22:\"entity_bundle.listener\";s:708:\"a:4:{s:5:\"class\";s:39:\"Drupal\\Core\\Entity\\EntityBundleListener\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:23:\"entity_type.bundle.info\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"entity_field.manager\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:22:\"entity_bundle.listener\";}}\";s:23:\"entity_route_subscriber\";s:394:\"a:4:{s:5:\"class\";s:57:\"Drupal\\Core\\EventSubscriber\\EntityRouteProviderSubscriber\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:23:\"entity_route_subscriber\";}}\";s:32:\"entity.definition_update_manager\";s:874:\"a:4:{s:5:\"class\";s:48:\"Drupal\\Core\\Entity\\EntityDefinitionUpdateManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:39:\"entity.last_installed_schema.repository\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"entity_field.manager\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"entity_type.listener\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:33:\"field_storage_definition.listener\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:32:\"entity.definition_update_manager\";}}\";s:39:\"entity.last_installed_schema.repository\";s:395:\"a:4:{s:5:\"class\";s:54:\"Drupal\\Core\\Entity\\EntityLastInstalledSchemaRepository\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"keyvalue\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:39:\"entity.last_installed_schema.repository\";}}\";s:38:\"entity_field.deleted_fields_repository\";s:378:\"a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\Field\\DeletedFieldsRepository\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:5:\"state\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:38:\"entity_field.deleted_fields_repository\";}}\";s:33:\"field_storage_definition.listener\";s:876:\"a:4:{s:5:\"class\";s:48:\"Drupal\\Core\\Field\\FieldStorageDefinitionListener\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"event_dispatcher\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:39:\"entity.last_installed_schema.repository\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"entity_field.manager\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:38:\"entity_field.deleted_fields_repository\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:33:\"field_storage_definition.listener\";}}\";s:25:\"field_definition.listener\";s:698:\"a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\Field\\FieldDefinitionListener\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"entity_field.manager\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"keyvalue\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"field_definition.listener\";}}\";s:19:\"entity.form_builder\";s:473:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Entity\\EntityFormBuilder\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"form_builder\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"entity.form_builder\";}}\";s:37:\"entity.bundle_config_import_validator\";s:508:\"a:4:{s:5:\"class\";s:51:\"Drupal\\Core\\Entity\\Event\\BundleConfigImportValidate\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:37:\"entity.bundle_config_import_validator\";}}\";s:27:\"entity.autocomplete_matcher\";s:407:\"a:4:{s:5:\"class\";s:44:\"Drupal\\Core\\Entity\\EntityAutocompleteMatcher\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:41:\"plugin.manager.entity_reference_selection\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"entity.autocomplete_matcher\";}}\";s:19:\"plugin_form.factory\";s:364:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Plugin\\PluginFormFactory\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"plugin_form.factory\";}}\";s:41:\"plugin.manager.entity_reference_selection\";s:635:\"a:4:{s:5:\"class\";s:66:\"Drupal\\Core\\Entity\\EntityReferenceSelection\\SelectionPluginManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:41:\"plugin.manager.entity_reference_selection\";}}\";s:20:\"plugin.manager.block\";s:692:\"a:4:{s:5:\"class\";s:30:\"Drupal\\Core\\Block\\BlockManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:22:\"logger.channel.default\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"plugin.manager.block\";}}\";s:31:\"plugin.manager.field.field_type\";s:709:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Field\\FieldTypePluginManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"typed_data_manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:31:\"plugin.manager.field.field_type\";}}\";s:27:\"plugin.manager.field.widget\";s:715:\"a:4:{s:5:\"class\";s:37:\"Drupal\\Core\\Field\\WidgetPluginManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"plugin.manager.field.field_type\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"plugin.manager.field.widget\";}}\";s:30:\"plugin.manager.field.formatter\";s:721:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Field\\FormatterPluginManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"plugin.manager.field.field_type\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:30:\"plugin.manager.field.formatter\";}}\";s:23:\"plugin.manager.archiver\";s:587:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Archiver\\ArchiverManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:23:\"plugin.manager.archiver\";}}\";s:21:\"plugin.manager.action\";s:581:\"a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Action\\ActionManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"plugin.manager.action\";}}\";s:24:\"plugin.manager.menu.link\";s:1140:\"a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Menu\\MenuLinkManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:17:\"menu.tree_storage\";s:5:\"value\";a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Menu\\MenuTreeStorage\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"cache.menu\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:22:\"cache_tags.invalidator\";s:15:\"invalidBehavior\";i:1;}i:3;s:9:\"menu_tree\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;}s:6:\"shared\";b:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"menu_link.static.overrides\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:24:\"plugin.manager.menu.link\";}}\";s:14:\"menu.link_tree\";s:1352:\"a:4:{s:5:\"class\";s:29:\"Drupal\\Core\\Menu\\MenuLinkTree\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:17:\"menu.tree_storage\";s:5:\"value\";a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Menu\\MenuTreeStorage\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"database\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"cache.menu\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:22:\"cache_tags.invalidator\";s:15:\"invalidBehavior\";i:1;}i:3;s:9:\"menu_tree\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;}s:6:\"shared\";b:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:24:\"plugin.manager.menu.link\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"router.route_provider\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"menu.active_trail\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"controller_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"menu.link_tree\";}}\";s:30:\"menu.default_tree_manipulators\";s:602:\"a:4:{s:5:\"class\";s:48:\"Drupal\\Core\\Menu\\DefaultMenuLinkTreeManipulators\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"access_manager\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:30:\"menu.default_tree_manipulators\";}}\";s:17:\"menu.active_trail\";s:676:\"a:4:{s:5:\"class\";s:32:\"Drupal\\Core\\Menu\\MenuActiveTrail\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:24:\"plugin.manager.menu.link\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"current_route_match\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:10:\"cache.menu\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:4:\"lock\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"menu.active_trail\";}}\";s:25:\"menu.parent_form_selector\";s:594:\"a:4:{s:5:\"class\";s:39:\"Drupal\\Core\\Menu\\MenuParentFormSelector\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"menu.link_tree\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"string_translation\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"menu.parent_form_selector\";}}\";s:32:\"plugin.manager.menu.local_action\";s:1262:\"a:4:{s:5:\"class\";s:35:\"Drupal\\Core\\Menu\\LocalActionManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:9:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:40:\"http_kernel.controller.argument_resolver\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"current_route_match\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"router.route_provider\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"access_manager\";s:15:\"invalidBehavior\";i:1;}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:9;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:32:\"plugin.manager.menu.local_action\";}}\";s:30:\"plugin.manager.menu.local_task\";s:1258:\"a:4:{s:5:\"class\";s:33:\"Drupal\\Core\\Menu\\LocalTaskManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:9:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:40:\"http_kernel.controller.argument_resolver\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"current_route_match\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"router.route_provider\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"access_manager\";s:15:\"invalidBehavior\";i:1;}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:9;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:30:\"plugin.manager.menu.local_task\";}}\";s:35:\"plugin.manager.menu.contextual_link\";s:1023:\"a:4:{s:5:\"class\";s:38:\"Drupal\\Core\\Menu\\ContextualLinkManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"controller_resolver\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"access_manager\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"current_user\";s:15:\"invalidBehavior\";i:1;}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:7;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:35:\"plugin.manager.menu.contextual_link\";}}\";s:30:\"plugin.manager.display_variant\";s:592:\"a:4:{s:5:\"class\";s:34:\"Drupal\\Core\\Display\\VariantManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:30:\"plugin.manager.display_variant\";}}\";s:27:\"plugin.manager.queue_worker\";s:591:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Queue\\QueueWorkerManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"plugin.manager.queue_worker\";}}\";s:20:\"plugin.cache_clearer\";s:14630:\"a:5:{s:5:\"class\";s:52:\"Drupal\\Core\\ProxyClass\\Plugin\\CachedDiscoveryClearer\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:50:\"drupal.proxy_original_service.plugin.cache_clearer\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:20:\"plugin.cache_clearer\";}s:5:\"calls\";a:57:{i:0;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:12:\"config.typed\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:1;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:33:\"plugin.manager.link_relation_type\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:2;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"entity_type.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:3;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:41:\"plugin.manager.entity_reference_selection\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:4;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"plugin.manager.block\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:5;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"plugin.manager.field.field_type\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:6;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.field.widget\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:7;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:30:\"plugin.manager.field.formatter\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:8;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:23:\"plugin.manager.archiver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:9;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"plugin.manager.action\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:10;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:32:\"plugin.manager.menu.local_action\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:11;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:30:\"plugin.manager.menu.local_task\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:12;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:35:\"plugin.manager.menu.contextual_link\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:13;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:30:\"plugin.manager.display_variant\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:14;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.queue_worker\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:15;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"typed_data_manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:16;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"validation.constraint\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:17;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"plugin.manager.mail\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:18;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:24:\"plugin.manager.condition\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:19;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.element_info\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:20;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"image.toolkit.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:21;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"image.toolkit.operation.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:22;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"breakpoint.manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:23;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:30:\"plugin.manager.ckeditor.plugin\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:24;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:35:\"plugin.manager.crop.entity_provider\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:25;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:34:\"plugin.manager.ctools.relationship\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:26;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.devel_dumper\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:27;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"plugin.manager.editor\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:28;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"plugin.manager.filter\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:29;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.image.effect\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:30;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:42:\"plugin.manager.language_negotiation_method\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:31;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"plugin.manager.metatag.tag\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:32;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:28:\"plugin.manager.metatag.group\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:33;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"plugin.manager.quickedit.editor\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:34;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"plugin.manager.search\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:35;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:23:\"plugin.manager.tour.tip\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:36;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"plugin.manager.alias_type\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:37;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.views.access\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:38;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"plugin.manager.views.area\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:39;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:29:\"plugin.manager.views.argument\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:40;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:37:\"plugin.manager.views.argument_default\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:41;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:39:\"plugin.manager.views.argument_validator\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:42;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"plugin.manager.views.cache\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:43;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:37:\"plugin.manager.views.display_extender\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:44;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:28:\"plugin.manager.views.display\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:45;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:33:\"plugin.manager.views.exposed_form\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:46;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"plugin.manager.views.field\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:47;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.views.filter\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:48;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"plugin.manager.views.join\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:49;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"plugin.manager.views.pager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:50;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"plugin.manager.views.query\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:51;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:33:\"plugin.manager.views.relationship\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:52;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:24:\"plugin.manager.views.row\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:53;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"plugin.manager.views.sort\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:54;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"plugin.manager.views.style\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:55;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"plugin.manager.views.wizard\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}i:56;a:2:{i:0;s:18:\"addCachedDiscovery\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:51:\"plugin.manager.eu_cookie_compliance.consent_storage\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:24:\"paramconverter.menu_link\";s:463:\"a:4:{s:5:\"class\";s:61:\"Drupal\\Core\\ProxyClass\\ParamConverter\\MenuLinkPluginConverter\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:54:\"drupal.proxy_original_service.paramconverter.menu_link\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:24:\"paramconverter.menu_link\";}}\";s:26:\"menu_link.static.overrides\";s:375:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Menu\\StaticMenuLinkOverrides\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:26:\"menu_link.static.overrides\";}}\";s:13:\"request_stack\";s:161:\"a:3:{s:5:\"class\";s:45:\"Symfony\\Component\\HttpFoundation\\RequestStack\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:13:\"request_stack\";}}\";s:19:\"current_route_match\";s:364:\"a:4:{s:5:\"class\";s:37:\"Drupal\\Core\\Routing\\CurrentRouteMatch\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"current_route_match\";}}\";s:16:\"event_dispatcher\";s:12980:\"a:4:{s:5:\"class\";s:62:\"Drupal\\Component\\EventDispatcher\\ContainerAwareEventDispatcher\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;a:24:{s:22:\"routing.route_finished\";a:4:{i:200;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:31:\"cache_router_rebuild_subscriber\";i:1;s:16:\"onRouterFinished\";}}}i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:23:\"menu.rebuild_subscriber\";i:1;s:15:\"onRouterRebuild\";}}}i:0;a:4:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:21:\"router.route_provider\";i:1;s:5:\"reset\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"router.route_preloader\";i:1;s:16:\"onFinishedRoutes\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"router.path_roots_subscriber\";i:1;s:15:\"onRouteFinished\";}}i:3;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"views.route_subscriber\";i:1;s:20:\"routeRebuildFinished\";}}}i:-3000;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:34:\"router.route_provider.lazy_builder\";i:1;s:21:\"routerRebuildFinished\";}}}}s:11:\"config.save\";a:4:{i:255;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:14:\"config.factory\";i:1;s:12:\"onConfigSave\";}}}i:128;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:19:\"entity.query.config\";i:1;s:12:\"onConfigSave\";}}}i:20;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"language.config_factory_override\";i:1;s:12:\"onConfigSave\";}}}i:0;a:7:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:30:\"color.config_cache_invalidator\";i:1;s:8:\"onChange\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"language.config_subscriber\";i:1;s:12:\"onConfigSave\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"locale.config_subscriber\";i:1;s:12:\"onConfigSave\";}}i:3;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"node.admin_path.route_subscriber\";i:1;s:12:\"onConfigSave\";}}i:4;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"system.config_subscriber\";i:1;s:12:\"onConfigSave\";}}i:5;a:1:{s:7:\"service\";a:2:{i:0;s:23:\"system.config_cache_tag\";i:1;s:6:\"onSave\";}}i:6;a:1:{s:7:\"service\";a:2:{i:0;s:27:\"pathauto.settings_cache_tag\";i:1;s:6:\"onSave\";}}}}s:13:\"config.delete\";a:4:{i:255;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:14:\"config.factory\";i:1;s:14:\"onConfigDelete\";}}}i:128;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:19:\"entity.query.config\";i:1;s:14:\"onConfigDelete\";}}}i:20;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"language.config_factory_override\";i:1;s:14:\"onConfigDelete\";}}}i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:30:\"color.config_cache_invalidator\";i:1;s:8:\"onChange\";}}}}s:31:\"config.importer.missing_content\";a:1:{i:-1024;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"config.importer_subscriber\";i:1;s:16:\"onMissingContent\";}}}}s:14:\"kernel.request\";a:10:{i:1000;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"options_request_listener\";i:1;s:9:\"onRequest\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:35:\"redirect_leading_slashes_subscriber\";i:1;s:8:\"redirect\";}}}i:300;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"authentication_subscriber\";i:1;s:27:\"onKernelRequestAuthenticate\";}}}i:256;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"devel.error_subscriber\";i:1;s:20:\"registerErrorHandler\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:30:\"devel.theme_rebuild_subscriber\";i:1;s:16:\"rebuildThemeInfo\";}}}i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:17:\"seckit.subscriber\";i:1;s:15:\"onKernelRequest\";}}}i:50;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"ajax_response.subscriber\";i:1;s:9:\"onRequest\";}}}i:32;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:15:\"router_listener\";i:1;s:15:\"onKernelRequest\";}}}i:31;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"authentication_subscriber\";i:1;s:29:\"onKernelRequestFilterProvider\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"user_maintenance_mode_subscriber\";i:1;s:26:\"onKernelRequestMaintenance\";}}}i:30;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:27:\"maintenance_mode_subscriber\";i:1;s:26:\"onKernelRequestMaintenance\";}}}i:27;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:29:\"dynamic_page_cache_subscriber\";i:1;s:9:\"onRequest\";}}}i:0;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"database.replica_kill_switch\";i:1;s:18:\"checkReplicaServer\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"router.route_preloader\";i:1;s:9:\"onRequest\";}}}}s:21:\"routing.route_dynamic\";a:2:{i:3000;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:34:\"router.route_provider.lazy_builder\";i:1;s:16:\"routerRebuilding\";}}}i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:23:\"entity_route_subscriber\";i:1;s:19:\"onDynamicRouteEvent\";}}}}s:24:\"config.importer.validate\";a:3:{i:512;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"system.config_subscriber\";i:1;s:32:\"onConfigImporterValidateNotEmpty\";}}}i:256;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"system.config_subscriber\";i:1;s:32:\"onConfigImporterValidateSiteUUID\";}}}i:20;a:3:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:37:\"entity.bundle_config_import_validator\";i:1;s:24:\"onConfigImporterValidate\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"config_import_subscriber\";i:1;s:24:\"onConfigImporterValidate\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"config.config_subscriber\";i:1;s:24:\"onConfigImporterValidate\";}}}}s:19:\"routing.route_alter\";a:9:{i:5000;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"route_http_method_subscriber\";i:1;s:15:\"onRouteBuilding\";}}}i:100;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"devel.route_subscriber\";i:1;s:13:\"onAlterRoutes\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"token.route_subscriber\";i:1;s:13:\"onAlterRoutes\";}}}i:0;a:5:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:23:\"route_subscriber.module\";i:1;s:13:\"onAlterRoutes\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:35:\"route_special_attributes_subscriber\";i:1;s:13:\"onAlterRoutes\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"route_subscriber.no_big_pipe\";i:1;s:31:\"onRoutingRouteAlterSetNoBigPipe\";}}i:3;a:1:{s:7:\"service\";a:2:{i:0;s:21:\"node.route_subscriber\";i:1;s:13:\"onAlterRoutes\";}}i:4;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"node.admin_path.route_subscriber\";i:1;s:13:\"onAlterRoutes\";}}}i:-100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:19:\"field_ui.subscriber\";i:1;s:13:\"onAlterRoutes\";}}}i:-150;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:23:\"route_subscriber.entity\";i:1;s:26:\"onRoutingRouteAlterSetType\";}}}i:-175;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"views.route_subscriber\";i:1;s:13:\"onAlterRoutes\";}}}i:-200;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:34:\"system.admin_path.route_subscriber\";i:1;s:13:\"onAlterRoutes\";}}}i:-220;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"paramconverter_subscriber\";i:1;s:41:\"onRoutingRouteAlterSetParameterConverters\";}}}i:-1024;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"router.route_preloader\";i:1;s:13:\"onAlterRoutes\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"router.path_roots_subscriber\";i:1;s:12:\"onRouteAlter\";}}}}s:15:\"kernel.response\";a:10:{i:128;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"exception.enforced_form_response\";i:1;s:16:\"onKernelResponse\";}}}i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:29:\"dynamic_page_cache_subscriber\";i:1;s:10:\"onResponse\";}}}i:16;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"finish_response_subscriber\";i:1;s:13:\"onAllResponds\";}}}i:10;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"route_access_response_subscriber\";i:1;s:9:\"onRespond\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"client_error_response_subscriber\";i:1;s:9:\"onRespond\";}}}i:5;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:34:\"anonymous_user_response_subscriber\";i:1;s:9:\"onRespond\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:45:\"html_response.placeholder_strategy_subscriber\";i:1;s:9:\"onRespond\";}}}i:3;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:33:\"html_response.big_pipe_subscriber\";i:1;s:14:\"onRespondEarly\";}}}i:0;a:5:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"html_response.subscriber\";i:1;s:9:\"onRespond\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"finish_response_subscriber\";i:1;s:9:\"onRespond\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:29:\"response_generator_subscriber\";i:1;s:9:\"onRespond\";}}i:3;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"redirect_response_subscriber\";i:1;s:16:\"checkRedirectUrl\";}}i:4;a:1:{s:7:\"service\";a:2:{i:0;s:17:\"seckit.subscriber\";i:1;s:16:\"onKernelResponse\";}}}i:-100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"ajax_response.subscriber\";i:1;s:10:\"onResponse\";}}}i:-512;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:27:\"response_filter.active_link\";i:1;s:10:\"onResponse\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"response_filter.rss.relative_url\";i:1;s:10:\"onResponse\";}}}i:-10000;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:33:\"html_response.big_pipe_subscriber\";i:1;s:9:\"onRespond\";}}}}s:16:\"kernel.exception\";a:14:{i:200;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:23:\"exception.fast_404_html\";i:1;s:11:\"onException\";}}}i:128;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"exception.enforced_form_response\";i:1;s:17:\"onKernelException\";}}}i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"exception.needs_installer\";i:1;s:11:\"onException\";}}}i:80;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"authentication_subscriber\";i:1;s:23:\"onExceptionAccessDenied\";}}}i:75;a:3:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:31:\"route_enhancer.param_conversion\";i:1;s:11:\"onException\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"authentication_subscriber\";i:1;s:24:\"onExceptionSendChallenge\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:29:\"user_access_denied_subscriber\";i:1;s:11:\"onException\";}}}i:51;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:20:\"form_ajax_subscriber\";i:1;s:11:\"onException\";}}}i:50;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:16:\"exception.logger\";i:1;s:11:\"onException\";}}}i:3;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:19:\"exception.test_site\";i:1;s:11:\"onException\";}}}i:0;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:27:\"maintenance_mode_subscriber\";i:1;s:26:\"onKernelRequestMaintenance\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:31:\"node.node_translation_exception\";i:1;s:11:\"onException\";}}}i:-50;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"exception.custom_page_html\";i:1;s:11:\"onException\";}}}i:-64;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:15:\"router_listener\";i:1;s:17:\"onKernelException\";}}}i:-75;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"exception.default_json\";i:1;s:11:\"onException\";}}}i:-128;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:22:\"exception.default_html\";i:1;s:11:\"onException\";}}}i:-256;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:15:\"exception.final\";i:1;s:11:\"onException\";}}}}s:11:\"kernel.view\";a:3:{i:1;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:20:\"form_ajax_subscriber\";i:1;s:6:\"onView\";}}}i:0;a:2:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"psr_response_view_subscriber\";i:1;s:12:\"onKernelView\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:28:\"main_content_view_subscriber\";i:1;s:17:\"onViewRenderArray\";}}}i:-10;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:17:\"renderer_non_html\";i:1;s:9:\"onRespond\";}}}}s:21:\"kernel.finish_request\";a:1:{i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:15:\"router_listener\";i:1;s:21:\"onKernelFinishRequest\";}}}}s:17:\"kernel.controller\";a:2:{i:200;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:15:\"path_subscriber\";i:1;s:18:\"onKernelController\";}}}i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:45:\"early_rendering_controller_wrapper_subscriber\";i:1;s:12:\"onController\";}}}}s:16:\"kernel.terminate\";a:3:{i:300;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:27:\"user_last_access_subscriber\";i:1;s:17:\"onKernelTerminate\";}}}i:200;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:15:\"path_subscriber\";i:1;s:17:\"onKernelTerminate\";}}}i:100;a:3:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"request_close_subscriber\";i:1;s:11:\"onTerminate\";}}i:1;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"kernel_destruct_subscriber\";i:1;s:17:\"onKernelTerminate\";}}i:2;a:1:{s:7:\"service\";a:2:{i:0;s:25:\"automated_cron.subscriber\";i:1;s:11:\"onTerminate\";}}}}s:22:\"config.importer.import\";a:1:{i:40;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:26:\"config_snapshot_subscriber\";i:1;s:22:\"onConfigImporterImport\";}}}}s:34:\"render.page_display_variant.select\";a:1:{i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:37:\"block.page_display_variant_subscriber\";i:1;s:26:\"onSelectPageDisplayVariant\";}}}}s:22:\"config.collection_info\";a:1:{i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"language.config_factory_override\";i:1;s:14:\"addCollections\";}}}}s:13:\"config.rename\";a:1:{i:20;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:32:\"language.config_factory_override\";i:1;s:14:\"onConfigRename\";}}}}s:22:\"language.save_override\";a:1:{i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"locale.config_subscriber\";i:1;s:16:\"onOverrideChange\";}}}}s:24:\"language.delete_override\";a:1:{i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:24:\"locale.config_subscriber\";i:1;s:16:\"onOverrideChange\";}}}}s:23:\"locale.save_translation\";a:1:{i:0;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:35:\"locale.locale_translation_cache_tag\";i:1;s:15:\"saveTranslation\";}}}}s:29:\"entity_type.definition.create\";a:1:{i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:30:\"views.entity_schema_subscriber\";i:1;s:17:\"onEntityTypeEvent\";}}}}s:29:\"entity_type.definition.update\";a:1:{i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:30:\"views.entity_schema_subscriber\";i:1;s:17:\"onEntityTypeEvent\";}}}}s:29:\"entity_type.definition.delete\";a:1:{i:100;a:1:{i:0;a:1:{s:7:\"service\";a:2:{i:0;s:30:\"views.entity_schema_subscriber\";i:1;s:17:\"onEntityTypeEvent\";}}}}}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"event_dispatcher\";}}\";s:8:\"app.root\";s:543:\"a:3:{s:5:\"class\";s:9:\"SplString\";s:15:\"arguments_count\";i:0;s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__Zsw1Sj4oDjvzkmxM28DwWfx9Nnh9vi4D2mcS7WCJLbg\";s:5:\"value\";a:4:{s:5:\"class\";s:26:\"Drupal\\Core\\AppRootFactory\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:6:\"kernel\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;}s:6:\"shared\";b:0;}i:1;s:3:\"get\";}}\";s:9:\"site.path\";s:544:\"a:3:{s:5:\"class\";s:9:\"SplString\";s:15:\"arguments_count\";i:0;s:7:\"factory\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__q7FBVi7mHs7UOJnYi5kAkY_Xr2APp9Ue5a9KP7FyvMA\";s:5:\"value\";a:4:{s:5:\"class\";s:27:\"Drupal\\Core\\SitePathFactory\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:6:\"kernel\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;}s:6:\"shared\";b:0;}i:1;s:3:\"get\";}}\";s:19:\"controller_resolver\";s:486:\"a:4:{s:5:\"class\";s:41:\"Drupal\\Core\\Controller\\ControllerResolver\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"psr7.http_message_factory\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:19:\"controller_resolver\";}}\";s:14:\"class_resolver\";s:411:\"a:4:{s:5:\"class\";s:45:\"Drupal\\Core\\DependencyInjection\\ClassResolver\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"class_resolver\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:14:\"title_resolver\";s:606:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Controller\\TitleResolver\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"controller_resolver\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:18:\"string_translation\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:40:\"http_kernel.controller.argument_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:14:\"title_resolver\";}}\";s:11:\"http_kernel\";s:1151:\"a:4:{s:5:\"class\";s:23:\"Stack\\StackedHttpKernel\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"http_middleware.negotiation\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:6:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:27:\"http_middleware.negotiation\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:29:\"http_middleware.reverse_proxy\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"http_middleware.page_cache\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:33:\"http_middleware.kernel_pre_handle\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:23:\"http_middleware.session\";s:15:\"invalidBehavior\";i:1;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"http_kernel.basic\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:11:\"http_kernel\";}}\";s:17:\"http_kernel.basic\";s:730:\"a:5:{s:5:\"class\";s:39:\"Symfony\\Component\\HttpKernel\\HttpKernel\";s:4:\"lazy\";b:1;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"event_dispatcher\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:19:\"controller_resolver\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:40:\"http_kernel.controller.argument_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:17:\"http_kernel.basic\";}}\";s:40:\"http_kernel.controller.argument_resolver\";s:2682:\"a:4:{s:5:\"class\";s:56:\"Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__aVVgmTsbLy2mehkCW1XkPCxoNfAe-gToi9ed1epV65A\";s:5:\"value\";a:3:{s:5:\"class\";s:71:\"Symfony\\Component\\HttpKernel\\ControllerMetadata\\ArgumentMetadataFactory\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;}s:6:\"shared\";b:0;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:6:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__4paxHwrBqZgLMOLaRrJsmOfZ3q3b8GmysfCJVR59dww\";s:5:\"value\";a:3:{s:5:\"class\";s:86:\"Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;}s:6:\"shared\";b:0;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__PhticrBBzcjC79bzKkozEgo29oWMlYExB1k4XZRI_a0\";s:5:\"value\";a:3:{s:5:\"class\";s:65:\"Drupal\\Core\\Controller\\ArgumentResolver\\RawParameterValueResolver\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;}s:6:\"shared\";b:0;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__s9WvKxAAioSxnrbszotBL4p3vALnLB-MHJQxkpMqIAU\";s:5:\"value\";a:3:{s:5:\"class\";s:77:\"Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;}s:6:\"shared\";b:0;}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__eDpbPL4wwnQyhPmwwLlalHD-HQzju54CeEhnePoq77M\";s:5:\"value\";a:4:{s:5:\"class\";s:64:\"Drupal\\Core\\Controller\\ArgumentResolver\\Psr7RequestValueResolver\";s:6:\"public\";b:0;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:25:\"psr7.http_message_factory\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;}s:6:\"shared\";b:0;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__jmHlQ8DenPOz2Y1rQPf6wcbGV3XZvwuMnC6wCu8cgXM\";s:5:\"value\";a:3:{s:5:\"class\";s:63:\"Drupal\\Core\\Controller\\ArgumentResolver\\RouteMatchValueResolver\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;}s:6:\"shared\";b:0;}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:15:\"private_service\";s:2:\"id\";s:52:\"private__E5RB7EPjMp2Q_miXb0vh6M0K5wUh779hDQkqBCZjB2g\";s:5:\"value\";a:3:{s:5:\"class\";s:77:\"Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver\";s:6:\"public\";b:0;s:15:\"arguments_count\";i:0;}s:6:\"shared\";b:0;}}s:7:\"resolve\";b:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:40:\"http_kernel.controller.argument_resolver\";}}\";s:27:\"http_middleware.negotiation\";s:524:\"a:5:{s:5:\"class\";s:49:\"Drupal\\Core\\StackMiddleware\\NegotiationMiddleware\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:29:\"http_middleware.reverse_proxy\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:27:\"http_middleware.negotiation\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:14:\"registerFormat\";i:1;a:2:{i:0;s:3:\"bin\";i:1;a:1:{i:0;s:24:\"application/octet-stream\";}}}}}\";s:29:\"http_middleware.reverse_proxy\";s:499:\"a:4:{s:5:\"class\";s:50:\"Drupal\\Core\\StackMiddleware\\ReverseProxyMiddleware\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:26:\"http_middleware.page_cache\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:29:\"http_middleware.reverse_proxy\";}}\";s:33:\"http_middleware.kernel_pre_handle\";s:506:\"a:5:{s:5:\"class\";s:43:\"Drupal\\Core\\StackMiddleware\\KernelPreHandle\";s:4:\"lazy\";b:1;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:23:\"http_middleware.session\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:6:\"kernel\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:33:\"http_middleware.kernel_pre_handle\";}}\";s:23:\"http_middleware.session\";s:634:\"a:6:{s:5:\"class\";s:35:\"Drupal\\Core\\StackMiddleware\\Session\";s:4:\"lazy\";b:1;s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"http_kernel.basic\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:23:\"http_middleware.session\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:12:\"setContainer\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:28:\"psr7.http_foundation_factory\";s:190:\"a:3:{s:5:\"class\";s:59:\"Symfony\\Bridge\\PsrHttpMessage\\Factory\\HttpFoundationFactory\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:28:\"psr7.http_foundation_factory\";}}\";s:25:\"psr7.http_message_factory\";s:182:\"a:3:{s:5:\"class\";s:54:\"Symfony\\Bridge\\PsrHttpMessage\\Factory\\DiactorosFactory\";s:15:\"arguments_count\";i:0;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:25:\"psr7.http_message_factory\";}}\";s:16:\"language_manager\";s:811:\"a:4:{s:5:\"class\";s:43:\"Drupal\\language\\ConfigurableLanguageManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:5:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language.default\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"config.factory\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:32:\"language.config_factory_override\";s:15:\"invalidBehavior\";i:1;}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:13:\"request_stack\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:5;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"language_manager\";}}\";s:33:\"language.current_language_context\";s:403:\"a:4:{s:5:\"class\";s:59:\"Drupal\\Core\\Language\\ContextProvider\\CurrentLanguageContext\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language_manager\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:33:\"language.current_language_context\";}}\";s:16:\"language.default\";s:347:\"a:4:{s:5:\"class\";s:36:\"Drupal\\Core\\Language\\LanguageDefault\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:9:\"parameter\";s:4:\"name\";s:23:\"language.default_values\";}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:16:\"language.default\";}}\";s:32:\"string_translator.custom_strings\";s:388:\"a:4:{s:5:\"class\";s:54:\"Drupal\\Core\\StringTranslation\\Translator\\CustomStrings\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:8:\"settings\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:32:\"string_translator.custom_strings\";}}\";s:18:\"string_translation\";s:905:\"a:5:{s:5:\"class\";s:48:\"Drupal\\Core\\StringTranslation\\TranslationManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:16:\"language.default\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:1;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"string_translation\";}s:5:\"calls\";a:2:{i:0;a:2:{i:0;s:13:\"addTranslator\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:32:\"string_translator.custom_strings\";s:15:\"invalidBehavior\";i:1;}i:1;i:30;}s:7:\"resolve\";b:1;}}i:1;a:2:{i:0;s:13:\"addTranslator\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:31:\"string_translator.locale.lookup\";s:15:\"invalidBehavior\";i:1;}i:1;i:0;}s:7:\"resolve\";b:1;}}}}\";s:18:\"typed_data_manager\";s:961:\"a:5:{s:5:\"class\";s:38:\"Drupal\\Core\\TypedData\\TypedDataManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:4:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"class_resolver\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:4;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:18:\"typed_data_manager\";}s:5:\"calls\";a:1:{i:0;a:2:{i:0;s:30:\"setValidationConstraintManager\";i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:21:\"validation.constraint\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}}}}\";s:21:\"validation.constraint\";s:589:\"a:4:{s:5:\"class\";s:40:\"Drupal\\Core\\Validation\\ConstraintManager\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:20:\"container.namespaces\";s:15:\"invalidBehavior\";i:1;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:15:\"cache.discovery\";s:15:\"invalidBehavior\";i:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:14:\"module_handler\";s:15:\"invalidBehavior\";i:1;}}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:3;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:21:\"validation.constraint\";}}\";s:4:\"lock\";s:408:\"a:4:{s:5:\"class\";s:47:\"Drupal\\Core\\ProxyClass\\Lock\\DatabaseLockBackend\";s:9:\"arguments\";O:8:\"stdClass\":3:{s:4:\"type\";s:10:\"collection\";s:5:\"value\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:7:\"service\";s:2:\"id\";s:17:\"service_container\";s:15:\"invalidBehavior\";i:1;}i:1;s:34:\"drupal.proxy_original_service.lock\";}s:7:\"resolve\";b:1;}s:15:\"arguments_count\";i:2;s:10:\"properties\";a:1:{s:10:\"_serviceId\";s:4:\"lock\";}}\";s:15:\"lock.persistent\";s:441:\"a:4:{s:5:\"class\";s:57:\"Drupal\\Core\\ProxyClass\\Lock\\PersistentDatabaseLockBackend\"